/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.jndi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import oracle.ldap.util.jndi.LDAPSocketFactory;
import oracle.ldap.util.jndi.LDAPTrustManager;
import oracle.security.pki.OraclePKIProvider;

public class LDAPJSSESocketFactoryImpl
extends LDAPSocketFactory {
    public LDAPJSSESocketFactoryImpl() throws Exception {
        this(System.getProperties());
    }

    public LDAPJSSESocketFactoryImpl(Hashtable ht) throws Exception {
        Security.insertProviderAt((Provider)new OraclePKIProvider(), 1);
        try {
            KeyStore myWallet = null;
            KeyManager[] kmA = null;
            String pwd = (String)ht.get("oracle.ldap.wltpass");
            String loc = (String)ht.get("oracle.ldap.wltloc");
            if (loc != null && pwd != null) {
                this.ckWltLoc(loc);
                FileInputStream istr = new FileInputStream(loc);
                myWallet = KeyStore.getInstance("PKCS12", "OraclePKI");
                myWallet.load(istr, pwd.toCharArray());
                String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerAlgorithm);
                kmf.init(myWallet, pwd.toCharArray());
                kmA = kmf.getKeyManagers();
            }
            String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerAlgorithm);
            boolean ibmJSSE = false;
            String providerName = tmf.getProvider().getName();
            if (providerName.indexOf("IBMJSSE") >= 0) {
                ibmJSSE = true;
            }
            tmf.init(myWallet);
            TrustManager[] tmA = tmf.getTrustManagers();
            tmA = LDAPTrustManager.wrap(tmA, ibmJSSE);
            sslf = LDAPJSSESocketFactoryImpl.initSSLSocketFactory(kmA, tmA);
        }
        catch (Exception ex) {
            System.out.println("Exception while trying to connect:" + ex.toString());
            ex.printStackTrace();
        }
    }

    public static SocketFactory getDefault() {
        try {
            return new LDAPJSSESocketFactoryImpl();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected SSLSocket init(SSLSocket sock) throws IOException {
        sock.setUseClientMode(true);
        sock.setEnabledCipherSuites(this.addAnonymousCiphers());
        sock.startHandshake();
        return sock;
    }

    private void ckWltLoc(String wltLoc) throws IOException {
        File file = new File(wltLoc);
        if (!file.exists()) {
            throw new IOException("The wallet \"" + wltLoc + "\" does not exist.");
        }
        if (!file.canRead()) {
            throw new IOException("The wallet \"" + wltLoc + "\" cannot be read.");
        }
        if (!file.isFile()) {
            throw new IOException("The wallet \"" + wltLoc + "\" is not a 'normal' file.");
        }
    }
}

