/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.discovery;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.ldap.util.discovery.CfgflProp;
import oracle.ldap.util.discovery.DiscoveryFailureException;
import oracle.ldap.util.discovery.DiscoveryHelper;
import oracle.ldap.util.discovery.FileExistsException;
import oracle.ldap.util.discovery.MandatoryPropsMissingException;

public class DiscoveryUtil {
    public static int SUCCESS = 0;
    public static int ERR_VERIFICATION_FAILED = 1;

    public static String getConfigFilePath() throws DiscoveryFailureException {
        DiscoveryHelper disco = new DiscoveryHelper(2);
        HashMap reshdl = new HashMap();
        int ret = disco.discover(reshdl);
        if (ret != 0) {
            throw new DiscoveryFailureException(2, ret);
        }
        ArrayList result = (ArrayList)reshdl.get(DiscoveryHelper.CFGFL_PATH);
        if (result != null && result.size() != 0) {
            return (String)result.get(0);
        }
        return null;
    }

    public static CfgflProp getConfigFileProperties(CfgflProp properties) throws DiscoveryFailureException, MandatoryPropsMissingException {
        ArrayList<String> mandMissing = new ArrayList<String>();
        ArrayList<String> discoverProps = new ArrayList<String>();
        ArrayList<String> hostportinfo = new ArrayList<String>();
        ArrayList<String> hostsslportinfo = new ArrayList<String>();
        String host = new String("");
        String port = new String("");
        String sslport = new String("");
        String[] hostarr = null;
        Iterator itr = null;
        CfgflProp cfgprop = (CfgflProp)properties.clone();
        ArrayList dirsrvrs = cfgprop.getMultiValProperty("DIRECTORY_SERVERS");
        String srvrtype = cfgprop.getProperty("DIRECTORY_SERVER_TYPE");
        if (dirsrvrs == null || dirsrvrs.size() == 0) {
            mandMissing.add("DIRECTORY_SERVERS");
        } else {
            boolean valpresent = false;
            itr = dirsrvrs.iterator();
            while (itr.hasNext()) {
                if (((String)itr.next()).length() == 0) continue;
                valpresent = true;
                break;
            }
            if (!valpresent) {
                mandMissing.add("DIRECTORY_SERVERS");
            }
        }
        if (srvrtype == null || srvrtype.length() == 0) {
            mandMissing.add("DIRECTORY_SERVER_TYPE");
        }
        if (mandMissing.size() > 0) {
            throw new MandatoryPropsMissingException(mandMissing);
        }
        String admnctxt = cfgprop.getProperty("DEFAULT_ADMIN_CONTEXT");
        if (admnctxt == null || admnctxt.length() == 0) {
            discoverProps.add("DEFAULT_ADMIN_CONTEXT");
        }
        if (dirsrvrs.size() == 1 && (itr = dirsrvrs.iterator()).hasNext()) {
            hostarr = DiscoveryUtil.parseDirServers((String)itr.next());
            host = hostarr[0];
            port = hostarr[1];
            sslport = hostarr[2];
            if (port.length() == 0 || sslport.length() == 0) {
                discoverProps.add("DIRECTORY_SERVERS");
            }
        }
        if (discoverProps.size() == 0) {
            return cfgprop;
        }
        itr = dirsrvrs.iterator();
        while (itr.hasNext()) {
            hostarr = DiscoveryUtil.parseDirServers((String)itr.next());
            hostportinfo.add(hostarr[0] + ":" + hostarr[1]);
            hostsslportinfo.add(hostarr[0] + ":" + hostarr[2]);
        }
        HashMap reshdl = new HashMap();
        DiscoveryHelper disco = new DiscoveryHelper(4);
        disco.setProperty("3", "0");
        disco.setMultiValProperty("4", hostportinfo);
        int ret = disco.discover(reshdl);
        if (ret != 0) {
            disco.setProperty("3", "1");
            disco.setMultiValProperty("4", hostsslportinfo);
            ret = disco.discover(reshdl);
        }
        if (ret != 0) {
            throw new DiscoveryFailureException(4, ret);
        }
        int len = discoverProps.size();
        for (int i = 0; i < len; ++i) {
            ArrayList result;
            String prop = (String)discoverProps.get(i);
            if (prop.equals("DEFAULT_ADMIN_CONTEXT") && (result = (ArrayList)reshdl.get(DiscoveryHelper.DEF_ADMIN_CTXT)) != null && result.size() != 0) {
                cfgprop.setMultiValProperty(prop, result);
            }
            if (!prop.equals("DIRECTORY_SERVERS")) continue;
            if (port.length() == 0) {
                result = (ArrayList)reshdl.get(DiscoveryHelper.NONSSL_PORT);
                if (result != null && result.size() != 0) {
                    port = (String)result.get(0);
                }
            } else if (sslport.length() == 0 && (result = (ArrayList)reshdl.get(DiscoveryHelper.SSL_PORT)) != null && result.size() != 0) {
                sslport = (String)result.get(0);
            }
            cfgprop.setProperty(prop, host + ":" + port + ":" + sslport);
        }
        return cfgprop;
    }

    private static String[] parseDirServers(String str) {
        String[] arr = new String[3];
        StringTokenizer strtok = new StringTokenizer(str, ":", true);
        String host = new String("");
        String port = new String("");
        String sslport = new String("");
        String token = null;
        block5: for (int ind = 0; ind < 3 && strtok.hasMoreTokens(); ++ind) {
            if (strtok.hasMoreTokens()) {
                token = strtok.nextToken();
            }
            switch (ind) {
                case 0: {
                    if (token.equals(":")) continue block5;
                    host = token;
                    if (!strtok.hasMoreTokens()) continue block5;
                    strtok.nextToken();
                    continue block5;
                }
                case 1: {
                    if (token.equals(":")) continue block5;
                    port = token;
                    if (!strtok.hasMoreTokens()) continue block5;
                    strtok.nextToken();
                    continue block5;
                }
                case 2: {
                    if (token.equals(":")) continue block5;
                    sslport = token;
                }
            }
        }
        arr[0] = host;
        arr[1] = port;
        arr[2] = sslport;
        return arr;
    }

    public static int persistToConfigFile(CfgflProp cfgprop, String path, boolean verify, boolean forcedCreate) throws FileExistsException, DiscoveryFailureException, IOException {
        int ret = SUCCESS;
        int discoret = 0;
        String[] hostarr = null;
        ArrayList<String> hostportinfo = new ArrayList<String>();
        ArrayList<String> hostsslportinfo = new ArrayList<String>();
        if (verify) {
            String prop;
            ArrayList dirsrvrs = cfgprop.getMultiValProperty("DIRECTORY_SERVERS");
            if (dirsrvrs == null || dirsrvrs.size() == 0) {
                return ERR_VERIFICATION_FAILED;
            }
            Iterator itr = dirsrvrs.iterator();
            while (itr.hasNext()) {
                hostarr = DiscoveryUtil.parseDirServers((String)itr.next());
                hostportinfo.add(hostarr[0] + ":" + hostarr[1]);
                hostsslportinfo.add(hostarr[0] + ":" + hostarr[2]);
            }
            HashMap reshdl = new HashMap();
            DiscoveryHelper disco = new DiscoveryHelper(4);
            disco.setProperty("3", "0");
            disco.setMultiValProperty("4", hostportinfo);
            discoret = disco.discover(reshdl);
            if (discoret != 0) {
                disco.setProperty("3", "1");
                disco.setMultiValProperty("4", hostsslportinfo);
                discoret = disco.discover(reshdl);
            }
            if (discoret != 0) {
                throw new DiscoveryFailureException(4, discoret);
            }
            ArrayList vlist = (ArrayList)reshdl.get(DiscoveryHelper.DEF_ADMIN_CTXT);
            String value = null;
            if (vlist != null && vlist.size() > 0) {
                value = (String)vlist.get(0);
            }
            if ((prop = cfgprop.getProperty("DEFAULT_ADMIN_CONTEXT")) != null || value != null) {
                if (prop != null && value != null) {
                    if (!prop.trim().equals(value.trim())) {
                        return ERR_VERIFICATION_FAILED;
                    }
                } else {
                    return ERR_VERIFICATION_FAILED;
                }
            }
        }
        File file = new File(path);
        if (!forcedCreate && file.exists()) {
            throw new FileExistsException(path);
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "US-ASCII"));
        pw.print(cfgprop);
        pw.close();
        return ret;
    }
}

