/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.discovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class DiscoveryHelper {
    public int discoveryType;
    private Hashtable prop;
    public static final int DNS_DISCOVER = 1;
    public static final int CFGFILE_DISCOVER = 2;
    public static final int AUTO_DISCOVER = 3;
    public static final int OID_DISCOVER = 4;
    public static final Integer DEF_ADMIN_CTXT = new Integer(1);
    public static final Integer DIR_SERVERS = new Integer(2);
    public static final Integer DIR_SERVER_TYPE = new Integer(3);
    public static final Integer ALTDIR_SERVERS = new Integer(4);
    public static final Integer ORCLCOMMCTXMAP = new Integer(5);
    public static final Integer DIR_SERVER_CONN_SEC = new Integer(6);
    public static final Integer CFGFL_PATH = new Integer(7);
    public static final Integer SSL_PORT = new Integer(8);
    public static final Integer NONSSL_PORT = new Integer(9);
    public static final Integer DETAILED_ERROR_INFO = new Integer(10);
    public static final String SSL_FALSE = "0";
    public static final String SSL_TRUE = "1";
    public static final String DNS_DN = "1";
    public static final String DNS_DISCOVER_METHOD = "2";
    public static final String SSLMODE = "3";
    public static final String HOSTINFO = "4";
    public static final String GEN_DETAILED_ERR_RPT = "5";
    public static final String USE_INPUT_DN_METHOD = "1";
    public static final String USE_MC_DOMAIN_METHOD = "2";
    public static final String USE_DFLT_LOOKUP_METHOD = "4";
    public static final String USE_ALL_METHODS = "7";
    public static final int LDAP_NO_INFO_OBTAINED = 500;
    public static final int LDAP_LOOKUP_ERROR = 501;
    public static final int LDAP_DNS_ADDR_NOT_FOUND = 502;
    public static final int LDAP_FILE_NOT_FOUND = 503;
    public static final int LDAP_FILE_PARSE_ERROR = 504;
    public static final int LDAP_PARAM_ERROR = 89;
    public static final int LDAP_SUCCESS = 0;

    public DiscoveryHelper(int type) {
        this.discoveryType = type;
        this.prop = new Hashtable();
    }

    public int discover(HashMap reshdl) {
        return DiscoveryHelper.ldapDiscover(this.discoveryType, this.prop, reshdl);
    }

    public Object setProperty(String property, String value) {
        if (property.equals("4")) {
            ArrayList<String> al = new ArrayList<String>();
            al.add(value);
            return this.prop.put(property, al);
        }
        return this.prop.put(property, value);
    }

    public Object setMultiValProperty(String property, ArrayList lst) {
        if (property.equals("4")) {
            return this.prop.put(property, lst.clone());
        }
        Iterator itr = lst.iterator();
        if (itr.hasNext()) {
            return this.prop.put(property, (String)itr.next());
        }
        return null;
    }

    public String getProperty(String property) {
        if (property.equals("4")) {
            ArrayList lst = (ArrayList)this.prop.get(property);
            if (lst == null) {
                return null;
            }
            Iterator itr = lst.iterator();
            if (itr.hasNext()) {
                return (String)itr.next();
            }
            return null;
        }
        return (String)this.prop.get(property);
    }

    public ArrayList getMultiValProperty(String property) {
        if (property.equals("4")) {
            ArrayList al = (ArrayList)this.prop.get(property);
            if (al == null) {
                return null;
            }
            return (ArrayList)al.clone();
        }
        ArrayList<String> al = new ArrayList<String>();
        al.add((String)this.prop.get(property));
        return al;
    }

    private static native int ldapDiscover(int var0, Hashtable var1, HashMap var2);

    static {
        try {
            Class.forName("oracle.ldap.util.LibldapjclntLoader");
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println(cnfe);
        }
    }
}

