/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util.controls;

import java.util.HashMap;
import javax.naming.ldap.Control;
import oracle.ldap.util.ber.BEREncoder;
import oracle.ldap.util.ber.EncodeException;

public class DynamicVerifierRequestControl
implements Control {
    private String controlID = "2.16.840.1.113894.1.8.14";
    private boolean criticality = true;
    private final String defaultVersion = "1";
    private int sequenceTag = 161;
    public static final String CRYPTO_SCHEME = "crypto_scheme";
    public static final String USER_NAME = "user_name";
    public static final String REALM_NAME = "realm_name";
    public static final String NONCE = "nonce";
    public static final String VERSION = "version";
    private HashMap ctlProperties = new HashMap();

    public DynamicVerifierRequestControl() {
        this.ctlProperties.put(VERSION, "1");
    }

    public String getID() {
        return this.controlID;
    }

    public boolean isCritical() {
        return this.criticality;
    }

    public void set(String valueType, Object value) {
        this.ctlProperties.put(valueType, value);
    }

    public byte[] getEncodedValue() {
        boolean encodeUTF8 = true;
        try {
            BEREncoder berElement = new BEREncoder();
            berElement.beginSeq(this.sequenceTag);
            berElement.encodeInt(Integer.parseInt((String)this.ctlProperties.get(VERSION)));
            if (this.ctlProperties.containsKey(CRYPTO_SCHEME)) {
                berElement.encodeString((String)this.ctlProperties.get(CRYPTO_SCHEME), encodeUTF8);
            }
            if (this.ctlProperties.containsKey(USER_NAME)) {
                berElement.encodeString((String)this.ctlProperties.get(USER_NAME), encodeUTF8);
            }
            if (this.ctlProperties.containsKey(REALM_NAME)) {
                berElement.encodeString((String)this.ctlProperties.get(REALM_NAME), encodeUTF8);
            }
            if (this.ctlProperties.containsKey(NONCE)) {
                berElement.encodeString((String)this.ctlProperties.get(NONCE), encodeUTF8);
            }
            berElement.endSeq();
            return berElement.getTrimmedBuf();
        }
        catch (EncodeException e) {
            return null;
        }
    }

    public String toString() {
        return super.toString() + "\n" + this.ctlProperties;
    }
}

