/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.StringTokenizer;
import javax.naming.NamingException;

public class UtilException
extends Exception {
    protected int ldapErrorCode = -1;
    protected int passwordPolicyErrorCode = -1;
    protected Exception e = null;
    protected boolean isNamingException = false;
    protected boolean hasPasswordPolicyError = false;
    protected boolean hasLDAPErrorCode = false;
    protected NamingException ne = null;

    protected UtilException() {
    }

    protected UtilException(String s) {
        super(s);
    }

    private UtilException(NamingException ine) {
        this.isNamingException = true;
        this.parseErrorCode(ine);
    }

    public UtilException(Exception e) {
        super(e);
    }

    protected UtilException(String s, Exception ine) {
        super(s + " " + ine.getMessage());
        if (ine instanceof NamingException) {
            this.ne = (NamingException)ine;
            this.isNamingException = true;
            this.parseErrorCode((NamingException)ine);
        }
        this.e = ine;
    }

    public NamingException returnNamingException() {
        return this.ne;
    }

    public boolean isNamingException() {
        return this.isNamingException;
    }

    public boolean hasPasswordPolicyError() {
        return this.hasPasswordPolicyError;
    }

    public boolean hasLDAPErrorCode() {
        return this.hasLDAPErrorCode;
    }

    public int getLDAPErrorCode() {
        return this.ldapErrorCode;
    }

    public int getPasswordPolicyErrorCode() {
        return this.passwordPolicyErrorCode;
    }

    public static int getLDAPErrorCode(NamingException ne) {
        return new UtilException(ne).getLDAPErrorCode();
    }

    private void parseErrorCode(NamingException ne) {
        StringTokenizer st;
        String s = ne.toString();
        int i = s.indexOf("LDAP: error code");
        if (i > -1) {
            this.hasLDAPErrorCode = true;
            st = new StringTokenizer(s.substring(i));
            st.nextToken();
            st.nextToken();
            st.nextToken();
            if (st.hasMoreTokens()) {
                try {
                    this.ldapErrorCode = new Integer(st.nextToken());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        if ((i = s.indexOf(":")) > -1) {
            st = new StringTokenizer(s.substring(i), ":");
            while (st.hasMoreTokens()) {
                try {
                    this.passwordPolicyErrorCode = new Integer(st.nextToken());
                    if (this.passwordPolicyErrorCode <= 999 || this.passwordPolicyErrorCode >= 10000) continue;
                    this.hasPasswordPolicyError = true;
                    break;
                }
                catch (NumberFormatException nfe) {
                }
            }
        }
    }
}

