/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.DistinguishedName;
import oracle.ldap.util.GeneralErrorException;
import oracle.ldap.util.Group;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.InvalidRootOrclctxException;
import oracle.ldap.util.LDAPObjectClass;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFLoader;
import oracle.ldap.util.LDIFReader;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.LDIFSubstitute;
import oracle.ldap.util.LDIFWriter;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.NoGroupMembersException;
import oracle.ldap.util.OUILdap;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.SetPropertiesException;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.User;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.UtilException;
import oracle.ldap.util.nls.NlsMsg;

public class Util {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    private static ResourceBundle resBundle = null;
    public static String API_VERSION;
    public static String INTERFACE_VERSION;
    private static String[] SUPPORTED_VERSION;
    public static int PWD_VERIFIERTYPE_COMMON;
    public static int IDTYPE_DN;
    public static int IDTYPE_SIMPLE;
    public static int IDTYPE_GUID;
    public static int IDTYPE_DEFAULT;
    public static int IDTYPE_FILTER;
    public static int IDTYPE_WINDOWS;
    public static int IDTYPE_KERB_PRINCIPAL;
    public static int PROPERTIES_ENTRY;
    public static int PROPERTIES_DETACHED;
    public static int CREDTYPE_PASSWD;
    public static String DASURL_BASE;
    public static String DASURL_CREATE_USER;
    public static String DASURL_EDIT_GROUP;
    public static String DASURL_EDIT_GROUP_GIVEN_GUID;
    public static String DASURL_GROUP_SEARCH;
    public static String DASURL_EDIT_USER;
    public static String DASURL_GROUP_LOV;
    public static String DASURL_DELETE_USER;
    public static String DASURL_USER_PRIVILEGE;
    public static String DASURL_CREATE_GROUP;
    public static String DASURL_USER_SEARCH;
    public static String DASURL_ACCOUNT_INFO;
    public static String DASURL_EDIT_USER_GIVEN_GUID;
    public static String DASURL_DELETE_USER_GIVEN_GUID;
    public static String DASURL_DELETE_GROUP_GIVEN_GUID;
    public static String DASURL_GROUP_PRIVILEGE;
    public static String DASURL_USER_PRIVILEGE_GIVEN_GUID;
    public static String DASURL_PASSWORD_CHANGE;
    public static String DASURL_USER_LOV;
    public static String DASURL_GROUP_PRIVILEGE_GIVEN_GUID;
    public static String DASURL_DELETE_GROUP;
    public static String DASURL_CREATE_RESOURCE;
    public static String DASURL_EUS_CONSOLE;
    public static String DASURL_DELEGATION_CONSOLE;
    public static String DASURL_EDIT_MY_PROFILE;
    public static String DASURL_RESET_PASSWORD;
    public static String DASURL_VIEW_USER_PROFILE;
    public static String DASURL_TIMEZONE;
    public static final int FILE_EXISTENCE = 1;
    public static final int FILE_NOT_EXISTENCE = 2;
    public static final int FILE_READABLE = 4;
    public static final int FILE_WRITABLE = 8;
    public static final int FILE_NOT_EMPTY = 16;
    public static final int FILE_CREATEABLE = 32;
    private static String[] DASurlDNs;
    private static String rootOracleContextDN;
    private static String commonDN;
    private static String DASbaseDN;
    private static final String JNDI_SPECIAL_CHARS = "*()\\\u0000";
    private static final String[] JNDI_SUBSTITUTION_HEX_CHARS;
    private static final String[] JNDI_SUBSTITUTION_DN_ATTR_HEX_CHARS;

    static void addEntry(DirContext ctx, String dn, String[] attrs, Object[][] attrValArray, Logger lgr) throws NamingException {
        m_logger = lgr;
        Util.addEntry(ctx, dn, attrs, attrValArray);
    }

    static void addEntry(DirContext ctx, String dn, String[] attrs, Object[][] attrValArray) throws NamingException {
        if (attrs.length != attrValArray.length) {
            m_logger.log(Level.INFO, "Attribute list size and attribute values don't match in sizes");
        }
        BasicAttributes curAttrs = new BasicAttributes(true);
        for (int i = 0; i < attrs.length; ++i) {
            BasicAttribute curAttr = new BasicAttribute(attrs[i]);
            for (int j = 0; j < attrValArray[i].length; ++j) {
                curAttr.add(attrValArray[i][j]);
            }
            curAttrs.put(curAttr);
        }
        DirContext result = ctx.createSubcontext(dn, (Attributes)curAttrs);
        result.close();
    }

    static void addEntry(DirContext ctx, String dn, Attributes attrs) throws NamingException {
        DirContext result = ctx.createSubcontext(dn, attrs);
        result.close();
    }

    public static PropertySetCollection getEntryDetails(DirContext ctx, String base, String filter, int scope, String[] attrList) throws NamingException {
        return (PropertySetCollection)Util.getEntryDetails(ctx, base, filter, scope, attrList, true);
    }

    public static Object getEntryDetails(DirContext ctx, String base, String filter, int scope, String[] attrList, boolean convert) throws NamingException {
        UtilDebug.log(4, "Util: ", "ldapsearch: ");
        UtilDebug.log(4, "Util: ", ctx);
        UtilDebug.log(2, "Util: ", "ldapsearch  base=" + base + " filter=" + filter + " scope=" + scope);
        UtilDebug.log(2, "Util: ", "required attributes=");
        UtilDebug.log(2, "Util: ", attrList);
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(scope);
        if (scope == 0 && attrList != null && attrList.length == 0) {
            ctls.setReturningAttributes(new String[]{"dn"});
        } else {
            ctls.setReturningAttributes(attrList);
        }
        NamingEnumeration resultSet = (NamingEnumeration)Util.getEntryDetails(ctx, base, filter, ctls);
        if (convert) {
            return new PropertySetCollection(base, resultSet);
        }
        return resultSet;
    }

    public static Object getEntryDetails(DirContext ctx, String base, String filter, SearchControls ctls) throws NamingException {
        NameParser ldapParser = ctx.getNameParser("");
        Name compound = ldapParser.parse(base);
        NamingEnumeration<SearchResult> resultSet = ctx.search(compound, filter, ctls);
        return resultSet;
    }

    public static void setEntryDetails(DirContext ctx, String base, ModificationItem[] mods) throws UtilException {
        try {
            ctx.modifyAttributes(base, mods);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new SetPropertiesException(e.toString(), e);
        }
    }

    public static void setEntryDetails(DirContext ctx, String base, ModPropertySet ps) throws UtilException {
        Util.ldapModify(ctx, base, ps);
    }

    public static void authenticateUser(DirContext ctx, User curUser, int authType, Object cred) throws UtilException {
        curUser.authenticateUser(ctx, authType, cred);
    }

    public static String getSubscriberDn(DirContext ctx, String subId, int subIdType, Logger lgr) throws UtilException {
        Subscriber subs = new Subscriber(ctx, subIdType, subId, true, lgr);
        return subs.getDN(ctx);
    }

    public static String getSubscriberDn(DirContext ctx, String subId, int subIdType) throws UtilException {
        Subscriber subs = new Subscriber(ctx, subIdType, subId, true);
        return subs.getDN(ctx);
    }

    public static String getUserDn(DirContext ctx, String userId, int userIdType, String subscriberDN) throws UtilException {
        User myUser = new User(ctx, userIdType, userId, IDTYPE_DN, subscriberDN, true);
        return myUser.getDN(ctx);
    }

    public static PropertySetCollection getOwnership(DirContext ctx, User curUser, String[] attrList, boolean nested) throws UtilException {
        if (curUser == null) {
            return new PropertySetCollection();
        }
        return Util.getOwnership(ctx, curUser.getDN(ctx), attrList, nested);
    }

    public static PropertySetCollection getOwnership(DirContext ctx, String dn, String[] attrList, boolean nested) throws UtilException {
        return Util.getOwnership(ctx, "", dn, attrList, nested);
    }

    protected static PropertySetCollection getOwnership(DirContext ctx, String base, String dn, String[] attrList, boolean nested) throws UtilException {
        if (dn == null || ctx == null) {
            return new PropertySetCollection();
        }
        String sfilter = !nested ? Util.makeFilter("owner", dn) : Util.makeFilterFromGroupMem(ctx, dn, "owner");
        try {
            return Util.getEntryDetails(ctx, base, sfilter, 2, attrList);
        }
        catch (NamingException ne) {
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            return new PropertySetCollection();
        }
    }

    static String makeFilterFromGroupMem(DirContext ctx, String startdn, String searchAttr) throws UtilException {
        if (ctx == null) {
            return null;
        }
        PropertySetCollection groups = Util.getGroupMembership(ctx, startdn, new String[]{"dn"}, true);
        String userMem = "(" + Util.makeFilter(searchAttr, startdn);
        String filter = groups.size() == 0 ? userMem : "(|" + userMem + ")";
        for (int i = 0; i < groups.size(); ++i) {
            String gdn = groups.getPropertySet(i).getDN();
            filter = new String(filter + "(" + Util.makeFilter(searchAttr, gdn) + ")");
        }
        return filter + ")";
    }

    public static PropertySetCollection getGroupMembership(DirContext ctx, User curUser, String[] attrList, boolean nested) throws UtilException {
        return Util.getGroupMembership(ctx, curUser.getDN(ctx), attrList, nested);
    }

    public static PropertySetCollection getGroupMembership(DirContext ctx, String dn, String[] attrList, boolean nested, String memberAttribute) throws UtilException {
        PropertySetCollection resultVector = null;
        resultVector = nested ? Util.getGroups(ctx, dn, attrList, new String[]{memberAttribute}) : Util.getDirectGroupMembership(ctx, dn, attrList, new String[]{memberAttribute});
        return resultVector;
    }

    public static PropertySetCollection getGroupMembership(DirContext ctx, String dn, String[] attrList, boolean nested) throws UtilException {
        PropertySetCollection resultVector = null;
        resultVector = nested ? Util.getGroups(ctx, dn, attrList, Group.GROUP_MEMBERS) : Util.getDirectGroupMembership(ctx, dn, attrList, Group.GROUP_MEMBERS);
        return resultVector;
    }

    private static PropertySetCollection getDirectGroupMembership(DirContext ctx, String userDN, String[] attrList, String[] searchAttrs) throws UtilException {
        try {
            return Util.getDirectGroupMembershipVector(ctx, "", userDN, attrList, searchAttrs);
        }
        catch (UtilException e) {
            if (e instanceof CommunicationErrorException) {
                throw e;
            }
            throw new NoGroupMembersException();
        }
    }

    static PropertySetCollection getDirectGroupMembershipVector(DirContext ctx, String base, String userDN, String[] attrList, String[] searchAttrs) throws UtilException {
        try {
            return Util.getEntryDetails(ctx, base, Util.makeFilters(searchAttrs, userDN, true), 2, attrList);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            return new PropertySetCollection();
        }
    }

    private static PropertySetCollection getGroups(DirContext ctx, String userDN, String[] attrList, String[] searchAttrs) throws UtilException {
        String[] newAttrList = null;
        if (attrList != null) {
            newAttrList = new String[attrList.length + 1];
            for (int i = 0; i < attrList.length; ++i) {
                newAttrList[i] = attrList[i];
            }
            newAttrList[attrList.length] = "orclguid";
        }
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(newAttrList);
        Hashtable result = new Hashtable(100);
        Util.getNestedGroups(ctx, null, Util.makeFilters(searchAttrs, userDN, true), searchAttrs, ctls, result);
        return Util.convert2Collection(result, attrList);
    }

    private static PropertySetCollection convert2Collection(Hashtable result, String[] attrList) {
        PropertySetCollection psc = new PropertySetCollection(result.size());
        Enumeration values = result.elements();
        while (values.hasMoreElements()) {
            PropertySet ps;
            SearchResult sr = (SearchResult)values.nextElement();
            if (attrList == null) {
                ps = new PropertySet("", sr);
                psc.add(ps);
                continue;
            }
            ps = new PropertySet(sr.getName(), sr.getAttributes(), null);
            psc.add(ps.returnPropertySet(attrList));
        }
        return psc;
    }

    protected static void grpErrHandler(NamingException ne, UtilException ue) throws UtilException {
        int errcode = ue.getLDAPErrorCode();
        switch (errcode) {
            case 51: 
            case 52: 
            case 53: 
            case 81: 
            case 88: {
                throw new NoGroupMembersException(ue.toString());
            }
            case 50: {
                return;
            }
        }
        if (ne instanceof CommunicationException) {
            throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
        }
        throw ue;
    }

    static boolean getNestedGroups(DirContext ctx, String guid, String filter, String[] searchAttrs, SearchControls ctls, Hashtable curList) throws UtilException {
        try {
            int groupsReturned = 0;
            String searchFilter = "";
            NamingEnumeration<SearchResult> nr = ctx.search("", filter, ctls);
            while (nr.hasMore()) {
                SearchResult sr = nr.next();
                String key = null;
                boolean getNestedGroup = false;
                try {
                    key = Util.getGUID(sr);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (guid != null && guid.equalsIgnoreCase(key)) {
                    return true;
                }
                if (key != null && !curList.containsKey(key)) {
                    curList.put(key, sr);
                    getNestedGroup = true;
                } else if (key == null && !Util.isDNInCurrList(curList, sr.getName())) {
                    curList.put(sr.getName(), sr);
                    getNestedGroup = true;
                }
                if (!getNestedGroup) continue;
                searchFilter = searchFilter + Util.makeFilters(searchAttrs, sr.getName(), false);
                if (++groupsReturned <= 1 || searchFilter.length() < 10240) continue;
                searchFilter = "(|" + searchFilter + ")";
                Util.getNestedGroups(ctx, guid, searchFilter, searchAttrs, ctls, curList);
                searchFilter = "";
                groupsReturned = 0;
            }
            if (groupsReturned > 0) {
                if (searchAttrs.length > 1 || groupsReturned > 1) {
                    searchFilter = "(|" + searchFilter + ")";
                }
                if (Util.getNestedGroups(ctx, guid, searchFilter, searchAttrs, ctls, curList)) {
                    return true;
                }
            }
        }
        catch (NamingException ne) {
            Util.grpErrHandler(ne, new UtilException("getGroupMembership", ne));
        }
        return false;
    }

    private static boolean isDNInCurrList(Hashtable result, String dn) {
        dn = Util.normalizeDN(dn);
        Enumeration values = result.elements();
        while (values.hasMoreElements()) {
            SearchResult sr = (SearchResult)values.nextElement();
            String grpNormDN = Util.normalizeDN(sr.getName());
            if (!grpNormDN.equals(Util.normalizeDN(dn))) continue;
            return true;
        }
        return false;
    }

    protected static String[] vector2StrArray(Vector list) {
        if (list.size() > 0) {
            String[] stringList = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringList[i] = (String)list.elementAt(i);
            }
            return stringList;
        }
        return null;
    }

    public static String normalizeDN(String inDN, String[] attrList) {
        try {
            int i;
            DistinguishedName dn = new DistinguishedName(inDN);
            ArrayList<String> allowedAttributeList = new ArrayList<String>(attrList.length);
            for (i = 0; i < attrList.length; ++i) {
                allowedAttributeList.add(attrList[i]);
            }
            for (i = 0; i < dn.size(); ++i) {
                String rdn = dn.get(i);
                String rdnAttributeName = rdn.substring(0, rdn.indexOf("="));
                if (allowedAttributeList.contains(rdnAttributeName)) continue;
                return null;
            }
            return dn.getNormalizedDN();
        }
        catch (InvalidNameException ie) {
            return null;
        }
    }

    private static String normalizeDN(String inDN, int optType, String[] attrList, DirContext ctx) throws UtilException {
        boolean findEqualSign = true;
        boolean findAttrValue = false;
        boolean quotedValueFound = false;
        boolean parsingComplete = false;
        boolean curIndex = false;
        boolean level = false;
        int curOptType = optType;
        String normDN = "";
        String curString = inDN;
        Vector<String> attrVec = null;
        Vector<String> valueVec = null;
        if (curOptType == 3) {
            attrVec = new Vector<String>();
            valueVec = new Vector<String>();
        }
        while (curString.length() > 0) {
            Object curAttr = null;
            if (findEqualSign) {
                int equalIndex = curString.indexOf("=");
                if (equalIndex <= 0) {
                    normDN = null;
                    break;
                }
                String attr = curString.substring(0, equalIndex).trim().toLowerCase();
                if (curOptType == 3) {
                    attrVec.addElement(attr);
                }
                if (attrList != null) {
                    boolean notfound = true;
                    for (int i = 0; i < attrList.length; ++i) {
                        if (!attr.equalsIgnoreCase(attrList[i])) continue;
                        notfound = false;
                        break;
                    }
                    if (notfound) {
                        normDN = null;
                        break;
                    }
                }
                normDN = normDN + attr + "=";
                curString = curString.substring(equalIndex + 1).trim();
                findEqualSign = false;
                findAttrValue = true;
            } else if (findAttrValue) {
                if (curString.startsWith("\"")) {
                    int endQuoteIndex = curString.indexOf("\"", 1);
                    if (endQuoteIndex <= 1) {
                        normDN = null;
                        break;
                    }
                    normDN = normDN + curString.substring(0, endQuoteIndex + 1);
                    if (curOptType == 3) {
                        valueVec.addElement(curString.substring(0, endQuoteIndex + 1));
                    }
                    curString = curString.substring(endQuoteIndex + 1).trim();
                    quotedValueFound = true;
                } else {
                    quotedValueFound = false;
                }
                findAttrValue = false;
            } else {
                int commaIndex = curString.indexOf(",");
                if (commaIndex >= 0) {
                    normDN = normDN + curString.substring(0, commaIndex).trim().toLowerCase() + ",";
                    if (curOptType == 3 && !quotedValueFound) {
                        valueVec.addElement(curString.substring(0, commaIndex).trim());
                    }
                    curString = curString.substring(commaIndex + 1);
                    findEqualSign = true;
                } else {
                    normDN = normDN + curString.trim().toLowerCase();
                    if (curOptType == 3 && !quotedValueFound) {
                        valueVec.addElement(curString.trim());
                    }
                    curString = "";
                    findEqualSign = true;
                    parsingComplete = true;
                }
            }
            if (curOptType == 0) continue;
            if (findEqualSign && curOptType == 1) {
                if (normDN.endsWith(",")) {
                    return normDN.substring(0, normDN.length() - 1);
                }
                return normDN;
            }
            if (!findEqualSign || curOptType != 2) continue;
            normDN = "";
            curOptType = 0;
        }
        if (curOptType == 3 && attrVec.size() == valueVec.size()) {
            String curDN = "";
            for (int i = attrVec.size() - 1; i >= 0; --i) {
                String[] objcls;
                ModPropertySet mps = new ModPropertySet();
                String attrStr = (String)attrVec.elementAt(i);
                String attrValue = (String)valueVec.elementAt(i);
                if (attrStr.equalsIgnoreCase("ou")) {
                    objcls = new String[]{"organizationalUnit", "top"};
                    mps.addProperty(0, "objectclass", objcls);
                }
                if (attrStr.equalsIgnoreCase("dc")) {
                    objcls = new String[]{"domain", "top"};
                    mps.addProperty(0, "objectclass", objcls);
                } else if (attrStr.equalsIgnoreCase("o")) {
                    objcls = new String[]{"organization", "top"};
                    mps.addProperty(0, "objectclass", objcls);
                } else if (attrStr.equalsIgnoreCase("c")) {
                    objcls = new String[]{"country", "top"};
                    mps.addProperty(0, "objectclass", objcls);
                } else if (attrStr.equalsIgnoreCase("l")) {
                    objcls = new String[]{"locality", "top"};
                    mps.addProperty(0, "objectclass", objcls);
                }
                mps.addProperty(0, attrStr, attrValue);
                curDN = i == attrVec.size() - 1 ? attrStr + "=" + attrValue : attrStr + "=" + attrValue + "," + curDN;
                if (Util.dnExists(ctx, curDN)) continue;
                Util.ldapAdd(ctx, curDN, mps);
            }
        }
        return normDN;
    }

    public static String normalizeDN(String inDN) {
        if (inDN == null) {
            return null;
        }
        try {
            return new DistinguishedName(inDN).getNormalizedDN();
        }
        catch (InvalidNameException ie) {
            return null;
        }
    }

    public static String createDN(DirContext ctx, String inDN) throws UtilException {
        String[] attrList = new String[]{"dc", "o", "l", "c", "ou"};
        ArrayList<String> allowedAttributeList = new ArrayList<String>(attrList.length);
        for (int i = 0; i < attrList.length; ++i) {
            allowedAttributeList.add(attrList[i]);
        }
        if (Util.normalizeDN(inDN, attrList) == null) {
            return null;
        }
        DistinguishedName dn = null;
        try {
            dn = new DistinguishedName(inDN);
        }
        catch (InvalidNameException ie) {
            return null;
        }
        for (int i = 1; i < dn.size() + 1; ++i) {
            String[] objcls;
            DistinguishedName dnPrefix = (DistinguishedName)dn.getPrefix(i);
            if (Util.dnExists(ctx, dnPrefix.toString())) continue;
            String rdn = dnPrefix.get(i - 1);
            ModPropertySet mps = new ModPropertySet();
            String attrStr = rdn.substring(0, rdn.indexOf("="));
            String attrValue = rdn.substring(rdn.indexOf("=") + 1, rdn.length());
            if (attrStr.equalsIgnoreCase("ou")) {
                objcls = new String[]{"organizationalUnit", "top"};
                mps.addProperty(0, "objectclass", objcls);
            } else if (attrStr.equalsIgnoreCase("dc")) {
                objcls = new String[]{"domain", "top"};
                mps.addProperty(0, "objectclass", objcls);
            } else if (attrStr.equalsIgnoreCase("o")) {
                objcls = new String[]{"organization", "top"};
                mps.addProperty(0, "objectclass", objcls);
            } else if (attrStr.equalsIgnoreCase("c")) {
                objcls = new String[]{"country", "top"};
                mps.addProperty(0, "objectclass", objcls);
            } else if (attrStr.equalsIgnoreCase("l")) {
                objcls = new String[]{"locality", "top"};
                mps.addProperty(0, "objectclass", objcls);
            }
            mps.addProperty(0, attrStr, attrValue);
            Util.ldapAdd(ctx, dnPrefix.toString(), mps);
        }
        return dn.getNormalizedDN();
    }

    public static String getDASUrl(DirContext ctx, String urlTypeDN) throws UtilException {
        String urlDN = new String("cn=OperationURLs," + DASbaseDN);
        try {
            String[] attrList;
            PropertySetCollection propSetCol = null;
            if (urlTypeDN.equals("")) {
                attrList = new String[]{"orcldasurlbase"};
                propSetCol = Util.getEntryDetails(ctx, urlDN, "(objectclass=*)", 0, attrList);
            } else {
                attrList = new String[]{"orcldasurl"};
                propSetCol = Util.getEntryDetails(ctx, Util.normalizeDN(urlTypeDN) + "," + urlDN, "(objectclass=*)", 0, attrList);
            }
            PropertySet propSet = propSetCol.getPropertySet(0);
            return (String)propSet.getProperty(0).getValue(0);
        }
        catch (Exception e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            if (e instanceof NamingException) {
                throw new InvalidRootOrclctxException(resBundle.getString("INVALID_ROOT_CTX"), e);
            }
            throw new InvalidRootOrclctxException(resBundle.getString("INVALID_ROOT_CTX"));
        }
    }

    public static Hashtable getAllDASUrl(DirContext ctx) throws UtilException {
        String urlDN = new String("cn=OperationURLs," + DASbaseDN);
        Hashtable<String, Object> urlTable = new Hashtable<String, Object>(DASurlDNs.length);
        try {
            String[] baseURLattrList = new String[]{"orcldasurlbase"};
            PropertySetCollection basePropSetCol = Util.getEntryDetails(ctx, urlDN, "(objectclass=*)", 0, baseURLattrList);
            PropertySet basePropSet = basePropSetCol.getPropertySet(0);
            urlTable.put("", basePropSet.getProperty(0).getValue(0));
            String[] attrList = new String[]{"orcldasurl"};
            PropertySetCollection propSetCol = Util.getEntryDetails(ctx, urlDN, "(objectclass=*)", 1, attrList);
            for (int i = 0; i < propSetCol.size(); ++i) {
                PropertySet propSet = propSetCol.getPropertySet(i);
                String urlDNType = Util.normalizeDN(new StringTokenizer(propSet.getDN(), ",", false).nextToken());
                urlTable.put(urlDNType, propSet.getProperty(0).getValue(0));
            }
            return urlTable;
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new InvalidRootOrclctxException(resBundle.getString("INVALID_ROOT_CTX"));
        }
    }

    public static void printResults(PropertySetCollection resultSet) {
        try {
            for (int i = 0; i < resultSet.size(); ++i) {
                PropertySet curEntry = resultSet.getPropertySet(i);
                Object obj = null;
                System.out.println("dn: " + curEntry.getDN());
                for (int j = 0; j < curEntry.size(); ++j) {
                    Property curAttr = curEntry.getProperty(j);
                    for (int k = 0; k < curAttr.size(); ++k) {
                        obj = curAttr.getValue(k);
                        if (obj instanceof String) {
                            System.out.println(curAttr.getName() + ": " + (String)obj);
                            continue;
                        }
                        if (!(obj instanceof byte[])) continue;
                        System.out.println(curAttr.getName() + ": NON ASCII");
                    }
                }
                System.out.println();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static String[] getDefaultSubscriber(Logger lgr) {
        m_logger = lgr;
        return Util.getDefaultSubscriber();
    }

    public static String[] getDefaultSubscriber() {
        StringTokenizer domainTok = new StringTokenizer(Util.getDomain(), ".", false);
        while (domainTok.countTokens() > 2) {
            domainTok.nextToken();
        }
        String[] strArr = new String[2];
        strArr[1] = domainTok.nextToken();
        strArr[0] = domainTok.nextToken();
        return strArr;
    }

    public static String getDomain(Logger lgr) {
        m_logger = lgr;
        return Util.getDomain();
    }

    public static String getDomain() {
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            m_logger.log(Level.INFO, "Inet: " + hostName);
            StringTokenizer strTok = new StringTokenizer(hostName, ".");
            if (strTok.countTokens() == 1) {
                return strTok.nextToken() + ".com";
            }
            if (strTok.countTokens() == 2) {
                return hostName;
            }
            strTok.nextToken();
            return strTok.nextToken("?").substring(1);
        }
        catch (Exception e) {
            return "domain.com";
        }
    }

    public static void subAndLoadLdif(DirContext ctx, String filename, Vector subVector, Logger lgr) throws UtilException {
        m_logger = lgr;
        Util.subAndLoadLdif(ctx, filename, subVector);
    }

    public static void subAndLoadLdif(DirContext ctx, String filename, Vector subVector) throws UtilException {
        try {
            m_logger.log(Level.INFO, "in subandload: " + filename);
            LDIFReader ldifReader = new LDIFReader(filename);
            LDIFWriter ldifWriter = null;
            ByteArrayOutputStream outStream = null;
            outStream = new ByteArrayOutputStream();
            ldifWriter = new LDIFWriter(outStream);
            Vector ldifEntry = null;
            Vector subsLdifEntry = null;
            while ((ldifEntry = ldifReader.nextEntry()) != null) {
                subsLdifEntry = LDIFSubstitute.substitute(ldifEntry, subVector);
                ldifWriter.writeEntry(subsLdifEntry);
            }
            ldifWriter.close();
            ldifReader.close();
            ldifReader = new LDIFReader(new ByteArrayInputStream(outStream.toByteArray()));
            LDIFRecord curRecord = null;
            while ((curRecord = ldifReader.nextRecord()) != null) {
                switch (curRecord.getChangeType()) {
                    case 1: {
                        Attributes attrs = curRecord.getJNDIAttributes();
                        DirContext result = ctx.createSubcontext(curRecord.getDN(), attrs);
                        result.close();
                        break;
                    }
                    case 3: {
                        ModificationItem[] modItem = curRecord.getJNDIModificationItems();
                        ctx.modifyAttributes(curRecord.getDN(), modItem);
                        break;
                    }
                    case 2: {
                        ctx.destroySubcontext(curRecord.getDN());
                    }
                }
            }
            ldifReader.close();
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            m_logger.log(Level.INFO, "Naming Exception in subandload");
        }
        catch (IOException e) {
            m_logger.log(Level.SEVERE, "IOException in performing substitution", e);
        }
    }

    public static String getFQHN() {
        String fQHN = null;
        try {
            InetAddress locHost = InetAddress.getLocalHost();
            locHost = InetAddress.getByName(locHost.getHostAddress());
            fQHN = locHost.getHostName();
        }
        catch (UnknownHostException ue) {
            return null;
        }
        return fQHN;
    }

    public static String getIAC_DNFromFQHN() throws UtilException {
        String fQHN = Util.getFQHN();
        if (fQHN != null) {
            String DN = new String();
            StringTokenizer strTok = new StringTokenizer(Util.getFQHN(), ".");
            if (strTok.countTokens() < 2) {
                DN = "dc=" + strTok.nextToken() + ",dc=com";
                return DN;
            }
            strTok.nextToken();
            while (strTok.hasMoreTokens()) {
                if (strTok.countTokens() > 1) {
                    DN = DN + "dc=" + strTok.nextToken() + ",";
                    continue;
                }
                DN = DN + "dc=" + strTok.nextToken();
            }
            return DN;
        }
        return null;
    }

    public static String getParentDN(String dn) {
        try {
            return new DistinguishedName(dn).getParentDN().toString();
        }
        catch (InvalidNameException ie) {
            return null;
        }
    }

    public static String getRDN(String dn) {
        try {
            return new DistinguishedName(dn).getRDN().toString();
        }
        catch (InvalidNameException e) {
            return null;
        }
    }

    public static boolean dnExists(DirContext ctx, String dn) throws UtilException {
        PropertySetCollection propSetCol = Util.dnExists(ctx, dn, new String[0]);
        return propSetCol != null;
    }

    public static PropertySetCollection dnExists(DirContext ctx, String dn, String[] attrs) throws UtilException {
        try {
            PropertySetCollection propSetCol = Util.getEntryDetails(ctx, dn, "(objectclass=*)", 0, attrs);
            return propSetCol;
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            if (e instanceof NameNotFoundException) {
                return null;
            }
            if (e.getExplanation().indexOf("36") > -1) {
                return null;
            }
            throw new UtilException(resBundle.getString("GENERAL_ERROR_SEARCH"), e);
        }
    }

    public static boolean checkInterfaceVersion(String intVersion) {
        return intVersion.compareTo(SUPPORTED_VERSION[0]) >= 0 && intVersion.compareTo(SUPPORTED_VERSION[1]) <= 0;
    }

    public static void performLDAPOperation(DirContext dirCtx, LDIFRecord ldifRecord) throws NamingException {
        switch (ldifRecord.getChangeType()) {
            case 1: {
                Attributes attrs = ldifRecord.getJNDIAttributes();
                DirContext result = dirCtx.createSubcontext(ldifRecord.getDN(), attrs);
                result.close();
                break;
            }
            case 3: {
                ModificationItem[] modItem = ldifRecord.getJNDIModificationItems();
                dirCtx.modifyAttributes(ldifRecord.getDN(), modItem);
                break;
            }
            case 2: {
                dirCtx.destroySubcontext(ldifRecord.getDN());
            }
        }
    }

    public static LDIFRecord getEntryFromDirectory(DirContext dirCtx, String dn) throws NamingException {
        LDIFRecord ldifRecord = null;
        if (null != dn) {
            SearchControls ctls = new SearchControls();
            String filter = "objectclass=*";
            ctls.setSearchScope(0);
            NamingEnumeration<SearchResult> nEnum = dirCtx.search(dn, filter, ctls);
            while (nEnum.hasMore()) {
                SearchResult res = (SearchResult)nEnum.nextElement();
                Attributes attrs = res.getAttributes();
                ldifRecord = Util.getLDIFRecord(dn, attrs);
            }
        }
        return ldifRecord;
    }

    public static LDIFRecord getLDIFRecord(String dn, Attributes pAttrs) throws NamingException {
        LDIFRecord ldifRecord = new LDIFRecord(dn);
        NamingEnumeration<? extends Attribute> attrs = pAttrs.getAll();
        while (attrs.hasMore()) {
            Attribute atr = (Attribute)attrs.nextElement();
            NamingEnumeration<?> vals = atr.getAll();
            LDIFAttribute ldifAttr = new LDIFAttribute(atr.getID());
            ldifRecord.addAttribute(ldifAttr);
            while (vals.hasMore()) {
                Object obj = vals.nextElement();
                try {
                    ldifAttr.addValue((String)obj);
                }
                catch (ClassCastException cce) {
                    ldifAttr.removeAll();
                    ldifAttr.setBinary(true);
                    ldifAttr.addValue((byte[])obj);
                }
            }
        }
        return ldifRecord;
    }

    public static void validateFile(String fileName, int checkFor) throws InvalidParameterException {
        Util.validateFile(new File(fileName), checkFor);
    }

    public static void validateFile(File fileObj, int checkFor) throws InvalidParameterException {
        String errMsg = null;
        String fileName = fileObj.getAbsolutePath();
        if (3 == (checkFor & 3)) {
            throw new IllegalArgumentException("Invalid combination of parameters");
        }
        if (!(1 != (checkFor & 1) || fileObj.exists() && fileObj.isFile())) {
            errMsg = NlsMsg.getMessage("FILE_DOES_NOT_EXIST", fileName);
            throw new InvalidParameterException(errMsg);
        }
        if (2 == (checkFor & 2) && fileObj.exists()) {
            errMsg = NlsMsg.getMessage("FILE_ALREADY_EXISTS", fileName);
            throw new InvalidParameterException(errMsg);
        }
        if (4 == (checkFor & 4) && !fileObj.canRead()) {
            errMsg = NlsMsg.getMessage("FILE_NOT_READABLE", fileName);
            throw new InvalidParameterException(errMsg);
        }
        if (8 == (checkFor & 8) && !fileObj.canWrite()) {
            errMsg = NlsMsg.getMessage("FILE_NOT_WRITABLE", fileName);
            throw new InvalidParameterException(errMsg);
        }
        if (16 == (checkFor & 0x10) && fileObj.length() == 0L) {
            errMsg = NlsMsg.getMessage("FILE_EMPTY", fileName);
            throw new InvalidParameterException(errMsg);
        }
        if (32 == (checkFor & 0x20)) {
            String parentOutputDir = fileObj.getAbsolutePath();
            parentOutputDir = parentOutputDir.substring(0, parentOutputDir.lastIndexOf(File.separatorChar));
            if (fileObj.exists() || !new File(parentOutputDir).canWrite()) {
                errMsg = NlsMsg.getMessage("FILE_NOT_CREATABLE", fileName);
                throw new InvalidParameterException(errMsg);
            }
        }
    }

    public static void addUniquemember(DirContext ctx, String base, String memberDn) throws UtilException {
        try {
            BasicAttributes attrs = new BasicAttributes("uniquemember", memberDn);
            ctx.modifyAttributes(base, 1, (Attributes)attrs);
        }
        catch (NamingException ne) {
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException("NamingException encountered in addUniqueMember", ne);
        }
    }

    public static void removeUniquemember(DirContext ctx, Group[] groupArr, String memberDn) throws UtilException {
        for (int i = 0; i < groupArr.length; ++i) {
            Util.removeUniquemember(ctx, groupArr[i].getDN(ctx), memberDn);
        }
    }

    public static void removeUniquemember(DirContext ctx, Group group, String memberDn) throws UtilException {
        Util.removeUniquemember(ctx, group.getDN(ctx), memberDn);
    }

    public static void removeUniquemember(DirContext ctx, String[] groupDNArr, String memberDn) throws UtilException {
        for (int i = 0; i < groupDNArr.length; ++i) {
            Util.removeUniquemember(ctx, groupDNArr[i], memberDn);
        }
    }

    public static void removeUniquemember(DirContext ctx, String groupDN, String memberDn) throws UtilException {
        try {
            ModificationItem[] mis = new ModificationItem[]{new ModificationItem(3, new BasicAttribute("uniquemember", memberDn))};
            ctx.modifyAttributes(groupDN, mis);
        }
        catch (NamingException ne) {
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException("NamingException encountered in removeUniqueMember", ne);
        }
    }

    public static void bulkDelete(DirContext ctx, String base, boolean deleteBaseDN) throws NamingException {
        UtilDebug.log(4, "Util: ", "bulkDelete: ");
        UtilDebug.log(4, "Util: ", ctx);
        UtilDebug.log(2, "Util: ", "bulkDelete subtree under: " + deleteBaseDN);
        try {
            PropertySetCollection psc = Util.getEntryDetails(ctx, base, "(objectclass=*)", 2, new String[0]);
            Vector dnLists = new Vector(30);
            for (int i = 0; i < 30; ++i) {
                dnLists.insertElementAt(new Vector(), i);
            }
            int offset = new StringTokenizer(base, ",").countTokens() - 1;
            for (int i = 0; i < psc.size(); ++i) {
                String curDN = psc.getPropertySet(i).getDN();
                StringTokenizer curDNTok = new StringTokenizer(curDN, ",");
                Vector dnList = (Vector)dnLists.elementAt(curDNTok.countTokens() - 1 - offset);
                dnList.add(curDN);
            }
            int baseLevel = deleteBaseDN ? 0 : 1;
            for (int i = 29; i >= baseLevel; --i) {
                Vector dnList = (Vector)dnLists.elementAt(i);
                if (dnList.isEmpty()) continue;
                for (int j = 0; j < dnList.size(); ++j) {
                    UtilDebug.log(2, "Util: ", "bulkdelete: " + dnList.elementAt(j));
                    ctx.destroySubcontext((String)dnList.elementAt(j));
                }
            }
        }
        catch (Exception e) {
            UtilDebug.log(2, "Util: ", "Exception caught in bulkDelete: " + e.toString());
            if (e instanceof CommunicationException) {
                throw (CommunicationException)e;
            }
            throw new NamingException("Exception caught in bulkDelete: " + e.toString());
        }
    }

    public static String getAttrOfRDN(String rdn) {
        return rdn.substring(0, rdn.indexOf("="));
    }

    public static String getAttrValueOfRDN(String rdn) {
        return rdn.substring(rdn.indexOf("=") + 1);
    }

    public static String getParameterFromFile(String parameter, String fileName) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        String value = null;
        while (in.ready()) {
            String possible;
            String line = in.readLine();
            if (!line.startsWith(parameter)) continue;
            int index = line.indexOf("=");
            if (index == -1 || (possible = line.substring(line.indexOf("=") + 1).trim()) == "") break;
            value = possible;
            break;
        }
        return value;
    }

    public static LDAPObjectClass getObjectClass(DirContext ctx, String inID) throws UtilException {
        PropertySetCollection subSchemaSubEntryPsc = null;
        String[] attrs = new String[]{"objectclasses"};
        subSchemaSubEntryPsc = Util.ldapSearch(ctx, "cn=subschemasubentry", "(objectclass=*)", 0, attrs);
        Property objClsAttr = subSchemaSubEntryPsc.getPropertySet(0).getProperty("objectclasses");
        boolean OID = false;
        if (inID.indexOf(".") > -1) {
            OID = true;
        }
        for (int i = 0; i < objClsAttr.size(); ++i) {
            String curObjClsVal = (String)objClsAttr.getValue(i);
            boolean match = false;
            if (!(OID ? LDAPObjectClass.getOID(curObjClsVal).equalsIgnoreCase(inID) : LDAPObjectClass.getName(curObjClsVal).equalsIgnoreCase(inID))) continue;
            return new LDAPObjectClass(curObjClsVal);
        }
        return null;
    }

    public static PropertySetCollection ldapSearch(DirContext ctx, String base, String filter, int scope, String[] attrList) throws UtilException {
        try {
            return Util.getEntryDetails(ctx, base, filter, scope, attrList);
        }
        catch (NamingException ne) {
            UtilDebug.log(2, "Util: ", "NamingException caught in ldapSearch: " + ne.toString());
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException("NamingException encountered in ldapSearch", ne);
        }
    }

    public static void ldapAdd(DirContext ctx, String base, ModPropertySet ps) throws UtilException {
        try {
            UtilDebug.log(4, "Util: ", "ldapAdd: ");
            UtilDebug.log(4, "Util: ", ctx);
            UtilDebug.log(2, "Util: ", "ldapAdd dn: " + base);
            UtilDebug.log(2, "Util: ", ps);
            Attributes attrs = ps.getModProperty().getJNDIAttributes();
            NameParser ldapParser = ctx.getNameParser("");
            Name compound = ldapParser.parse(base);
            DirContext result = ctx.createSubcontext(compound, attrs);
            result.close();
        }
        catch (NamingException ne) {
            UtilDebug.log(2, "Util: ", "NamingException caught in ldapAdd: " + ne.toString());
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException("NamingException encountered in ldapAdd", ne);
        }
    }

    public static void ldapAdd_noLog(DirContext ctx, String base, ModPropertySet ps) throws UtilException {
        try {
            Attributes attrs = ps.getModProperty().getJNDIAttributes();
            NameParser ldapParser = ctx.getNameParser("");
            Name compound = ldapParser.parse(base);
            DirContext result = ctx.createSubcontext(compound, attrs);
            result.close();
        }
        catch (NamingException ne) {
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException("NamingException encountered in ldapAdd", ne);
        }
    }

    public static void ldapModify(DirContext ctx, String base, ModPropertySet ps) throws UtilException {
        UtilDebug.log(4, "Util: ", "ldapModify: ");
        UtilDebug.log(4, "Util: ", ctx);
        UtilDebug.log(2, "Util: ", "ldapModify dn: " + base);
        UtilDebug.log(2, "Util: ", ps);
        LDIFRecord curRecord = ps.getModProperty();
        try {
            ModificationItem[] modItem = curRecord.getJNDIModificationItems();
            ctx.modifyAttributes(base, modItem);
        }
        catch (NamingException ne) {
            UtilDebug.log(2, "Util: ", "NamingException caught in ldapModify: " + ne.toString());
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException("NamingException encountered in ldapModify", ne);
        }
    }

    public static void ldapModify(DirContext ctx, Logger lgr, String fileName, Vector subVector, boolean ignoreError) throws UtilException {
        LDIFLoader ld = new LDIFLoader(ctx, fileName, subVector, lgr);
        ld.load(ignoreError, System.out);
    }

    public static void ldapModify(DirContext ctx, String fileName, Vector subVector, boolean ignoreError) throws UtilException {
        LDIFLoader ld = new LDIFLoader(ctx, fileName, subVector);
        ld.load(ignoreError, System.out);
    }

    public static void ldapModify(DirContext ctx, Logger lgr, String fileName, Vector subVector, boolean ignoreError, PrintStream pStream) throws UtilException {
        LDIFLoader ld = new LDIFLoader(ctx, fileName, subVector, lgr);
        ld.load(ignoreError, pStream);
    }

    public static void ldapModify(DirContext ctx, String fileName, Vector subVector, boolean ignoreError, PrintStream pStream) throws UtilException {
        LDIFLoader ld = new LDIFLoader(ctx, fileName, subVector);
        ld.load(ignoreError, pStream);
    }

    public static void ldapDelete(DirContext ctx, String base) throws UtilException {
        UtilDebug.log(4, "Util: ", "ldapDelete: ");
        UtilDebug.log(4, "Util: ", ctx);
        UtilDebug.log(2, "Util: ", "ldapDelete dn: " + base);
        try {
            ctx.destroySubcontext(base);
        }
        catch (NamingException ne) {
            UtilDebug.log(2, "Util: ", "NamingException caught in ldapDelete: " + ne.toString());
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException("NamingException encountered in ldapDelete", ne);
        }
    }

    public static boolean ldapCompare(DirContext ctx, String baseDN, String attr, Object attrval) throws UtilException {
        UtilDebug.log(4, "Util: ", "ldapCompare: ");
        UtilDebug.log(4, "Util: ", ctx);
        UtilDebug.log(2, "Util: ", "ldapCompare dn: " + baseDN);
        UtilDebug.log(2, "Util: ", "attribute: " + attr);
        try {
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(new String[0]);
            ctls.setSearchScope(0);
            NamingEnumeration<SearchResult> answer = ctx.search(baseDN, "(" + attr + "=" + attrval + ")", ctls);
            return answer.hasMore();
        }
        catch (NamingException ne) {
            UtilDebug.log(2, "Util: ", "NamingException caught in ldapCompare: " + ne.toString());
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new GeneralErrorException(resBundle.getString("UNABLE_SET_CONTROLS"), ne);
        }
    }

    public static PropertySetCollection multiSearchBaseSearch(DirContext ctx, String specifiedSearchBase, String[] allSearchBases, String filter, String[] attrList, boolean returnONE) throws UtilException {
        String[] curSearchBases = null;
        if (specifiedSearchBase != null) {
            boolean found = false;
            for (int i = 0; i < allSearchBases.length; ++i) {
                String curSearchBase = Util.normalizeDN(allSearchBases[i]);
                if (!curSearchBase.equals(Util.normalizeDN(specifiedSearchBase))) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new UtilException("Invalid search base");
            }
            curSearchBases = new String[]{specifiedSearchBase};
        } else {
            curSearchBases = allSearchBases;
        }
        boolean oneFound = false;
        PropertySetCollection returnPsc = null;
        returnPsc = new PropertySetCollection();
        for (int i = 0; i < curSearchBases.length; ++i) {
            String baseDN = curSearchBases[i];
            PropertySetCollection psc = null;
            try {
                psc = Util.ldapSearch(ctx, baseDN, filter, 2, attrList);
            }
            catch (UtilException ue) {
                if (ue instanceof CommunicationErrorException) {
                    throw ue;
                }
                throw new UtilException("NamingException encountered when resolving object using the following filter: " + filter);
            }
            if (psc.isEmpty() && i == allSearchBases.length - 1 && returnONE && !oneFound) {
                throw new UtilException("Object cannot be found using the following filter: " + filter);
            }
            for (int j = 0; j < psc.size(); ++j) {
                if (returnONE && oneFound) {
                    throw new UtilException("Multiple Objects found using the following filter: " + filter);
                }
                returnPsc.add(psc.getPropertySet(j));
                if (!returnONE) continue;
                oneFound = true;
            }
        }
        return returnPsc;
    }

    public static String[] getSSODBInfo(DirContext ctx) throws Exception {
        String[] result = OUILdap.getSSODBInfo(ctx, new String[0]);
        return result;
    }

    static String getGUID(SearchResult sr) {
        try {
            return (String)sr.getAttributes().get("orclguid").get(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String makeFilters(String[] attrs, String val, boolean stop) {
        if (attrs == null) {
            return null;
        }
        String filter = "";
        for (int i = 0; i < attrs.length; ++i) {
            filter = filter + "(" + Util.makeFilter(attrs[i], val) + ")";
        }
        if (stop && attrs.length > 1) {
            filter = "(|" + filter + ")";
        }
        return filter;
    }

    public static String makeFilter(String attr, String value) {
        return attr + "=" + Util.handleSpecialChars(value);
    }

    public static String handleSpecialChars(String originalString) {
        return Util.substituteChars(originalString, JNDI_SPECIAL_CHARS, JNDI_SUBSTITUTION_DN_ATTR_HEX_CHARS);
    }

    public static String handleSpecialFilterChars(String originalString) {
        return Util.substituteChars(originalString, JNDI_SPECIAL_CHARS, JNDI_SUBSTITUTION_HEX_CHARS);
    }

    private static String substituteChars(String filterVal, String specialCharList, String[] substitutionList) {
        int len = filterVal.length();
        int[] indexes = new int[len];
        String[] escChars = new String[len];
        int count = 0;
        for (int i = 0; i < len; ++i) {
            int x = specialCharList.indexOf(filterVal.charAt(i));
            if (x < 0 || x == 5 && i + 1 == len) continue;
            indexes[count] = i;
            escChars[count++] = substitutionList[x];
        }
        if (count < 1) {
            return filterVal;
        }
        StringBuffer sb = new StringBuffer(count * 3 + len);
        int j = 0;
        for (int i = 0; i < count; ++i) {
            sb = sb.append(filterVal.substring(j, indexes[i]));
            sb = sb.append(escChars[i]);
            j = indexes[i] + 1;
        }
        sb.append(filterVal.substring(j));
        return sb.toString();
    }

    public static String resolveDuplicateDN(DirContext ctx, String dnString) throws UtilException {
        try {
            int suffixCounter = 1;
            DistinguishedName dn = new DistinguishedName(dnString);
            DistinguishedName originalRDN = dn.getRDN();
            while (Util.dnExists(ctx, dn.toString())) {
                dn.remove(dn.size() - 1);
                dn.add(originalRDN.toString() + "_" + suffixCounter);
                ++suffixCounter;
            }
            return dn.toString();
        }
        catch (InvalidNameException ine) {
            throw new UtilException((Exception)ine);
        }
    }

    static {
        try {
            resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        API_VERSION = "10.1.2.0.0";
        INTERFACE_VERSION = "1";
        SUPPORTED_VERSION = new String[]{"1", "1"};
        PWD_VERIFIERTYPE_COMMON = 1;
        IDTYPE_DN = 0;
        IDTYPE_SIMPLE = 1;
        IDTYPE_GUID = 2;
        IDTYPE_DEFAULT = 3;
        IDTYPE_FILTER = 4;
        IDTYPE_WINDOWS = 5;
        IDTYPE_KERB_PRINCIPAL = 6;
        PROPERTIES_ENTRY = 0;
        PROPERTIES_DETACHED = 0;
        CREDTYPE_PASSWD = 0;
        DASURL_BASE = "";
        DASURL_CREATE_USER = "cn=create user";
        DASURL_EDIT_GROUP = "cn=edit group";
        DASURL_EDIT_GROUP_GIVEN_GUID = "cn=edit groupgivenguid";
        DASURL_GROUP_SEARCH = "cn=group search";
        DASURL_EDIT_USER = "cn=edit user";
        DASURL_GROUP_LOV = "cn=group lOV";
        DASURL_DELETE_USER = "cn=deleteUser";
        DASURL_USER_PRIVILEGE = "cn=user privilege";
        DASURL_CREATE_GROUP = "cn=create group";
        DASURL_USER_SEARCH = "cn=user search";
        DASURL_ACCOUNT_INFO = "cn=account info";
        DASURL_EDIT_USER_GIVEN_GUID = "cn=edit usergivenguid";
        DASURL_DELETE_USER_GIVEN_GUID = "cn=deleteusergivenguid";
        DASURL_DELETE_GROUP_GIVEN_GUID = "cn=deletegroupgivenguid";
        DASURL_GROUP_PRIVILEGE = "cn=group privilege";
        DASURL_USER_PRIVILEGE_GIVEN_GUID = "cn=user privilege given guid";
        DASURL_PASSWORD_CHANGE = "cn=password change";
        DASURL_USER_LOV = "cn=user lov";
        DASURL_GROUP_PRIVILEGE_GIVEN_GUID = "cn=group privilege given guid";
        DASURL_DELETE_GROUP = "cn=DeleteGroup";
        DASURL_CREATE_RESOURCE = "cn=create resource";
        DASURL_EUS_CONSOLE = "cn=eus console";
        DASURL_DELEGATION_CONSOLE = "cn=delegation console";
        DASURL_EDIT_MY_PROFILE = "cn=edit my profile";
        DASURL_RESET_PASSWORD = "cn=reset password";
        DASURL_VIEW_USER_PROFILE = "cn=view user profile";
        DASURL_TIMEZONE = "cn=timezone";
        DASurlDNs = new String[]{"", "cn=Create User", "cn=Edit Group", "cn=Edit GroupGivenGUID", "cn=Group Search", "cn=Edit User", "cn=Group LOV", "cn=DeleteUser", "cn=User Privilege", "cn=Create Group", "cn=User Search", "cn=Account Info", "cn=Edit UserGivenGUID", "cn=DeleteUserGivenGUID", "cn=DeleteGroupGivenGUID", "cn=Group Privilege", "cn=User Privilege Given GUID", "cn=Password Change", "cn=User LOV", "cn=Group Privilege Given GUID", "cn=DeleteGroup", "cn=Create Resource"};
        rootOracleContextDN = "cn=OracleContext";
        commonDN = "cn=Common,cn=Products,cn=OracleContext";
        DASbaseDN = "cn=DAS,cn=Products,cn=OracleContext";
        JNDI_SUBSTITUTION_HEX_CHARS = new String[]{"\\5c2a", "\\5c28", "\\5c29", "\\5c5c", "\\5c00"};
        JNDI_SUBSTITUTION_DN_ATTR_HEX_CHARS = new String[]{"\\5c2a", "\\5c28", "\\5c29", "\\\\", "\\5c00"};
    }
}

