/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import oracle.ldap.util.AccessDeniedException;
import oracle.ldap.util.AccountDisabledException;
import oracle.ldap.util.AccountInactiveException;
import oracle.ldap.util.AccountLockedException;
import oracle.ldap.util.AcctIPLockedException;
import oracle.ldap.util.AuthFailureException;
import oracle.ldap.util.ChangePwdObserver;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.GeneralErrorException;
import oracle.ldap.util.GraceLoginException;
import oracle.ldap.util.Group;
import oracle.ldap.util.IllegalValueException;
import oracle.ldap.util.InvalidRootOrclctxException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.MinimumLengthException;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.MultipleUserException;
import oracle.ldap.util.MustChangeException;
import oracle.ldap.util.NoSuchUserException;
import oracle.ldap.util.NumericCharacterException;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.PasswordExpiredException;
import oracle.ldap.util.PasswordExpiredWarningException;
import oracle.ldap.util.PasswordInHistoryException;
import oracle.ldap.util.PasswordNullException;
import oracle.ldap.util.PasswordPolicyControl;
import oracle.ldap.util.PasswordPolicyException;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.SetPropertiesException;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.SubscriberNotFoundException;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class User
extends LDAPEntry
implements Serializable {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    private String entryGUID = null;
    private String inUserId = null;
    private String inSearchBase = null;
    private String searchFilter = null;
    private int userIdType = -1;
    private String subIdName = null;
    private int subIdType = -1;
    private String subDN = null;
    private Subscriber subscriber = null;
    private String[] userSearchBase = null;
    private String userNickNameAttr = null;
    private String userPrincipalAttr = null;
    private String userNameWinAttr = null;
    private boolean toBeAutoProvisioned = false;
    private String[] attrList = new String[0];
    private String enumBase = null;
    private static String commonDN = "cn=Common,cn=Products,cn=OracleContext";
    public static final String[] radContainerObjList = new String[]{"top", "orclcontainer", "orclauxiliaryguid"};
    public static final String[] extPrefRefObjList = new String[]{"top", "orclreferenceobject"};
    public static final String[] radObjList = new String[]{"top", "orclresourcedescriptor"};
    private static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    public static int CREDTYPE_PASSWD = 0;
    public static int EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR = 0;

    protected User(DirContext inCtx, String inUserDN, String inUserGUID, PropertySet inPs, Logger lgr) {
        this(inCtx, inUserDN, inUserGUID, inPs);
        m_logger = lgr;
    }

    protected User(DirContext inCtx, String inUserDN, String inUserGUID, PropertySet inPs) {
        super(inCtx, inUserDN, inPs);
        this.entryGUID = inUserGUID;
        this.validated = true;
    }

    protected User(DirContext inCtx, String inUserDN, String inUserGUID, String inEnumBase, Subscriber inSubscr, SearchResult inEnum, Logger lgr) {
        this(inCtx, inUserDN, inUserGUID, inEnumBase, inSubscr, inEnum);
        m_logger = lgr;
    }

    protected User(DirContext inCtx, String inUserDN, String inUserGUID, String inEnumBase, Subscriber inSubscr, SearchResult inEnum) {
        this(inCtx, inUserDN, inUserGUID, null);
        this.subscriber = inSubscr;
        this.entryGUID = inUserGUID;
        this.enumBase = inEnumBase;
        if (inEnum != null) {
            this.entryPsc = new PropertySetCollection(inEnumBase, inEnum, true);
        }
    }

    public User(DirContext ctx, int inUserIdType, String inUserIdName, Subscriber inSubscriber, boolean validate, Logger lgr) throws UtilException {
        this(ctx, inUserIdType, inUserIdName, inSubscriber, validate);
        m_logger = lgr;
    }

    public User(DirContext ctx, int inUserIdType, String inUserIdName, Subscriber inSubscriber, boolean validate) throws UtilException {
        this(ctx, inUserIdType, inUserIdName, 0, null, inSubscriber, null, null, null, new String[0], false, validate);
    }

    public User(DirContext ctx, int inUserIdType, String inUserIdName, int inSubIdType, String inSubIdName, boolean validate, Logger lgr) throws UtilException {
        this(ctx, inUserIdType, inUserIdName, inSubIdType, inSubIdName, validate);
        m_logger = lgr;
    }

    public User(DirContext ctx, int inUserIdType, String inUserIdName, int inSubIdType, String inSubIdName, boolean validate) throws UtilException {
        this(ctx, inUserIdType, inUserIdName, inSubIdType, inSubIdName, null, null, null, null, new String[0], false, validate);
    }

    protected User(DirContext ctx, int inUserIdType, String inUserIdName, int inSubIdType, String inSubIdName, Subscriber inSubscriber, String inSpecifiedSearchBase, String[] inUserSearchBase, String inUserNickNameAttr, String[] inAttrList, boolean toBeAutoProvisioned, boolean validateNow, Logger lgr) throws UtilException {
        this(ctx, inUserIdType, inUserIdName, inSubIdType, inSubIdName, inSubscriber, inSpecifiedSearchBase, inUserSearchBase, inUserNickNameAttr, inAttrList, toBeAutoProvisioned, validateNow);
        m_logger = lgr;
    }

    protected User(DirContext ctx, int inUserIdType, String inUserIdName, int inSubIdType, String inSubIdName, Subscriber inSubscriber, String inSpecifiedSearchBase, String[] inUserSearchBase, String inUserNickNameAttr, String[] inAttrList, boolean toBeAutoProvisioned, boolean validateNow) throws UtilException {
        super(ctx, inUserIdName);
        if (inUserIdName == null) {
            throw new ParameterException(resBundle.getString("PARAMETER_NULL") + ":  inUserIdName");
        }
        if (inUserIdName == "") {
            throw new UtilException(resBundle.getString("PARAMETER_INVALID") + ":  inUserIdName");
        }
        if (inUserIdType != Util.IDTYPE_DN && inUserIdType != Util.IDTYPE_SIMPLE && inUserIdType != Util.IDTYPE_WINDOWS && inUserIdType != Util.IDTYPE_KERB_PRINCIPAL && inUserIdType != Util.IDTYPE_GUID) {
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  inUserIdType");
        }
        this.subIdType = inSubIdType;
        this.subIdName = inSubIdName;
        this.subscriber = inSubscriber;
        this.attrList = inAttrList;
        this.userSearchBase = inUserSearchBase;
        this.userNickNameAttr = inUserNickNameAttr;
        this.inSearchBase = inSpecifiedSearchBase;
        this.toBeAutoProvisioned = toBeAutoProvisioned;
        this.inUserId = inUserIdName;
        this.userIdType = inUserIdType;
        if (validateNow) {
            this.resolve(ctx);
        }
    }

    public PropertySetCollection getExtendedProperties(DirContext ctx, int propType, String[] attrList, String filter) throws UtilException {
        this.resolve(ctx);
        String mySub = this.locateSubscriber(ctx);
        String[] guidAttrList = new String[]{"orclguid"};
        PropertySetCollection propSetCol = this.getProperties(ctx, guidAttrList, true);
        PropertySet propSet = propSetCol.getPropertySet(0);
        String userGUID = (String)propSet.getProperty(0).getValue(0);
        String propTypeRDN = null;
        if (propType != EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR) {
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  propType");
        }
        propTypeRDN = new String("cn=Resource Access Descriptor");
        String extDN = new String(propTypeRDN + ",orclOwnerGUID=" + userGUID + ",cn=Extended Properties,cn=OracleContext," + mySub);
        try {
            return Util.getEntryDetails(ctx, extDN, filter, 2, attrList);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            String errormsg = resBundle.getString("GENERAL_ERROR_SEARCH") + ":  getExtendedProperties";
            if (e instanceof NoPermissionException) {
                throw new AccessDeniedException(errormsg, e);
            }
            if (UtilException.getLDAPErrorCode(e) == 32) {
                return new PropertySetCollection();
            }
            throw new GeneralErrorException(errormsg, e);
        }
    }

    public PropertySetCollection getExtendedProperties(DirContext ctx, int propType, String[] attrList) throws UtilException {
        return this.getExtendedProperties(ctx, propType, attrList, "(objectclass=*)");
    }

    public void setExtendedProperties(DirContext ctx, int propType, String filter, ModPropertySet mps) throws UtilException {
        this.resolve(ctx);
        String mySub = this.locateSubscriber(ctx);
        String userGUID = this.getGUID(ctx);
        String propTypeRDN = null;
        if (propType != EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR) {
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  propType");
        }
        propTypeRDN = new String("cn=Resource Access Descriptor");
        String extDN = new String(propTypeRDN + ",orclOwnerGUID=" + userGUID + ",cn=Extended Properties,cn=OracleContext," + mySub);
        PropertySetCollection psc = null;
        String radDN = null;
        boolean isCtxUser = this.sameCtxUser(ctx);
        try {
            String[] attrList = null;
            attrList = isCtxUser ? new String[]{"dn", "orclusermodifiable"} : new String[]{"dn"};
            psc = Util.ldapSearch(ctx, extDN, filter, 2, attrList);
        }
        catch (UtilException ue) {
            if (ue instanceof CommunicationErrorException) {
                throw ue;
            }
            throw new SetPropertiesException("Requested RAD does not exist.", ue);
        }
        if (psc == null || psc.isEmpty()) {
            throw new SetPropertiesException("Requested RAD does not exist");
        }
        if (psc.size() > 1) {
            throw new SetPropertiesException("Multiple RADs encountered");
        }
        if (isCtxUser) {
            String is_mod = "TRUE";
            try {
                is_mod = psc.getUniquePropertyValue("orclusermodifiable");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!is_mod.equalsIgnoreCase("TRUE")) {
                throw new SetPropertiesException("User is not allowed to modify this RAD");
            }
        }
        radDN = psc.getPropertySet(0).getDN();
        try {
            Util.ldapModify(ctx, radDN, mps);
        }
        catch (UtilException e) {
            if (e instanceof CommunicationErrorException) {
                throw e;
            }
            throw new SetPropertiesException("Cannot Update Extended Properties", e.returnNamingException());
        }
    }

    public void createExtendedProperties(DirContext ctx, int propType, ModPropertySet mps) throws UtilException {
        String restype;
        String resname;
        String curDN;
        String userGUID;
        block13: {
            this.resolve(ctx);
            String mySub = this.locateSubscriber(ctx);
            userGUID = this.getGUID(ctx);
            Object propTypeRDN = null;
            if (propType == EXTPROPTYPE_RESOURCE_ACCESS_DESCRIPTOR) {
                curDN = "orclownerguid=" + userGUID + ",cn=Extended Properties,cn=oracleContext," + mySub;
                try {
                    Util.ldapSearch(ctx, curDN, "objectclass=*", 0, new String[]{"dn"});
                }
                catch (UtilException ue) {
                    if (ue.isNamingException() && ue.returnNamingException() instanceof NameNotFoundException) {
                        ModPropertySet mp = new ModPropertySet();
                        mp.addProperty(0, "objectclass", extPrefRefObjList);
                        mp.addProperty(0, "orclownerguid", userGUID);
                        mp.addProperty(0, "seealso", this.entryDN);
                        Util.ldapAdd(ctx, curDN, mp);
                    }
                    throw ue;
                }
                curDN = "cn=Resource Access Descriptor," + curDN;
                try {
                    Util.ldapSearch(ctx, curDN, "objectclass=*", 0, new String[]{"dn"});
                }
                catch (UtilException ue) {
                    if (ue.isNamingException() && ue.returnNamingException() instanceof NameNotFoundException) {
                        ModPropertySet mp1 = new ModPropertySet();
                        mp1.addProperty(0, "objectclass", radContainerObjList);
                        mp1.addProperty(0, "cn", "Resource Access Descriptor");
                        mp1.addProperty(0, "orclownerguid", userGUID);
                        Util.ldapAdd(ctx, curDN, mp1);
                    }
                    throw ue;
                }
                resname = null;
                restype = null;
                LDIFRecord lr = mps.getModProperty();
                try {
                    resname = lr.getAttribute("orclresourcename").getValue();
                    if (resname == null) {
                        throw new UtilException("ModPropertySet does not contain orclresourcename");
                    }
                }
                catch (NullPointerException e) {
                    throw new UtilException("ModPropertySet does not contain orclresourcename");
                }
                try {
                    restype = lr.getAttribute("orclresourcetypename").getValue();
                    if (restype == null) {
                        throw new UtilException("ModPropertySet does not contain orclresourcetypename");
                    }
                    break block13;
                }
                catch (NullPointerException e) {
                    throw new UtilException("ModPropertySet does not contain orclresourcetypename");
                }
            }
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  propType");
        }
        curDN = "orclresourcename=" + resname + "+" + "orclresourcetypename=" + restype + "," + curDN;
        mps.addProperty(0, "orclownerguid", userGUID);
        mps.addProperty(0, "objectclass", radObjList);
        Util.ldapAdd(ctx, curDN, mps);
    }

    public void setProperties(DirContext ctx, ModificationItem[] mods) throws UtilException {
        this.resolve(ctx);
        Util.setEntryDetails(ctx, this.entryDN, mods);
    }

    public void setProperties(DirContext ctx, ModPropertySet mps) throws UtilException {
        this.resolve(ctx);
        try {
            super.setProperties(ctx, mps);
        }
        catch (UtilException ue) {
            if (ue.hasPasswordPolicyError()) {
                int ec = ue.getPasswordPolicyErrorCode();
                switch (ec) {
                    case 9001: {
                        throw new AccountLockedException("The account is locked", ue.returnNamingException());
                    }
                    case 9011: {
                        throw new AcctIPLockedException("The account is locked from this IP address", ue.returnNamingException());
                    }
                    case 9050: {
                        throw new AccountDisabledException("The account has been disabled", ue.returnNamingException());
                    }
                    case 9053: {
                        throw new AccountInactiveException("The account is inactive", ue.returnNamingException());
                    }
                    case 9003: {
                        throw new MinimumLengthException("The password does not satisfy the minimum length", ue.returnNamingException());
                    }
                    case 9004: {
                        throw new NumericCharacterException("The password requires at least one numeric value", ue.returnNamingException());
                    }
                    case 9006: {
                        throw new PasswordInHistoryException("Cannot change to a previously used password", ue.returnNamingException());
                    }
                    case 9007: {
                        throw new IllegalValueException("Illegal password value", ue.returnNamingException());
                    }
                    case 9005: {
                        throw new PasswordNullException("Password cannot be null", ue.returnNamingException());
                    }
                }
                throw new PasswordPolicyException("Password policy error encountered: " + ue.returnNamingException().toString(), ue.returnNamingException());
            }
            throw ue;
        }
    }

    public PropertySetCollection getProperties(DirContext ctx, String[] attrList) throws UtilException {
        return this.getProperties(ctx, attrList, true);
    }

    public PropertySetCollection getProperties(DirContext ctx, String[] attrList, boolean usecache) throws UtilException {
        return super.getProperties(ctx, attrList, usecache);
    }

    private void getCommonAttrsFromSubscriber(DirContext ctx, Subscriber sub, String inUSB) throws UtilException {
        int j;
        String[] commonAttrs = sub.getCommonAttrs(ctx);
        this.userNickNameAttr = commonAttrs[0];
        this.userPrincipalAttr = commonAttrs[2];
        this.userNameWinAttr = commonAttrs[3];
        if (inUSB == null) {
            int searchBaseNum = commonAttrs.length - 4;
            this.userSearchBase = new String[searchBaseNum];
            for (int i = 0; i < searchBaseNum; ++i) {
                this.userSearchBase[i] = commonAttrs[j++];
            }
            return;
        }
        boolean found = false;
        for (j = 4; j < commonAttrs.length; ++j) {
            String curSearchBase = Util.normalizeDN(commonAttrs[j]);
            if (!curSearchBase.equals(Util.normalizeDN(inUSB))) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new UtilException("Invalid user search base");
        }
        this.userSearchBase = new String[1];
        this.userSearchBase[0] = inUSB;
    }

    private boolean sameCtxUser(DirContext ctx) {
        try {
            Hashtable<?, ?> ht = ctx.getEnvironment();
            String ctxDN = (String)ht.get("java.naming.security.principal");
            return ctxDN.equalsIgnoreCase(this.entryDN);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void resolve(DirContext ctx) throws UtilException {
        if (!this.validated) {
            if (ctx == null) {
                throw new UtilException(resBundle.getString("PARAMETER_NULL") + ": DirContext");
            }
            if (this.userIdType == Util.IDTYPE_SIMPLE || this.userIdType == Util.IDTYPE_WINDOWS || this.userIdType == Util.IDTYPE_KERB_PRINCIPAL) {
                try {
                    int i;
                    String[] newAttrList;
                    if (this.subscriber == null) {
                        RootOracleContext rc = new RootOracleContext(ctx, m_logger);
                        this.subscriber = rc.getSubscriber(ctx, this.subIdType, this.subIdName, new String[0]);
                    }
                    this.subDN = this.subscriber.getDN(ctx);
                    this.getCommonAttrsFromSubscriber(ctx, this.subscriber, this.inSearchBase);
                    if (this.attrList != null) {
                        int arrSize = this.attrList.length + 1;
                        newAttrList = new String[arrSize];
                        for (i = 0; i < this.attrList.length; ++i) {
                            newAttrList[i] = this.attrList[i];
                        }
                        newAttrList[this.attrList.length] = "orclguid";
                    } else {
                        newAttrList = new String[]{"orclguid"};
                    }
                    boolean oneFound = false;
                    for (i = 0; i < this.userSearchBase.length; ++i) {
                        String baseDN = this.userSearchBase[i];
                        String userAttr = this.userNickNameAttr;
                        if (this.userIdType == Util.IDTYPE_WINDOWS) {
                            userAttr = this.userNameWinAttr;
                        } else if (this.userIdType == Util.IDTYPE_KERB_PRINCIPAL) {
                            userAttr = this.userPrincipalAttr;
                        }
                        NamingEnumeration curEnum = (NamingEnumeration)Util.getEntryDetails(ctx, baseDN, "(&(objectclass=*)(" + userAttr + "=" + Util.handleSpecialFilterChars(this.inUserId) + "))", 2, newAttrList, false);
                        boolean hasMore = curEnum.hasMoreElements();
                        if (!hasMore && i == this.userSearchBase.length - 1 && !oneFound) {
                            throw new NoSuchUserException("User does not exist - SIMPLE NAME = " + this.inUserId);
                        }
                        if (hasMore) {
                            if (oneFound) {
                                throw new MultipleUserException("Multiple Users found with Simple Name = " + this.inUserId);
                            }
                            SearchResult sr = (SearchResult)curEnum.nextElement();
                            oneFound = true;
                            this.entryDN = new String(sr.getNameInNamespace());
                            this.entryGUID = (String)sr.getAttributes().get("orclguid").get(0);
                            if (curEnum.hasMoreElements()) {
                                throw new MultipleUserException("Multiple Users found with Simple Name = " + this.inUserId);
                            }
                            this.entryPsc = new PropertySetCollection(baseDN, sr, true);
                        }
                        this.validated = true;
                    }
                }
                catch (NamingException ne) {
                    if (ne instanceof CommunicationException) {
                        throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
                    }
                    throw new NoSuchUserException("Error encountered when resolving user - SIMPLE NAME = " + this.inUserId, ne);
                }
            }
            if (this.userIdType == Util.IDTYPE_GUID) {
                try {
                    NamingEnumeration curEnum = (NamingEnumeration)Util.getEntryDetails(ctx, "", "(orclguid=" + this.inUserId + ")", 2, this.attrList, false);
                    if (!curEnum.hasMoreElements()) {
                        throw new NoSuchUserException("User does not exist - GUID = " + this.inUserId);
                    }
                    SearchResult sr = (SearchResult)curEnum.nextElement();
                    this.entryDN = new String(sr.getName());
                    this.entryGUID = this.inUserId;
                    this.enumBase = "";
                    this.entryPsc = new PropertySetCollection("", sr, true);
                }
                catch (NamingException ne) {
                    if (ne instanceof CommunicationException) {
                        throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
                    }
                    throw new NoSuchUserException("Error encountered when resolving user - GUID = " + this.inUserId, ne);
                }
                this.validated = true;
            } else if (this.userIdType == Util.IDTYPE_DN) {
                try {
                    NamingEnumeration curEnum = (NamingEnumeration)Util.getEntryDetails(ctx, this.inUserId, "(objectclass=*)", 0, this.attrList, false);
                    if (!curEnum.hasMoreElements()) {
                        throw new NoSuchUserException("User does not exist - DN = " + this.inUserId);
                    }
                    SearchResult sr = (SearchResult)curEnum.nextElement();
                    this.entryDN = this.inUserId;
                    this.enumBase = this.inUserId;
                    this.entryPsc = new PropertySetCollection(this.entryDN, sr, true);
                }
                catch (NamingException ne) {
                    if (ne instanceof CommunicationException) {
                        throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
                    }
                    throw new NoSuchUserException("Error encountered when resolving user - DN = " + this.inUserId, ne);
                }
                this.validated = true;
            }
        }
    }

    public String getDN(DirContext ctx) throws UtilException {
        return super.getDN(ctx);
    }

    public String getDn(DirContext ctx) throws UtilException {
        return super.getDN(ctx);
    }

    public String getDn() throws UtilException {
        if (!this.validated) {
            throw new UtilException("This operation has been desupported");
        }
        return super.getDN(null);
    }

    public String getDN() throws UtilException {
        return this.getDn();
    }

    public String locateSubscriber(DirContext ctx) throws UtilException {
        String subscriberSearchBaseDN = null;
        this.resolve(ctx);
        if (this.subDN == null) {
            try {
                String[] returnAttrs = new String[]{"orclsubscribersearchbase"};
                Attributes result = ctx.getAttributes(commonDN, returnAttrs);
                NamingEnumeration<? extends Attribute> resultSet = result.getAll();
                while (resultSet.hasMore()) {
                    Attribute attr = resultSet.next();
                    NamingEnumeration<?> value = attr.getAll();
                    if (!attr.getID().equals("orclsubscribersearchbase")) continue;
                    subscriberSearchBaseDN = (String)value.next();
                }
                if (subscriberSearchBaseDN == null) {
                    subscriberSearchBaseDN = "";
                }
            }
            catch (NamingException e) {
                throw new InvalidRootOrclctxException(resBundle.getString("INVALID_ROOT_CTX"));
            }
            String normDn = Util.normalizeDN(this.entryDN);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            String[] subscriberList = null;
            try {
                if (subscriberSearchBaseDN == null) {
                    subscriberSearchBaseDN = "";
                }
                subscriberSearchBaseDN = new CompositeName().add(subscriberSearchBaseDN).toString();
                NamingEnumeration<Serializable> resultSet = ctx.search(subscriberSearchBaseDN, "objectclass=orclSubscriber", ctls);
                Vector<String> subList = new Vector<String>();
                while (resultSet.hasMore()) {
                    if (subscriberSearchBaseDN.equals("")) {
                        String string = resultSet.next().getName();
                    }
                    String to_add = resultSet.next().getNameInNamespace();
                    subList.addElement(to_add);
                }
                if (subList.size() == 0) {
                    throw new SubscriberNotFoundException(resBundle.getString("NO_SUBSCRIBER_FOUND") + ":  " + subscriberSearchBaseDN);
                }
                subscriberList = Util.vector2StrArray(subList);
                String[] attrList = new String[]{"orclcommonusersearchbase"};
                for (int i = 0; i < subscriberList.length; ++i) {
                    Attributes result = ctx.getAttributes(commonDN + "," + subscriberList[i], attrList);
                    resultSet = result.getAll();
                    String curSubUserSearchBase = null;
                    if (!resultSet.hasMore()) continue;
                    Attribute attr = (Attribute)resultSet.next();
                    NamingEnumeration<?> value = attr.getAll();
                    while (value.hasMore()) {
                        curSubUserSearchBase = Util.normalizeDN((String)value.next());
                        if (!normDn.endsWith(curSubUserSearchBase)) continue;
                        this.subDN = subscriberList[i];
                        return this.subDN;
                    }
                }
                throw new SubscriberNotFoundException(resBundle.getString("NO_MATCHING_SUBSCRIBER"));
            }
            catch (NamingException e) {
                throw new GeneralErrorException(resBundle.getString("CANNOT_FIND_SUBSCRIBER") + ":  " + this.entryDN, e);
            }
        }
        return this.subDN;
    }

    public String getGUID() throws UtilException {
        if (this.entryGUID == null) {
            throw new UtilException("This operation has been desupported");
        }
        return this.entryGUID;
    }

    public String getGUID(DirContext ctx) throws UtilException {
        this.resolve(ctx);
        if (this.entryGUID == null) {
            String[] attrList = new String[]{"orclguid"};
            PropertySetCollection psc = Util.ldapSearch(ctx, this.entryDN, "(objectclass=*)", 0, attrList);
            this.entryGUID = (String)psc.getPropertySet(0).getProperty(0).getValue(0);
        }
        return this.entryGUID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void authenticateUser(DirContext ctx, int authType, Object cred) throws UtilException {
        if (authType != CREDTYPE_PASSWD) throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  authType");
        String attr = new String("userpassword");
        String password = (String)cred;
        if (ctx instanceof LdapContext) {
            try {
                Control[] ctls = new Control[]{new PasswordPolicyControl()};
                ((LdapContext)ctx).setRequestControls(ctls);
            }
            catch (NamingException ne) {
                if (!(ne instanceof CommunicationException)) throw new UtilException("Unable to set Password Policy controls");
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
        }
        try {
            this.authenticateUser(ctx, attr, password);
        }
        catch (UtilException ue) {
            if (this.toBeAutoProvisioned) {
                if (!ue.isNamingException()) throw ue;
                NamingException ne = ue.returnNamingException();
                if (ne instanceof NameNotFoundException) {
                    try {
                        this.resolve(ctx);
                        this.toBeAutoProvisioned = false;
                        return;
                    }
                    catch (UtilException ue1) {
                        if (!(ue1 instanceof NoSuchUserException)) throw ue1;
                        throw new AuthFailureException(resBundle.getString("UNABLE_AUTHENTICATE_USER"));
                    }
                }
            }
            if (!ue.hasPasswordPolicyError()) throw ue;
            int ec = ue.getPasswordPolicyErrorCode();
            switch (ec) {
                case 9000: {
                    throw new PasswordExpiredException("Password has expired", ue.returnNamingException());
                }
                case 9001: {
                    throw new AccountLockedException("The account is locked", ue.returnNamingException());
                }
                case 9011: {
                    throw new AcctIPLockedException("The account is locked from this IP address", ue.returnNamingException());
                }
                case 9050: {
                    throw new AccountDisabledException("The account has been disabled", ue.returnNamingException());
                }
                case 9053: {
                    throw new AccountInactiveException("The account is inactive", ue.returnNamingException());
                }
                case 9005: {
                    throw new PasswordNullException("Password is null", ue.returnNamingException());
                }
            }
            throw new PasswordPolicyException("Password policy error encountered: " + ue.returnNamingException().toString(), ue.returnNamingException());
        }
        if (!(ctx instanceof LdapContext)) return;
        try {
            Control[] rctls = ((LdapContext)ctx).getResponseControls();
            String responseOID = null;
            if (rctls == null || rctls.length <= 0) return;
            byte[] encVal = rctls[0].getEncodedValue();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(encVal, 0, encVal.length);
            m_logger.log(Level.INFO, bout.toString());
            responseOID = rctls[0].getID();
            if (responseOID.equals("2.16.840.1.113894.1.8.7")) {
                throw new PasswordExpiredWarningException("User Password Expire Warning");
            }
            if (responseOID.equals("2.16.840.1.113894.1.8.8")) {
                throw new GraceLoginException("User in Grace Login mode");
            }
            if (!responseOID.equals("2.16.840.1.113894.1.8.9")) return;
            ChangePwdObserver.getInstance().setStatus(ChangePwdObserver.MUST_CHANGE_EXCEPTION_RAISED, true);
            throw new MustChangeException("User password must be changed");
        }
        catch (NamingException ne) {
            if (!(ne instanceof CommunicationException)) return;
            throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
        }
    }

    public void authenticateUser(DirContext ctx, String attrName, String attrValue) throws UtilException {
        if (!this.toBeAutoProvisioned) {
            this.resolve(ctx);
        }
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(new String[0]);
        ctls.setSearchScope(0);
        try {
            byte[] attrBValue = attrValue.getBytes("UTF-8");
            this.entryDN = new CompositeName().add(this.entryDN).toString();
            NamingEnumeration<SearchResult> answer = ctx.search(this.entryDN, "(" + attrName + "={0})", new Object[]{attrBValue}, ctls);
            if (!answer.hasMore()) {
                throw new AuthFailureException(resBundle.getString("UNABLE_AUTHENTICATE_USER") + ": " + this.entryDN);
            }
        }
        catch (Exception e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            if (e instanceof AuthFailureException) {
                throw (AuthFailureException)e;
            }
            throw new AuthFailureException(resBundle.getString("UNABLE_AUTHENTICATE_USER") + ": " + this.entryDN, e);
        }
    }

    public Group[] getGroupMembership(DirContext ctx, String[] attrList, boolean nested) throws UtilException {
        this.resolve(ctx);
        PropertySetCollection psc = Util.getGroupMembership(ctx, this, attrList, nested);
        if (psc == null) {
            return null;
        }
        Group[] groupArr = new Group[psc.size()];
        for (int i = 0; i < groupArr.length; ++i) {
            groupArr[i] = new Group(ctx, psc.getPropertySet(i).getDN(), psc.getPropertySet(i));
        }
        return groupArr;
    }

    public boolean isProvisioned() {
        return !this.toBeAutoProvisioned;
    }
}

