/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.PrintStream;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import oracle.ldap.das.util.UILabelsNLS;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.OrclGuid;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class SubscriberCreator {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    private static String rootOracleContextDN = "cn=OracleContext";
    private String subDN = null;
    private String rawDN = null;
    private String parentDN = null;
    private String fQHN = null;
    private String simpleName = null;
    private String ohome = null;
    private DirContext ctx = null;
    private int nameType = 0;
    private String subSearchBase = null;
    private String subNickNameAttr = null;
    private boolean defaultSub = false;
    private boolean install = false;
    private boolean genGuid = true;
    private boolean createAux = false;
    private static ResourceBundle resBundle = LDAPEntry.resBundle;
    private PrintStream pStream = null;

    public SubscriberCreator(DirContext inCtx, Logger lgr, String inOhome, String inStr) throws UtilException {
        this(inCtx, inOhome, inStr);
        m_logger = lgr;
    }

    public SubscriberCreator(DirContext inCtx, String inOhome, String inStr) throws UtilException {
        this(inCtx, inOhome, inStr, System.out);
    }

    public SubscriberCreator(DirContext inCtx, Logger lgr, String inOhome, String inStr, PrintStream pStream) throws UtilException {
        this(inCtx, inOhome, inStr, pStream);
        m_logger = lgr;
    }

    public SubscriberCreator(DirContext inCtx, String inOhome, String inStr, PrintStream pStream) throws UtilException {
        this.pStream = pStream;
        if (inCtx == null) {
            throw new UtilException("Null DirContext");
        }
        this.ctx = inCtx;
        if (inOhome == null) {
            throw new UtilException("Null Oracle Home String");
        }
        this.ohome = inOhome;
        if (inStr == null) {
            throw new UtilException(resBundle.getString("PARAMETER_INVALID"));
        }
        this.subDN = Util.normalizeDN(inStr);
        this.rawDN = inStr;
    }

    protected SubscriberCreator(DirContext inCtx, Logger lgr, String inOhome, String inSimpleName, String inSubSearchBase, String inSubNickNameAttr, PrintStream pStream) throws UtilException {
        this(inCtx, inOhome, inSimpleName, inSubSearchBase, inSubNickNameAttr, pStream);
        m_logger = lgr;
    }

    protected SubscriberCreator(DirContext inCtx, String inOhome, String inSimpleName, String inSubSearchBase, String inSubNickNameAttr, PrintStream pStream) throws UtilException {
        this(inCtx, inOhome, inSimpleName, pStream);
        this.simpleName = inSimpleName;
        this.subSearchBase = inSubSearchBase;
        this.subNickNameAttr = inSubNickNameAttr;
    }

    public void createInstall() throws UtilException {
        this.install = true;
        this.genGuid = true;
        Util.createDN(this.ctx, this.rawDN);
        this.createDefault(true);
    }

    public void createDefault(boolean withAux) throws UtilException {
        this.defaultSub = true;
        this.create(withAux);
    }

    public Subscriber create(boolean withAux) throws UtilException {
        this.createAux = withAux;
        if (this.simpleName == null) {
            try {
                PropertySetCollection psc = Util.getEntryDetails(this.ctx, this.subDN, "(objectclass=*)", 0, new String[0]);
            }
            catch (NamingException ne) {
                if (ne instanceof CommunicationException) {
                    throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
                }
                throw new UtilException(resBundle.getString("CANNOT_FIND_SUBSCRIBER"));
            }
            this.createSubscriber();
        } else {
            this.subDN = this.getSimpleNameDN();
            this.createSubscriber();
        }
        return new Subscriber(this.ctx, Util.IDTYPE_DN, this.subDN, false, m_logger);
    }

    private void createSubscriber() throws UtilException {
        StringTokenizer subTok = new StringTokenizer(this.subDN, "=", false);
        String subNamingAttr = null;
        String subName = null;
        String subParent = null;
        if (subTok.countTokens() > 2) {
            subNamingAttr = subTok.nextToken();
            subName = subTok.nextToken(",").substring(1);
            subParent = subTok.nextToken("?").substring(1);
        } else {
            subNamingAttr = subTok.nextToken();
            subName = subTok.nextToken();
            subParent = "";
        }
        String subObjCls = null;
        String curUserDN = null;
        try {
            curUserDN = (String)this.ctx.getEnvironment().get("java.naming.security.principal");
        }
        catch (NamingException ne) {
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException("Cannot obtain current user info from DirContext");
        }
        if (subNamingAttr.equalsIgnoreCase("o")) {
            subObjCls = new String("organization");
        } else if (subNamingAttr.equalsIgnoreCase("dc")) {
            subObjCls = new String("domain");
        } else if (subNamingAttr.equalsIgnoreCase("l")) {
            subObjCls = new String("locality");
        } else if (subNamingAttr.equalsIgnoreCase("c")) {
            subObjCls = new String("country");
        } else if (subNamingAttr.equalsIgnoreCase("ou")) {
            subObjCls = new String("organizationalUnit");
        }
        Vector<String> subVector = new Vector<String>(20);
        subVector.insertElementAt("s_SubscriberObjectclass", 0);
        subVector.insertElementAt(subObjCls, 1);
        subVector.insertElementAt("s_SubscriberNamingAttribute", 2);
        subVector.insertElementAt(subNamingAttr, 3);
        subVector.insertElementAt("s_SubscriberName", 4);
        subVector.insertElementAt(subName, 5);
        subVector.insertElementAt("s_SubscriberParentDN", 6);
        subVector.insertElementAt(subParent, 7);
        subVector.insertElementAt("s_SubscriberDN", 8);
        subVector.insertElementAt(this.subDN, 9);
        subVector.insertElementAt("s_RootOracleContextDN", 10);
        subVector.insertElementAt(rootOracleContextDN, 11);
        subVector.insertElementAt("s_OracleContextDN", 12);
        subVector.insertElementAt("cn=OracleContext," + this.subDN, 13);
        subVector.insertElementAt("s_OracleContextParentDN", 14);
        subVector.insertElementAt(this.subDN, 15);
        subVector.insertElementAt("s_CurrentUserDN", 16);
        subVector.insertElementAt(curUserDN, 17);
        subVector.insertElementAt("s_GroupSearchBase", 18);
        subVector.insertElementAt("cn=groups," + this.subDN, 19);
        String schemaDir = this.ohome + System.getProperty("file.separator") + "ldap" + System.getProperty("file.separator") + "schema" + System.getProperty("file.separator") + "oid" + System.getProperty("file.separator");
        try {
            Util.ldapModify(this.ctx, m_logger, schemaDir + "oidSubscriberCreateCommon.lst", subVector, true, this.pStream);
            if (this.createAux) {
                Util.ldapModify(this.ctx, m_logger, schemaDir + "oidSubscriberCreateAuxDIT.lst", subVector, true, this.pStream);
            }
            if (this.defaultSub) {
                Util.ldapModify(this.ctx, m_logger, schemaDir + "oidDefaultSubscriberConfig.sbs", subVector, true, this.pStream);
            }
        }
        catch (Exception e) {
            throw new UtilException("Error in Subscriber creation");
        }
        UILabelsNLS.populateNLSLabels(this.ctx, this.subDN);
        if (this.genGuid) {
            int guid_count = 7;
            int vsize = 6;
            Vector<String> subVectorJAZN = new Vector<String>(vsize + guid_count * 2);
            subVectorJAZN.insertElementAt("s_SubscriberDN", 0);
            subVectorJAZN.insertElementAt(this.subDN, 1);
            subVectorJAZN.insertElementAt("s_SubscriberName", 2);
            subVectorJAZN.insertElementAt(subName, 3);
            subVectorJAZN.insertElementAt("s_OracleContextDN", 4);
            subVectorJAZN.insertElementAt("cn=OracleContext", 5);
            OrclGuid gid = null;
            for (int i = 0; i < guid_count; ++i) {
                gid = OrclGuid.newInstance();
                String gidRef = "s_GUID" + (i + 1);
                subVectorJAZN.insertElementAt(gidRef, vsize + i);
                subVectorJAZN.insertElementAt(gid.toString(), ++vsize + i);
            }
            Util.ldapModify(this.ctx, m_logger, schemaDir + "oidSubscriberCreateJAZN.sbs", subVectorJAZN, true, this.pStream);
        } else {
            Vector<String> subVectorJAZN = new Vector<String>(6);
            subVectorJAZN.insertElementAt("subscriberDN", 0);
            subVectorJAZN.insertElementAt(this.subDN, 1);
            subVectorJAZN.insertElementAt("subscriberNickname", 2);
            subVectorJAZN.insertElementAt(subName, 3);
            subVectorJAZN.insertElementAt("s_OracleContextDN", 4);
            subVectorJAZN.insertElementAt("cn=OracleContext", 5);
            Util.ldapModify(this.ctx, m_logger, this.ohome + System.getProperty("file.separator") + "j2ee" + System.getProperty("file.separator") + "home" + System.getProperty("file.separator") + "jazn" + System.getProperty("file.separator") + "install" + System.getProperty("file.separator") + "oidSubCreateJAZN.sbs", subVectorJAZN, true, this.pStream);
        }
    }

    private void rCreateDN(String inDN) throws UtilException {
        if (inDN == null) {
            throw new UtilException("inDN is null in rCreateDN");
        }
        StringTokenizer dnTok = new StringTokenizer(inDN, ",");
        if (Util.dnExists(this.ctx, inDN)) {
            return;
        }
        if (dnTok.countTokens() < 2) {
            this.createDNEntries(inDN);
        } else {
            this.rCreateDN(Util.getParentDN(inDN));
            this.createDNEntries(inDN);
        }
    }

    private void createDNEntries(String inDN) throws UtilException {
        String rdn = Util.getRDN(inDN);
        String attr = Util.getAttrOfRDN(inDN);
        String attrValue = Util.getAttrValueOfRDN(inDN);
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute objcls = new BasicAttribute("objectclass");
        objcls.add("top");
        if (attr.equalsIgnoreCase("dc")) {
            objcls.add("domain");
        } else if (attr.equalsIgnoreCase("c")) {
            objcls.add("country");
        } else if (attr.equalsIgnoreCase("o")) {
            objcls.add("organization");
        } else if (attr.equalsIgnoreCase("l")) {
            objcls.add("locality");
        } else if (attr.equalsIgnoreCase("ou")) {
            objcls.add("organizationalUnit");
        } else {
            throw new UtilException("RDN not valid for subscriber creation");
        }
        attrs.put(objcls);
        BasicAttribute attrObj = new BasicAttribute(attr);
        attrObj.add(attrValue);
        attrs.put(attrObj);
        try {
            this.ctx.createSubcontext(inDN, (Attributes)attrs);
        }
        catch (NamingException ne) {
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException("Cannot create DN during subscriber creation:  " + inDN, ne);
        }
    }

    private String getSimpleNameDN() throws UtilException {
        try {
            String[] attrList = new String[]{"orclsubscribernicknameattribute", "orclsubscribersearchbase"};
            PropertySetCollection psc = Util.getEntryDetails(this.ctx, "cn=common,cn=products,cn=oraclecontext", "(objectclass=*)", 0, attrList);
            String orclsubscribernicknameattribute = (String)psc.getPropertySet(0).getProperty("orclsubscribernicknameattribute").getValue(0);
            String orclsubscribersearchbase = null;
            orclsubscribersearchbase = psc.getPropertySet(0).getProperty("orclsubscribersearchbase") == null ? "" : "," + (String)psc.getPropertySet(0).getProperty("orclsubscribersearchbase").getValue(0);
            String curDN = orclsubscribernicknameattribute + "=" + this.simpleName + orclsubscribersearchbase;
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute objcls = new BasicAttribute("objectclass");
            objcls.add("top");
            if (orclsubscribernicknameattribute.equalsIgnoreCase("dc")) {
                objcls.add("domain");
            } else if (orclsubscribernicknameattribute.equalsIgnoreCase("c")) {
                objcls.add("country");
            } else if (orclsubscribernicknameattribute.equalsIgnoreCase("o")) {
                objcls.add("organization");
            } else if (orclsubscribernicknameattribute.equalsIgnoreCase("l")) {
                objcls.add("locality");
            } else if (orclsubscribernicknameattribute.equalsIgnoreCase("ou")) {
                objcls.add("organizationalUnit");
            } else {
                throw new UtilException("RDN not valid for subscriber creation");
            }
            attrs.put(objcls);
            BasicAttribute attrObj = new BasicAttribute(orclsubscribernicknameattribute);
            attrObj.add(this.simpleName);
            attrs.put(attrObj);
            this.ctx.createSubcontext(curDN, (Attributes)attrs);
            return curDN;
        }
        catch (NamingException ne) {
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException(resBundle.getString("INVALID_ROOT_CTX"), ne);
        }
    }
}

