/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.ResourceBundle;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Service;
import oracle.ldap.util.ServiceRecipient;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class ServiceReference
extends LDAPEntry {
    private static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    private String subscriptionContainerDN = null;
    private String serviceInstanceDN = null;

    public ServiceReference(DirContext inctx, String inputDN) {
        super(inctx, inputDN);
        try {
            this.resolve(inctx);
        }
        catch (UtilException utilException) {
            // empty catch block
        }
    }

    public ServiceReference(DirContext inctx, String inputDN, PropertySet ps) {
        super(inctx, inputDN, ps);
        try {
            this.resolve(inctx);
        }
        catch (UtilException e) {
            // empty catch block
        }
    }

    public Service getServiceInstance(DirContext ctx) throws UtilException {
        this.resolve(ctx);
        if (this.serviceInstanceDN == null) {
            throw new UtilException("Cannot locate Service Instance - attribute value missing");
        }
        Service svc = new Service(ctx, this.serviceInstanceDN);
        return svc;
    }

    public ServiceRecipient getServiceRecipient(DirContext ctx, String srName) throws UtilException {
        this.resolve(ctx);
        if (this.subscriptionContainerDN != null) {
            return new ServiceRecipient(ctx, "cn=" + srName + "," + this.subscriptionContainerDN);
        }
        throw new UtilException("Unable to locate subscription container");
    }

    public ServiceRecipient createServiceRecipient(DirContext ctx, String srName) throws UtilException {
        this.resolve(ctx);
        if (this.subscriptionContainerDN == null) {
            throw new UtilException("Subscription Container not specified");
        }
        String curDN = "cn=" + srName + "," + this.subscriptionContainerDN;
        String[] objclsList = new String[]{"groupOfUniqueNames", "orclServiceRecipient", "top"};
        ModPropertySet mps = new ModPropertySet(1);
        mps.addProperty(0, "objectclass", objclsList);
        mps.addProperty(0, "cn", srName);
        mps.addProperty(0, "uniquemember", "cn=orcladmin");
        try {
            Util.ldapAdd(ctx, curDN, mps);
        }
        catch (UtilException ne) {
            throw new UtilException("Cannot Create Service Recipient", ne);
        }
        return new ServiceRecipient(ctx, curDN);
    }

    public ServiceRecipient[] getAllServiceRecipients(DirContext ctx) throws UtilException {
        return this.getAllServiceRecipients(ctx, new String[0]);
    }

    public ServiceRecipient[] getAllServiceRecipients(DirContext ctx, String[] attrList) throws UtilException {
        this.resolve(ctx);
        if (this.subscriptionContainerDN == null) {
            throw new UtilException("Unable to locate subscription container");
        }
        ServiceRecipient[] svrArr = null;
        try {
            PropertySetCollection psc = Util.getEntryDetails(ctx, this.subscriptionContainerDN, "(objectclass=orclServiceRecipient)", 2, attrList);
            if (psc != null) {
                svrArr = new ServiceRecipient[psc.size()];
                for (int i = 0; i < psc.size(); ++i) {
                    PropertySet curPropSet = psc.getPropertySet(i);
                    svrArr[i] = new ServiceRecipient(ctx, curPropSet.getDN(), curPropSet);
                }
            }
            return svrArr;
        }
        catch (NamingException ne) {
            throw new UtilException(ne.toString());
        }
    }

    public void resolve(DirContext ctx) throws UtilException {
        String[] attrList;
        PropertySetCollection psc;
        if (!this.validated && !(psc = Util.dnExists(ctx, this.entryDN, attrList = new String[]{"orclservicesubscriptionlocation", "orclserviceinstancelocation"})).isEmpty()) {
            Property subLocProp = psc.getPropertySet(0).getProperty("orclservicesubscriptionlocation");
            Property svcLocProp = psc.getPropertySet(0).getProperty("orclserviceinstancelocation");
            this.validated = true;
            if (subLocProp != null) {
                this.subscriptionContainerDN = (String)subLocProp.getValue(0);
            } else {
                this.validated = false;
            }
            if (svcLocProp != null) {
                this.serviceInstanceDN = (String)svcLocProp.getValue(0);
            } else {
                this.validated = false;
            }
        }
    }
}

