/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.ResourceBundle;
import javax.naming.directory.DirContext;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPGroup;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class ServiceRecipient
extends LDAPGroup {
    private static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    private String hostedServiceObjectClass = "orclHostedService";

    public ServiceRecipient(DirContext inctx, String inputDN) throws UtilException {
        super(inctx, inputDN);
        this.resolve(inctx);
    }

    public ServiceRecipient(DirContext inctx, String inputDN, PropertySet ps) throws UtilException {
        super(inctx, inputDN, ps);
        this.resolve(inctx);
    }

    public void addUniquemember(DirContext ctx, String dn) throws UtilException {
        this.resolve(ctx);
        try {
            this.addMemberGuidEntry(ctx, dn);
        }
        catch (UtilException ue) {
            if (ue instanceof CommunicationErrorException) {
                throw ue;
            }
            throw new UtilException("Error in creating member guid entry under ServiceRecipient");
        }
        super.addUniquemember(ctx, dn);
    }

    public void addUniquemember(DirContext ctx, String[] dnArr) throws UtilException {
        this.resolve(ctx);
        for (int i = 0; i < dnArr.length; ++i) {
            this.addUniquemember(ctx, dnArr[i]);
        }
    }

    public void removeUniquemember(DirContext ctx, String dn) throws UtilException {
        this.resolve(ctx);
        try {
            this.removeMemberGuidEntry(ctx, dn);
        }
        catch (UtilException ue) {
            if (ue instanceof CommunicationErrorException) {
                throw ue;
            }
            throw new UtilException("Error in removing member guid entry under ServiceRecipient");
        }
        Util.removeUniquemember(ctx, this.entryDN, dn);
    }

    public void resolve(DirContext ctx) throws UtilException {
        if (!this.validated && Util.dnExists(ctx, this.entryDN)) {
            this.validated = true;
        }
    }

    private void addMemberGuidEntry(DirContext ctx, String dn) throws UtilException {
        String guid = null;
        try {
            guid = this.verifyDnAndGetGUID(ctx, dn);
        }
        catch (UtilException ue) {
            if (ue instanceof CommunicationErrorException) {
                throw ue;
            }
            throw new UtilException("DN is not a valid user");
        }
        ModPropertySet mps = new ModPropertySet(1);
        String[] objclsList = new String[]{"orclServiceSubscriptionDetail", "orclReferenceObject", "top"};
        mps.addProperty(0, "objectclass", objclsList);
        mps.addProperty(0, "orclOwnerGUID", guid);
        mps.addProperty(0, "seeAlso", dn);
        String newDN = "orclOwnerGUID=" + guid + "," + this.entryDN;
        Util.ldapAdd(ctx, newDN, mps);
    }

    private void removeMemberGuidEntry(DirContext ctx, String dn) throws UtilException {
        String guid = null;
        try {
            guid = this.verifyDnAndGetGUID(ctx, dn);
        }
        catch (UtilException ue) {
            if (ue instanceof CommunicationErrorException) {
                throw ue;
            }
            throw new UtilException("DN is not a valid user");
        }
        String newDN = "orclOwnerGUID=" + guid + "," + this.entryDN;
        Util.ldapDelete(ctx, newDN);
    }

    private String verifyDnAndGetGUID(DirContext ctx, String dn) throws UtilException {
        String[] attrList = new String[]{"orclguid"};
        PropertySetCollection psc = Util.ldapSearch(ctx, dn, "objectclass=*", 0, attrList);
        if (psc == null) {
            throw new UtilException("Cannot find the user");
        }
        return (String)psc.getPropertySet(0).getProperty("orclguid").getValue(0);
    }
}

