/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.OracleContext;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.SubscriberCreator;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public final class RootOracleContext
extends OracleContext {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    public static final String rootOracleContextDN = "cn=OracleContext";
    private PropertySetCollection subSchemaSubEntryPsc = null;
    protected String orclCtxFilePrefix = "oidRootContext";
    protected String[] resolveAttrs = new String[]{"orclversion", "orclDefaultSubscriber", "orclSubscriberNickNameAttribute", "orclSubscriberSearchBase"};
    private String subSearchBase = null;

    public RootOracleContext(DirContext inCtx, Logger lgr, String inOhome) {
        this(inCtx, lgr, inOhome, (PrintStream)null);
    }

    public RootOracleContext(DirContext inCtx, String inOhome) {
        this(inCtx, inOhome, (PrintStream)null);
    }

    public RootOracleContext(DirContext inCtx, Logger lgr, String inOhome, PrintStream pStream) {
        super(inCtx, lgr, inOhome, rootOracleContextDN, pStream);
        ((OracleContext)this).orclCtxFilePrefix = "oidRootContext";
        ((OracleContext)this).resolveAttrs = new String[4];
        ((OracleContext)this).resolveAttrs[0] = "orclversion";
        ((OracleContext)this).resolveAttrs[1] = "orclDefaultSubscriber";
        ((OracleContext)this).resolveAttrs[2] = "orclSubscriberNickNameAttribute";
        ((OracleContext)this).resolveAttrs[3] = "orclSubscriberSearchBase";
        m_logger = lgr;
    }

    public RootOracleContext(DirContext inCtx, String inOhome, PrintStream pStream) {
        super(inCtx, inOhome, rootOracleContextDN, pStream);
        ((OracleContext)this).orclCtxFilePrefix = "oidRootContext";
        ((OracleContext)this).resolveAttrs = new String[4];
        ((OracleContext)this).resolveAttrs[0] = "orclversion";
        ((OracleContext)this).resolveAttrs[1] = "orclDefaultSubscriber";
        ((OracleContext)this).resolveAttrs[2] = "orclSubscriberNickNameAttribute";
        ((OracleContext)this).resolveAttrs[3] = "orclSubscriberSearchBase";
    }

    public RootOracleContext(DirContext inCtx, Logger lgr) {
        super(inCtx, lgr, rootOracleContextDN);
        ((OracleContext)this).orclCtxFilePrefix = "oidRootContext";
        ((OracleContext)this).resolveAttrs = new String[4];
        ((OracleContext)this).resolveAttrs[0] = "orclversion";
        ((OracleContext)this).resolveAttrs[1] = "orclDefaultSubscriber";
        ((OracleContext)this).resolveAttrs[2] = "orclSubscriberNickNameAttribute";
        ((OracleContext)this).resolveAttrs[3] = "orclSubscriberSearchBase";
        m_logger = lgr;
    }

    public RootOracleContext(DirContext inCtx) {
        super(inCtx, rootOracleContextDN);
        ((OracleContext)this).orclCtxFilePrefix = "oidRootContext";
        ((OracleContext)this).resolveAttrs = new String[4];
        ((OracleContext)this).resolveAttrs[0] = "orclversion";
        ((OracleContext)this).resolveAttrs[1] = "orclDefaultSubscriber";
        ((OracleContext)this).resolveAttrs[2] = "orclSubscriberNickNameAttribute";
        ((OracleContext)this).resolveAttrs[3] = "orclSubscriberSearchBase";
    }

    public Subscriber[] getAllSubscribers(DirContext ctx, String filter, String[] attrList) throws UtilException {
        this.resolve(ctx);
        try {
            String[] tmpattrList;
            PropertySetCollection psc;
            if (filter == null) {
                filter = new String("(objectclass=orclSubscriber)");
            }
            this.subSearchBase = (psc = this.getCommonProperties(ctx, tmpattrList = new String[]{"orclsubscribersearchbase"})).getPropertySet(0).isEmpty() ? "" : (String)psc.getPropertySet(0).getProperty(0).getValue(0);
            psc = Util.getEntryDetails(ctx, this.subSearchBase, "(&(objectclass=orclSubscriber)(" + filter + "))", 2, attrList);
            int numSubscribers = psc.size();
            ArrayList<Subscriber> subscriberList = new ArrayList<Subscriber>();
            for (int i = 0; i < numSubscribers; ++i) {
                PropertySet curPropertySet = psc.getPropertySet(i);
                Subscriber curSub = null;
                try {
                    curSub = new Subscriber(ctx, curPropertySet.getDN(), curPropertySet, m_logger);
                    curSub.resolve(ctx);
                    subscriberList.add(curSub);
                    continue;
                }
                catch (UtilException ue) {
                    if (!(ue instanceof CommunicationErrorException)) continue;
                    throw ue;
                }
            }
            Subscriber[] subArray = new Subscriber[subscriberList.size()];
            for (int i = 0; i < subscriberList.size(); ++i) {
                subArray[i] = (Subscriber)subscriberList.get(i);
            }
            return subArray;
        }
        catch (NamingException ne) {
            if (ne instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
            }
            throw new UtilException("Cannot return all Subscribers", ne);
        }
    }

    public Subscriber[] getAllSubscribers(DirContext ctx, String[] attrList) throws UtilException {
        return this.getAllSubscribers(ctx, "(objectclass=orclSubscriber)", attrList);
    }

    public Subscriber createDefaultSubscriber(DirContext ctx, String subscriberDN, boolean withAux) throws UtilException {
        SubscriberCreator sc = new SubscriberCreator(ctx, m_logger, this.ohome, subscriberDN, this.pStream);
        sc.createDefault(withAux);
        return this.getSubscriber(ctx, Util.IDTYPE_DEFAULT, null, new String[0]);
    }

    public Subscriber createSubscriber(DirContext ctx, String simpleName, boolean withAux) throws UtilException {
        this.resolve(ctx);
        String[] attrList = new String[]{"orclSubscriberSearchBase", "orclSubscriberNickNameAttribute"};
        PropertySetCollection psc = this.getCommonProperties(ctx, attrList);
        String subSearchBase = null;
        subSearchBase = psc.getPropertySet(0).isEmpty() ? "" : (String)psc.getPropertySet(0).getProperty(0).getValue(0);
        String subNickNameAttribute = (String)psc.getPropertySet(0).getProperty("orclSubscriberNickNameAttribute").getValue(0);
        SubscriberCreator sc = new SubscriberCreator(ctx, m_logger, this.ohome, simpleName, subSearchBase, subNickNameAttribute, this.pStream);
        sc.create(withAux);
        return this.getSubscriber(ctx, Util.IDTYPE_SIMPLE, simpleName, new String[0]);
    }

    public Subscriber getSubscriber(DirContext ctx, int inSubIdType, String inSubIdName, String[] attrList) throws UtilException {
        this.resolve(ctx);
        Subscriber sub = new Subscriber(ctx, inSubIdType, inSubIdName, this.ohome, this.commonPsc, attrList, m_logger);
        return sub;
    }

    public void create(DirContext ctx) throws UtilException {
        try {
            super.create(ctx);
            String fileName = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "oid" + this.fileSeparator + "oidRootACISetup.sbs";
            Util.ldapModify(ctx, m_logger, fileName, null, true, this.pStream);
        }
        catch (Exception e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new UtilException(resBundle.getString("INVALID_ROOT_CTX"), e);
        }
    }
}

