/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.Serializable;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.SearchResult;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class PropertySetCollection
implements Serializable {
    private static String commonDN = "cn=Common,cn=Products,cn=OracleContext";
    private Vector resultVector = null;
    private String searchBaseDN = null;
    private transient Object resultSet = null;
    private boolean converted = false;
    private boolean sizeLimitExceeded = false;

    protected PropertySetCollection() {
        this.resultVector = new Vector();
        this.converted = true;
    }

    public PropertySetCollection(int initSize) {
        this.resultVector = new Vector(initSize);
        this.converted = true;
    }

    protected PropertySetCollection(String base, Object inResultSet) {
        this(base, inResultSet, true);
    }

    protected PropertySetCollection(String base, Object inResultSet, boolean convert) {
        this.resultVector = new Vector();
        this.searchBaseDN = base;
        this.resultSet = inResultSet;
        if (convert) {
            this.convert();
        }
    }

    public final boolean isEmpty() {
        this.convert();
        return this.resultVector.isEmpty();
    }

    public final int size() {
        this.convert();
        return this.resultVector.size();
    }

    public final boolean isSizeLimitExceeded() {
        return this.sizeLimitExceeded;
    }

    public void addPropertySet(PropertySet propSet) {
        this.resultVector.addElement(propSet);
    }

    public final String[] getDns() {
        this.convert();
        String[] dnArray = new String[this.resultVector.size()];
        for (int i = 0; i < this.resultVector.size(); ++i) {
            dnArray[i] = ((PropertySet)this.resultVector.elementAt(i)).getDN();
        }
        return dnArray;
    }

    public final PropertySet getPropertySet(int i) {
        this.convert();
        return (PropertySet)this.resultVector.elementAt(i);
    }

    public final PropertySet getPropertySet(String dn) {
        this.convert();
        String normDn = Util.normalizeDN(dn);
        for (int i = 0; i < this.resultVector.size(); ++i) {
            if (!normDn.equals(Util.normalizeDN(((PropertySet)this.resultVector.elementAt(i)).getDN()))) continue;
            return this.getPropertySet(i);
        }
        return new PropertySet();
    }

    final void add(PropertySet propSet) {
        this.convert();
        this.resultVector.addElement(propSet);
    }

    final PropertySet remove(int i) {
        this.convert();
        PropertySet propSet = (PropertySet)this.resultVector.elementAt(i);
        this.resultVector.removeElementAt(i);
        return propSet;
    }

    final Vector toVector() {
        this.convert();
        return (Vector)this.resultVector.clone();
    }

    public void convert() {
        block8: {
            if (!this.converted) {
                try {
                    if (this.resultSet != null) {
                        if (this.resultSet instanceof NamingEnumeration) {
                            while (((NamingEnumeration)this.resultSet).hasMore()) {
                                SearchResult curRes = (SearchResult)((NamingEnumeration)this.resultSet).next();
                                PropertySet curProp = new PropertySet(this.searchBaseDN, curRes);
                                this.resultVector.addElement(curProp);
                            }
                        } else if (this.resultSet instanceof SearchResult) {
                            PropertySet curProp = new PropertySet(this.searchBaseDN, (SearchResult)this.resultSet);
                            this.resultVector.addElement(curProp);
                        }
                    }
                }
                catch (NamingException e) {
                    if (!(e instanceof SizeLimitExceededException)) break block8;
                    this.sizeLimitExceeded = true;
                }
            }
        }
        this.converted = true;
        this.resultSet = null;
    }

    public String[] getPropertyValues(String propName) throws UtilException {
        if (this.isEmpty()) {
            throw new UtilException("The PropertySetCollection is empty");
        }
        Vector<Object> values = new Vector<Object>();
        try {
            for (int i = 0; i < this.size(); ++i) {
                Property prop = this.getPropertySet(i).getProperty(propName);
                if (prop == null || prop.size() < 1) continue;
                for (int j = 0; j < prop.size(); ++j) {
                    values.addElement(prop.getValue(j));
                }
            }
        }
        catch (Exception e) {
            throw new UtilException("Unexpected exception from getPropertyValues" + e.toString());
        }
        if (values.size() > 0) {
            return Util.vector2StrArray(values);
        }
        return null;
    }

    public String getUniquePropertyValue(String propName) throws UtilException {
        if (this.isEmpty()) {
            throw new UtilException("The PropertySetCollection is empty");
        }
        String retval = null;
        try {
            for (int i = 0; i < this.size(); ++i) {
                Property prop = this.getPropertySet(i).getProperty(propName);
                if (prop == null || prop.size() <= 0) continue;
                if (prop.size() > 1) {
                    throw new UtilException("The property has more than 1 value");
                }
                if (retval != null) {
                    throw new UtilException("The property is not unique.");
                }
                retval = (String)prop.getValue(0);
            }
        }
        catch (Exception e) {
            throw new UtilException("Unexpected exception from getUniquePropertyValue" + e.toString());
        }
        return retval;
    }
}

