/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class PropertySet
implements Serializable {
    private String commonDN = "cn=Common,cn=Products,cn=OracleContext";
    protected Vector attributeVector = null;
    private String DN = null;
    protected Attributes attributeSet = null;
    private static ResourceBundle resBundle = LDAPEntry.resBundle;

    protected PropertySet() {
        this.attributeVector = new Vector();
    }

    protected PropertySet(String baseDN, Attributes attributeSet, Vector attributeVector) {
        this.DN = new String(baseDN);
        this.attributeSet = attributeSet;
        this.attributeVector = attributeVector;
    }

    public PropertySet(String baseDN, SearchResult result) {
        this.attributeVector = new Vector();
        this.DN = result.getName().length() > 0 ? result.getNameInNamespace() : new String(baseDN);
        this.attributeSet = result.getAttributes();
        try {
            NamingEnumeration<? extends Attribute> attrEnum = this.attributeSet.getAll();
            while (attrEnum.hasMore()) {
                this.attributeVector.addElement(attrEnum.next());
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public final boolean isEmpty() {
        return this.attributeVector.isEmpty();
    }

    public final int size() {
        return this.attributeVector.size();
    }

    public final String[] getAttributeNames() {
        int numAttr = this.size();
        String[] attrArray = new String[numAttr];
        for (int i = 0; i < numAttr; ++i) {
            attrArray[i] = ((Attribute)this.attributeVector.elementAt(i)).getID();
        }
        return attrArray;
    }

    public final Property getProperty(int i) {
        return new Property((Attribute)this.attributeVector.elementAt(i));
    }

    public final Property getProperty(String attrID) {
        Property ret = null;
        Attribute attr = this.attributeSet.get(attrID);
        if (attr != null) {
            ret = new Property(attr);
        }
        return ret;
    }

    public final String getDN() {
        return this.DN;
    }

    protected void mergePropertySet(PropertySet newPs) {
        Attributes newAttributeSet = newPs.getAttributeSet();
        try {
            NamingEnumeration<? extends Attribute> attrEnum = newAttributeSet.getAll();
            while (attrEnum.hasMore()) {
                Attribute curAttr = attrEnum.next();
                this.attributeVector.addElement(curAttr);
                this.attributeSet.put(curAttr);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    protected String[] getMissingAttributes(String[] attrList) {
        Vector<String> missingList = new Vector<String>();
        for (int i = 0; i < attrList.length; ++i) {
            Attribute attr = null;
            if (attrList[i] != null) {
                attr = this.attributeSet.get(attrList[i]);
            }
            if (attr != null) continue;
            missingList.add(attrList[i]);
        }
        int missingListSize = missingList.size();
        String[] strArr = new String[missingListSize];
        for (int i = 0; i < missingListSize; ++i) {
            strArr[i] = (String)missingList.elementAt(i);
        }
        return strArr;
    }

    protected PropertySet returnPropertySet(String[] attrList) {
        BasicAttributes newAttributeSet = new BasicAttributes(true);
        Vector<Attribute> newAttributeVector = new Vector<Attribute>();
        for (int i = 0; i < attrList.length; ++i) {
            Attribute attr = null;
            if (attrList[i] != null) {
                attr = this.attributeSet.get(attrList[i]);
            }
            if (attr == null) continue;
            newAttributeVector.addElement(attr);
            newAttributeSet.put(attr);
        }
        return new PropertySet(this.getDN(), newAttributeSet, newAttributeVector);
    }

    protected Attributes getAttributeSet() {
        return this.attributeSet;
    }

    protected PropertySet doSearch(DirContext ctx, String[] attrList) throws UtilException {
        try {
            String[] newAttrList = this.getMissingAttributes(attrList);
            PropertySetCollection newDnPsc = null;
            if (newAttrList.length > 0) {
                newDnPsc = Util.getEntryDetails(ctx, this.DN, "(objectclass=*)", 0, newAttrList);
                this.mergePropertySet(newDnPsc.getPropertySet(0));
            }
            return this.returnPropertySet(attrList);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new UtilException(resBundle.getString("GENERAL_ERROR_SEARCH") + this.DN, e);
        }
    }
}

