/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import oracle.ldap.util.IllegalValueException;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.MinimumLengthException;
import oracle.ldap.util.NumericCharacterException;
import oracle.ldap.util.PasswordPolicyException;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;
import oracle.ldap.util.controls.PasswordPolicyRequestControl;

public class PasswordPolicy
implements Serializable {
    public static final int PASSWORD_EXPIRED_EC = 9000;
    public static final int PASSWORD_ACCOUNT_LOCKED = 9001;
    public static final int PASSWORD_EXPIRE_WARNING = 9002;
    public static final int PASSWORD_MINLENGTH_EC = 9003;
    public static final int PASSWORD_NUMERIC_EC = 9004;
    public static final int PASSWORD_NULL_EC = 9005;
    public static final int PASSWORD_IN_HISTORY_EC = 9006;
    public static final int PASSWORD_ILLEGAL_VALUE_EC = 9007;
    public static final int PASSWORD_GRACE_LOGIN = 9008;
    public static final int PASSWORD_MUST_CHANGE = 9009;
    public static final int PASSWORD_IP_ACCOUNT_LOCKED = 9011;
    public static final int ACCT_DISABLED_EC = 9050;
    public static final int ACCT_UNLOCK_EC = 9051;
    public static final int ACCT_INACTIVE = 9053;
    public static final String PASSWORD_EXPIRE_WARNING_CONTROL = "2.16.840.1.113894.1.8.7";
    public static final String PASSWORD_EXPIRE_GRACE_LOGIN_CONTROL = "2.16.840.1.113894.1.8.8";
    public static final String PASSWORD_EXPIRE_MUST_CHANGE_CONTROL = "2.16.840.1.113894.1.8.9";
    public static final int PASSWORD_POLICY_ENABLED = 0;
    public static final int PASSWORD_MINLENGTH_PROPERTY = 1;
    public static final int PASSWORD_ALPHA_NUMERIC_PROPERTY = 2;
    public static final int PASSWORD_ILLEGAL_VALUES_PROPERTY = 3;
    private boolean passwordPolicyEnabled = false;
    private int passwordMinimumLength = 0;
    private int passwordAlphaNumericValue = 0;
    private static String[] passwordIllegalValues = null;
    private static final String[] passwordPolicyAttributes = new String[]{"orclpwdpolicyenable", "orclpwdalphanumeric", "pwdminlength", "orclpwdillegalvalues"};

    public static PasswordPolicy getPasswordPolicy(LdapContext ctx, Subscriber sub, String userCreateBase) throws UtilException {
        try {
            return PasswordPolicy.getPasswordPolicy(ctx, userCreateBase);
        }
        catch (UtilException e) {
            if (!e.isNamingException() || !(e.returnNamingException() instanceof OperationNotSupportedException)) {
                throw e;
            }
            return PasswordPolicy.getPasswordPolicy((DirContext)ctx, sub);
        }
    }

    public static PasswordPolicy getPasswordPolicy(DirContext ctx, Subscriber sub) throws UtilException {
        String passwordPolicyDN = "cn=pwdpolicyentry,cn=common,cn=products,cn=oraclecontext," + sub.getDN(ctx);
        PropertySetCollection psc = Util.ldapSearch(ctx, passwordPolicyDN, "objectclass=pwdpolicy", 0, passwordPolicyAttributes);
        PropertySet ps = psc.getPropertySet(0);
        return new PasswordPolicy(ctx, ps);
    }

    public static PasswordPolicy getPasswordPolicy(LdapContext ctx, String dn) throws UtilException {
        Control[] originalCtls = null;
        PropertySetCollection psc = null;
        try {
            originalCtls = ctx.getRequestControls();
            ctx.setRequestControls(new Control[]{new PasswordPolicyRequestControl()});
        }
        catch (NamingException ne) {
            throw new UtilException((Exception)ne);
        }
        try {
            psc = Util.ldapSearch(ctx, dn, "objectclass=*", 0, null);
        }
        catch (UtilException e) {
            throw e;
        }
        finally {
            try {
                ctx.setRequestControls(originalCtls);
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        PropertySet ps = psc.getPropertySet(0);
        return new PasswordPolicy(ctx, ps);
    }

    private PasswordPolicy(DirContext ctx, PropertySet ps) throws UtilException {
        try {
            int value;
            Property prop = ps.getProperty("orclpwdpolicyenable");
            if (prop != null && (value = new Integer((String)prop.getValue(0)).intValue()) > 0) {
                this.passwordPolicyEnabled = true;
            }
            if ((prop = ps.getProperty("pwdminlength")) != null) {
                this.passwordMinimumLength = new Integer((String)prop.getValue(0));
            }
            if ((prop = ps.getProperty("orclpwdalphanumeric")) != null) {
                this.passwordAlphaNumericValue = new Integer((String)prop.getValue(0));
            }
            if ((prop = ps.getProperty("orclpwdillegalvalues")) != null) {
                passwordIllegalValues = new String[prop.size()];
                for (int i = 0; i < prop.size(); ++i) {
                    PasswordPolicy.passwordIllegalValues[i] = (String)prop.getValue(i);
                }
            }
        }
        catch (Exception e) {
            throw new PasswordPolicyException("Invalid Password Policy: " + ps.getDN());
        }
    }

    public void validatePassword(String password) throws PasswordPolicyException {
        if (this.passwordPolicyEnabled) {
            this.validateMinimumLength(password);
            this.validateAlphaNumericValue(password);
            this.validateIllegalValues(password);
        }
    }

    public Object getProperties(int propType) throws InvalidParameterException {
        if (propType == 0) {
            if (this.passwordPolicyEnabled) {
                return "1";
            }
            return "0";
        }
        if (propType == 1) {
            return new Integer(this.passwordMinimumLength).toString();
        }
        if (propType == 2) {
            return new Integer(this.passwordAlphaNumericValue).toString();
        }
        if (propType == 3) {
            return passwordIllegalValues;
        }
        throw new InvalidParameterException();
    }

    public void validateMinimumLength(String password) throws MinimumLengthException {
        if (password.length() < this.passwordMinimumLength) {
            throw new MinimumLengthException("Password must have at least " + this.passwordMinimumLength + " characters.");
        }
    }

    public void validateAlphaNumericValue(String password) throws NumericCharacterException {
        int withoutAlphaNumericLength;
        int originalLength = password.length();
        if (originalLength - (withoutAlphaNumericLength = password.replaceAll("[0-9]", "").length()) < this.passwordAlphaNumericValue) {
            throw new NumericCharacterException("Password must have at least " + this.passwordAlphaNumericValue + " alphanumeric [0,9] characters.");
        }
    }

    public void validateIllegalValues(String password) throws IllegalValueException {
        if (passwordIllegalValues != null && passwordIllegalValues.length > 0) {
            for (int i = 0; i < passwordIllegalValues.length; ++i) {
                if (!password.equals(passwordIllegalValues[i])) continue;
                throw new IllegalValueException("Illegal Password value is detected: " + passwordIllegalValues[i]);
            }
        }
    }
}

