/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class OracleContext
extends LDAPEntry
implements Serializable {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    public static final String oracleContextCN = "OracleContext";
    public static final String oracleContextRDN = "cn=OracleContext";
    public static final String oracleContextObjClass = "orclContext";
    private static final String adDefaultNamingContext = "defaultNamingContext";
    protected static final String listFileExt = ".lst";
    protected String ohome = null;
    protected String orclCtxVersion = null;
    protected String orclCtxFilePrefix = "oidContext";
    protected Vector subVector = null;
    protected PropertySetCollection commonPsc = null;
    protected PropertySetCollection productPsc = null;
    protected String[] resolveAttrs = new String[]{"orclversion", "orclCommonNickNameAttribute", "orclCommonNamingAttribute", "orclCommonUserSearchBase", "orclCommonUserCreateBase", "orclCommonGroupSearchBase", "orclUserObjectclasses"};
    protected String fileSeparator = null;
    protected transient PrintStream pStream = null;

    public OracleContext(Logger lgr) {
        m_logger = lgr;
    }

    public OracleContext() {
    }

    public OracleContext(DirContext inCtx, Logger lgr, String inOhome, String inOrclCtxDN) {
        this(inCtx, inOhome, inOrclCtxDN, null);
    }

    public OracleContext(DirContext inCtx, String inOhome, String inOrclCtxDN) {
        this(inCtx, inOhome, inOrclCtxDN, null);
    }

    public OracleContext(DirContext inCtx, Logger lgr, String inOhome, String inOrclCtxDN, PrintStream pStream) {
        this(inCtx, inOhome, inOrclCtxDN, pStream);
        m_logger = lgr;
    }

    public OracleContext(DirContext inCtx, String inOhome, String inOrclCtxDN, PrintStream pStream) {
        this(inCtx, inOrclCtxDN);
        this.pStream = pStream;
        this.ohome = inOhome;
    }

    public OracleContext(DirContext inCtx, Logger lgr, String inOrclCtxDN) {
        this(inCtx, inOrclCtxDN);
        m_logger = lgr;
    }

    public OracleContext(DirContext inCtx, String inOrclCtxDN) {
        super(inCtx, inOrclCtxDN);
        this.fileSeparator = System.getProperty("file.separator");
    }

    public boolean exists(DirContext ctx) {
        try {
            this.resolve(ctx);
        }
        catch (UtilException ue) {
            return false;
        }
        return true;
    }

    public void refresh(DirContext ctx) throws UtilException {
        this.validated = false;
        this.resolve(ctx);
    }

    public void resolve(DirContext ctx) throws UtilException {
        if (!this.validated) {
            try {
                PropertySetCollection psc = Util.getEntryDetails(ctx, this.entryDN, "(|(objectclass=orclContext)(cn=common))", 2, this.resolveAttrs);
                if (psc.isEmpty() || psc.size() < 2) {
                    throw new UtilException("Invalid OracleContext:  " + this.entryDN);
                }
                this.commonPsc = new PropertySetCollection();
                this.commonPsc.add(psc.getPropertySet("cn=common,cn=products," + this.entryDN));
                this.entryPsc = new PropertySetCollection();
                this.entryPsc.add(psc.getPropertySet(this.entryDN));
                this.validated = true;
            }
            catch (NamingException ne) {
                if (ne instanceof CommunicationException) {
                    throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
                }
                throw new UtilException(resBundle.getString("ORACLECONTEXT_RESOLVE_ERROR") + this.entryDN, ne);
            }
        }
    }

    public void resolve(DirContext ctx, String product) throws UtilException {
        if (!this.validated) {
            try {
                PropertySetCollection psc = Util.getEntryDetails(ctx, this.entryDN, "(|(objectclass=orclContext)(cn=" + product + ")(cn=common))", 2, this.resolveAttrs);
                if (psc.isEmpty() || psc.size() < 2) {
                    throw new UtilException("Invalid OracleContext:  " + this.entryDN);
                }
                this.commonPsc = new PropertySetCollection();
                this.commonPsc.add(psc.getPropertySet("cn=common,cn=products," + this.entryDN));
                this.entryPsc = new PropertySetCollection();
                this.entryPsc.add(psc.getPropertySet(this.entryDN));
                if (product != null) {
                    this.productPsc = new PropertySetCollection();
                    this.productPsc.add(psc.getPropertySet("cn=" + product + ",cn=products," + this.entryDN));
                } else {
                    this.productPsc = this.entryPsc;
                }
                this.validated = true;
            }
            catch (NamingException ne) {
                if (ne instanceof CommunicationException) {
                    throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), ne);
                }
                throw new UtilException(resBundle.getString("ORACLECONTEXT_RESOLVE_ERROR") + this.entryDN, ne);
            }
        }
    }

    public void create(DirContext ctx) throws UtilException {
        try {
            this.getSubstitutionVector(ctx);
            String fileName = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "oid" + this.fileSeparator + this.orclCtxFilePrefix + "Create.lst";
            Util.ldapModify(ctx, m_logger, fileName, this.subVector, true, this.getPrintStream());
        }
        catch (Exception e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new UtilException(resBundle.getString("ORACLECONTEXT_CREATION_ERROR"), e);
        }
    }

    public void create(DirContext ctx, String product, String schemaLoc) throws UtilException {
        try {
            this.getSubstitutionVector(ctx);
            String fileName = this.ohome + this.fileSeparator + schemaLoc + this.fileSeparator + this.orclCtxFilePrefix + "Create.lst";
            Util.ldapModify(ctx, m_logger, fileName, this.subVector, true, this.getPrintStream());
        }
        catch (Exception e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new UtilException(resBundle.getString("ORACLECONTEXT_CREATION_ERROR"), e);
        }
    }

    public String getVersion(DirContext ctx) throws UtilException {
        this.validated = false;
        this.resolve(ctx);
        return ((String)this.entryPsc.getPropertySet(0).getProperty("orclversion").getValue(0)).trim();
    }

    public String getVersion(DirContext ctx, String product) throws UtilException {
        this.validated = false;
        this.resolve(ctx, product);
        if (this.productPsc.getPropertySet(0).getDN() == null || this.productPsc.getPropertySet(0).getProperty("orclversion") == null) {
            return new String("0");
        }
        return ((String)this.productPsc.getPropertySet(0).getProperty("orclversion").getValue(0)).trim();
    }

    public String getDBCompatibilityVersion(DirContext ctx) throws UtilException {
        try {
            String[] attrList = new String[]{"orclDBVersionCompatibility"};
            PropertySetCollection psc = Util.getEntryDetails(ctx, "cn=OracleDBSecurity,cn=products," + this.entryDN, "(objectclass=*)", 0, attrList);
            return (String)psc.getPropertySet(0).getProperty(0).getValue(0);
        }
        catch (Exception e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new UtilException(resBundle.getString("ORACLECONTEXT_RESOLVE_ERROR") + this.entryDN, e);
        }
    }

    public static String[] getOracleContext(DirContext ctx) throws UtilException {
        return OracleContext.getOracleContext(ctx, "");
    }

    public static String[] getOracleContext(DirContext ctx, String baseDN) throws UtilException {
        try {
            PropertySetCollection psc = Util.getEntryDetails(ctx, baseDN, "(objectclass=orclContext)", 2, new String[0]);
            int numDNs = psc.size();
            String[] dnArray = new String[numDNs];
            for (int i = 0; i < numDNs; ++i) {
                dnArray[i] = new String(psc.getPropertySet(i).getDN());
            }
            return dnArray;
        }
        catch (Exception e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new UtilException(resBundle.getString("GENERAL_ERROR_SEARCH"), e);
        }
    }

    public void upgrade(DirContext ctx) throws Exception {
        while (!this.isUpToDate(ctx)) {
            String curVersion = this.getVersion(ctx);
            m_logger.log(Level.INFO, "curVersion: " + curVersion + "\n");
            String curUpgradeFromLst = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "oid" + this.fileSeparator + this.orclCtxFilePrefix + "UpgradeFrom" + curVersion + listFileExt;
            m_logger.log(Level.INFO, "Loading: " + curUpgradeFromLst);
            this.getSubstitutionVector(ctx);
            Util.ldapModify(ctx, m_logger, curUpgradeFromLst, this.subVector, true, this.getPrintStream());
        }
    }

    public void upgrade(DirContext ctx, String product, String schemaLoc) throws Exception {
        while (!this.isUpToDate(ctx, product, schemaLoc)) {
            String curVersion = this.getVersion(ctx, product);
            m_logger.log(Level.INFO, "curVersion: " + curVersion + "\n");
            if (curVersion.compareTo("0") != 0) {
                String curUpgradeFromLst = this.ohome + this.fileSeparator + schemaLoc + this.fileSeparator + this.orclCtxFilePrefix + "UpgradeFrom" + curVersion + listFileExt;
                m_logger.log(Level.INFO, "Loading: " + curUpgradeFromLst);
                this.getSubstitutionVector(ctx);
                Util.ldapModify(ctx, m_logger, curUpgradeFromLst, this.subVector, true, this.getPrintStream());
                continue;
            }
            String createLst = this.ohome + this.fileSeparator + schemaLoc + this.fileSeparator + this.orclCtxFilePrefix + "Create.lst";
            m_logger.log(Level.INFO, "Loading: " + createLst);
            this.getSubstitutionVector(ctx);
            Util.ldapModify(ctx, m_logger, createLst, this.subVector, true, this.getPrintStream());
        }
    }

    protected void getSubstitutionVector(DirContext ctx) {
        try {
            Hashtable<?, ?> ctxEnvironment = ctx.getEnvironment();
            String curUserDN = (String)ctxEnvironment.get("java.naming.security.principal");
            String orclCtxParentDN = Util.getParentDN(this.entryDN);
            this.subVector = new Vector(6);
            this.subVector.insertElementAt("s_CurrentUserDN", 0);
            this.subVector.insertElementAt(curUserDN, 1);
            this.subVector.insertElementAt("s_OracleContextParentDN", 2);
            this.subVector.insertElementAt(orclCtxParentDN, 3);
            this.subVector.insertElementAt("s_OracleContextDN", 4);
            this.subVector.insertElementAt(this.entryDN, 5);
            this.subVector.toString();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public PropertySetCollection getCommonProperties(DirContext ctx, String[] attrList) throws UtilException {
        boolean usecache = true;
        this.resolve(ctx);
        try {
            if (usecache && attrList != null) {
                this.commonPsc.getPropertySet(0).doSearch(ctx, attrList);
                PropertySetCollection returnPsc = new PropertySetCollection();
                returnPsc.add(this.commonPsc.getPropertySet(0).returnPropertySet(attrList));
                return returnPsc;
            }
            this.commonPsc = Util.getEntryDetails(ctx, this.entryDN, "(objectclass=*)", 0, attrList);
            return this.commonPsc;
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new UtilException(resBundle.getString("ORACLECONTEXT_RESOLVE_ERROR") + this.entryDN, e);
        }
    }

    public boolean isUpToDate(DirContext ctx) throws UtilException {
        try {
            String version = this.getVersion(ctx).trim();
            String versionFileName = this.ohome + this.fileSeparator + "ldap" + this.fileSeparator + "schema" + this.fileSeparator + "versions.txt";
            m_logger.log(Level.INFO, versionFileName);
            String upToDateVersion = Util.getParameterFromFile("ContextVersion", versionFileName).trim();
            m_logger.log(Level.INFO, "version: " + version + " up_version: " + upToDateVersion);
            int upToDateVersionInt = Integer.valueOf(upToDateVersion);
            int versionInt = Integer.valueOf(version);
            return versionInt >= upToDateVersionInt;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public boolean isUpToDate(DirContext ctx, String product, String schemaLoc) throws UtilException {
        try {
            String version = this.getVersion(ctx, product).trim();
            String versionFileName = this.ohome + this.fileSeparator + schemaLoc + this.fileSeparator + "versions.txt";
            m_logger.log(Level.INFO, versionFileName);
            String upToDateVersion = Util.getParameterFromFile("ContextVersion", versionFileName).trim();
            m_logger.log(Level.INFO, "version: " + version + " up_version: " + upToDateVersion);
            int upToDateVersionInt = Integer.valueOf(upToDateVersion);
            int versionInt = Integer.valueOf(version);
            return versionInt >= upToDateVersionInt;
        }
        catch (IOException e) {
            return true;
        }
    }

    protected PrintStream getPrintStream() {
        if (this.pStream != null) {
            return this.pStream;
        }
        return System.out;
    }
}

