/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.StringTokenizer;
import javax.naming.NamingSecurityException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.User;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;
import oracle.ldap.util.jndi.ConnectionUtil;

public class OUILdap {
    public static final int GET_REALMS_QUERY = 0;
    public static final int GET_OID_VERSION_QUERY = 1;
    public static final int VALIDATE_DN_QUERY = 2;
    public static final int IS_MEMBER_QUERY = 3;
    public static final int AUTHENTICATE_USER_QUERY = 4;
    public static final int GET_OID_DB_INFO_QUERY = 5;
    public static final int GET_SSO_DB_INFO_QUERY = 6;
    public static final int LDAP_DELETE_QUERY = 7;
    public static final int GET_OID_PORTS_QUERY = 8;
    public static final int UPDATE_SSO_DB_DN_QUERY = 9;
    public static final int IS_SUPERUSER_QUERY = 10;
    public static final int SUCCESS = 0;
    public static final int PARAMETER_ERROR = 1;
    public static final int CONNECTION_ERROR = 2;
    public static final int LDAP_OPERATION_ERROR = 3;
    public static final int IS_NOT_MEMBER_ERROR = 4;
    public static final int AUTHENTICATION_ERROR = 5;
    public static final int INVALID_DN_ERROR = 6;
    public static final int NOT_INFRA_DB_ERROR = 7;
    public static final int SSO_NOT_CONFIGURED_ERROR = 8;
    public static final int CANNOT_LOCATE_SSO_DB_ERROR = 9;
    public static final int IS_NOT_SUPERUSER = 10;
    public static final int INVALID_QUERY_NUMBER = -1;

    public static void main(String[] args) {
        String[] arrArr = new String[]{"sandal", "3060", "", ""};
        String[] v = OUILdap.runLdapQuery(1, arrArr);
        for (int i = 0; i < v.length; ++i) {
            System.out.println(v[i]);
        }
    }

    public static String[] runLdapQuery(int queryNum, String[] argsArr) {
        switch (queryNum) {
            case 0: {
                return OUILdap.getRealms(argsArr);
            }
            case 1: {
                return OUILdap.getOIDVersion(argsArr);
            }
            case 2: {
                return OUILdap.validateDN(argsArr);
            }
            case 3: {
                return OUILdap.isMember(argsArr);
            }
            case 4: {
                return OUILdap.authenticateUser(argsArr);
            }
            case 5: {
                return OUILdap.getOIDDBInfo(null, argsArr, true);
            }
            case 6: {
                return OUILdap.getSSODBInfo(null, argsArr);
            }
            case 7: {
                return OUILdap.ldapDelete(argsArr);
            }
            case 8: {
                return OUILdap.getOIDPorts(argsArr);
            }
            case 9: {
                return OUILdap.updateSSODBDN(argsArr);
            }
            case 10: {
                return OUILdap.isSuperUser(argsArr);
            }
        }
        String[] result = new String[]{Integer.toString(-1)};
        return result;
    }

    private static String[] isSuperUser(String[] argsArr) {
        String inDN;
        boolean isSuperUser = true;
        if (argsArr.length != 6) {
            String[] result = new String[]{Integer.toString(1)};
            return result;
        }
        DirContext ctx = OUILdap.getDirCtx(argsArr);
        if (ctx == null) {
            return OUILdap.error_Connection(argsArr);
        }
        PropertySetCollection psc = null;
        String normalizeSuperUserDN = null;
        try {
            psc = Util.ldapSearch(ctx, "", "objectclass=*", 0, new String[]{"orclsuname"});
            String suDN = (String)psc.getPropertySet(0).getProperty(0).getValue(0);
            normalizeSuperUserDN = Util.normalizeDN(suDN);
        }
        catch (UtilException ue) {
            if (ue.isNamingException() && ue.returnNamingException() instanceof NamingSecurityException) {
                isSuperUser = false;
            }
            String[] result = new String[]{Integer.toString(3), ue.toString()};
            return result;
        }
        catch (NullPointerException ne) {
            String[] result = new String[]{Integer.toString(3), "Cannot obtain super user DN information from Root DSE"};
            return result;
        }
        catch (Exception e) {
            isSuperUser = false;
        }
        if (isSuperUser && !(inDN = Util.normalizeDN(argsArr[5])).equalsIgnoreCase(normalizeSuperUserDN)) {
            isSuperUser = false;
        }
        String[] result = new String[]{isSuperUser ? Integer.toString(0) : Integer.toString(10)};
        return result;
    }

    private static String[] updateSSODBDN(String[] argsArr) {
        Object resultVec = null;
        if (argsArr.length != 7) {
            String[] result = new String[]{Integer.toString(1)};
            return result;
        }
        DirContext ctx = OUILdap.getDirCtx(argsArr);
        if (ctx == null) {
            return OUILdap.error_Connection(argsArr);
        }
        String dbHost = new StringTokenizer(argsArr[5].trim(), ".").nextToken();
        String dbSID = argsArr[6];
        try {
            PropertySetCollection psc = Util.ldapSearch(ctx, "cn=oraclecontext", "objectclass=orcldbserver", 1, new String[]{"orclsystemname", "orclsid"});
            boolean found = false;
            String ssoDbDN = null;
            for (int i = 0; i < psc.size(); ++i) {
                try {
                    PropertySet curPs = psc.getPropertySet(i);
                    String curDbHost = (String)curPs.getProperty("orclsystemname").getValue(0);
                    String curDbSID = (String)curPs.getProperty("orclsid").getValue(0);
                    if (!dbHost.equalsIgnoreCase(new StringTokenizer(curDbHost.trim(), ".").nextToken()) || !dbSID.equalsIgnoreCase(curDbSID)) continue;
                    ssoDbDN = curPs.getDN();
                    found = true;
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!found) {
                String[] result = new String[]{Integer.toString(9)};
                return result;
            }
            ModPropertySet mps = new ModPropertySet();
            mps.addProperty(7, "seeAlso", ssoDbDN);
            Util.ldapModify(ctx, "orclApplicationCommonName=ORASSO_SSOSERVER,cn=SSO,cn=Products,cn=OracleContext", mps);
            String[] result = new String[]{Integer.toString(0)};
            return result;
        }
        catch (UtilException e) {
            String[] result = new String[]{Integer.toString(3), e.returnNamingException().toString()};
            return result;
        }
        catch (Exception e) {
            String[] result = new String[]{Integer.toString(3), e.toString()};
            return result;
        }
    }

    private static String[] getOIDPorts(String[] argsArr) {
        if (argsArr.length != 5) {
            String[] result = new String[]{Integer.toString(1)};
            return result;
        }
        DirContext ctx = OUILdap.getDirCtx(argsArr);
        if (ctx == null) {
            return OUILdap.error_Connection(argsArr);
        }
        PropertySetCollection psc = null;
        try {
            String configsetDN = "cn=configset0,cn=osdldapd,cn=subconfigsubentry";
            psc = Util.ldapSearch(ctx, configsetDN, "objectclass=*", 0, new String[]{"orclnonsslport", "orclsslport", "orclsslenable"});
        }
        catch (UtilException ue) {
            String[] result = new String[]{Integer.toString(3), ue.returnNamingException().toString()};
            return result;
        }
        String[] result = new String[4];
        result[0] = Integer.toString(0);
        try {
            result[1] = (String)psc.getPropertySet(0).getProperty("orclnonsslport").getValue(0);
        }
        catch (NullPointerException ne) {
            result[1] = null;
        }
        try {
            result[2] = (String)psc.getPropertySet(0).getProperty("orclsslport").getValue(0);
        }
        catch (NullPointerException ne) {
            result[2] = null;
        }
        try {
            result[3] = (String)psc.getPropertySet(0).getProperty("orclsslenable").getValue(0);
        }
        catch (NullPointerException ne) {
            result[3] = null;
        }
        return result;
    }

    private static String[] ldapDelete(String[] argsArr) {
        if (argsArr.length != 6) {
            String[] result = new String[]{Integer.toString(1)};
            return result;
        }
        DirContext ctx = OUILdap.getDirCtx(argsArr);
        if (ctx == null) {
            return OUILdap.error_Connection(argsArr);
        }
        try {
            Util.ldapDelete(ctx, argsArr[5]);
            String[] result = new String[]{Integer.toString(0)};
            return result;
        }
        catch (UtilException ue) {
            String[] result = new String[]{Integer.toString(3), ue.returnNamingException().toString()};
            return result;
        }
    }

    private static String[] authenticateUser(String[] argsArr) {
        Object resultVec = null;
        boolean noRealm = true;
        String realmName = null;
        if (argsArr.length == 7) {
            noRealm = true;
        } else if (argsArr.length == 8) {
            noRealm = false;
            realmName = argsArr[7];
        } else {
            String[] result = new String[]{Integer.toString(1)};
            return result;
        }
        String userName = argsArr[5];
        String userPwd = argsArr[6];
        DirContext ctx = OUILdap.getDirCtx(argsArr);
        if (ctx == null) {
            return OUILdap.error_Connection(argsArr);
        }
        String normUserName = Util.normalizeDN(userName);
        if (normUserName != null) {
            DirContext ctx1 = OUILdap.getDirCtx(new String[]{argsArr[0], argsArr[1], userName, userPwd, argsArr[4]});
            if (ctx1 == null) {
                String[] result = new String[]{Integer.toString(5)};
                return result;
            }
            String[] result = new String[]{Integer.toString(0), normUserName};
            return result;
        }
        try {
            RootOracleContext roc = new RootOracleContext(ctx);
            Subscriber sub = noRealm ? roc.getSubscriber(ctx, Util.IDTYPE_DEFAULT, null, new String[]{"dn"}) : roc.getSubscriber(ctx, Util.IDTYPE_SIMPLE, realmName, new String[]{"dn"});
            User user = sub.getUser(ctx, Util.IDTYPE_SIMPLE, userName, new String[0]);
            DirContext ctx1 = OUILdap.getDirCtx(new String[]{argsArr[0], argsArr[1], user.getDN(ctx), userPwd, argsArr[4]});
            if (ctx1 == null) {
                String[] result = new String[]{Integer.toString(5)};
                return result;
            }
            String[] result = new String[]{Integer.toString(0), Util.normalizeDN(user.getDN(ctx))};
            return result;
        }
        catch (UtilException ue) {
            String[] result = new String[]{Integer.toString(3)};
            return result;
        }
    }

    private static String[] getRealms(String[] argsArr) {
        Object resultVec = null;
        if (argsArr.length != 5) {
            String[] result = new String[]{Integer.toString(1)};
            return result;
        }
        DirContext ctx = OUILdap.getDirCtx(argsArr);
        if (ctx == null) {
            return OUILdap.error_Connection(argsArr);
        }
        try {
            RootOracleContext roc = new RootOracleContext(ctx);
            Subscriber[] subs = roc.getAllSubscribers(ctx, new String[]{"dn"});
            if (subs == null || subs.length < 1) {
                subs = new Subscriber[]{};
            }
            String[] result = new String[subs.length + 1];
            result[0] = Integer.toString(0);
            for (int i = 0; i < subs.length; ++i) {
                result[i + 1] = subs[i].getDN(ctx);
            }
            return result;
        }
        catch (Exception e) {
            String[] result = new String[]{Integer.toString(3), e.toString()};
            return result;
        }
    }

    protected static String[] getSSODBInfo(DirContext inCtx, String[] argsArr) {
        DirContext ctx = inCtx;
        if (ctx == null) {
            if (argsArr.length != 5) {
                String[] result = new String[]{Integer.toString(1)};
                return result;
            }
            ctx = OUILdap.getDirCtx(argsArr);
            if (ctx == null) {
                return OUILdap.error_Connection(argsArr);
            }
        }
        PropertySetCollection psc = null;
        String dbDN = null;
        try {
            psc = Util.ldapSearch(ctx, "orclApplicationCommonName=ORASSO_SSOSERVER,cn=SSO,cn=Products,cn=OracleContext", "objectclass=*", 0, new String[]{"seeAlso"});
            dbDN = (String)psc.getPropertySet(0).getProperty("seeAlso").getValue(0);
        }
        catch (UtilException ue) {
        }
        catch (Exception e) {
            try {
                psc = Util.ldapSearch(ctx, "cn=oraclecontext", "objectclass=*", 0, new String[]{"orclversion"});
                String orclctxversion = (String)psc.getPropertySet(0).getProperty("orclversion").getValue(0);
                if (Integer.valueOf(orclctxversion) < 90400) {
                    String[] result = new String[]{Integer.toString(8)};
                    return result;
                }
            }
            catch (UtilException ne) {
                String[] result = new String[]{Integer.toString(3)};
                return result;
            }
        }
        if (dbDN != null) {
            try {
                String[] result;
                psc = Util.ldapSearch(ctx, dbDN, "objectclass=*", 0, new String[]{"orcldbglobalname", "orclnetdescstring"});
                result = new String[]{Integer.toString(0), (String)psc.getPropertySet(0).getProperty("orcldbglobalname").getValue(0), (String)psc.getPropertySet(0).getProperty("orclnetdescstring").getValue(0), dbDN, "orclReferenceName=" + result[1] + ",cn=IAS Infrastructure Databases,cn=IAS,cn=Products,cn=OracleContext"};
                return result;
            }
            catch (UtilException ue) {
                String[] result = new String[]{Integer.toString(3)};
                return result;
            }
        }
        return OUILdap.getOIDDBInfo(ctx, argsArr, false);
    }

    private static String[] getOIDDBInfo(DirContext inCtx, String[] argsArr, boolean infraDBCheck) {
        DirContext ctx = inCtx;
        if (ctx == null) {
            if (argsArr.length != 5) {
                String[] result = new String[]{Integer.toString(1)};
                return result;
            }
            ctx = OUILdap.getDirCtx(argsArr);
            if (ctx == null) {
                return OUILdap.error_Connection(argsArr);
            }
        }
        PropertySetCollection psc = null;
        String repDN = null;
        String dbDN = null;
        try {
            psc = Util.ldapSearch(ctx, "", "objectclass=*", 0, new String[]{"orclreplicaid"});
            repDN = "orclreplicaid=" + (String)psc.getPropertySet(0).getProperty("orclreplicaid").getValue(0) + ",cn=replication configuration";
        }
        catch (UtilException ue) {
            String[] result = new String[]{Integer.toString(3), "While retrieving orclreplicaid from Root DSE - " + ue.toString()};
            return result;
        }
        catch (Exception e) {
            String[] result = new String[]{Integer.toString(3), "Error when reading orclreplicaid value  - " + e.toString()};
            return result;
        }
        try {
            psc = Util.ldapSearch(ctx, repDN, "objectclass=*", 0, new String[]{"seeAlso"});
            dbDN = (String)psc.getPropertySet(0).getProperty("seeAlso").getValue(0);
        }
        catch (UtilException ue) {
            String[] result = new String[]{Integer.toString(3), "While retrieving orclreplicaid entry under cn=replication configuration - " + ue.toString()};
            return result;
        }
        catch (Exception e) {
            String[] result = new String[]{Integer.toString(3), "Error when reading seeAlso of replicaid entry - " + e.toString()};
            return result;
        }
        if (infraDBCheck) {
            try {
                boolean isIASDB = false;
                psc = Util.ldapSearch(ctx, "cn=IAS Infrastructure Databases,cn=ias,cn=products,cn=oraclecontext", "objectclass=*", 1, new String[]{"seeAlso"});
                for (int i = 0; i < psc.size(); ++i) {
                    String iASDBseeAlsoValue = (String)psc.getPropertySet(i).getProperty("seeAlso").getValue(0);
                    if (!Util.normalizeDN(dbDN).equals(Util.normalizeDN(iASDBseeAlsoValue))) continue;
                    isIASDB = true;
                    break;
                }
                if (!isIASDB) {
                    String[] result = new String[]{Integer.toString(7)};
                    return result;
                }
            }
            catch (UtilException ue) {
                String[] result = new String[]{Integer.toString(3), "While retrieving Reference Names under cn=replication configuration - " + ue.toString()};
                return result;
            }
            catch (Exception e) {
                String[] result = new String[]{Integer.toString(3), "Error when reading Reference Name entries " + e.toString()};
                return result;
            }
        }
        try {
            String[] result;
            psc = Util.ldapSearch(ctx, dbDN, "objectclass=*", 0, new String[]{"orcldbglobalname", "orclnetdescstring"});
            result = new String[]{Integer.toString(0), (String)psc.getPropertySet(0).getProperty("orcldbglobalname").getValue(0), (String)psc.getPropertySet(0).getProperty("orclnetdescstring").getValue(0), dbDN, "orclReferenceName=" + result[1] + ",cn=IAS Infrastructure Databases,cn=IAS,cn=Products,cn=OracleContext"};
            return result;
        }
        catch (UtilException ue) {
            String[] result = new String[]{Integer.toString(3), "While retrieving DB registration entry " + dbDN + " - " + ue.toString()};
            return result;
        }
        catch (Exception e) {
            String[] result = new String[]{Integer.toString(3), "Error when reading gdbname and netdescstring value from " + dbDN + "  - " + e.toString()};
            return result;
        }
    }

    private static String[] getOIDVersion(String[] argsArr) {
        Object resultVec = null;
        if (argsArr.length != 5) {
            String[] result = new String[]{Integer.toString(1)};
            return result;
        }
        DirContext ctx = OUILdap.getDirCtx(argsArr);
        if (ctx == null) {
            return OUILdap.error_Connection(argsArr);
        }
        try {
            PropertySetCollection psc = Util.ldapSearch(ctx, "", "objectclass=*", 0, new String[]{"orcldirectoryversion"});
            String[] result = new String[2];
            result[0] = Integer.toString(0);
            String version = (String)psc.getPropertySet(0).getProperty("orcldirectoryversion").getValue(0);
            result[1] = version.substring(version.indexOf("OID") + 3).trim();
            return result;
        }
        catch (UtilException ue) {
            String[] result = new String[]{Integer.toString(3)};
            return result;
        }
    }

    private static String[] isMember(String[] argsArr) {
        Object resultVec = null;
        if (argsArr.length != 8) {
            String[] result = new String[]{Integer.toString(1)};
            return result;
        }
        DirContext ctx = OUILdap.getDirCtx(argsArr);
        if (ctx == null) {
            return OUILdap.error_Connection(argsArr);
        }
        try {
            boolean ismember = Util.ldapCompare(ctx, argsArr[5], argsArr[6], argsArr[7]);
            String[] result = new String[]{ismember ? Integer.toString(0) : Integer.toString(4)};
            return result;
        }
        catch (UtilException ue) {
            String[] result = new String[]{Integer.toString(3)};
            return result;
        }
    }

    private static String[] validateDN(String[] argsArr) {
        Object resultVec = null;
        if (argsArr.length != 1) {
            String[] result = new String[]{Integer.toString(1)};
            return result;
        }
        String normDN = Util.normalizeDN(argsArr[0], new String[]{"ou", "dc", "o", "l", "c"});
        if (normDN == null || normDN.length() == 0) {
            String[] result = new String[]{Integer.toString(6)};
            return result;
        }
        String[] result = new String[]{Integer.toString(0), normDN};
        return result;
    }

    private static DirContext getDirCtx(String[] argsArr) {
        if (argsArr[4] == null || argsArr[4].length() != 0 && !argsArr[4].equals("oracle.ldap.util.jndi.LDAPSSLSocketFactoryImpl") && !argsArr[4].equals("oracle.ias.repqueries.InstallSSLSocketFactoryImpl")) {
            return null;
        }
        boolean useSSL = false;
        if (argsArr[4].length() != 0) {
            useSSL = true;
        }
        boolean established = false;
        InitialLdapContext ctx = null;
        if (!useSSL) {
            try {
                ctx = ConnectionUtil.getDefaultDirCtx(argsArr[0], argsArr[1], argsArr[2], argsArr[3]);
                established = true;
            }
            catch (Exception ne) {
                return null;
            }
        }
        try {
            ctx = ConnectionUtil.getSSLDirCtx(argsArr[0], argsArr[1], argsArr[2], argsArr[3], argsArr[4]);
        }
        catch (Exception ne) {
            return null;
        }
        return ctx;
    }

    private static String[] error_Connection(String[] argsArr) {
        String[] result = new String[]{Integer.toString(2), new String("Cannot establish connection with the following input:  host:" + argsArr[0] + " port:" + argsArr[1] + " bindDN:" + argsArr[2] + " bindPwd: *****" + " SSL Socket Factory:" + argsArr[4])};
        return result;
    }
}

