/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.Serializable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.UtilDebug;

public class ModPropertySet
implements Cloneable,
Serializable {
    private LDIFRecord lrec = new LDIFRecord();

    public ModPropertySet() {
        this(3);
    }

    public ModPropertySet(int chgType) {
        this.lrec.setChangeType(chgType);
    }

    public ModPropertySet(Attributes attrs, int chgType) {
        this(chgType);
        NamingEnumeration<? extends Attribute> enumAttributes = attrs.getAll();
        try {
            while (enumAttributes.hasMore()) {
                Attribute attr = enumAttributes.next();
                this.addProperty(chgType, attr);
            }
        }
        catch (NamingException ex) {
            String mesg = "NamingException encountered while creating a ModPropertySet inside ModPropertySet constructor : " + ex.getMessage();
            UtilDebug.log(1, "ModPropertySet : ModPropertySet(Attributes, int)", mesg);
        }
    }

    public final boolean isEmpty() {
        int lrecSize = this.lrec.size();
        return lrecSize == 0;
    }

    public final int size() {
        return this.lrec.size();
    }

    public final String[] getAttributeNames() {
        String[] attrArray = new String[this.lrec.size()];
        for (int i = 0; i < this.lrec.size(); ++i) {
            LDIFAttribute lAttr = this.lrec.getAttribute(i);
            attrArray[i] = lAttr.getName();
        }
        return attrArray;
    }

    public final LDIFRecord getModProperty() {
        return this.lrec;
    }

    public final String getModPropertyValue(String propName) {
        String retVal = null;
        LDIFAttribute ldAttr = this.lrec.getAttribute(propName);
        if (ldAttr != null) {
            retVal = ldAttr.getValue();
        }
        return retVal;
    }

    public final String[] getModPropertyValues(String propName) {
        String[] retVals = null;
        LDIFAttribute ldAttr = this.lrec.getAttribute(propName);
        if (ldAttr != null) {
            retVals = ldAttr.getStringValueArray();
        }
        return retVals;
    }

    public final int getChangeType() {
        return this.lrec.getChangeType();
    }

    public void addProperty(String attrName, String attrValue) {
        this.addProperty(5, attrName, attrValue);
    }

    public void addProperty(int chgType, String attrName, String attrValue) {
        LDIFAttribute lattr = new LDIFAttribute(attrName, attrValue);
        this.addProperty(chgType, lattr);
    }

    public void addProperty(int chgType, String attrName, String[] attrValueList) {
        LDIFAttribute lattr = new LDIFAttribute(attrName, attrValueList);
        this.addProperty(chgType, lattr);
    }

    public void addProperty(int chgType, String attrName, byte[] byteArray) {
        LDIFAttribute lattr = new LDIFAttribute(attrName, byteArray);
        this.addProperty(chgType, lattr);
    }

    public void addProperty(int chgType, LDIFAttribute lattr) {
        lattr.setChangeType(chgType);
        this.lrec.addAttribute(lattr);
    }

    public void addProperty(int chgType, Attribute attr) {
        try {
            if (attr.size() > 1) {
                NamingEnumeration<?> enumAttrs = attr.getAll();
                String[] val = new String[attr.size()];
                int i = 0;
                while (enumAttrs.hasMoreElements()) {
                    val[i++] = (String)enumAttrs.nextElement();
                }
                this.addProperty(chgType, attr.getID(), val);
            } else {
                Object val = attr.get();
                if (val instanceof String) {
                    this.addProperty(chgType, attr.getID(), (String)val);
                } else {
                    this.addProperty(chgType, attr.getID(), (byte[])val);
                }
            }
        }
        catch (Exception ex) {
            UtilDebug.log(1, "Exception in adding property ", ex.toString());
        }
    }

    public void deleteProperty(String attrName) {
        this.lrec.removeAttribute(attrName);
    }

    public synchronized Object clone() {
        ModPropertySet retMod = null;
        LDIFRecord lRec = null;
        lRec = this.getModProperty();
        retMod = new ModPropertySet(lRec.getChangeType());
        int sz = lRec.size();
        for (int i = 0; i < sz; ++i) {
            LDIFAttribute lattr = this.lrec.getAttribute(i);
            retMod.addProperty(lattr.getChangeType(), lattr);
        }
        return retMod;
    }
}

