/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import oracle.ldap.util.LogException;

public class Logger {
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int DEBUG = 4;
    public static final int ERROR = 8;
    public static final int ALL_TYPES = 15;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String ENCODING = "UTF8";
    private int m_flags = 0;
    private PrintWriter m_out = null;
    private PrintWriter m_consoleOut = null;
    private boolean m_xmlLog = false;
    private String m_fName = null;
    private boolean m_append = false;

    public Logger(String fileName, int severity, boolean append) throws LogException {
        this(fileName, severity, append, false);
    }

    public Logger(String fileName, int severity, boolean append, boolean xmlLog) throws LogException {
        File logFile = null;
        if (fileName == null) {
            throw new LogException("Invalid file name : " + fileName);
        }
        if (severity < 1 || severity > 15) {
            throw new LogException("Invalid severity ");
        }
        logFile = new File(fileName);
        if (logFile.isDirectory()) {
            throw new LogException("Specified file name is a directory : " + fileName);
        }
        this.m_append = append;
        String parentOutputDir = logFile.getAbsolutePath();
        File parentDir = new File(parentOutputDir = parentOutputDir.substring(0, parentOutputDir.lastIndexOf(File.separatorChar)));
        if (!parentDir.exists() || !parentDir.canWrite()) {
            throw new LogException("Cannot open the log file " + fileName + " for writing");
        }
        if (logFile.exists() && !this.m_append) {
            File backupFile = new File(fileName + ".bak");
            if (backupFile.exists()) {
                backupFile.delete();
            }
            logFile.renameTo(backupFile);
        }
        try {
            this.m_out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(logFile.getAbsolutePath(), this.m_append), ENCODING), true);
            this.m_consoleOut = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, ENCODING), true);
        }
        catch (IOException ioe) {
            throw new LogException(ioe);
        }
        this.m_flags = severity;
        this.m_xmlLog = xmlLog;
        if (this.m_xmlLog) {
            this.m_out.write("<LOG timestamp = \"");
            this.m_out.write(new Date(System.currentTimeMillis()).toString() + "\" >");
            this.m_out.write(NEW_LINE);
            if (this.m_out.checkError()) {
                System.out.println("I/O ERROR While writing to log file");
            }
        }
    }

    public Logger(OutputStream outS, int severity) throws LogException {
        this(outS, severity, false);
    }

    public Logger(OutputStream outS, int severity, boolean xmlLog) throws LogException {
        if (outS == null) {
            throw new LogException("NULL input value");
        }
        if (severity < 1 || severity > 15) {
            throw new LogException("Invalid severity ");
        }
        try {
            this.m_out = new PrintWriter((Writer)new OutputStreamWriter(outS, ENCODING), true);
            this.m_consoleOut = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, ENCODING), true);
        }
        catch (IOException ioe) {
            throw new LogException(ioe);
        }
        this.m_flags = severity;
        this.m_xmlLog = xmlLog;
        if (this.m_xmlLog) {
            this.m_out.write("<LOG timestamp = \"");
            this.m_out.write(new Date(System.currentTimeMillis()).toString() + "\" >");
            this.m_out.write(NEW_LINE);
            if (this.m_out.checkError()) {
                System.out.println("I/O ERROR While writing to log file");
            }
        }
    }

    public synchronized void setSeverity(int severity) {
        this.m_flags |= severity;
    }

    public synchronized void unsetSeverity(int severity) {
        this.m_flags = this.m_flags & severity ^ this.m_flags;
    }

    public void log(String message, int severity) {
        this.log(message, severity, false);
    }

    public void log(String message, int severity, boolean console) {
        if (console) {
            this.writeLog(this.m_consoleOut, message, severity);
        }
        this.writeLog(this.m_out, message, severity);
    }

    public void log(Exception ex, int severity) {
        this.log(ex, severity, false);
    }

    public void log(Exception ex, int severity, boolean console) {
        if (ex != null) {
            StringWriter strWriter = new StringWriter();
            PrintWriter prWrt = new PrintWriter(strWriter);
            ex.printStackTrace(prWrt);
            if (console) {
                this.writeLog(this.m_consoleOut, strWriter.getBuffer().toString(), severity);
            }
            this.writeLog(this.m_out, strWriter.getBuffer().toString(), severity);
            strWriter = null;
            prWrt = null;
        }
    }

    public void close() {
        if (this.m_out != null) {
            if (this.m_xmlLog) {
                this.m_out.write("</LOG>");
                this.m_out.write(NEW_LINE);
            }
            this.m_out.write(NEW_LINE);
            this.m_out.close();
            this.m_out = null;
        }
        if (this.m_consoleOut != null) {
            this.m_consoleOut = null;
        }
    }

    synchronized void writeLog(PrintWriter outBuf, String message, int severity) {
        int writeFlags = this.m_flags & severity;
        if (writeFlags == 1 || writeFlags == 2 || writeFlags == 4 || writeFlags == 8) {
            outBuf.write(this.getFormattedString(message, severity));
            outBuf.flush();
        }
    }

    private String getFormattedString(String message, int severity) {
        StringBuffer retStrBuf = new StringBuffer();
        String sevStr = this.getString(severity);
        if (this.m_xmlLog) {
            retStrBuf.append("  <").append(sevStr).append(" timestamp = \"").append(new Date(System.currentTimeMillis()).toString()).append("\">").append(NEW_LINE).append("    ").append(message).append(NEW_LINE).append("  </").append(sevStr).append(">").append(NEW_LINE);
        } else {
            retStrBuf.append(this.getString(severity)).append(": [").append(new Date(System.currentTimeMillis()).toString()).append("] ").append(message).append(NEW_LINE);
        }
        return retStrBuf.toString();
    }

    private String getString(int severity) {
        String retString = null;
        switch (severity) {
            case 1: {
                retString = "INFO";
                break;
            }
            case 2: {
                retString = "WARNING";
                break;
            }
            case 4: {
                retString = "DEBUG";
                break;
            }
            case 8: {
                retString = "ERROR";
                break;
            }
            default: {
                retString = "ERROR";
            }
        }
        return retString;
    }
}

