/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.LDIFAttribute;

public class LDIFRecord
implements Cloneable,
Serializable {
    private String dn = null;
    private Vector attrs = null;
    private int changeType = 1;
    private String newRdn = null;
    private boolean deleteOldRdn = false;
    private String newSuperior = null;
    private boolean expChgType = false;

    public LDIFRecord() {
        this(null);
    }

    public LDIFRecord(String dn) {
        this.dn = dn;
        this.attrs = new Vector();
    }

    public String getNewRdn() {
        return this.newRdn;
    }

    public String getNewSuperior() {
        return this.newSuperior;
    }

    public boolean getDeleteOldRdn() {
        return this.deleteOldRdn;
    }

    public void addAttribute(LDIFAttribute atr) {
        if (atr != null) {
            int index = this.attrs.lastIndexOf(atr);
            if (index == -1) {
                this.attrs.addElement(atr);
            } else {
                LDIFAttribute ldifAttr = (LDIFAttribute)this.attrs.elementAt(index);
                if (ldifAttr.getChangeType() == atr.getChangeType()) {
                    ldifAttr.addValue(atr.getStringValueArray());
                } else {
                    this.attrs.addElement(atr);
                }
            }
        }
    }

    public void add(String attrName, String attrVal, int chgType) {
        LDIFAttribute attr = null;
        if (null != attrName) {
            attr = new LDIFAttribute(attrName, attrVal);
            attr.setChangeType(chgType);
            this.addAttribute(attr);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public void setDN(String dn) {
        this.dn = dn;
    }

    void setExpChgType(boolean expChgType) {
        this.expChgType = expChgType;
    }

    boolean getExpChgType() {
        return this.expChgType;
    }

    public synchronized LDIFAttribute getAttribute(String attrName) {
        LDIFAttribute retAttrib = null;
        for (int i = 0; i < this.attrs.size() && !attrName.equalsIgnoreCase((retAttrib = (LDIFAttribute)this.attrs.elementAt(i)).getName()); ++i) {
            retAttrib = null;
        }
        return retAttrib;
    }

    public synchronized void removeAttribute(String attrName) {
        this.removeAttribute(attrName, false);
    }

    public synchronized void removeAttribute(String attrName, boolean baseName) {
        LDIFAttribute attr = null;
        int sz = this.attrs.size();
        int i = 0;
        String aName = null;
        while (i < sz) {
            attr = (LDIFAttribute)this.attrs.elementAt(i);
            String string = aName = baseName ? attr.getBaseName() : attr.getName();
            if (attrName.equalsIgnoreCase(aName)) {
                this.attrs.removeElement(attr);
                if (!baseName) break;
                --sz;
                continue;
            }
            ++i;
        }
    }

    public synchronized LDIFAttribute getAttribute(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid Index : " + index);
        }
        return (LDIFAttribute)this.attrs.elementAt(index);
    }

    public Enumeration getAll() {
        return this.attrs.elements();
    }

    public boolean contains(String attrName) {
        LDIFAttribute attribute = this.getAttribute(attrName);
        return attribute != null;
    }

    public synchronized Enumeration getIDs() {
        Vector<String> retVect = new Vector<String>();
        for (int i = 0; i < this.attrs.size(); ++i) {
            LDIFAttribute attribute = (LDIFAttribute)this.attrs.elementAt(i);
            retVect.addElement(attribute.getName());
        }
        return retVect.elements();
    }

    public int getChangeType() {
        return this.changeType;
    }

    public void setChangeType(int changeType) {
        this.changeType = changeType;
    }

    public int size() {
        return this.attrs.size();
    }

    public Object clone() {
        return null;
    }

    synchronized void setNewRdn(String newRdn, boolean deleteOldRdn, String newSuperior) {
        if (this.changeType == 4) {
            this.newRdn = newRdn;
            this.deleteOldRdn = deleteOldRdn;
            this.newSuperior = newSuperior;
        }
    }

    public synchronized Attributes getJNDIAttributes() {
        BasicAttributes retAttrs = null;
        LDIFAttribute ldifAttribute = null;
        int noAttrs = this.attrs.size();
        if (noAttrs != 0) {
            retAttrs = new BasicAttributes();
            for (int i = 0; i < noAttrs; ++i) {
                ldifAttribute = (LDIFAttribute)this.attrs.elementAt(i);
                retAttrs.put(ldifAttribute.getJNDIAttribute());
            }
        }
        return retAttrs;
    }

    public synchronized ModificationItem[] getJNDIModificationItems() {
        ModificationItem[] retModItems = null;
        LDIFAttribute ldifAttribute = null;
        int noAttrs = this.attrs.size();
        if (noAttrs != 0) {
            retModItems = new ModificationItem[noAttrs];
            for (int i = 0; i < noAttrs; ++i) {
                ldifAttribute = (LDIFAttribute)this.attrs.elementAt(i);
                retModItems[i] = ldifAttribute.getJNDIModificationItem();
            }
        }
        return retModItems;
    }

    String getRecordAsString(boolean asComment) {
        return this.getRecordAsString(asComment, true);
    }

    String getRecordAsString(boolean asComment, boolean wrap) {
        StringBuffer retBuf;
        block13: {
            Enumeration attributes;
            block14: {
                String cmt;
                String newLine;
                block12: {
                    attributes = this.getAll();
                    newLine = System.getProperty("line.separator");
                    retBuf = new StringBuffer();
                    String string = cmt = asComment ? "#" : "";
                    if (this.dn != null) {
                        retBuf.append(LDIFAttribute.getAttrAsLDIFStr("dn", this.getDN(), asComment, wrap)).append(newLine);
                    }
                    if (this.changeType == 2) {
                        retBuf.append(cmt + "changetype: delete").append(newLine);
                    } else if (this.changeType == 3) {
                        retBuf.append(cmt + "changetype: modify").append(newLine);
                    } else if (this.changeType == 4) {
                        retBuf.append(cmt + "changetype: moddn").append(newLine);
                    }
                    if (this.changeType != 1) break block12;
                    if (this.expChgType) {
                        retBuf.append(cmt + "changetype: add").append(newLine);
                    }
                    while (attributes.hasMoreElements()) {
                        LDIFAttribute attribute = (LDIFAttribute)attributes.nextElement();
                        int atrChangeType = attribute.getChangeType();
                        String atrName = attribute.getName();
                        Enumeration values = attribute.getByteValues();
                        while (values.hasMoreElements()) {
                            byte[] byteValues = (byte[])values.nextElement();
                            retBuf.append(LDIFAttribute.getAttrAsLDIFStr(atrName, byteValues, asComment, wrap, attribute.isBinary())).append(newLine);
                        }
                    }
                    break block13;
                }
                if (this.changeType != 4) break block14;
                retBuf.append(LDIFAttribute.getAttrAsLDIFStr("newrdn", this.newRdn, asComment, wrap)).append(newLine).append(cmt + "deleteoldrdn: ");
                if (this.deleteOldRdn) {
                    retBuf.append("1");
                } else {
                    retBuf.append("0");
                }
                retBuf.append(newLine);
                if (this.newSuperior == null) break block13;
                retBuf.append(LDIFAttribute.getAttrAsLDIFStr("newsuperior", this.newSuperior, asComment, wrap)).append(newLine);
                break block13;
            }
            while (attributes.hasMoreElements()) {
                retBuf.append(((LDIFAttribute)attributes.nextElement()).getAttributeAsString(asComment, wrap));
            }
        }
        return retBuf.toString();
    }

    public String toString() {
        return this.getRecordAsString(false);
    }
}

