/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import oracle.ldap.util.DirEntryReconcile;
import oracle.ldap.util.InvalidParameterException;
import oracle.ldap.util.LDIFReader;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.LDIFSubstitute;
import oracle.ldap.util.LDIFWriter;
import oracle.ldap.util.LogException;
import oracle.ldap.util.Logger;
import oracle.ldap.util.MigrationException;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;
import oracle.ldap.util.jndi.ConnectionUtil;
import oracle.ldap.util.nls.NlsMsg;
import oracle.ldap.util.param.CmdArgParser;
import oracle.ldap.util.param.FlagParameterDescriptor;
import oracle.ldap.util.param.Parameter;
import oracle.ldap.util.param.ParameterDescriptor;
import oracle.ldap.util.param.ParameterParser;

public class LDIFMigration {
    private static final String INPUT_FILE = "INPUT_FILE";
    private static final String OUTPUT_FILE = "OUTPUT_FILE";
    private static final String LOG_FILE = "LOG_FILE";
    private static final String HOST = "HOST";
    private static final String PORT = "PORT";
    private static final String DN = "DN";
    private static final String PASSWORD = "PASSWORD";
    private static final String SUBSCRIBER = "SUBSCRIBER";
    private static final String REALM = "REALM";
    private static final char PARAM_NAME_VALUE_DELIM = '=';
    private static final String DEL_OUTPUT_FILE_OPTION = "O";
    private static final String DIRECTORY_LOOKUP_OPTION = "LOOKUP";
    private static final String DIRECTORY_LOAD_OPTION = "LOAD";
    private static final String DIRECTORY_RECONCILE_OPTION = "RECONCILE";
    private static final String NOPROMPT = "NOPROMPT";
    private static final String VERBOSE = "V";
    private static String NEW_LINE = System.getProperty("line.separator");
    private LDIFReader m_ldifReader = null;
    private LDIFWriter m_ldifWriter = null;
    private Vector m_substitutionVector = null;
    private Logger m_logger = null;
    private String m_inputFileName = null;
    private String m_outputFileName = null;
    private String m_logFileName = null;
    private String m_hostName = null;
    private int m_port = 389;
    private String m_bindDn = null;
    private String m_password = null;
    private DirContext m_dirContext = null;
    private boolean m_doDelOutputFlag = false;
    private boolean m_doLookup = false;
    private boolean m_doLoad = false;
    private boolean m_doReconcile = false;
    private String m_reconcileValue = null;
    private boolean m_doVerbose = false;
    private boolean m_noPrompt = false;
    private static final String ROOT_ORACLE_CONTEST_DN = "cn=OracleContext";
    private int m_totalEntries = 0;
    private int m_failedEntries = 0;
    private String m_oHome = null;
    private String m_oInstance = null;
    private String m_subscriberName = null;

    private LDIFMigration() throws MigrationException {
    }

    public LDIFMigration(String inputFile, Vector subsVect, String outFile) throws MigrationException {
        this(new File(inputFile), subsVect, new File(outFile));
    }

    public LDIFMigration(File inpF, Vector subsVect, File outF) throws MigrationException {
        this.doValidate(inpF, subsVect, outF);
        this.m_inputFileName = inpF.getAbsolutePath();
        this.m_outputFileName = outF.getAbsolutePath();
        try {
            this.m_ldifReader = new LDIFReader(inpF, "UTF-8");
        }
        catch (IOException ioe) {
            String errMsg = ioe.getMessage();
            if (errMsg == null || errMsg.equals("")) {
                errMsg = NlsMsg.getMessage("MIGRATION_ERROR");
            }
            throw new MigrationException(errMsg);
        }
        try {
            this.m_ldifWriter = new LDIFWriter(outF);
        }
        catch (IOException ioe) {
            String errMsg = ioe.getMessage();
            if (errMsg == null || errMsg.equals("")) {
                errMsg = NlsMsg.getMessage("MIGRATION_ERROR");
            }
            throw new MigrationException(errMsg);
        }
    }

    public LDIFMigration(InputStream inpS, Vector subsVect, OutputStream outS) throws MigrationException {
        if (subsVect == null || subsVect.size() == 0) {
            String errMsg = NlsMsg.getMessage("NO_SUBSTITUTION_VARIABLES");
            throw new MigrationException(errMsg);
        }
        this.m_substitutionVector = subsVect;
        try {
            this.m_ldifReader = new LDIFReader(inpS, "UTF-8");
            this.m_inputFileName = "<Input Stream Object> " + inpS.toString();
        }
        catch (IOException ioe) {
            String errMsg = ioe.getMessage();
            if (errMsg == null || errMsg.equals("")) {
                errMsg = NlsMsg.getMessage("MIGRATION_ERROR");
            }
            throw new MigrationException(errMsg);
        }
        try {
            this.m_ldifWriter = new LDIFWriter(outS);
            this.m_outputFileName = "<Output Stream Object> " + inpS.toString();
        }
        catch (IOException ioe) {
            String errMsg = ioe.getMessage();
            if (errMsg == null || errMsg.equals("")) {
                errMsg = NlsMsg.getMessage("MIGRATION_ERROR");
            }
            throw new MigrationException(errMsg);
        }
    }

    private void initializeLog() throws MigrationException {
        if (this.m_oHome == null) {
            throw new MigrationException(NlsMsg.getMessage("ORACLE_HOME_NOT_SET"));
        }
        if (null == this.m_logFileName) {
            if (this.m_oInstance == null) {
                this.m_logFileName = "-";
            } else {
                this.m_logFileName = this.m_oInstance + File.separator + "diagnostics" + File.separator + "logs" + File.separator + "OID" + File.separator + "tools";
                Calendar cal = Calendar.getInstance();
                int month = cal.get(2) + 1;
                this.m_logFileName = this.m_logFileName + File.separator + "LDIFMig_" + cal.get(1) + "_" + (cal.get(2) + 1) + "_" + cal.get(5) + "_" + cal.get(11) + "_" + cal.get(12) + "_" + cal.get(13) + ".log";
            }
        }
        try {
            this.m_logger = this.m_logFileName.toLowerCase().endsWith("xml") ? new Logger(this.m_logFileName, 15, false, true) : (this.m_logFileName.equals("-") ? new Logger(System.out, 15, false) : new Logger(this.m_logFileName, 15, false));
        }
        catch (LogException le) {
            throw new MigrationException(le.getMessage());
        }
    }

    void setDirContext(DirContext dirCtx) {
        this.m_dirContext = dirCtx;
    }

    void setUserDN(String dn) {
        this.m_bindDn = dn;
    }

    private String getAttrValue(Property ps, String atr) throws IOException {
        int size = ps.size();
        int sel = 1;
        Object retVal = null;
        if (!this.m_noPrompt && size != 1) {
            BufferedReader bfr = new BufferedReader(new InputStreamReader(System.in));
            System.out.println();
            System.out.println("The subscriber `" + (null == this.m_subscriberName ? "Default" : this.m_subscriberName) + "' contains multiple values for the attribute `" + atr + "'");
            System.out.println();
            for (int i = 0; i < size; ++i) {
                System.out.println("   " + (i + 1) + ". " + ps.getValue(i));
            }
            System.out.println();
            do {
                System.out.print("Please choose a value for substitution [1-" + size + "] ");
                try {
                    sel = Integer.parseInt(bfr.readLine());
                }
                catch (NumberFormatException nfe) {
                    sel = 0;
                }
            } while (sel <= 0 || sel > size);
        }
        return (String)ps.getValue(sel - 1);
    }

    private void doValidate(File inFileObj, Vector subsVect, File outFileObj) throws MigrationException {
        String errMsg = null;
        if (!(subsVect != null && subsVect.size() != 0 || this.m_doLookup)) {
            errMsg = NlsMsg.getMessage("NO_SUBSTITUTION_VARIABLES");
            throw new MigrationException(errMsg);
        }
        this.m_substitutionVector = subsVect;
        if (inFileObj != null) {
            try {
                Util.validateFile(inFileObj, 21);
            }
            catch (InvalidParameterException ipe) {
                throw new MigrationException(ipe.getMessage());
            }
        }
        if (!this.m_doDelOutputFlag && outFileObj != null) {
            try {
                Util.validateFile(outFileObj, 34);
            }
            catch (InvalidParameterException ipe) {
                throw new MigrationException(ipe.getMessage());
            }
        }
    }

    private Subscriber processCmdLineInput(String[] args) throws MigrationException {
        Subscriber subscriber = null;
        RootOracleContext rootOrclContext = null;
        File inFileObj = null;
        File outFileObj = null;
        File logFileObj = null;
        Vector subsVect = null;
        Parameter param = null;
        boolean index = false;
        String errMsg = null;
        ParameterDescriptor[] params = new ParameterDescriptor[]{new ParameterDescriptor(INPUT_FILE, false, null, null), new ParameterDescriptor(OUTPUT_FILE, false, null, null), new ParameterDescriptor(LOG_FILE, false, null, null), new FlagParameterDescriptor(DIRECTORY_LOOKUP_OPTION, false, null), new FlagParameterDescriptor(DIRECTORY_LOAD_OPTION, false, null), new FlagParameterDescriptor(DEL_OUTPUT_FILE_OPTION, false, null), new FlagParameterDescriptor(VERBOSE, false, null), new FlagParameterDescriptor(NOPROMPT, false, null), new FlagParameterDescriptor(DIRECTORY_RECONCILE_OPTION, true, new String[]{"SAFE", "SAFE_EXTENDED", "NORMAL"}), new ParameterDescriptor(HOST, false, null, "localHost"), new ParameterDescriptor(DN, false, null, null), new ParameterDescriptor(PASSWORD, false, null, null), new ParameterDescriptor(SUBSCRIBER, false, null, null), new ParameterDescriptor(REALM, false, null, null), new ParameterDescriptor(PORT, false, null, "389")};
        CmdArgParser cmdArgParser = new CmdArgParser(params, args);
        try {
            ((ParameterParser)cmdArgParser).parse();
            subsVect = cmdArgParser.getUnParsedParams();
        }
        catch (ParameterException ipe) {
            errMsg = NlsMsg.getMessage("ERROR_WHILE_PARSING_PARAMETER") + NEW_LINE + ipe.getMessage();
            throw new MigrationException(errMsg);
        }
        this.m_oHome = System.getProperty("ORACLE_HOME");
        this.m_oInstance = System.getProperty("ORACLE_INSTANCE");
        param = cmdArgParser.get(INPUT_FILE);
        if (null == param) {
            errMsg = NlsMsg.getMessage("INPUT_PARAMETER_NOT_SPECIFIED");
            throw new MigrationException(errMsg);
        }
        this.m_inputFileName = param.getValue();
        param = cmdArgParser.get(OUTPUT_FILE);
        if (null == param) {
            errMsg = NlsMsg.getMessage("OUTPUT_PARAMETER_NOT_SPECIFIED");
            throw new MigrationException(errMsg);
        }
        this.m_outputFileName = param.getValue();
        param = cmdArgParser.get(LOG_FILE);
        if (null != param) {
            this.m_logFileName = param.getValue();
            logFileObj = new File(this.m_logFileName);
        }
        inFileObj = new File(this.m_inputFileName);
        outFileObj = new File(this.m_outputFileName);
        if (logFileObj != null && logFileObj.equals(outFileObj)) {
            throw new MigrationException(NlsMsg.getMessage("SAME_OUTPUT_AND_LOG_FILE"));
        }
        if (this.m_inputFileName.equals("-")) {
            inFileObj = null;
        } else if (logFileObj != null && logFileObj.equals(inFileObj)) {
            throw new MigrationException(NlsMsg.getMessage("SAME_INPUT_AND_LOG_FILE"));
        }
        if (this.m_outputFileName.equals("-")) {
            outFileObj = null;
        }
        if (outFileObj != null && outFileObj.equals(inFileObj)) {
            throw new MigrationException(NlsMsg.getMessage("SAME_INPUT_AND_OUTPUT_FILE"));
        }
        param = cmdArgParser.get(DEL_OUTPUT_FILE_OPTION);
        if (null != param) {
            this.m_doDelOutputFlag = true;
        }
        if (null != (param = cmdArgParser.get(VERBOSE))) {
            this.m_doVerbose = true;
        }
        if (null != (param = cmdArgParser.get(NOPROMPT))) {
            this.m_noPrompt = true;
        }
        if (null != (param = cmdArgParser.get(DIRECTORY_LOOKUP_OPTION))) {
            this.m_doLookup = true;
        }
        if (null != (param = cmdArgParser.get(DIRECTORY_LOAD_OPTION))) {
            this.m_doLoad = true;
        }
        if (null != (param = cmdArgParser.get(DIRECTORY_RECONCILE_OPTION))) {
            this.m_doReconcile = true;
            this.m_reconcileValue = param.getValue();
        }
        this.m_password = null;
        this.m_bindDn = null;
        this.m_hostName = null;
        this.m_subscriberName = null;
        param = cmdArgParser.get(HOST);
        this.m_hostName = param.getValue();
        param = cmdArgParser.get(PORT);
        try {
            this.m_port = Integer.parseInt(param.getValue());
            if (this.m_port < 1) {
                errMsg = NlsMsg.getMessage("INVALID_PORT_NUMBER_SPECIFIED");
                throw new MigrationException(errMsg);
            }
        }
        catch (NumberFormatException ne) {
            errMsg = NlsMsg.getMessage("INVALID_PORT_NUMBER_SPECIFIED");
            throw new MigrationException(errMsg);
        }
        param = cmdArgParser.get(DN);
        if (null == param) {
            if (this.m_doLookup || this.m_doLoad || this.m_doReconcile) {
                errMsg = NlsMsg.getMessage("BIND_DN_PARAMETER_NOT_SPECIFIED");
                throw new MigrationException(errMsg);
            }
        } else {
            this.m_bindDn = param.getValue();
        }
        this.m_password = null == (param = cmdArgParser.get(PASSWORD)) ? "" : param.getValue();
        param = cmdArgParser.get(SUBSCRIBER);
        if (null != param) {
            this.m_subscriberName = param.getValue();
        }
        if (null != (param = cmdArgParser.get(REALM))) {
            this.m_subscriberName = param.getValue();
        }
        this.doValidate(inFileObj, subsVect, outFileObj);
        try {
            if (inFileObj != null) {
                this.m_ldifReader = new LDIFReader(inFileObj, "UTF-8");
                this.m_inputFileName = inFileObj.getAbsolutePath();
            } else {
                this.m_ldifReader = new LDIFReader(System.in, "UTF-8");
                this.m_inputFileName = "stdin";
            }
        }
        catch (IOException ioe) {
            errMsg = ioe.getMessage();
            if (errMsg == null || errMsg.equals("")) {
                errMsg = NlsMsg.getMessage("MIGRATION_ERROR");
            }
            throw new MigrationException(errMsg);
        }
        try {
            if (outFileObj != null) {
                this.m_ldifWriter = new LDIFWriter(outFileObj);
                this.m_outputFileName = outFileObj.getAbsolutePath();
            } else {
                this.m_ldifWriter = new LDIFWriter(System.out);
                this.m_outputFileName = "stdout";
            }
        }
        catch (IOException ioe) {
            errMsg = ioe.getMessage();
            if (errMsg == null || errMsg.equals("")) {
                errMsg = NlsMsg.getMessage("MIGRATION_ERROR");
            }
            throw new MigrationException(errMsg);
        }
        if (this.m_doLookup || this.m_doLoad || this.m_doReconcile) {
            String portStr = this.m_port + "";
            try {
                this.m_dirContext = ConnectionUtil.getDefaultDirCtx(this.m_hostName, portStr, this.m_bindDn, this.m_password);
            }
            catch (NamingException ne) {
                errMsg = NlsMsg.getMessage("UNABLE_TO_CONNECT_TO_DIR") + NEW_LINE + ne.getMessage();
                throw new MigrationException(errMsg);
            }
            if (this.m_doLookup) {
                rootOrclContext = new RootOracleContext(this.m_dirContext, this.m_oHome);
                try {
                    subscriber = this.m_subscriberName == null ? rootOrclContext.getSubscriber(this.m_dirContext, Util.IDTYPE_DEFAULT, null, null) : rootOrclContext.getSubscriber(this.m_dirContext, Util.IDTYPE_SIMPLE, this.m_subscriberName, null);
                }
                catch (UtilException ue) {
                    errMsg = NlsMsg.getMessage("SUBSCRIBER_RETRIEVAL_ERROR") + NEW_LINE + ue.getMessage();
                    throw new MigrationException(errMsg);
                }
            }
        }
        this.initializeLog();
        return subscriber;
    }

    private ReconciledEntry reconcile(LDIFRecord ldifRecord, String reconcileType) throws NamingException, MigrationException {
        String dn = null;
        int ldifRecChgType = 0;
        Attributes attrs = null;
        LDIFRecord dirRecord = null;
        LDIFRecord recRecord = null;
        ReconciledEntry retReconciledEntry = new ReconciledEntry();
        retReconciledEntry.originalRecord = ldifRecord;
        dn = ldifRecord.getDN();
        ldifRecChgType = ldifRecord.getChangeType();
        try {
            attrs = this.m_dirContext.getAttributes(dn, new String[]{"*", "orclguid"});
            dirRecord = Util.getLDIFRecord(dn, attrs);
            retReconciledEntry.directoryRecord = dirRecord;
            retReconciledEntry.directoryRecordComment = "Entry present in the directory";
            retReconciledEntry.reconciledRecordComment = "After reconciliation of the entry";
            if (reconcileType.equals("SAFE")) {
                if (ldifRecChgType == 2) {
                    retReconciledEntry.reconciledRecordComment = "In safe mode deletion of a record is not possible";
                    recRecord = null;
                } else {
                    recRecord = DirEntryReconcile.getLdifDiffForSafe(ldifRecord, dirRecord, false);
                }
            } else if (reconcileType.equals("SAFE_EXTENDED")) {
                if (ldifRecChgType == 2) {
                    retReconciledEntry.reconciledRecordComment = "In safe extended mode deletion of a record is not possible";
                    recRecord = null;
                } else {
                    recRecord = DirEntryReconcile.getLdifDiffForSafe(ldifRecord, dirRecord, true);
                }
            } else if (reconcileType.equals("NORMAL")) {
                recRecord = DirEntryReconcile.getLdifDiffForNormal(ldifRecord, dirRecord);
            }
            if (null == recRecord && ldifRecChgType != 2) {
                retReconciledEntry.reconciledRecordComment = "There is no change to apply to this entry ~ " + dn;
            }
        }
        catch (NameNotFoundException nnfe) {
            retReconciledEntry.directoryRecordComment = "Entry not present in the directory ~ " + dn;
            if (ldifRecChgType == 1) {
                recRecord = ldifRecord;
                retReconciledEntry.reconciledRecordComment = "Entry will be added for the first time";
            }
            retReconciledEntry.reconciledRecordComment = "Ignoring the change to the entry";
        }
        retReconciledEntry.reconciledRecord = recRecord;
        return retReconciledEntry;
    }

    public int migrate() throws MigrationException, IOException {
        boolean firstRecord = false;
        StringBuffer logBuf = new StringBuffer();
        String errMsg = null;
        String[] bAttrs = new String[]{"jpegphoto", "usercertificate"};
        this.writeLog(NlsMsg.getMessage("MIGRATIONS_STARTS"), 1);
        this.writeLog(NlsMsg.getMessage(INPUT_FILE) + " : " + this.m_inputFileName, 1);
        this.writeLog(NlsMsg.getMessage(OUTPUT_FILE) + " : " + this.m_outputFileName, 1);
        logBuf.append(NlsMsg.getMessage("SUBSTITUTION_VARIABLES"));
        for (int inx = 0; inx < this.m_substitutionVector.size() - 1; inx += 2) {
            logBuf.append(NEW_LINE).append("    ").append(this.m_substitutionVector.elementAt(inx)).append(" : ").append(this.m_substitutionVector.elementAt(inx + 1));
        }
        errMsg = logBuf.toString();
        if (this.m_doVerbose) {
            System.out.println("input_file  : " + this.m_inputFileName);
            System.out.println("output_file : " + this.m_outputFileName);
            System.out.println(errMsg);
        }
        this.writeLog(errMsg, 1);
        logBuf = null;
        errMsg = null;
        this.m_ldifReader.setBinaryAttributes(bAttrs);
        while (true) {
            LDIFRecord ldifRecord = null;
            ldifRecord = this.m_ldifReader.nextRecord();
            if (ldifRecord == null) break;
            ++this.m_totalEntries;
            ldifRecord = LDIFSubstitute.substitute(ldifRecord, this.m_substitutionVector);
            if (this.m_doReconcile) {
                ReconciledEntry recObj = null;
                String dn = ldifRecord.getDN();
                if (firstRecord) {
                    this.m_ldifWriter.newLine();
                } else {
                    String ldifVersion = this.m_ldifReader.getVersion();
                    if (null != ldifVersion) {
                        this.m_ldifWriter.writeAttribute("version", ldifVersion);
                    }
                }
                this.m_ldifWriter.writeComment("Before reconciliation of the entry");
                this.m_ldifWriter.writeEntryAsComment(ldifRecord);
                firstRecord = true;
                if (ldifRecord.getChangeType() == 4) {
                    errMsg = "The changetype:modrdn / changetype:moddn not supported ~ " + dn;
                    this.m_ldifWriter.newLine();
                    this.m_ldifWriter.writeComment(errMsg);
                    this.writeLog(errMsg, 2);
                    continue;
                }
                try {
                    recObj = this.reconcile(ldifRecord, this.m_reconcileValue);
                }
                catch (NamingException ne) {
                    errMsg = ne.getMessage();
                    this.writeLog(errMsg, 8);
                    this.writeLog(ne, 8);
                    throw new MigrationException(errMsg);
                }
                this.m_ldifWriter.newLine();
                this.m_ldifWriter.writeComment(recObj.directoryRecordComment);
                this.writeLog(recObj.directoryRecordComment, 1);
                if (null != recObj.directoryRecord) {
                    this.m_ldifWriter.writeEntryAsComment(recObj.directoryRecord);
                }
                this.m_ldifWriter.newLine();
                this.m_ldifWriter.writeComment(recObj.reconciledRecordComment);
                this.writeLog(recObj.reconciledRecordComment, 1);
                ldifRecord = recObj.reconciledRecord;
                if (null != recObj.reconciledRecord) {
                    this.m_ldifWriter.writeEntry(recObj.reconciledRecord);
                }
            } else {
                if (firstRecord) {
                    this.m_ldifWriter.newLine();
                } else {
                    String ldifVersion = this.m_ldifReader.getVersion();
                    if (null != ldifVersion) {
                        this.m_ldifWriter.writeAttribute("version", ldifVersion);
                    }
                }
                this.m_ldifWriter.writeEntry(ldifRecord);
                firstRecord = true;
            }
            if (this.m_doLoad && ldifRecord != null) {
                try {
                    Util.performLDAPOperation(this.m_dirContext, ldifRecord);
                    this.writeLog("Applied change " + ldifRecord.getDN(), 1);
                }
                catch (NamingException ne) {
                    this.writeLog("Failed to apply change " + ldifRecord.getDN() + " ~ " + ne.getMessage(), 8);
                    ++this.m_failedEntries;
                }
            }
            if (!this.m_doVerbose) continue;
            System.out.print("# Processed Entries : " + this.m_totalEntries + " # Success : " + (this.m_totalEntries - this.m_failedEntries) + " # Failure : " + this.m_failedEntries + " \r");
        }
        if (this.m_doVerbose) {
            System.out.println();
        }
        if (this.m_failedEntries > 0) {
            this.writeLog(NlsMsg.getMessage("MIGRATION_FAILED"), 1);
        } else {
            this.writeLog(NlsMsg.getMessage("MIGRATION_COMPLETE"), 1);
        }
        return this.m_totalEntries - this.m_failedEntries;
    }

    public int migrate(Subscriber subscriber) throws MigrationException, IOException {
        String[] attrList = new String[]{"orclCommonUserSearchBase", "orclCommonGroupSearchBase", "orclCommonNickNameAttribute", "orclCommonNamingAttribute"};
        String subscriberDN = null;
        String userContainerDN = null;
        String groupContainerDN = null;
        String nickNameAttribute = null;
        String namingAttribute = null;
        String subscriberOracleContextDN = null;
        PropertySetCollection psCollect = null;
        try {
            subscriberDN = subscriber.getDN(this.m_dirContext);
            subscriberOracleContextDN = "cn=OracleContext," + subscriberDN;
            psCollect = subscriber.getExtendedProperties(this.m_dirContext, Subscriber.EXTPROPTYPE_COMMON, attrList, null);
            if (!psCollect.isEmpty()) {
                PropertySet pSet = psCollect.getPropertySet(0);
                Property property = pSet.getProperty(attrList[0]);
                if (property != null) {
                    userContainerDN = this.getAttrValue(property, attrList[0]);
                }
                if ((property = pSet.getProperty(attrList[1])) != null) {
                    groupContainerDN = this.getAttrValue(property, attrList[1]);
                }
                if ((property = pSet.getProperty("orclCommonNickNameAttribute")) != null) {
                    nickNameAttribute = (String)property.getValue(0);
                }
                if ((property = pSet.getProperty("orclCommonNamingAttribute")) != null) {
                    namingAttribute = (String)property.getValue(0);
                }
            }
        }
        catch (UtilException ue) {
            String errMsg = ue.getMessage();
            this.writeLog(errMsg, 8);
            this.writeLog(ue, 8);
            throw new MigrationException(errMsg);
        }
        String errMsg = "";
        if (subscriberDN == null) {
            errMsg = errMsg + " s_SubscriberDN,";
        }
        if (userContainerDN == null) {
            errMsg = errMsg + "s_UserContainerDN,";
        }
        if (groupContainerDN == null) {
            errMsg = errMsg + "s_GroupContainerDN,";
        }
        if (nickNameAttribute == null) {
            errMsg = errMsg + "s_UserNicknameAttribute,";
        }
        if (errMsg.length() > 0) {
            errMsg = NlsMsg.getMessage("SUBSTITUTION_VARIALBE_NOT_FOUND") + " [" + errMsg.substring(0, errMsg.length() - 1) + " ]";
            this.writeLog(errMsg, 1);
            throw new MigrationException(errMsg);
        }
        if (!this.m_substitutionVector.contains("s_SubscriberDN")) {
            this.m_substitutionVector.addElement("s_SubscriberDN");
            this.m_substitutionVector.addElement(subscriberDN);
        }
        if (!this.m_substitutionVector.contains("s_UserContainerDN")) {
            this.m_substitutionVector.addElement("s_UserContainerDN");
            this.m_substitutionVector.addElement(userContainerDN);
        }
        if (!this.m_substitutionVector.contains("s_GroupContainerDN")) {
            this.m_substitutionVector.addElement("s_GroupContainerDN");
            this.m_substitutionVector.addElement(groupContainerDN);
        }
        if (!this.m_substitutionVector.contains("s_SubscriberOracleContextDN")) {
            this.m_substitutionVector.addElement("s_SubscriberOracleContextDN");
            this.m_substitutionVector.addElement(subscriberOracleContextDN);
        }
        if (!this.m_substitutionVector.contains("s_UserNicknameAttribute")) {
            this.m_substitutionVector.addElement("s_UserNicknameAttribute");
            this.m_substitutionVector.addElement(nickNameAttribute);
        }
        if (!this.m_substitutionVector.contains("s_UserNamingAttribute") && null != namingAttribute) {
            this.m_substitutionVector.addElement("s_UserNamingAttribute");
            this.m_substitutionVector.addElement(namingAttribute);
        }
        if (!this.m_substitutionVector.contains("s_RootOracleContextDN")) {
            this.m_substitutionVector.addElement("s_RootOracleContextDN");
            this.m_substitutionVector.addElement(ROOT_ORACLE_CONTEST_DN);
        }
        if (!this.m_substitutionVector.contains("s_CurrentUserDN")) {
            this.m_substitutionVector.addElement("s_CurrentUserDN");
            this.m_substitutionVector.addElement(this.m_bindDn);
        }
        return this.migrate();
    }

    public void cleanup() throws MigrationException {
        try {
            File outFile;
            if (this.m_ldifWriter != null) {
                this.m_ldifWriter.close();
                this.m_ldifWriter = null;
            }
            if (this.m_ldifReader != null) {
                this.m_ldifReader.close();
                this.m_ldifReader = null;
            }
            if (this.m_logger != null) {
                this.m_logger.close();
                this.m_logger = null;
            }
            if (this.m_outputFileName != null && (outFile = new File(this.m_outputFileName)).exists() && outFile.length() == 0L) {
                outFile.delete();
            }
        }
        catch (IOException ioe) {
            throw new MigrationException(ioe.getMessage());
        }
    }

    private void writeLog(String mesg, int severity) {
        if (mesg != null && this.m_logger != null) {
            this.m_logger.log(mesg, severity);
        }
    }

    private void writeLog(Exception ex, int severity) {
        if (ex != null && this.m_logger != null) {
            this.m_logger.log(ex, severity);
        }
    }

    private static void usage() {
        StringBuffer usgStr = new StringBuffer();
        String newLine = System.getProperty("line.separator");
        usgStr.append(newLine).append("usage: ldifmigrator ").append("[options]").append(" {ParameterName=Value ....}").append(" {s_SubVar=val ... }").append(newLine).append("where:").append(newLine).append("   Required parameters :").append(newLine).append("      input_file=<inputfile>").append(newLine).append("      output_file=<outputfile>").append(newLine).append("   Optional parameters :").append(newLine).append("      host=<hostName> [localhost]").append(newLine).append("      port=<portNumber> [389]").append(newLine).append("      dn=<bindDn> Required when -lookup ").append("or -load or -reconcile is specifed").append(newLine).append("      password=<password of the bindDn>").append(newLine).append("      subscriber/realm=<subscriberName> if not specified").append(" default subscriber/realm is assumed").append(newLine).append("      log_file=<logfile>").append(newLine).append(newLine).append("options:").append(newLine).append("      -lookup    lookup the directory for the standard ").append("list of substitution variables").append(newLine).append("      -load      load the entries to the directory").append(newLine).append("      -reconcile {SAFE | SAFE_EXTENDED | NORMAL} reconcile ").append("with the entry in the directory").append(newLine).append("      -noprompt  Do not prompt when the attribute contains ").append("multiple values").append(newLine).append("      -help      prints this message").append(newLine).append(newLine).append("Example:").append(newLine).append("   ldifmigrator input_file=PortalUser.dat ").append("output_file=PortalUser.ldif \\").append(newLine).append("   -lookup dn=\"cn=orcladmin\" password=welcome ").append("s_subscriberDomain=\"dc=oracle,dc=com\"").append(newLine).append(newLine).append("   ldifmigrator input_file=PortalUser.dat ").append("output_file= - log_file=PortalUser.log \\").append(newLine).append("   -lookup dn=\"cn=orcladmin\" password=welcome -reconcile ").append("SAFE \\").append(newLine).append("   s_subscriberDomain=\"dc=oracle,dc=com\"").append(newLine).append(newLine).append("   ldifmigrator input_file= - output_file=PortUser.ldif").append("log_file=PortalUser.log\\").append(newLine).append("   -lookup -load dn=\"cn=orcladmin\" password=welcome ").append("-reconcile NORMAL \\").append(newLine).append("   s_subscriberDomain=\"dc=oracle,dc=com\"");
        System.out.println(usgStr.toString());
    }

    public static void main(String[] args) {
        LDIFMigration ldifMig = null;
        Subscriber subscriber = null;
        if (0 == args.length) {
            System.out.println(NlsMsg.getMessage("NOT_ALL_PARAMETERS_ARE_PROVIDED"));
            return;
        }
        for (int ix = 0; ix < args.length; ++ix) {
            if (!args[ix].equalsIgnoreCase("-help") && !args[ix].equals("?") && !args[ix].equalsIgnoreCase("help") && !args[ix].equalsIgnoreCase("-h")) continue;
            LDIFMigration.usage();
            return;
        }
        try {
            ldifMig = new LDIFMigration();
            subscriber = ldifMig.processCmdLineInput(args);
        }
        catch (MigrationException me) {
            System.out.println(me.getMessage());
            try {
                if (ldifMig != null) {
                    ldifMig.cleanup();
                }
            }
            catch (MigrationException mee) {
                System.out.println(mee.getMessage());
                System.exit(1);
            }
            System.exit(1);
        }
        try {
            if (subscriber != null) {
                ldifMig.migrate(subscriber);
            } else {
                ldifMig.migrate();
            }
            if (ldifMig.m_failedEntries > 0) {
                System.out.println(NlsMsg.getMessage("MIGRATION_FAILED"));
            } else {
                System.out.println(NlsMsg.getMessage("MIGRATION_COMPLETE"));
            }
        }
        catch (MigrationException me) {
            System.out.println(NlsMsg.getMessage("MIGRATION_ERROR"));
            System.out.println(me.getMessage());
            try {
                ldifMig.cleanup();
            }
            catch (MigrationException mee) {
                System.out.println(mee.getMessage());
                System.exit(1);
            }
            System.exit(1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            ldifMig.cleanup();
        }
        catch (MigrationException mee) {
            System.out.println(mee.getMessage());
            System.exit(1);
        }
    }

    private class ReconciledEntry {
        private LDIFRecord originalRecord = null;
        private String directoryRecordComment = null;
        private LDIFRecord directoryRecord = null;
        private String reconciledRecordComment = null;
        private LDIFRecord reconciledRecord = null;

        private ReconciledEntry() {
        }
    }
}

