/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import oracle.ldap.util.Base64;

public class LDIFAttribute
implements Cloneable,
Serializable {
    private static Logger m_logger = Logger.getLogger("oracle.ldap.util");
    private String name = null;
    private Vector values = null;
    private int changeType = 5;
    private static final String ENCODING = "UTF8";
    private boolean isBinary = false;
    private static final String NON_PRINTABLE_ATTRS = "oracle.idm.util.npattrs";

    public LDIFAttribute(String attrName) {
        this(attrName, false);
    }

    public LDIFAttribute(String attrName, boolean isBinary) {
        this.name = attrName;
        this.values = new Vector();
        this.isBinary = isBinary;
    }

    public LDIFAttribute(LDIFAttribute ldapAttribute) {
        this(ldapAttribute.name, ldapAttribute.isBinary);
        int sz = ldapAttribute.values.size();
        for (int i = 0; i < sz; ++i) {
            byte[] valBuf = (byte[])ldapAttribute.values.elementAt(i);
            byte[] newValBuf = new byte[valBuf.length];
            System.arraycopy(valBuf, 0, newValBuf, 0, valBuf.length);
            this.values.addElement(newValBuf);
        }
    }

    public LDIFAttribute(String attrName, byte[] attrBytes, boolean isBinary) {
        this(attrName, isBinary);
        this.addValue(attrBytes);
    }

    public LDIFAttribute(String attrName, byte[] attrBytes) {
        this(attrName, attrBytes, false);
    }

    public LDIFAttribute(String attrName, String attrString) {
        this(attrName);
        this.addValue(attrString);
    }

    public LDIFAttribute(String attrName, String[] attrStrings) {
        this(attrName);
        this.setValues(attrStrings);
    }

    private static byte[] string2bytes(String attrStr) {
        byte[] retBytes = null;
        try {
            retBytes = attrStr.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            m_logger.log(Level.SEVERE, "Exception in string2bytes()", uee);
        }
        return retBytes;
    }

    private static String bytes2string(byte[] bytes) {
        String retStr = null;
        try {
            retStr = new String(bytes, ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            m_logger.log(Level.SEVERE, "Exception in bytes2string()", uee);
        }
        return retStr;
    }

    public synchronized void addValue(String attrString) {
        if (attrString != null) {
            this.values.addElement(LDIFAttribute.string2bytes(attrString));
        }
    }

    public synchronized void addValue(byte[] attrBytes) {
        if (attrBytes != null) {
            byte[] newValBuf = new byte[attrBytes.length];
            System.arraycopy(attrBytes, 0, newValBuf, 0, attrBytes.length);
            this.values.addElement(newValBuf);
        }
    }

    public synchronized void addValue(String[] attrValues) {
        if (attrValues != null) {
            for (int i = 0; i < attrValues.length; ++i) {
                this.addValue(attrValues[i]);
            }
        }
    }

    public Enumeration getByteValues() {
        return this.values.elements();
    }

    public Enumeration getStringValues() {
        return new AttributeValueEnumerator(this.values, false);
    }

    public synchronized Enumeration getValsAsObject() {
        return new AttributeValueEnumerator(this.values, this.isBinary());
    }

    public synchronized byte[][] getByteValueArray() {
        Object retVals = null;
        if (this.values.size() != 0) {
            retVals = new byte[this.values.size()][];
            for (int i = 0; i < this.values.size(); ++i) {
                byte[] ar = (byte[])this.values.elementAt(i);
                retVals[i] = new byte[ar.length];
                System.arraycopy(ar, 0, retVals[i], 0, ar.length);
            }
        }
        return retVals;
    }

    public synchronized String[] getStringValueArray() {
        String[] retVals = null;
        if (this.values.size() != 0) {
            retVals = new String[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                if (this.values.elementAt(i) == null) continue;
                retVals[i] = LDIFAttribute.bytes2string((byte[])this.values.elementAt(i));
            }
        }
        return retVals;
    }

    public synchronized void setValues(String[] attrValues) {
        if (attrValues != null) {
            this.values.removeAllElements();
            for (int i = 0; i < attrValues.length; ++i) {
                this.values.addElement(LDIFAttribute.string2bytes(attrValues[i]));
            }
        }
    }

    public String getLangSubtype() {
        String[] subTypes = this.getSubtypes();
        String retString = null;
        if (subTypes != null) {
            for (int i = 0; i < subTypes.length; ++i) {
                String str = subTypes[i].trim();
                if (str.length() < 5 || !str.substring(0, 5).equalsIgnoreCase("lang-")) continue;
                retString = str;
                break;
            }
        }
        return retString;
    }

    public static String getBaseName(String attrName) {
        String retStr = attrName;
        int index = attrName.indexOf(";");
        if (index != -1) {
            retStr = attrName.substring(0, index);
        }
        return retStr;
    }

    public String getBaseName() {
        return LDIFAttribute.getBaseName(this.name);
    }

    public String getName() {
        return this.name;
    }

    public static String[] getSubtypes(String attrName) {
        StringTokenizer st = new StringTokenizer(attrName, ";");
        String[] retVals = null;
        if (st.hasMoreElements()) {
            st.nextElement();
            retVals = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreElements()) {
                retVals[i] = (String)st.nextElement();
                ++i;
            }
        }
        return retVals;
    }

    public String[] getSubtypes() {
        return LDIFAttribute.getSubtypes(this.name);
    }

    public boolean hasSubtype(String subtype) {
        String[] subtypes = this.getSubtypes();
        for (int i = 0; i < subtypes.length; ++i) {
            if (!subtype.equalsIgnoreCase(subtypes[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasSubtypes(String[] subtypes) {
        for (int i = 0; i < subtypes.length; ++i) {
            if (this.hasSubtype(subtypes[i])) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean removeValue(String attrString) {
        boolean retBool = false;
        if (attrString != null && this.values.size() != 0) {
            for (int i = 0; i < this.values.size(); ++i) {
                String attrVal = LDIFAttribute.bytes2string((byte[])this.values.elementAt(i));
                if (!attrVal.equalsIgnoreCase(attrString)) continue;
                this.values.removeElementAt(i);
                retBool = true;
                break;
            }
        }
        return retBool;
    }

    public synchronized void removeValue(byte[] attrBytes) {
        if (attrBytes != null && this.values.size() != 0) {
            for (int i = 0; i < this.values.size(); ++i) {
                byte[] bytes = (byte[])this.values.elementAt(i);
                if (!LDIFAttribute.isEqual(bytes, attrBytes)) continue;
                this.values.removeElementAt(i);
                break;
            }
        }
    }

    public synchronized void removeAll() {
        this.values.removeAllElements();
    }

    public int size() {
        return this.values.size();
    }

    public int getChangeType() {
        return this.changeType;
    }

    public void setChangeType(int changeType) {
        this.changeType = changeType;
    }

    public String getValue() {
        String retVal = null;
        if (this.values.size() > 0) {
            retVal = LDIFAttribute.bytes2string((byte[])this.values.elementAt(0));
        }
        return retVal;
    }

    public synchronized boolean contains(String attrString) {
        if (attrString == null || this.values.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            String attrVal = LDIFAttribute.bytes2string((byte[])this.values.elementAt(i));
            if (!attrVal.equalsIgnoreCase(attrString)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean contains(byte[] attrBytes) {
        if (attrBytes == null || this.values.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            byte[] byteArr = (byte[])this.values.elementAt(i);
            if (!LDIFAttribute.isEqual(byteArr, attrBytes)) continue;
            return true;
        }
        return false;
    }

    public Attribute getJNDIAttribute() {
        BasicAttribute retAttr = new BasicAttribute(this.name, true);
        for (int ix = 0; ix < this.values.size(); ++ix) {
            retAttr.add(this.values.elementAt(ix));
        }
        return retAttr;
    }

    public ModificationItem getJNDIModificationItem() {
        Attribute attr = this.getJNDIAttribute();
        int modOp = 1;
        if (this.getChangeType() == 7) {
            modOp = 2;
        } else if (this.getChangeType() == 6) {
            modOp = 3;
        }
        ModificationItem retModItem = new ModificationItem(modOp, attr);
        return retModItem;
    }

    private static boolean isEqual(byte[] byteArr1, byte[] byteArr2) {
        if (byteArr1.length != byteArr2.length) {
            return false;
        }
        for (int i = 0; i < byteArr2.length; ++i) {
            if (byteArr2[i] == byteArr1[i]) continue;
            return false;
        }
        return true;
    }

    public String getAttributeAsString(boolean asComment) {
        return this.getAttributeAsString(asComment, true);
    }

    public String getAttributeAsString(boolean asComment, boolean wrap) {
        StringBuffer retBuf = new StringBuffer();
        String newLine = System.getProperty("line.separator");
        if (this.changeType == 5) {
            retBuf.append(LDIFAttribute.getAttrAsLDIFStr("add", this.name, asComment, wrap)).append(newLine);
        } else if (this.changeType == 6) {
            retBuf.append(LDIFAttribute.getAttrAsLDIFStr("delete", this.name, asComment, wrap)).append(newLine);
        } else if (this.changeType == 7) {
            retBuf.append(LDIFAttribute.getAttrAsLDIFStr("replace", this.name, asComment, wrap)).append(newLine);
        }
        for (int i = 0; i < this.values.size(); ++i) {
            byte[] value = (byte[])this.values.elementAt(i);
            retBuf.append(LDIFAttribute.getAttrAsLDIFStr(this.name, value, asComment, wrap, this.isBinary)).append(newLine);
        }
        if (asComment) {
            retBuf.append("#");
        }
        retBuf.append("-").append(newLine);
        return retBuf.toString();
    }

    static String getAttrAsLDIFStr(String type, String val, boolean asComment, boolean wrap) {
        return LDIFAttribute.getAttrAsLDIFStr(type, LDIFAttribute.string2bytes(val), asComment, wrap, false);
    }

    static String getAttrAsLDIFStr(String type, byte[] val, boolean asComment, boolean wrap, boolean isBinary) {
        StringBuffer sbuf = new StringBuffer();
        String newLine = System.getProperty("line.separator");
        String cmt = "#";
        int maxLineLen = 77;
        int startIndex = 0;
        int endIndex = 0;
        int len = 0;
        boolean firstLine = true;
        String newStr = LDIFAttribute.bytes2string(val);
        String tmpStr = ": ";
        if (LDIFAttribute.isAttrNonPrintable(type)) {
            newStr = "*****";
        }
        if (isBinary) {
            byte[] encodedBytes = Base64.encode(val);
            tmpStr = ":: " + new String(encodedBytes);
        } else {
            tmpStr = tmpStr + newStr;
            if (newStr.startsWith(" ") || newStr.startsWith(":")) {
                tmpStr = ":: " + Base64.encode(newStr);
            } else {
                for (int i = 0; i < val.length; ++i) {
                    if (LDIFAttribute.isAscii(val[i]) && val[i] >= 32) continue;
                    tmpStr = ":: " + new String(Base64.encode(val));
                    break;
                }
            }
        }
        tmpStr = type + tmpStr;
        len = tmpStr.length();
        endIndex = Math.min(len, maxLineLen);
        if (wrap) {
            while (true) {
                if (asComment && firstLine) {
                    sbuf.append(cmt);
                    if (endIndex == maxLineLen) {
                        --endIndex;
                    }
                    firstLine = false;
                }
                sbuf.append(tmpStr.substring(startIndex, endIndex));
                startIndex = endIndex;
                endIndex = Math.min(len - endIndex, maxLineLen);
                if (endIndex == 0) break;
                sbuf.append(newLine);
                if (asComment) {
                    sbuf.append(cmt).append(' ');
                    if (endIndex == maxLineLen) {
                        endIndex -= 2;
                    }
                } else {
                    sbuf.append(' ');
                    if (endIndex == maxLineLen) {
                        --endIndex;
                    }
                }
                endIndex += startIndex;
            }
            tmpStr = sbuf.toString();
        }
        return tmpStr;
    }

    private static boolean isAttrNonPrintable(String type) {
        boolean retVal = false;
        String stype = type.toLowerCase();
        String lst = System.getProperty(NON_PRINTABLE_ATTRS);
        if (lst != null) {
            String[] attrs = lst.split("\\s");
            for (int i = 0; !retVal && attrs != null && i < attrs.length; ++i) {
                retVal = attrs[i].equalsIgnoreCase(type);
            }
        }
        return retVal;
    }

    private static boolean isAscii(byte b) {
        return 0 == (b & 0xFFFFFF80);
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public boolean setBinary(boolean binary) {
        boolean prevVal = this.isBinary;
        this.isBinary = binary;
        return this.isBinary;
    }

    public String toString() {
        return this.getAttributeAsString(false);
    }

    public boolean equals(Object ldifAttr) {
        boolean retVal = false;
        if (ldifAttr instanceof LDIFAttribute) {
            retVal = this.name.equalsIgnoreCase(((LDIFAttribute)ldifAttr).name);
        }
        return retVal;
    }

    public synchronized Object clone() {
        LDIFAttribute retAttr = null;
        Enumeration values = null;
        try {
            retAttr = (LDIFAttribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        retAttr.name = new String(this.name);
        retAttr.values = new Vector();
        retAttr.isBinary = this.isBinary;
        values = this.getByteValues();
        while (values.hasMoreElements()) {
            byte[] byteValues = (byte[])values.nextElement();
            retAttr.addValue(byteValues);
        }
        return retAttr;
    }

    final class AttributeValueEnumerator
    implements Enumeration {
        Vector vector;
        int count;
        boolean asBinary = false;

        AttributeValueEnumerator(Vector v, boolean asBinary) {
            this.vector = v;
            this.count = 0;
            this.asBinary = asBinary;
        }

        public boolean hasMoreElements() {
            return this.count < this.vector.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            Vector vector = this.vector;
            synchronized (vector) {
                if (this.count < this.vector.size()) {
                    byte[] bval = (byte[])this.vector.elementAt(this.count++);
                    if (this.asBinary) {
                        byte[] retValBuf = new byte[bval.length];
                        System.arraycopy(bval, 0, retValBuf, 0, bval.length);
                        return retValBuf;
                    }
                    return LDIFAttribute.bytes2string(bval);
                }
            }
            throw new NoSuchElementException("Reached End");
        }
    }
}

