/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import javax.naming.CommunicationException;
import javax.naming.directory.DirContext;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.LDAPEntry;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public abstract class LDAPGroup
extends LDAPEntry {
    protected LDAPGroup(DirContext inCtx, String inEntryDN) {
        super(inCtx, inEntryDN);
    }

    protected LDAPGroup(DirContext inCtx, String inEntryDN, PropertySet inDnPs) {
        super(inCtx, inEntryDN, inDnPs);
    }

    public String[] getAllUniquemembers(DirContext ctx) throws UtilException {
        try {
            this.resolve(ctx);
            String[] attrList = new String[]{"uniquemember"};
            PropertySetCollection psc = Util.getEntryDetails(ctx, this.entryDN, "(objectclass=*)", 0, attrList);
            String[] retarr = null;
            PropertySet ps = psc.getPropertySet(0);
            if (!ps.isEmpty()) {
                Property prop = ps.getProperty(0);
                int arraySize = prop.size();
                retarr = new String[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    retarr[i] = (String)prop.getValue(i);
                }
            }
            return retarr;
        }
        catch (Exception e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new UtilException(resBundle.getString("GENERAL_ERROR_SEARCH"), e);
        }
    }

    public boolean isUniquemember(DirContext ctx, String memberDN) throws UtilException {
        String[] GROUP_MEMBERS = new String[]{"uniquemember", "member"};
        this.resolve(ctx);
        PropertySetCollection result = Util.getDirectGroupMembershipVector(ctx, this.entryDN, memberDN, new String[]{"dn"}, GROUP_MEMBERS);
        return result.size() > 0;
    }

    public void addUniquemember(DirContext ctx, String dn) throws UtilException {
        this.resolve(ctx);
        Util.addUniquemember(ctx, this.entryDN, dn);
    }

    public void removeUniquemember(DirContext ctx, String dn) throws UtilException {
        this.resolve(ctx);
        Util.removeUniquemember(ctx, this.entryDN, dn);
    }
}

