/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import oracle.ldap.util.CommunicationErrorException;
import oracle.ldap.util.GeneralErrorException;
import oracle.ldap.util.LDAPGroup;
import oracle.ldap.util.NoSuchGroupException;
import oracle.ldap.util.ParameterException;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.User;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilException;

public class Group
extends LDAPGroup {
    static final String[] GROUP_MEMBERS = new String[]{"uniquemember", "member"};
    private int groupIdType = -1;
    private static String commonDN = "cn=Common,cn=Products,cn=OracleContext";
    private static ResourceBundle resBundle = ResourceBundle.getBundle("oracle.ldap.util.nls.UtilityResource");
    private String grpGuid = null;

    public Group(int inGroupIdType, String inGroupIdName) throws UtilException {
        super(null, inGroupIdName);
        if (inGroupIdName == null) {
            throw new ParameterException(resBundle.getString("PARAMETER_NULL") + ":  inGroupIdName");
        }
        if (inGroupIdType != Util.IDTYPE_GUID && inGroupIdType != Util.IDTYPE_DN) {
            throw new ParameterException(resBundle.getString("PARAMETER_INVALID") + ":  inGroupIdType");
        }
        this.entryDN = inGroupIdName;
        this.groupIdType = inGroupIdType;
        if (inGroupIdType == Util.IDTYPE_GUID) {
            this.grpGuid = inGroupIdName;
        }
        this.validated = false;
    }

    protected Group(DirContext ctx, String inGroupDN) {
        super(ctx, inGroupDN);
        this.validated = true;
    }

    protected Group(DirContext ctx, String inGroupDN, PropertySet inPs) {
        super(ctx, inGroupDN, inPs);
        this.validated = true;
    }

    protected Group(DirContext ctx, String inGroupDN, String guid, PropertySet inPs) {
        super(ctx, inGroupDN, inPs);
        this.grpGuid = guid;
        this.validated = true;
    }

    public void resolve(DirContext ctx) throws UtilException {
        try {
            if (!this.validated) {
                PropertySetCollection result = null;
                if (this.groupIdType == Util.IDTYPE_DN) {
                    result = Util.getEntryDetails(ctx, this.entryDN, "(objectclass=*)", 0, new String[]{"orclguid"});
                    if (!result.isEmpty()) {
                        this.grpGuid = (String)result.getPropertySet(0).getProperty("orclguid").getValue(0);
                    }
                } else if (this.groupIdType == Util.IDTYPE_GUID && !(result = Util.getEntryDetails(ctx, "", "orclguid=" + this.grpGuid, 2, new String[0])).isEmpty()) {
                    this.entryDN = result.getPropertySet(0).getDN();
                }
                if (result.isEmpty()) {
                    throw new NoSuchGroupException();
                }
                this.validated = true;
            }
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                throw new CommunicationErrorException(resBundle.getString("UNABLE_TO_CONNECT_TO_DIR"), e);
            }
            throw new GeneralErrorException(resBundle.getString("GENERAL_ERROR_SEARCH") + this.entryDN, e);
        }
    }

    public boolean isMember(DirContext ctx, User user, boolean nested) throws UtilException {
        if (ctx == null || user == null) {
            return false;
        }
        String userDN = user.getDN(ctx);
        return this.isMember(ctx, userDN, nested);
    }

    public boolean isOwner(DirContext ctx, String userDN, boolean nested) throws UtilException {
        if (!nested) {
            PropertySetCollection psc = Util.getOwnership(ctx, this.getDN(ctx), userDN, new String[]{"dn"}, nested);
            return psc != null && !psc.isEmpty();
        }
        return this.isNestedOwner(ctx, userDN);
    }

    public boolean isNestedOwner(DirContext ctx, String userDN) throws UtilException {
        PropertySetCollection groupProperties = this.getProperties(ctx, new String[]{"owner"});
        String ownerDN = groupProperties.getUniquePropertyValue("owner");
        Group ownerGroupDN = new Group(Util.IDTYPE_DN, ownerDN);
        if (Util.normalizeDN(ownerDN.toLowerCase()).equals(Util.normalizeDN(userDN.toLowerCase()))) {
            return true;
        }
        return ownerGroupDN.isMember(ctx, userDN, true);
    }

    public boolean isDirectUniqueMember(DirContext ctx, String uDN) {
        try {
            PropertySetCollection psc = Util.getDirectGroupMembershipVector(ctx, this.entryDN, uDN, new String[]{"dn"}, new String[]{"uniquemember"});
            return psc != null && !psc.isEmpty();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isMember(DirContext ctx, String userDN, boolean nested) throws UtilException {
        if (userDN == null) {
            return false;
        }
        if (!nested) {
            PropertySetCollection result = Util.getDirectGroupMembershipVector(ctx, this.entryDN, userDN, new String[]{"dn"}, GROUP_MEMBERS);
            return result.size() > 0;
        }
        if (this.grpGuid == null) {
            this.validated = false;
            this.groupIdType = Util.IDTYPE_DN;
        }
        this.resolve(ctx);
        String[] attrList = new String[]{"orclguid"};
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(attrList);
        Hashtable searchedTab = null;
        searchedTab = new Hashtable(500);
        return Util.getNestedGroups(ctx, this.grpGuid, Util.makeFilters(GROUP_MEMBERS, userDN, true), GROUP_MEMBERS, ctls, searchedTab);
    }

    public String getDn(DirContext ctx) throws UtilException {
        return this.getDN(ctx);
    }

    public PropertySetCollection getProperties(DirContext ctx, String[] attrList) throws UtilException {
        return this.getProperties(ctx, attrList, false);
    }

    public String getGUID(DirContext ctx) throws UtilException {
        this.resolve(ctx);
        if (this.grpGuid == null) {
            String[] attrList = new String[]{"orclguid"};
            PropertySetCollection psc = Util.ldapSearch(ctx, this.entryDN, "(objectclass=*)", 0, attrList);
            this.grpGuid = (String)psc.getPropertySet(0).getProperty(0).getValue(0);
        }
        return this.grpGuid;
    }
}

