/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import oracle.ldap.util.UtilException;

public class DASVersionConfigurator {
    private static final String DAS_PRODUCT_NAME = "DAS";
    private static final String ORCL_SCHEMA_VERSION_OBJECTCLASS = "orclSchemaVersion";
    private static final String TOP_OBJECTCLASS = "top";
    private static final String OBJECTCLASS_ATTRIBUTE = "objectclass";
    private static final String RDN_ATTRIBUTE = "cn";
    private static final String ORCLVERSION_ATTRIBUTE = "orclversion";
    private static final String ORCLPRODUCTVERSION_ATTRIBUTE = "orclproductversion";
    private static final String ORACLE_SCHEMA_VERSION_PARENT_DN = "cn=OracleSchemaVersion";
    private static final String PRODUCTS_ORACLE_CONTEXT_PARENT_DN = "cn=Products,cn=OracleContext";
    private static final String DAS_RDN = "cn=DAS";
    private static final String RDN_SEPARATOR = ",";
    private static final String DAS_SCHEMAVERSION_DN = "cn=DAS,cn=OracleSchemaVersion";
    private static final String DAS_PRODUCT_DN = "cn=DAS,cn=Products,cn=OracleContext";
    private static final String DAS_1012_SCHEMA_VERSION = "90500";
    private static final String DAS_1012_1_SCHEMA_VERSION = "90510";
    private static final String DAS_1014_SCHEMA_VERSION = "90600";
    private static final String DAS_1012_CHECK_ATTR = "cn=Reset Password,cn=OperationURLs,cn=DAS,cn=Products,cn=OracleContext";
    private static final String DAS_1014_CHECK_DN = "cn=orcltimezone,cn=Attributes,cn=User Configuration,cn=Attribute Configuration,cn=DAS,cn=Products,cn=OracleContext";
    private static final String DAS_1014_CHECK_ATTR = "orcldasuitype";
    private static final String DAS_1014_CHECK_RESULT = "timezonelist";
    DirContext oidCtx;
    Logger logger;

    public DASVersionConfigurator(DirContext oidCtx, Logger logger) {
        this.oidCtx = oidCtx;
        this.logger = logger;
    }

    public void configure() throws UtilException {
        try {
            this.configureDASVersion();
            this.configureDASSchemaVersion();
        }
        catch (NamingException e) {
            UtilException ue = new UtilException((Exception)e);
            throw ue;
        }
    }

    private void configureDASVersion() throws NamingException {
        if (!this.isDASVersionInfoPresent()) {
            this.logger.log(Level.FINEST, "DAS Version Information will be set");
            String dasVersion = this.getVersion();
            this.setDASVersion(dasVersion);
            this.logger.log(Level.FINEST, "DAS Version Information was set successfully");
        } else {
            this.logger.log(Level.FINEST, "DAS Version Information is already present");
        }
    }

    private boolean isDASVersionInfoPresent() throws NamingException {
        Attributes attrs = this.oidCtx.getAttributes(DAS_PRODUCT_DN);
        return attrs.get(ORCLVERSION_ATTRIBUTE) != null;
    }

    private String getVersion() throws NamingException {
        if (this.isDASVersion1012()) {
            this.logger.log(Level.FINE, "DAS Version is 10.1.2");
            return DAS_1012_SCHEMA_VERSION;
        }
        if (this.isDASVersion1014()) {
            this.logger.log(Level.FINE, "DAS Version is 10.1.4");
            return DAS_1014_SCHEMA_VERSION;
        }
        this.logger.log(Level.FINE, "DAS Version is 10.1.2.1");
        return DAS_1012_1_SCHEMA_VERSION;
    }

    private boolean isDASVersion1012() throws NamingException {
        try {
            this.oidCtx.search(DAS_1012_CHECK_ATTR, null);
            return false;
        }
        catch (NameNotFoundException e) {
            return true;
        }
    }

    private boolean isDASVersion1014() throws NamingException {
        try {
            Attributes attrs = this.oidCtx.getAttributes(DAS_1014_CHECK_DN);
            String dasUIType = (String)attrs.get(DAS_1014_CHECK_ATTR).get();
            this.logger.log(Level.FINE, "DAS UI type for timezone:" + dasUIType);
            return dasUIType != null && dasUIType.equals(DAS_1014_CHECK_RESULT);
        }
        catch (NameNotFoundException e) {
            return false;
        }
    }

    private void setDASVersion(String dasVersion) throws NamingException {
        this.oidCtx.modifyAttributes(DAS_PRODUCT_DN, 1, (Attributes)new BasicAttributes(ORCLVERSION_ATTRIBUTE, dasVersion));
    }

    private void configureDASSchemaVersion() throws NamingException {
        if (!this.isDASSchemaVersionEntryPresent()) {
            this.logger.log(Level.FINEST, "DAS SchemaVersion Entry will be created");
            String dasVersion = this.getSchemaVersion();
            this.createDASSchemaVersionEntry(dasVersion);
        } else {
            this.logger.log(Level.FINEST, "DAS SchemaVersion Entry is already present");
        }
    }

    private boolean isDASSchemaVersionEntryPresent() throws NamingException {
        try {
            this.oidCtx.search(DAS_SCHEMAVERSION_DN, null);
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
    }

    private String getSchemaVersion() throws NamingException {
        return this.getVersion();
    }

    private void createDASSchemaVersionEntry(String version) throws NamingException {
        this.logger.log(Level.FINEST, "Going to create DAS Schema Entry");
        BasicAttributes dasSchemaAttrs = new BasicAttributes(true);
        BasicAttribute objectClasses = new BasicAttribute(OBJECTCLASS_ATTRIBUTE);
        objectClasses.add(TOP_OBJECTCLASS);
        objectClasses.add(ORCL_SCHEMA_VERSION_OBJECTCLASS);
        dasSchemaAttrs.put(objectClasses);
        dasSchemaAttrs.put(new BasicAttribute(RDN_ATTRIBUTE, DAS_PRODUCT_NAME));
        dasSchemaAttrs.put(new BasicAttribute(ORCLPRODUCTVERSION_ATTRIBUTE, version));
        DirContext ctx = this.oidCtx.createSubcontext(DAS_SCHEMAVERSION_DN, (Attributes)dasSchemaAttrs);
        ctx.close();
        this.logger.log(Level.FINEST, "Created DAS Schema Entry");
    }
}

