/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.das.util;

import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import oracle.ldap.util.jndi.ConnectionUtil;

public class UILabelsNLS
implements Serializable {
    static String[] attrList = new String[]{"l", "homephone", "givenname", "telephonenumber", "orclhiredate", "pager", "orcldateofbirth", "orclmaidenname", "employeenumber", "middlename", "postalcode", "st", "mail", "mobile", "c", "displayname", "title", "manager", "homepostaladdress", "sn", "street", "facsimiletelephonenumber", "userpassword", "cn", "departmentnumber", "preferredlanguage", "orclactivestartdate", "orclactiveenddate", "orclisenabled", "uid", "orcltimezone", "orcldefaultprofilegroup", "secretary"};
    static String[] categoryList = new String[]{"category1", "category2", "category3", "category4", "category5", "photo", "Basic Info"};
    static String[][] localeList = new String[][]{{"en", "", "displayname"}, {"ar", "", "displayname;lang-ar"}, {"ca", "", "displayname;lang-ca"}, {"cs", "", "displayname;lang-cs"}, {"da", "", "displayname;lang-da"}, {"de", "", "displayname;lang-de"}, {"el", "", "displayname;lang-el"}, {"es", "", "displayname;lang-es"}, {"es", "ES", "displayname;lang-es_ES"}, {"fi", "", "displayname;lang-fi"}, {"fr", "", "displayname;lang-fr"}, {"fr", "CA", "displayname;lang-fr_CA"}, {"hu", "", "displayname;lang-hu"}, {"it", "", "displayname;lang-it"}, {"iw", "", "displayname;lang-iw"}, {"ja", "", "displayname;lang-ja"}, {"ko", "", "displayname;lang-ko"}, {"nl", "", "displayname;lang-nl"}, {"no", "", "displayname;lang-no"}, {"pl", "", "displayname;lang-pl"}, {"pt", "", "displayname;lang-pt"}, {"pt", "BR", "displayname;lang-pt_BR"}, {"ro", "", "displayname;lang-ro"}, {"ru", "", "displayname;lang-ru"}, {"sk", "", "displayname;lang-sk"}, {"sv", "", "displayname;lang-sv"}, {"th", "", "displayname;lang-th"}, {"tr", "", "displayname;lang-tr"}, {"zh", "CN", "displayname;lang-zh_CN"}, {"zh", "TW", "displayname;lang-zh_TW"}};

    public static void populateNLSLabels(DirContext userCtx, String subscriberdn) {
        String parentdn = "cn=Attributes,cn=User Configuration,cn=Attribute Configuration, cn=DAS,cn=Products,cn=OracleContext," + subscriberdn;
        UILabelsNLS.updateLabels(userCtx, parentdn, attrList);
        parentdn = "cn=categories,cn=User Configuration,cn=Attribute Configuration, cn=DAS,cn=Products,cn=OracleContext," + subscriberdn;
        UILabelsNLS.updateLabels(userCtx, parentdn, categoryList);
    }

    public static boolean checkNLSLabelsUpdateRequired(Attributes attrs, String currattr) {
        if (attrs == null) {
            return true;
        }
        try {
            Attribute attr = attrs.get(currattr);
            if (attr == null) {
                return true;
            }
            if (attr.getID().equalsIgnoreCase(currattr)) {
                return false;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return true;
    }

    public static Attributes getDisplayNameAttribute(DirContext ctx, String dn) throws Exception {
        String[] attrList = new String[]{"displayname"};
        return ctx.getAttributes(dn, attrList);
    }

    public static void upgradeNLSLabels(DirContext userCtx, String subscriberdn) {
        UILabelsNLS.populateNLSLabels(userCtx, subscriberdn);
    }

    public static void updateLabels(DirContext userCtx, String parentDN, String[] attrList) {
        int attrsize = attrList.length;
        int localesize = localeList.length;
        try {
            for (int i = 0; i < attrsize; ++i) {
                boolean val;
                String dn = "cn=" + attrList[i] + "," + parentDN;
                Attributes disp_attributes = null;
                try {
                    disp_attributes = UILabelsNLS.getDisplayNameAttribute(userCtx, dn);
                }
                catch (NameNotFoundException nnf) {
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e);
                    continue;
                }
                if (attrList[i].equalsIgnoreCase("uid") && (val = UILabelsNLS.fixUID(userCtx, dn, disp_attributes))) continue;
                Vector<ModificationItem> modVector = new Vector<ModificationItem>();
                for (int j = 0; j < localesize; ++j) {
                    if (!UILabelsNLS.checkNLSLabelsUpdateRequired(disp_attributes, localeList[j][2])) continue;
                    String newval = null;
                    try {
                        Locale locale = new Locale(localeList[j][0], localeList[j][1]);
                        ResourceBundle bundle = ResourceBundle.getBundle("oracle.ldap.das.nls.AttrDisplayNames", locale);
                        newval = bundle.getString(attrList[i]);
                    }
                    catch (Exception e) {
                        System.err.println("no key found in resource bundle : " + attrList[i]);
                    }
                    if (newval == null) continue;
                    BasicAttribute basicattr = new BasicAttribute(localeList[j][2]);
                    basicattr.add(newval);
                    modVector.addElement(new ModificationItem(1, basicattr));
                }
                int modsize = modVector.size();
                if (modsize == 0) continue;
                ModificationItem[] mods = new ModificationItem[modsize];
                for (int k = 0; k < modsize; ++k) {
                    mods[k] = (ModificationItem)modVector.elementAt(k);
                }
                try {
                    userCtx.modifyAttributes(dn, mods);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("error populate NLS labels for dn " + dn);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("error for populating attributes NLS labels !");
        }
    }

    public static boolean fixUID(DirContext userCtx, String dn, Attributes attrVal) {
        Attribute attr = attrVal.get("displayname");
        try {
            if (attr.get(0).equals("User Name")) {
                Vector<ModificationItem> modVector = new Vector<ModificationItem>();
                for (int j = 0; j < localeList.length; ++j) {
                    String newval = null;
                    try {
                        Locale locale = new Locale(localeList[j][0], localeList[j][1]);
                        ResourceBundle bundle = ResourceBundle.getBundle("oracle.ldap.das.nls.AttrDisplayNames", locale);
                        newval = bundle.getString("uid");
                    }
                    catch (Exception e) {
                        System.err.println("no key found in resource bundle : UID");
                    }
                    if (newval == null) continue;
                    BasicAttribute basicattr = new BasicAttribute(localeList[j][2]);
                    basicattr.add(newval);
                    modVector.addElement(new ModificationItem(2, basicattr));
                }
                int modsize = modVector.size();
                if (modsize == 0) {
                    return false;
                }
                ModificationItem[] mods = new ModificationItem[modsize];
                for (int k = 0; k < modsize; ++k) {
                    mods[k] = (ModificationItem)modVector.elementAt(k);
                }
                try {
                    userCtx.modifyAttributes(dn, mods);
                }
                catch (Exception e) {
                    System.err.println("error populate NLS labels for dn " + dn);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        InitialLdapContext ctx = ConnectionUtil.getDefaultDirCtx("stacg03.us.oracle.com", "3060", "cn=orcladmin", "welcome");
        UILabelsNLS.populateNLSLabels(ctx, "dc=us,dc=oracle,dc=com");
    }

    public static String[][] getLocaleList() {
        return localeList;
    }
}

