/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.user;

import java.text.SimpleDateFormat;
import java.util.List;
import oracle.idm.provisioning.plugin.ApplicationContext;
import oracle.idm.user.IdmUser;
import oracle.idm.user.UserFactory;
import oracle.idm.user.UserFactoryControl;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.UtilException;

abstract class UserHandler {
    protected Subscriber m_subscriber;
    protected UserFactory m_userFactory;
    protected UserFactoryControl m_uctl;
    public static String DATE_FORMAT_STR = "yyyyMMddHHmmss";
    protected SimpleDateFormat m_dateFormat = new SimpleDateFormat(DATE_FORMAT_STR);

    UserHandler(Subscriber subscriber, UserFactory userFactory) {
        this.m_subscriber = subscriber;
        this.m_userFactory = userFactory;
        this.m_uctl = userFactory.getUserFactoryControl();
    }

    protected void processAppStats(IdmUser idmUser, ModPropertySet modPropSet, List appStats) throws UtilException {
        int sz = appStats == null ? 0 : appStats.size();
        for (int i = 1; i < sz; i += 4) {
            ApplicationContext appCtx = (ApplicationContext)appStats.get(i);
            String status = (String)appStats.get(i + 1);
            String statusMsg = (String)appStats.get(i + 2);
            ModPropertySet appUserProp = (ModPropertySet)appStats.get(i + 3);
            if (!status.equalsIgnoreCase("PROVISIONING_REQUIRED")) continue;
            UserHandler.debug("setExtendedProperties: " + appCtx.getApplication().getType());
            if (appUserProp == null) {
                UserHandler.debug("No footprint for this application");
            }
            idmUser.setExtendedProperties(appCtx, modPropSet, appUserProp);
        }
    }

    protected ModPropertySet mergePropertySet(ModPropertySet mpSet1, ModPropertySet mpSet2) {
        LDIFRecord lRec1 = null;
        LDIFRecord lRec2 = null;
        if (mpSet2 == null) {
            return mpSet1;
        }
        if (mpSet1 == null) {
            return (ModPropertySet)mpSet2.clone();
        }
        lRec1 = mpSet1.getModProperty();
        lRec2 = mpSet2.getModProperty();
        int sz = lRec2.size();
        for (int i = 0; i < sz; ++i) {
            LDIFAttribute attr = lRec2.getAttribute(i);
            String attrName = attr.getName();
            int chgType = attr.getChangeType();
            attr.setChangeType(5);
            if (chgType == 5) {
                if (lRec1.contains(attrName)) continue;
                lRec1.addAttribute(attr);
                continue;
            }
            if (chgType == 7) {
                lRec1.removeAttribute(attrName);
                lRec1.addAttribute(attr);
                continue;
            }
            if (chgType != 6) continue;
            lRec1.removeAttribute(attrName);
        }
        return mpSet1;
    }

    static final boolean isStatusProvisioned(String provStatus) {
        return provStatus.equalsIgnoreCase("PROVISIONING_REQUIRED") || provStatus.equalsIgnoreCase("PROVISIONING_SUCCESSFUL") || provStatus.equalsIgnoreCase("DEPROVISIONING_FAILURE") || provStatus.equalsIgnoreCase("DEPROVISIONING_REQUIRED") || provStatus.equalsIgnoreCase("PROVISIONING_IN_PROGRESS") || provStatus.equalsIgnoreCase("DEPROVISIONING_IN_PROGRESS");
    }

    static void debug(Object o) {
        UtilDebug.log(32, "UserHandler : ", o);
    }

    protected class PluginResult {
        ModPropertySet m_baseUserMod = null;
        ModPropertySet m_appUserMod = null;
        String m_plgStat = null;
        String m_plgStatMsg = null;

        PluginResult(ModPropertySet baseUserMod, ModPropertySet appUserMod, String plgStat, String plgStatMsg) {
            this.m_baseUserMod = baseUserMod;
            this.m_appUserMod = appUserMod;
            this.m_plgStat = plgStat;
            this.m_plgStatMsg = plgStatMsg;
        }
    }
}

