/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.user;

import java.util.Hashtable;
import javax.naming.directory.DirContext;
import oracle.idm.provisioning.configuration.Configuration;
import oracle.idm.user.IdmException;
import oracle.idm.user.JndiUserFactory;
import oracle.idm.user.OIDContext;
import oracle.idm.user.UserFactory;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.UtilException;

public class UserFactoryBuilder {
    private UserFactoryBuilder() {
    }

    public static UserFactory createUserFactory(OIDContext ctxt, Hashtable environment) throws UtilException {
        JndiUserFactory retFactory = null;
        String realmName = null;
        Configuration provConfiguration = null;
        String access = null;
        realmName = (String)ctxt.getProperty("realm name");
        access = (String)ctxt.getProperty("access interface");
        if (access.equals("jndi")) {
            retFactory = new JndiUserFactory(ctxt);
        }
        if (retFactory != null) {
            if (realmName == null) {
                realmName = (String)ctxt.getProperty("realm name");
            }
            provConfiguration = new Configuration(realmName);
            retFactory.setProvisioningConfiguration(provConfiguration);
            UtilDebug.log(32, "UserFactory.createUserFactory", "Realm : " + realmName + ", Access Mode : " + access);
        }
        return retFactory;
    }

    public static UserFactory createUserFactory(DirContext dirCtx, Hashtable environment) throws UtilException {
        Hashtable<String, Object> env = null;
        OIDContext oidCtx = null;
        env = new Hashtable<String, Object>();
        env.put("access interface", "jndi");
        env.put("ldap context", dirCtx);
        try {
            oidCtx = new OIDContext(env);
        }
        catch (Exception e) {
            throw new IdmException(e.getMessage());
        }
        return UserFactoryBuilder.createUserFactory(oidCtx, null);
    }

    public static UserFactory createUserFactory(DirContext dirCtx, String realm) throws UtilException {
        Hashtable<String, Object> env = null;
        OIDContext oidCtx = null;
        env = new Hashtable<String, Object>();
        env.put("access interface", "jndi");
        env.put("ldap context", dirCtx);
        env.put("realm name", realm);
        try {
            oidCtx = new OIDContext(env);
        }
        catch (Exception e) {
            throw new IdmException(e.getMessage());
        }
        return UserFactoryBuilder.createUserFactory(oidCtx, null);
    }

    public static UserFactory createUserFactory(DirContext dirCtx, Configuration prvCfg) throws UtilException {
        JndiUserFactory retFactory = null;
        OIDContext oidCtx = null;
        String realmName = null;
        Hashtable<String, Object> env = null;
        realmName = prvCfg.getRealmName();
        env = new Hashtable<String, Object>();
        env.put("access interface", "jndi");
        env.put("ldap context", dirCtx);
        env.put("realm name", realmName);
        try {
            oidCtx = new OIDContext(env);
        }
        catch (Exception e) {
            throw new IdmException(e.getMessage());
        }
        retFactory = new JndiUserFactory(oidCtx);
        retFactory.setProvisioningConfiguration(prvCfg);
        return retFactory;
    }
}

