/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.user;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.configuration.Configuration;
import oracle.idm.provisioning.plugin.ApplicationContext;
import oracle.idm.provisioning.plugin.NoSuchPluginException;
import oracle.idm.provisioning.plugin.PluginException;
import oracle.idm.provisioning.plugin.PluginStatus;
import oracle.idm.provisioning.util.DataAccessPluginAdapter;
import oracle.idm.provisioning.util.PostDataEntryPluginAdapter;
import oracle.idm.provisioning.util.PreDataEntryPluginAdapter;
import oracle.idm.provisioning.util.ProvUtil;
import oracle.idm.user.IdmException;
import oracle.idm.user.IdmUser;
import oracle.idm.user.UserFactory;
import oracle.idm.user.UserHandler;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.UtilException;

class ModifyUserHandler
extends UserHandler {
    ModifyUserHandler(Subscriber subscriber, UserFactory userFactory) {
        super(subscriber, userFactory);
    }

    void modify(LdapContext lCtx, IdmUser idmUser, ModPropertySet modPropSet) throws UtilException {
        long startTime = System.currentTimeMillis();
        long noOfMilSec = 0L;
        Vector apps = null;
        List appStats = null;
        Configuration provConf = null;
        boolean shouldModifyBaseUser = true;
        boolean shouldModifyAppUsers = true;
        Object userIdentifier = null;
        ModifyUserHandler.debug("MODIFY User - ");
        ModifyUserHandler.debug(modPropSet);
        provConf = this.m_userFactory.getProvisioningConfiguration();
        shouldModifyBaseUser = this.m_uctl.isBaseUserModifyEnabled();
        shouldModifyAppUsers = this.m_uctl.isAppUserModifyEnabled();
        ModifyUserHandler.debug("User factory control information - Base User modification - " + shouldModifyBaseUser);
        ModifyUserHandler.debug("User factory control information - App users modification - " + shouldModifyAppUsers);
        if (shouldModifyAppUsers) {
            try {
                ModifyUserHandler.debug("Retrieving all applications for which the user needs to be provisioned...");
                apps = provConf.getAllApplications(lCtx);
            }
            catch (Exception e) {
                ModifyUserHandler.debug(e);
                throw new IdmException(e);
            }
        }
        ModifyUserHandler.debug("No.Of App : " + (apps == null ? "null" : "" + apps.size()));
        if (apps != null) {
            appStats = this.getAppList(lCtx, modPropSet, idmUser, apps);
            modPropSet = (ModPropertySet)appStats.get(0);
        }
        if (shouldModifyBaseUser) {
            modPropSet.addProperty(7, "orclUserProvMode", this.m_dateFormat.format(new Date()) + 'z');
            ModifyUserHandler.debug(modPropSet);
            idmUser.modifyAttributes(modPropSet);
        }
        ModifyUserHandler.debug("calling ******** PROCESS APP STATS ************");
        this.processAppStats(idmUser, modPropSet, appStats);
        noOfMilSec = System.currentTimeMillis() - startTime;
        ModifyUserHandler.debug("QUANTIFY TIME - modify() - " + noOfMilSec);
    }

    protected List getAppList(LdapContext lCtx, ModPropertySet modPropSet, IdmUser user, Vector apps) throws UtilException {
        LDIFRecord lRec;
        UserHandler.PluginResult pluginResult;
        String appName;
        String appType;
        String descAttrName;
        String provAttrName;
        String provStatusMsg;
        String provStatus;
        String operation = null;
        ModPropertySet baseUserPropSet = null;
        ModPropertySet curBaseAttrs = null;
        ArrayList<Object> appStats = null;
        appStats = new ArrayList<Object>();
        baseUserPropSet = (ModPropertySet)modPropSet.clone();
        appStats.add(baseUserPropSet);
        operation = "MODIFY";
        HashMap<ApplicationContext, String> appStatCache = new HashMap<ApplicationContext, String>();
        int sz = apps.size();
        for (int i = 0; i < sz; ++i) {
            PreDataEntryPluginAdapter prePlugin = null;
            ModPropertySet appUserPropSet = null;
            ApplicationContext appCtx = null;
            Application curApp = null;
            String curProvStatus = null;
            provStatus = null;
            provStatusMsg = null;
            provAttrName = null;
            descAttrName = null;
            appType = null;
            appName = null;
            curApp = (Application)apps.elementAt(i);
            appType = curApp.getType();
            appName = curApp.getName();
            if (!this.m_uctl.isAppAllowed(curApp)) {
                ModifyUserHandler.debug("Ignoring Not Requested Application : (" + appName + "," + appType + ")");
                continue;
            }
            ModifyUserHandler.debug("===== Processing MODIFY Provisioning Request For Application: " + appName + "," + appType + ") ======");
            appCtx = new ApplicationContext(lCtx, curApp);
            appCtx.setCallOp(operation);
            appCtx.setCallMode("AUTOMATIC_MODE");
            appCtx.setClientLocale(Locale.getDefault());
            if (UtilDebug.getDebugMode() > 0) {
                appCtx.setDebugEnabled(true);
            }
            try {
                prePlugin = new PreDataEntryPluginAdapter(lCtx, curApp, operation);
            }
            catch (NoSuchPluginException nspe) {
                ModifyUserHandler.debug("No PRE data entry plugin configured for : MODIFY : (" + appName + "," + appType + ")");
            }
            catch (PluginException pe) {
                ModifyUserHandler.debug("ERROR on instantiating PRE data entry plugin : MODIFY : (" + appName + "," + appType + ")");
                ModifyUserHandler.debug(pe);
                throw new IdmException(pe);
            }
            curProvStatus = provStatus = user.getProvisioningStatus(curApp);
            ModifyUserHandler.debug("Current provisioning policy : " + provStatus);
            if (prePlugin == null) {
                appStats.add(appCtx);
                appStats.add(provStatus);
                appStats.add(provStatusMsg);
                appStats.add(appUserPropSet);
                appStatCache.put(appCtx, curProvStatus);
                continue;
            }
            if (!ModifyUserHandler.isStatusProvisioned(provStatus)) {
                if (curBaseAttrs == null) {
                    curBaseAttrs = this.getBaseUserAttrs(lCtx, user);
                }
                appCtx.setCallOp("CREATE");
                ModifyUserHandler.debug("Getting application specific attributes that are configured...");
                try {
                    appUserPropSet = curApp.getAttributes(lCtx);
                }
                catch (Exception e) {
                    ModifyUserHandler.debug("Error while retrieving application specific attributes");
                    ModifyUserHandler.debug(e);
                }
            }
            ModifyUserHandler.debug("Initial Application spcecific attributes : ");
            ModifyUserHandler.debug(appUserPropSet);
            pluginResult = this.executePrePlugin(prePlugin, appCtx, user, baseUserPropSet, appUserPropSet, provStatus, curBaseAttrs);
            baseUserPropSet = pluginResult.m_baseUserMod;
            appUserPropSet = pluginResult.m_appUserMod;
            provStatus = pluginResult.m_plgStat;
            provStatusMsg = pluginResult.m_plgStatMsg;
            appStats.set(0, baseUserPropSet);
            if (provStatus != null) {
                lRec = baseUserPropSet.getModProperty();
                provAttrName = ProvUtil.getProvStatusAttrName(curApp);
                lRec.removeAttribute(provAttrName);
                baseUserPropSet.addProperty(7, provAttrName, provStatus);
                if (provStatusMsg != null) {
                    descAttrName = ProvUtil.getProvStatusDescAttrName(curApp);
                    lRec.removeAttribute(descAttrName);
                    baseUserPropSet.addProperty(7, descAttrName, provStatusMsg);
                }
            }
            if ((provStatus != null || !ModifyUserHandler.isStatusProvisioned(curProvStatus)) && !ModifyUserHandler.isStatusProvisioned(provStatus)) continue;
            appStats.add(appCtx);
            appStats.add(provStatus);
            appStats.add(provStatusMsg);
            appStats.add(appUserPropSet);
            appStatCache.put(appCtx, curProvStatus);
        }
        sz = appStats.size();
        int nApps = (sz - 1) / 4;
        ModifyUserHandler.debug("No. Of Applications before POST plugin : " + nApps);
        baseUserPropSet = (ModPropertySet)appStats.get(0);
        for (int i = 0; i < nApps; ++i) {
            PostDataEntryPluginAdapter postPlugin = null;
            ModPropertySet appUserPropSet = null;
            ApplicationContext appCtx = null;
            Application curApp = null;
            provStatus = null;
            provStatusMsg = null;
            provAttrName = null;
            descAttrName = null;
            appType = null;
            appName = null;
            appCtx = (ApplicationContext)appStats.remove(1);
            provStatus = (String)appStats.remove(1);
            provStatusMsg = (String)appStats.remove(1);
            appUserPropSet = (ModPropertySet)appStats.remove(1);
            curApp = appCtx.getApplication();
            appType = curApp.getType();
            appName = curApp.getName();
            try {
                postPlugin = new PostDataEntryPluginAdapter(lCtx, curApp, operation);
            }
            catch (NoSuchPluginException nspe) {
                ModifyUserHandler.debug("No POST Data entry plugin configured : MODIFY : (" + appName + "," + appType + ")");
            }
            catch (PluginException pe) {
                ModifyUserHandler.debug("ERROR on instantiating POST Data entry plugin : MODIFY : (" + appName + "," + appType + ")");
                ModifyUserHandler.debug(pe);
                throw new IdmException(pe);
            }
            if (postPlugin == null) {
                if (provStatus == null) continue;
                appStats.add(appCtx);
                appStats.add(provStatus);
                appStats.add(provStatusMsg);
                appStats.add(appUserPropSet);
                continue;
            }
            if (provStatus == null) {
                provStatus = (String)appStatCache.get(appCtx);
            }
            pluginResult = this.executePostPlugin(postPlugin, appCtx, user, baseUserPropSet, appUserPropSet, provStatus, curBaseAttrs);
            baseUserPropSet = pluginResult.m_baseUserMod;
            appUserPropSet = pluginResult.m_appUserMod;
            provStatus = pluginResult.m_plgStat;
            provStatusMsg = pluginResult.m_plgStatMsg;
            appStats.set(0, baseUserPropSet);
            if (provStatus == null) continue;
            lRec = baseUserPropSet.getModProperty();
            provAttrName = ProvUtil.getProvStatusAttrName(curApp);
            descAttrName = ProvUtil.getProvStatusDescAttrName(curApp);
            lRec.removeAttribute(provAttrName);
            baseUserPropSet.addProperty(7, provAttrName, provStatus);
            if (provStatusMsg != null) {
                lRec.removeAttribute(descAttrName);
                baseUserPropSet.addProperty(7, descAttrName, provStatusMsg);
            }
            if (!ModifyUserHandler.isStatusProvisioned(provStatus)) continue;
            appStats.add(appCtx);
            appStats.add(provStatus);
            appStats.add(provStatusMsg);
            appStats.add(appUserPropSet);
        }
        return appStats;
    }

    protected void processAppStats(IdmUser idmUser, ModPropertySet modPropSet, List appStats) throws UtilException {
        int sz = appStats == null ? 0 : appStats.size();
        int i = 1;
        while (i < sz) {
            ApplicationContext appCtx = (ApplicationContext)appStats.remove(i);
            String status = (String)appStats.remove(i);
            String statusMsg = (String)appStats.remove(i);
            ModPropertySet appUserProp = (ModPropertySet)appStats.remove(i);
            sz = appStats.size();
            if (status == null || !ModifyUserHandler.isStatusProvisioned(status) || appUserProp == null && modPropSet == null) continue;
            idmUser.setExtendedProperties(appCtx, modPropSet, appUserProp);
        }
    }

    private UserHandler.PluginResult executePrePlugin(PreDataEntryPluginAdapter prePlugin, ApplicationContext appCtx, IdmUser user, ModPropertySet baseAttrs, ModPropertySet appAttrs, String curProvStatus, ModPropertySet curBaseAttrs) {
        String provStatus = null;
        String pluginStatus = null;
        String pluginDescMsg = null;
        PluginStatus pluginStatusObj = null;
        ModPropertySet pluginBaseAttrs = null;
        ModPropertySet pluginAppAttrs = null;
        ModPropertySet retBaseAttrs = null;
        ModPropertySet retAppAttrs = null;
        ModPropertySet toPluginBaseAttrs = null;
        PluginStatus defFailSafePluginObj = null;
        defFailSafePluginObj = new PluginStatus("FAILURE", "PRE Plugin did not return a status object", null);
        retBaseAttrs = toPluginBaseAttrs = baseAttrs;
        if (curBaseAttrs != null) {
            toPluginBaseAttrs = super.mergePropertySet(curBaseAttrs, baseAttrs);
        }
        try {
            pluginStatusObj = prePlugin.process(appCtx, user, toPluginBaseAttrs, appAttrs);
            if (pluginStatusObj == null) {
                pluginStatusObj = defFailSafePluginObj;
                ModifyUserHandler.debug("NULL PluginStatus object returned from PRE data entry..");
            }
            pluginStatus = pluginStatusObj.getExecStatus();
            ModifyUserHandler.debug("PluginStatus : " + pluginStatus);
            pluginDescMsg = pluginStatusObj.getDesc();
        }
        catch (PluginException pe) {
            pluginStatus = "FAILURE";
            pluginDescMsg = pe.getMessage();
            ModifyUserHandler.debug("PRE data entry plugin execution failure : MODIFY");
            ModifyUserHandler.debug(pe);
        }
        if (pluginStatus.equalsIgnoreCase("SUCCESS")) {
            pluginBaseAttrs = prePlugin.getBaseAttrMods();
            ModifyUserHandler.debug("Delta Base ModAttrSet :");
            ModifyUserHandler.debug(pluginBaseAttrs);
            retBaseAttrs = this.mergePropertySet(baseAttrs, pluginBaseAttrs);
            ModifyUserHandler.debug("Merged Base ModAttrSet :");
            ModifyUserHandler.debug(retBaseAttrs);
            provStatus = pluginStatusObj.getProvStatus();
            ModifyUserHandler.debug("Provisioning status from plugin : " + provStatus);
            if (provStatus == null && !ModifyUserHandler.isStatusProvisioned(curProvStatus)) {
                provStatus = appCtx.getApplication().getPolicy();
            }
            if (provStatus != null && ModifyUserHandler.isStatusProvisioned(provStatus)) {
                pluginAppAttrs = prePlugin.getAppAttrMods();
                ModifyUserHandler.debug("ModPropSet returned by the PRE data entry modify plugin :");
                ModifyUserHandler.debug(pluginAppAttrs);
                retAppAttrs = this.mergePropertySet(appAttrs, pluginAppAttrs);
                ModifyUserHandler.debug("Merged App ModPropSet :");
                ModifyUserHandler.debug(retAppAttrs);
            }
        } else {
            ModifyUserHandler.debug("Plug in status NOT SUCCESS..");
            if (provStatus == null && !ModifyUserHandler.isStatusProvisioned(curProvStatus)) {
                provStatus = "PROVISIONING_FAILURE";
            }
        }
        ModifyUserHandler.debug("PRE Data Entry Plugin completed. Status : " + pluginStatus);
        ModifyUserHandler.debug("User Provisioning Status : " + provStatus);
        ModifyUserHandler.debug("Current User Provisioning Status " + curProvStatus);
        return new UserHandler.PluginResult(this, retBaseAttrs, retAppAttrs, provStatus, pluginDescMsg);
    }

    protected UserHandler.PluginResult executePostPlugin(PostDataEntryPluginAdapter postPlugin, ApplicationContext appCtx, IdmUser user, ModPropertySet baseAttrs, ModPropertySet appAttrs, String curProvStatus, ModPropertySet curBaseAttrs) {
        String provStatus = null;
        String pluginStatus = null;
        String pluginDescMsg = null;
        PluginStatus pluginStatusObj = null;
        ModPropertySet pluginBaseAttrs = null;
        ModPropertySet pluginAppAttrs = null;
        ModPropertySet toPluginBaseAttrs = null;
        ModPropertySet retBaseAttrs = null;
        ModPropertySet retAppAttrs = null;
        PluginStatus defFailSafePluginObj = null;
        defFailSafePluginObj = new PluginStatus("FAILURE", "POST Plugin did not return a status object", null);
        ModifyUserHandler.debug("Processing POST Plug in ...");
        retBaseAttrs = toPluginBaseAttrs = baseAttrs;
        if (curBaseAttrs != null) {
            toPluginBaseAttrs = super.mergePropertySet(curBaseAttrs, baseAttrs);
        }
        ModifyUserHandler.debug("Current Base ModPropSet : ");
        ModifyUserHandler.debug(toPluginBaseAttrs);
        try {
            pluginStatusObj = postPlugin.process(appCtx, user, toPluginBaseAttrs, appAttrs);
            if (pluginStatusObj == null) {
                pluginStatusObj = defFailSafePluginObj;
                ModifyUserHandler.debug("NULL PluginStatus object returned from POST data entry..");
            }
            pluginStatus = pluginStatusObj.getExecStatus();
            ModifyUserHandler.debug("Plugin Exec status : " + pluginStatus);
            pluginDescMsg = pluginStatusObj.getDesc();
        }
        catch (PluginException pe) {
            pluginStatus = "FAILURE";
            pluginDescMsg = pe.getMessage();
            ModifyUserHandler.debug("POST data entry plugin execution failure : MODIFY");
            ModifyUserHandler.debug(pe);
        }
        if (pluginStatus.equalsIgnoreCase("SUCCESS")) {
            pluginBaseAttrs = postPlugin.getBaseAttrMods();
            ModifyUserHandler.debug("Delta Base ModPropSet :");
            ModifyUserHandler.debug(pluginBaseAttrs);
            retBaseAttrs = this.mergePropertySet(baseAttrs, pluginBaseAttrs);
            ModifyUserHandler.debug("Merged Base ModPropSet :");
            ModifyUserHandler.debug(retBaseAttrs);
            provStatus = pluginStatusObj.getProvStatus();
            ModifyUserHandler.debug("Provisioning Status from Plugin : " + provStatus);
            if (provStatus == null && !ModifyUserHandler.isStatusProvisioned(curProvStatus)) {
                provStatus = curProvStatus;
            }
            if (provStatus != null && ModifyUserHandler.isStatusProvisioned(provStatus)) {
                pluginAppAttrs = postPlugin.getAppAttrMods();
                ModifyUserHandler.debug("ModPropSet returned by the POST data entry modify plugin :");
                ModifyUserHandler.debug(pluginAppAttrs);
                retAppAttrs = this.mergePropertySet(appAttrs, pluginAppAttrs);
                ModifyUserHandler.debug("Merged App ModPropSet :");
                ModifyUserHandler.debug(retAppAttrs);
            }
        } else if (provStatus == null && !ModifyUserHandler.isStatusProvisioned(curProvStatus)) {
            provStatus = "PROVISIONING_FAILURE";
        }
        ModifyUserHandler.debug("POST Data Entry Plugin completed. Status : " + pluginStatus);
        ModifyUserHandler.debug("App Prov Status : " + provStatus);
        return new UserHandler.PluginResult(this, retBaseAttrs, retAppAttrs, provStatus, pluginDescMsg);
    }

    protected ModPropertySet mergePropertySet(ModPropertySet mpSet1, ModPropertySet mpSet2) {
        LDIFRecord lRec1 = null;
        LDIFRecord lRec2 = null;
        if (mpSet2 == null) {
            return mpSet1;
        }
        if (mpSet1 == null) {
            return (ModPropertySet)mpSet2.clone();
        }
        lRec1 = mpSet1.getModProperty();
        lRec2 = mpSet2.getModProperty();
        int sz = lRec2.size();
        for (int i = 0; i < sz; ++i) {
            LDIFAttribute attr = lRec2.getAttribute(i);
            String attrName = attr.getName();
            if (lRec1.contains(attrName)) {
                lRec1.removeAttribute(attrName);
            }
            lRec1.addAttribute(attr);
        }
        return mpSet1;
    }

    private ModPropertySet getBaseUserAttrs(LdapContext lCtx, IdmUser user) {
        ModPropertySet retBaseAttrs = null;
        try {
            PropertySetCollection pCol = user.getAllProperties();
            PropertySet pSet = pCol.getPropertySet(0);
            int psz = pSet != null ? pSet.size() : 0;
            retBaseAttrs = new ModPropertySet();
            for (int k = 0; k < psz; ++k) {
                Property prop = pSet.getProperty(k);
                int asz = prop.size();
                LDIFAttribute lAttr = new LDIFAttribute(prop.getName());
                for (int j = 0; j < asz; ++j) {
                    Object obj;
                    if ((obj = prop.getValue(j++)) instanceof String) {
                        lAttr.addValue((String)obj);
                        continue;
                    }
                    if (!(obj instanceof byte[])) continue;
                    lAttr.addValue((byte[])obj);
                }
                retBaseAttrs.addProperty(5, lAttr);
            }
        }
        catch (Exception e) {
            ModifyUserHandler.debug("Error while retrieving Base user attributes");
            ModifyUserHandler.debug(e);
        }
        return retBaseAttrs;
    }

    public static void modifyAppUserWithPlugin(DataAccessPluginAdapter dataAccessPlugin, ApplicationContext appCtx, IdmUser idmUser, ModPropertySet baseUserPropSet, ModPropertySet appUserPropSet) throws UtilException {
        String curProvStatus;
        PluginStatus plgStat = null;
        PluginStatus defPlgStat = null;
        String stat = null;
        String provStat = null;
        String provStatMsg = null;
        IdmException uex = null;
        Application app = appCtx.getApplication();
        String appType = app.getType();
        String appName = app.getName();
        LdapContext dirCtx = (LdapContext)appCtx.getDirCtx();
        if (!appCtx.getCallOp().equalsIgnoreCase("MODIFY")) {
            throw new IdmException("Call op MODIFY expected");
        }
        defPlgStat = new PluginStatus("FAILURE", "Data Access Plugin did not return a status object", null);
        appCtx.setCallWhen("DATA_ACCESS");
        try {
            plgStat = dataAccessPlugin.process(appCtx, idmUser, baseUserPropSet, appUserPropSet);
            if (plgStat == null) {
                plgStat = defPlgStat;
            }
        }
        catch (PluginException pe) {
            plgStat = defPlgStat;
            plgStat.setDesc(pe.getMessage());
            ModifyUserHandler.debug("Data access plugin execution failure");
            uex = new IdmException(pe);
        }
        stat = plgStat.getExecStatus();
        provStat = plgStat.getProvStatus();
        provStatMsg = plgStat.getDesc();
        if (stat.equalsIgnoreCase("FAILURE")) {
            if (provStat != null) {
                ModifyUserHandler.debug("Ignoring the provsioning status returned by the plugin since execution status is failure");
                provStat = null;
            }
            if (uex == null) {
                uex = new IdmException(provStatMsg);
            }
        }
        if (provStat != null && !(curProvStatus = ProvUtil.getUserProvisioningStatus(dirCtx, Util.IDTYPE_GUID, idmUser.getGUID(), appType, appName)).equalsIgnoreCase(provStat)) {
            ProvUtil.setUserProvisioningStatus(dirCtx, Util.IDTYPE_GUID, idmUser.getGUID(), appType, appName, provStat, provStatMsg);
        }
        if (uex != null) {
            throw uex;
        }
    }

    static void modifyAppUserInDefAppContainer(String userGuid, ApplicationContext appCtx, ModPropertySet appUserPropSet) throws UtilException {
        Application app = appCtx.getApplication();
        LdapContext dirCtx = (LdapContext)appCtx.getDirCtx();
        String appType = app.getType();
        String appName = app.getName();
        String container = app.getUserDataLocation();
        UtilException uex = null;
        if (appUserPropSet == null) {
            ModifyUserHandler.debug("Application footprint is NULL");
            return;
        }
        if (container == null || container.trim().equals("") || container.trim().equalsIgnoreCase("DEFAULT")) {
            ModifyUserHandler.debug("Application does not have user data container (DEFAULT)..");
            return;
        }
        String dn = "orclownerguid=" + userGuid + "," + container;
        ModifyUserHandler.debug("Modifying the app user info - " + dn);
        try {
            ModifyUserHandler.debug("App user footprint - ");
            ModifyUserHandler.debug(appUserPropSet);
            Util.ldapModify(dirCtx, dn, appUserPropSet);
            ModifyUserHandler.debug("App user Footprint Modified Successfully..");
        }
        catch (UtilException ue) {
            ModifyUserHandler.debug("Modifying app user footprint failed.");
            uex = ue;
            if (ue.isNamingException()) {
                NamingException ne = ue.returnNamingException();
                if (ne instanceof NameNotFoundException) {
                    ModifyUserHandler.debug("App user footprint does not exist..");
                    try {
                        ModifyUserHandler.debug("Creating App user footprint for the first time..");
                        String objCls = appUserPropSet.getModPropertyValue("objectClass");
                        if (objCls == null) {
                            appUserPropSet.addProperty(5, "objectClass", "orclAppSpecificUserInfo");
                            String[] objectclasses = app.getObjectClasses();
                            appUserPropSet.addProperty(5, "objectClass", objectclasses);
                        }
                        Util.ldapAdd(dirCtx, dn, appUserPropSet);
                        uex = null;
                    }
                    catch (UtilException uee) {
                        ModifyUserHandler.debug("Error while creating App user footprint ..");
                        uex = uee;
                        ModifyUserHandler.debug(uex);
                    }
                } else {
                    ModifyUserHandler.debug(ne);
                }
            }
            ModifyUserHandler.debug(uex);
        }
        if (uex != null) {
            throw uex;
        }
    }

    static void debug(Object o) {
        UtilDebug.log(32, "ModifyUserHandler: ", o);
    }
}

