/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.user;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.configuration.Configuration;
import oracle.idm.user.CreateUserHandler;
import oracle.idm.user.DeleteUserHandler;
import oracle.idm.user.IdmException;
import oracle.idm.user.IdmUser;
import oracle.idm.user.JndiUser;
import oracle.idm.user.ModifyUserHandler;
import oracle.idm.user.OIDContext;
import oracle.idm.user.UserFactory;
import oracle.idm.user.UserFactoryBuilder;
import oracle.idm.user.UserFactoryControl;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFReader;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.NoSuchUserException;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.RootOracleContext;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.User;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.UtilException;
import oracle.ldap.util.jndi.ConnectionUtil;

class JndiUserFactory
implements UserFactory {
    private OIDContext m_oidctx;
    private String m_realmDn;
    private LdapContext m_lCtx;
    private String m_defUserCreateBase;
    private Subscriber m_subscriber;
    private Configuration m_provConfig;
    private UserFactoryControl m_uctl;

    public JndiUserFactory(OIDContext m_oidctx) throws UtilException {
        try {
            this.m_oidctx = (OIDContext)m_oidctx.clone();
        }
        catch (Exception e) {
            JndiUserFactory.debug(e);
        }
        String realmName = (String)this.m_oidctx.getProperty("realm name");
        int subscriberType = Util.IDTYPE_SIMPLE;
        this.m_lCtx = (LdapContext)m_oidctx.getProperty("ldap context");
        String[] attrlist = new String[]{"*", "orclguid"};
        RootOracleContext rootOC = new RootOracleContext((DirContext)this.m_lCtx, "");
        this.m_uctl = new UserFactoryControl();
        if (realmName == null) {
            subscriberType = Util.IDTYPE_DEFAULT;
        }
        this.m_subscriber = rootOC.getSubscriber(this.m_lCtx, subscriberType, realmName, attrlist);
        this.m_realmDn = this.m_subscriber.getDN(this.m_lCtx);
        if (subscriberType == Util.IDTYPE_DEFAULT && this.m_realmDn != null) {
            realmName = Util.getAttrValueOfRDN(Util.getRDN(this.m_realmDn));
            m_oidctx.setProperty("realm name", realmName);
        }
        JndiUserFactory.debug(this.m_lCtx);
        JndiUserFactory.debug("Realm name : " + realmName);
        JndiUserFactory.debug("Realm DN : " + this.m_realmDn);
        this.resolve();
    }

    public JndiUserFactory(OIDContext m_oidctx, Configuration prvConf) throws UtilException {
        try {
            this.m_oidctx = (OIDContext)m_oidctx.clone();
        }
        catch (Exception e) {
            JndiUserFactory.debug(e);
        }
        String realmName = prvConf.getRealmName();
        this.m_lCtx = (LdapContext)m_oidctx.getProperty("ldap context");
        this.m_uctl = new UserFactoryControl();
        this.m_provConfig = prvConf;
        try {
            this.m_subscriber = this.m_provConfig.getSubscriber(this.m_lCtx);
        }
        catch (Exception e) {
            throw new IdmException(e.getMessage());
        }
        this.m_realmDn = this.m_subscriber.getDN(this.m_lCtx);
        JndiUserFactory.debug(this.m_lCtx);
        JndiUserFactory.debug("Realm name : " + this.m_provConfig.getRealmName());
        JndiUserFactory.debug("Realm DN : " + this.m_realmDn);
        this.resolve();
    }

    public List searchUsers(int filterIdType, String filter, String userSearchBase) throws UtilException {
        ArrayList<JndiUser> users = new ArrayList<JndiUser>();
        String[] reqAttrList = new String[]{"*", "orclguid"};
        User[] baseUsers = null;
        try {
            baseUsers = this.m_subscriber.getUsers(this.m_lCtx, filterIdType, filter, userSearchBase, reqAttrList);
            for (int i = 0; i < baseUsers.length; ++i) {
                JndiUser idmUser = new JndiUser(this.m_oidctx, baseUsers[i]);
                idmUser.setProvisioningConfiguration(this.m_provConfig);
                users.add(idmUser);
            }
        }
        catch (Exception e) {
            JndiUserFactory.debug(e);
            throw new IdmException(e);
        }
        return users;
    }

    public OIDContext getOIDContext() {
        return this.m_oidctx;
    }

    public void setOIDContext(OIDContext oCtx) {
        this.m_oidctx = oCtx;
        this.m_lCtx = (InitialLdapContext)this.m_oidctx.getProperty("ldap context");
    }

    public IdmUser getUser(String guid) throws UtilException {
        return this.getUser(guid, Util.IDTYPE_GUID);
    }

    public IdmUser getUserByDN(String dn) throws UtilException {
        return this.getUser(dn, Util.IDTYPE_DN);
    }

    public IdmUser getUser(String idName, int idType) throws UtilException {
        JndiUser usr;
        block3: {
            usr = null;
            String[] newAttrList = new String[]{"*", "orclguid"};
            User baseuser = null;
            JndiUserFactory.debug("getUser : " + idName);
            try {
                baseuser = this.m_subscriber.getUser(this.m_lCtx, idType, idName, newAttrList);
                baseuser.resolve(this.m_lCtx);
                usr = new JndiUser(this.m_oidctx, baseuser);
                usr.setProvisioningConfiguration(this.m_provConfig);
            }
            catch (NoSuchUserException nse) {
            }
            catch (UtilException ue) {
                NamingException nfe = ue.returnNamingException();
                if (nfe != null || nfe instanceof NameNotFoundException) break block3;
                throw ue;
            }
        }
        return usr;
    }

    public IdmUser createUser(ModPropertySet modPropSet, boolean onlyBase) throws UtilException {
        String dn = null;
        return this.createUser(dn, modPropSet, onlyBase);
    }

    public IdmUser createUser(String dn, ModPropertySet modPropSet, boolean baseOnly) throws UtilException {
        return this.createUser(dn, this.m_defUserCreateBase, modPropSet, baseOnly);
    }

    private IdmUser createUser(String dn, String createBase, ModPropertySet modPropSet, boolean onlyBase) throws UtilException {
        IdmUser retUser = null;
        if (onlyBase) {
            JndiUserFactory.debug("Creating base user only");
            User baseUser = this.createBaseUser(dn, createBase, modPropSet);
            retUser = new JndiUser(this.m_oidctx, baseUser);
            retUser.setProvisioningConfiguration(this.m_provConfig);
            JndiUserFactory.debug("Successfully Created base user");
        } else {
            retUser = this.createUser(dn, createBase, modPropSet);
        }
        return retUser;
    }

    public IdmUser createUser(ModPropertySet modPropSet) throws UtilException {
        String dn = null;
        return this.createUser(dn, modPropSet);
    }

    public IdmUser createUser(String dn, ModPropertySet modPropSet) throws UtilException {
        return this.createUser(dn, this.m_defUserCreateBase, modPropSet);
    }

    private IdmUser createUser(String dn, String createBase, ModPropertySet modPropSet) throws UtilException {
        IdmUser retUser = null;
        CreateUserHandler createHandler = null;
        createHandler = new CreateUserHandler(this.m_subscriber, this, createBase);
        retUser = createHandler.create(this.m_lCtx, dn, modPropSet);
        return retUser;
    }

    public void modifyUser(String orclguid, ModPropertySet modPropSet) throws UtilException {
        IdmUser idmUser = null;
        if (orclguid != null) {
            idmUser = this.getUser(orclguid);
        }
        if (idmUser == null) {
            throw new IdmException("Base user does not exist : " + orclguid);
        }
        this.modifyUser(idmUser, modPropSet);
    }

    public void modifyUserByDN(String dn, ModPropertySet modPropSet) throws UtilException {
        IdmUser idmUser = null;
        if (dn != null) {
            idmUser = this.getUserByDN(dn);
        }
        if (idmUser == null) {
            throw new IdmException("Base user does not exist : " + dn);
        }
        this.modifyUser(idmUser, modPropSet);
    }

    public void modifyUser(IdmUser idmUser, ModPropertySet modPropSet) throws UtilException {
        Object retUser = null;
        ModifyUserHandler modifyHandler = null;
        modifyHandler = new ModifyUserHandler(this.m_subscriber, this);
        modifyHandler.modify(this.m_lCtx, idmUser, modPropSet);
    }

    public void deleteUser(String orclguid) throws UtilException {
        ModPropertySet mpSet = new ModPropertySet();
        mpSet.addProperty("orclguid", orclguid);
        this.deleteUser(mpSet);
    }

    public void deleteUserByDN(String dn) throws UtilException {
        ModPropertySet mpSet = new ModPropertySet();
        mpSet.addProperty("dn", dn);
        this.deleteUser(mpSet);
    }

    public void deleteUser(String orclguid, String dn) throws UtilException {
        ModPropertySet mpSet = new ModPropertySet();
        mpSet.addProperty("orclguid", orclguid);
        mpSet.addProperty("dn", dn);
        this.deleteUser(mpSet);
    }

    public void deleteUser(ModPropertySet mpSet) throws UtilException {
        DeleteUserHandler deleteHandler = null;
        deleteHandler = new DeleteUserHandler(this.m_subscriber, this);
        deleteHandler.delete(this.m_lCtx, null, mpSet);
    }

    public void deleteUser(IdmUser idmUser) throws UtilException {
        DeleteUserHandler deleteHandler = null;
        deleteHandler = new DeleteUserHandler(this.m_subscriber, this);
        deleteHandler.delete(this.m_lCtx, idmUser, null);
    }

    private void resolve() throws UtilException {
        String[] reqAttrList = new String[]{"orclCommonDefaultUserCreateBase"};
        PropertySetCollection pSetCol = this.m_subscriber.getProperties((DirContext)this.m_lCtx, 2, reqAttrList);
        PropertySet ps = null;
        ps = pSetCol.getPropertySet(0);
        if (ps != null) {
            this.m_defUserCreateBase = (String)ps.getProperty(reqAttrList[0]).getValue(0);
        }
        JndiUserFactory.debug("orclCommonDefaultUserCreateBase = " + this.m_defUserCreateBase);
    }

    public void setProvisioningConfiguration(Configuration config) {
        this.m_provConfig = config;
    }

    public Configuration getProvisioningConfiguration() {
        return this.m_provConfig;
    }

    public UserFactoryControl getUserFactoryControl() {
        return this.m_uctl;
    }

    public void setUserFactoryControl(UserFactoryControl uctl) {
        this.m_uctl = uctl;
    }

    public User createBaseUser(ModPropertySet pSet) throws UtilException {
        String dn = null;
        return this.createBaseUser(dn, pSet);
    }

    public User createBaseUser(String dn, ModPropertySet pSet) throws UtilException {
        return this.createBaseUser(dn, this.m_defUserCreateBase, pSet);
    }

    private User createBaseUser(String dn, String createBase, ModPropertySet pSet) throws UtilException {
        CreateUserHandler createHandler = null;
        createHandler = new CreateUserHandler(this.m_subscriber, this, createBase);
        return this.createBaseUser(createHandler, dn, pSet);
    }

    private User createBaseUser(CreateUserHandler createHandler, String dn, ModPropertySet pSet) throws UtilException {
        return createHandler.createBaseUser(this.m_lCtx, dn, pSet);
    }

    static void debug(Object o) {
        UtilDebug.log(32, "JndiUserFactory : ", o);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 6) {
            System.out.println("Usage: java oracle.ldap.idm.JndiUserFactory<realm> <host> <port> <bindDn> <passwd> <ldifFile>");
            return;
        }
        JndiUserFactory.debug("Connecting to " + args[1] + ":" + args[2]);
        InitialLdapContext ctx = ConnectionUtil.getDefaultDirCtx(args[1], args[2], args[3], args[4]);
        JndiUserFactory.debug("Connected.");
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("access interface", "jndi");
        env.put("ldap context", ctx);
        env.put("realm name", args[0]);
        OIDContext m_oidctx = new OIDContext(env);
        UserFactory factory = UserFactoryBuilder.createUserFactory(m_oidctx, null);
        JndiUserFactory.debug("JndiUserFactory created successfully...");
        LDIFReader ldifReader = new LDIFReader(args[5]);
        LDIFRecord lRec = null;
        JndiUserFactory.debug("LDIF Reader created succcessfully");
        while ((lRec = ldifReader.nextRecord()) != null) {
            ModPropertySet mpSet = new ModPropertySet(lRec.getChangeType());
            lRec.removeAttribute("objectClass");
            int sz = lRec.size();
            for (int i = 0; i < sz; ++i) {
                LDIFAttribute attr = lRec.getAttribute(i);
                mpSet.addProperty(attr.getChangeType(), attr);
            }
            IdmUser createdUser = factory.createUser(mpSet);
            JndiUserFactory.debug("Created User :" + createdUser.getDN());
        }
        ldifReader.close();
        ctx.close();
    }
}

