/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.user;

import java.io.Serializable;
import java.util.ArrayList;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.ProvisioningException;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.configuration.Configuration;
import oracle.idm.provisioning.plugin.ApplicationContext;
import oracle.idm.provisioning.plugin.IDataAccessPlugin;
import oracle.idm.provisioning.plugin.NoSuchPluginException;
import oracle.idm.provisioning.plugin.PluginException;
import oracle.idm.provisioning.util.DataAccessPluginAdapter;
import oracle.idm.provisioning.util.ProvUtil;
import oracle.idm.user.CreateUserHandler;
import oracle.idm.user.DeleteUserHandler;
import oracle.idm.user.IdmException;
import oracle.idm.user.IdmUser;
import oracle.idm.user.ModifyUserHandler;
import oracle.idm.user.OIDContext;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.User;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.UtilException;

public class JndiUser
implements IdmUser,
Serializable {
    private OIDContext oidctx;
    private String realmName;
    private transient LdapContext dirctx;
    private Configuration config;
    protected User baseuser;
    private String m_dn = null;
    private String m_orclGuid = null;

    public JndiUser(OIDContext oidctx, User baseuser) {
        this.baseuser = baseuser;
        try {
            this.oidctx = (OIDContext)oidctx.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.realmName = (String)this.oidctx.getProperty("realm name");
        this.dirctx = (InitialLdapContext)this.oidctx.getProperty("ldap context");
    }

    public JndiUser(String dn, String orclGuid) {
        this.m_dn = dn;
        this.m_orclGuid = orclGuid;
    }

    public String getGUID() throws UtilException {
        if (this.m_orclGuid == null) {
            if (this.baseuser != null) {
                this.m_orclGuid = this.baseuser.getGUID();
            } else {
                throw new IdmException("Base user does not exist");
            }
        }
        return this.m_orclGuid;
    }

    public String getDN() throws UtilException {
        if (this.m_dn == null) {
            if (this.baseuser != null) {
                this.m_dn = this.baseuser.getDN();
            } else {
                throw new IdmException("Base user does not exist");
            }
        }
        return this.m_dn;
    }

    public Property getProperty(String attr) throws UtilException {
        String[] attributes = new String[]{attr};
        PropertySetCollection psc = this.getProperties(attributes);
        return psc.getPropertySet(0).getProperty(attr);
    }

    public PropertySetCollection getProperties(String[] attributes) throws UtilException {
        return this.baseuser.getProperties(this.dirctx, attributes, false);
    }

    public PropertySetCollection getAllProperties() throws UtilException {
        String[] attributes = new String[]{"*", "orclguid"};
        return this.getProperties(attributes);
    }

    public Attribute getAttribute(String attr) throws UtilException {
        JndiUser.methodNotImplemented();
        return null;
    }

    public Attributes getAttributes(String[] attrlist) throws UtilException {
        JndiUser.methodNotImplemented();
        return null;
    }

    public void modifyAttributes(int mod_op, Attributes attrs) throws UtilException {
        JndiUser.methodNotImplemented();
    }

    public void modifyAttributes(ModPropertySet pset) throws UtilException {
        this.baseuser.setProperties((DirContext)this.dirctx, pset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setExtendedProperties(ApplicationContext appCtx, ModPropertySet baseUserPset, ModPropertySet appUserPset) throws UtilException {
        long startTime = System.currentTimeMillis();
        long noOfMilSec = 0L;
        String appType = null;
        String appName = null;
        DataAccessPluginAdapter dataAccessPlugin = null;
        String operation = null;
        Application app = appCtx.getApplication();
        if (UtilDebug.getDebugMode() > 0) {
            appCtx.setDebugEnabled(true);
        }
        appType = app.getType();
        appName = app.getName();
        JndiUser.debug("==================================================================");
        JndiUser.debug("Performing setExtended Properties For : (" + appName + "," + appType + ")");
        operation = appCtx.getCallOp();
        JndiUser.debug("operation : " + operation);
        if (operation == null) {
            JndiUser.debug("Operation Type is NULL !!. Returning ...");
            return;
        }
        if (baseUserPset != null) {
            JndiUser.debug("baseUserPset : " + baseUserPset.getModProperty());
        } else {
            JndiUser.debug("baseUserPset is NULL");
        }
        if (appUserPset != null) {
            JndiUser.debug("appUserPset : " + appUserPset.getModProperty());
        } else {
            JndiUser.debug("appUserPset is NULL");
        }
        dataAccessPlugin = null;
        try {
            dataAccessPlugin = new DataAccessPluginAdapter(this.dirctx, app);
        }
        catch (NoSuchPluginException nspe) {
            JndiUser.debug("No Data access plugin configured for ......" + appType + "," + appName);
        }
        catch (PluginException pe) {
            JndiUser.debug("ERROR on instantiating Data acces plugin ......");
            JndiUser.debug(pe);
            throw new IdmException(pe);
        }
        if (dataAccessPlugin != null) {
            JndiUser.debug("Data Access Plugin scenario...");
            if (operation.equalsIgnoreCase("CREATE")) {
                CreateUserHandler.createAppUserWithPlugin(dataAccessPlugin, appCtx, this, baseUserPset, appUserPset);
            } else if (operation.equalsIgnoreCase("MODIFY")) {
                ModifyUserHandler.modifyAppUserWithPlugin(dataAccessPlugin, appCtx, this, baseUserPset, appUserPset);
            } else {
                if (!operation.equalsIgnoreCase("DELETE")) throw new IdmException("Invalid Call operation");
                DeleteUserHandler.deleteAppUserWithPlugin(dataAccessPlugin, appCtx, this, baseUserPset, appUserPset);
            }
        } else {
            JndiUser.debug("No Plugin Scenario...");
            String userGuid = this.getGUID();
            if (operation.equalsIgnoreCase("CREATE")) {
                CreateUserHandler.createAppUserInDefAppContainer(userGuid, appCtx, appUserPset);
            } else if (operation.equalsIgnoreCase("MODIFY")) {
                ModifyUserHandler.modifyAppUserInDefAppContainer(userGuid, appCtx, appUserPset);
            } else {
                if (!operation.equalsIgnoreCase("DELETE")) throw new IdmException("Invalid Call operation");
                DeleteUserHandler.deleteAppUserInDefAppContainer(userGuid, appCtx, this);
            }
        }
        noOfMilSec = System.currentTimeMillis() - startTime;
        JndiUser.debug("QUANTIFY TIME - " + app.getType() + "." + app.getName() + ".setExtendedProperties() - " + noOfMilSec);
    }

    public void setProvisioningStatus(ApplicationContext appCtx, String status, String statusMsg) throws UtilException {
        Application app = appCtx.getApplication();
        this.setProvisioningStatus(app, status, statusMsg);
    }

    public void setProvisioningStatus(Application app, String status, String statusMsg) throws UtilException {
        String appType = app.getType();
        String appName = app.getName();
        String baseUserDN = this.getDN();
        ProvUtil.setUserProvisioningStatus(this.dirctx, Util.IDTYPE_DN, baseUserDN, appType, appName, status, statusMsg);
    }

    public PropertySetCollection getExtendedProperties(ApplicationContext appCtx) throws UtilException {
        Application app = appCtx.getApplication();
        String appProvPolicy = app.getPolicy();
        String appName = app.getName();
        String appType = app.getType();
        PropertySetCollection pCol = null;
        JndiUser.debug("Application Provisioning policy (getExtendedProp): " + appProvPolicy);
        IDataAccessPlugin dataAccessPlugin = null;
        try {
            dataAccessPlugin = (IDataAccessPlugin)app.getPluginInstance(this.dirctx, "DATA_ACCESS");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UtilException(e);
        }
        if (dataAccessPlugin != null) {
            try {
                pCol = new PropertySetCollection(1);
                PropertySet pSet = dataAccessPlugin.getAppUserData(appCtx, this, null);
                pCol.addPropertySet(pSet);
            }
            catch (PluginException pe) {
                pe.printStackTrace();
                throw new UtilException(pe);
            }
        }
        try {
            String container = app.getUserDataLocation();
            if (container == null || container.trim().equals("") || container.trim().equalsIgnoreCase("DEFAULT")) {
                return null;
            }
            String filter = "(&(objectclass=orclAppSpecificUserInfo)(orclownerguid=" + this.getGUID() + "))";
            pCol = Util.getEntryDetails(this.dirctx, container, filter, 2, null);
        }
        catch (NamingException ne) {
            throw new UtilException((Exception)ne);
        }
        return pCol;
    }

    public String getProvisioningStatus(ApplicationContext appCtx) throws UtilException {
        Application app = appCtx.getApplication();
        return this.getProvisioningStatus(app);
    }

    public String getProvisioningStatus(Application app) throws UtilException {
        String appType = app.getType();
        String appName = app.getName();
        String baseUserDN = this.getDN();
        return ProvUtil.getUserProvisioningStatus(this.dirctx, Util.IDTYPE_DN, baseUserDN, appType, appName);
    }

    public Application[] getUserApplications(String provStatus) throws UtilException {
        Application[] retApps = null;
        String StatusObjDN = this.baseuser.getDN();
        String[] rqdAttributes = new String[]{"orclUserApplnProvStatus"};
        PropertySetCollection psetC = null;
        PropertySet pset = null;
        String filter = "orclUserApplnProvStatus=" + provStatus.toUpperCase();
        try {
            psetC = Util.ldapSearch(this.dirctx, StatusObjDN, filter, 0, rqdAttributes);
            pset = psetC.getPropertySet(0);
            ArrayList<Application> appList = new ArrayList<Application>();
            for (int i = 0; i < pset.size(); ++i) {
                String attrName;
                int pos;
                Property prop = pset.getProperty(i);
                if (prop == null || (pos = (attrName = prop.getName().toLowerCase()).indexOf("orclUserApplnProvStatus;")) <= 0) continue;
                String appSubType = attrName.substring(pos + 1);
                int pos1 = appSubType.indexOf(95);
                String appName = appSubType.substring(0, pos);
                String appType = appSubType.substring(pos + 1);
                Application app = this.config.getApplication(this.dirctx, appType, appName);
                if (app == null) continue;
                appList.add(app);
            }
            int appListSz = appList.size();
            if (appListSz != 0) {
                retApps = appList.toArray(new Application[appListSz]);
            }
        }
        catch (Exception ue) {
            // empty catch block
        }
        return retApps;
    }

    public void changeSSOPassword(String oldPass, String newPass, boolean verify) throws UtilException {
        JndiUser.methodNotImplemented();
    }

    public void setPasswordHint(String hint, String answer) throws UtilException {
        JndiUser.methodNotImplemented();
    }

    public String getPasswordHint() throws UtilException {
        JndiUser.methodNotImplemented();
        return null;
    }

    public String getPasswordHintAnswer() throws UtilException {
        JndiUser.methodNotImplemented();
        return null;
    }

    public boolean setTimeZone(String timezone) throws UtilException {
        JndiUser.methodNotImplemented();
        return false;
    }

    public void resetPassword(String hintanswer, Property[] otherValidationProps) throws UtilException {
        JndiUser.methodNotImplemented();
    }

    public void setProvisioningConfiguration(Configuration cfg) {
        this.config = cfg;
    }

    public Configuration getProvisioningConfiguration() {
        return this.config;
    }

    public String toString() {
        String dn = null;
        try {
            dn = this.getDN();
        }
        catch (UtilException utilException) {
            // empty catch block
        }
        return "Base User DN : " + dn;
    }

    private static void debug(Object o) {
        UtilDebug.log(32, "JndiUser:", o);
    }

    private static void methodNotImplemented() throws UtilException {
        throw new ProvisioningException("Method not implemented");
    }

    public void setLdapContext(LdapContext lCtx) {
        this.dirctx = lCtx;
    }
}

