/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.user;

import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.configuration.Configuration;
import oracle.idm.provisioning.plugin.ApplicationContext;
import oracle.idm.provisioning.plugin.NoSuchPluginException;
import oracle.idm.provisioning.plugin.PluginException;
import oracle.idm.provisioning.plugin.PluginStatus;
import oracle.idm.provisioning.util.DataAccessPluginAdapter;
import oracle.idm.provisioning.util.ProvUtil;
import oracle.idm.user.IdmException;
import oracle.idm.user.IdmUser;
import oracle.idm.user.JndiUser;
import oracle.idm.user.UserFactory;
import oracle.idm.user.UserFactoryControl;
import oracle.idm.user.UserHandler;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.UtilException;

class DeleteUserHandler
extends UserHandler {
    private static String NO_FOOTPRINT = "DEFAULT";

    DeleteUserHandler(Subscriber subscriber, UserFactory userFactory) {
        super(subscriber, userFactory);
    }

    void delete(LdapContext lCtx, IdmUser idmUser, ModPropertySet mpSet) throws UtilException {
        String orclGuid = null;
        if (idmUser != null) {
            orclGuid = idmUser.getGUID();
        } else if (mpSet != null) {
            orclGuid = mpSet.getModPropertyValue("orclguid");
            if (orclGuid != null) {
                idmUser = this.m_userFactory.getUser(orclGuid);
            } else {
                String dn = mpSet.getModPropertyValue("dn");
                if (dn != null && (idmUser = this.m_userFactory.getUserByDN(dn)) != null) {
                    orclGuid = idmUser.getGUID();
                }
            }
        } else {
            throw new IdmException("Both idmUser and mpSet can not be NULL");
        }
        if (idmUser == null) {
            DeleteUserHandler.debug("The base user might already be deleted..");
            DeleteUserHandler.debug("Attempting to remove application footprint...");
        } else {
            DeleteUserHandler.debug("The base user exists..");
        }
        Vector apps = null;
        Configuration provConfig = null;
        provConfig = this.m_userFactory.getProvisioningConfiguration();
        try {
            apps = provConfig.getAllApplications(lCtx);
        }
        catch (Exception e) {
            DeleteUserHandler.debug(e);
            throw new IdmException(e);
        }
        boolean doNotDeleteBaseUser = false;
        Application curApp = null;
        Iterator itr = apps != null ? apps.iterator() : null;
        UserFactoryControl ufc = this.m_userFactory.getUserFactoryControl();
        boolean bl = ufc == null ? false : (doNotDeleteBaseUser = !ufc.isBaseUserDeleteEnabled());
        while (itr != null && itr.hasNext()) {
            curApp = (Application)itr.next();
            ApplicationContext appCtx = new ApplicationContext(lCtx, curApp);
            appCtx.setCallOp("DELETE");
            appCtx.setCallMode("AUTOMATIC_MODE");
            appCtx.setClientLocale(Locale.getDefault());
            if (UtilDebug.getDebugMode() > 0) {
                appCtx.setDebugEnabled(true);
            }
            try {
                if (idmUser != null) continue;
                String appType = null;
                String appName = null;
                DataAccessPluginAdapter dataAccessPlugin = null;
                appType = curApp.getType();
                appName = curApp.getName();
                DeleteUserHandler.debug("DELETE user - (" + appType + "," + appName + ")");
                try {
                    dataAccessPlugin = new DataAccessPluginAdapter(lCtx, curApp);
                }
                catch (NoSuchPluginException nspe) {
                    DeleteUserHandler.debug("No Data access plugin configured for ......" + appType + "," + appName);
                }
                catch (PluginException pe) {
                    DeleteUserHandler.debug("ERROR on instantiating Data acces plugin ......");
                    DeleteUserHandler.debug(pe);
                    throw new IdmException(pe);
                }
                if (dataAccessPlugin == null) continue;
                DeleteUserHandler.debug("DELETE App user using - DATA ACCESS PLUGIN");
                DeleteUserHandler.deleteAppUserWithPlugin(dataAccessPlugin, appCtx, idmUser, mpSet, null);
            }
            catch (UtilException ue) {
                DeleteUserHandler.debug(ue);
            }
        }
        if (!doNotDeleteBaseUser && idmUser != null) {
            this.m_subscriber.deleteUser(lCtx, ((JndiUser)idmUser).baseuser);
            DeleteUserHandler.debug("Successfully deleted the base user");
        }
    }

    static void deleteAppUserInDefAppContainer(String orclGuid, ApplicationContext appCtx, IdmUser idmUser) throws UtilException {
        String curStatus;
        if (orclGuid == null) {
            DeleteUserHandler.debug("orclGuid is NULL. A valid GUID must be passed to delete OID maintained application foot print.");
            return;
        }
        Application app = appCtx.getApplication();
        String appType = app.getType();
        String appName = app.getName();
        LdapContext lCtx = (LdapContext)appCtx.getDirCtx();
        String userDataLoc = app.getUserDataLocation();
        Object appUserDn = null;
        if (userDataLoc.equalsIgnoreCase(NO_FOOTPRINT)) {
            DeleteUserHandler.debug("Application does not require any footprint .. (" + appType + "," + appName + ")");
        }
        if (idmUser != null && DeleteUserHandler.isStatusProvisioned(curStatus = ProvUtil.getUserProvisioningStatus(lCtx, Util.IDTYPE_GUID, orclGuid, app.getType(), app.getName()))) {
            ProvUtil.setUserProvisioningStatus(lCtx, Util.IDTYPE_GUID, orclGuid, app.getType(), app.getName(), "DEPROVISIONING_REQUIRED", "Application user footprint deleted successfully");
        }
    }

    static void deleteAppUserWithPlugin(DataAccessPluginAdapter dataAccessPlugin, ApplicationContext appCtx, IdmUser idmUser, ModPropertySet baseUserMpSet, ModPropertySet appUserMpSet) throws UtilException {
        PluginStatus plgStat = null;
        String plgExecStatus = "FAILURE";
        Application app = appCtx.getApplication();
        String appType = app.getType();
        String appName = app.getName();
        LdapContext lCtx = (LdapContext)appCtx.getDirCtx();
        try {
            IdmUser tIdmUser = idmUser;
            if (tIdmUser == null) {
                String dn = baseUserMpSet.getModPropertyValue("dn");
                String orclGuid = baseUserMpSet.getModPropertyValue("orclguid");
                tIdmUser = new JndiUser(dn, orclGuid);
            }
            if ((plgStat = dataAccessPlugin.process(appCtx, tIdmUser, baseUserMpSet, appUserMpSet)) != null) {
                plgExecStatus = plgStat.getExecStatus();
            }
        }
        catch (PluginException pe) {
            DeleteUserHandler.debug("DATA ACCESS PLUGIN  - PluginException");
            DeleteUserHandler.debug(pe);
        }
        catch (Exception e) {
            DeleteUserHandler.debug("DATA ACCESS PLUGIN Execution Failed");
            DeleteUserHandler.debug(e);
            throw new IdmException(e);
        }
        if (plgExecStatus.equalsIgnoreCase("SUCCESS")) {
            String provStat = plgStat.getProvStatus();
            if (provStat == null) {
                provStat = "DEPROVISIONING_SUCCESSFUL";
            }
            if (idmUser != null) {
                String provStatusMsg = plgStat.getDesc();
                ProvUtil.setUserProvisioningStatus(lCtx, Util.IDTYPE_GUID, idmUser.getGUID(), app.getType(), app.getName(), provStat, provStatusMsg);
            }
        }
    }

    static void debug(Object o) {
        UtilDebug.log(32, "DeleteUserHandler : ", o);
    }
}

