/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.user;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.SchemaViolationException;
import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.configuration.Configuration;
import oracle.idm.provisioning.plugin.ApplicationContext;
import oracle.idm.provisioning.plugin.NoSuchPluginException;
import oracle.idm.provisioning.plugin.PluginException;
import oracle.idm.provisioning.plugin.PluginStatus;
import oracle.idm.provisioning.util.DataAccessPluginAdapter;
import oracle.idm.provisioning.util.PostDataEntryPluginAdapter;
import oracle.idm.provisioning.util.PreDataEntryPluginAdapter;
import oracle.idm.provisioning.util.ProvUtil;
import oracle.idm.user.IdmException;
import oracle.idm.user.IdmUser;
import oracle.idm.user.JndiUser;
import oracle.idm.user.OIDContext;
import oracle.idm.user.UserFactory;
import oracle.idm.user.UserHandler;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.Subscriber;
import oracle.ldap.util.User;
import oracle.ldap.util.Util;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.UtilException;

class CreateUserHandler
extends UserHandler {
    protected String m_userCreateBase;

    CreateUserHandler(Subscriber subscriber, UserFactory userFactory, String userCreateBase) {
        super(subscriber, userFactory);
        this.m_userCreateBase = userCreateBase;
    }

    IdmUser create(LdapContext lCtx, ModPropertySet modPropSet) throws UtilException {
        return this.create(lCtx, null, modPropSet);
    }

    IdmUser create(LdapContext lCtx, String dn, ModPropertySet modPropSet) throws UtilException {
        List appStats;
        IdmUser retUser;
        long noOfMilSec;
        long startTime;
        block18: {
            startTime = System.currentTimeMillis();
            noOfMilSec = 0L;
            Vector apps = null;
            retUser = null;
            appStats = null;
            boolean shouldCreateBaseUser = true;
            boolean shouldCreateAppUser = true;
            Configuration provConf = this.m_userFactory.getProvisioningConfiguration();
            CreateUserHandler.debug("CREATE User - ");
            CreateUserHandler.debug(modPropSet);
            shouldCreateBaseUser = this.m_uctl.isBaseUserCreateEnabled();
            if (!shouldCreateBaseUser) {
                CreateUserHandler.debug("UserFactoryControl - Should create base user .... FALSE");
                String orclguid = modPropSet.getModPropertyValue("orclguid");
                if (dn != null) {
                    retUser = this.m_userFactory.getUserByDN(dn);
                } else if (orclguid != null) {
                    retUser = this.m_userFactory.getUser(orclguid);
                }
                if (retUser == null) {
                    String msg = "Base user does not exist : " + orclguid;
                    CreateUserHandler.debug(msg);
                    throw new IdmException(msg);
                }
            }
            shouldCreateAppUser = this.m_uctl.isAppUserCreateEnabled();
            CreateUserHandler.debug("User factory control information - App users creation - " + shouldCreateAppUser);
            if (shouldCreateAppUser) {
                try {
                    CreateUserHandler.debug("Retrieving all applications for which the user needs to be provisioned...");
                    apps = provConf.getAllApplications(lCtx);
                }
                catch (Exception e) {
                    CreateUserHandler.debug(e);
                    throw new IdmException(e);
                }
            }
            CreateUserHandler.debug("No.Of App : " + (apps == null ? "null" : "" + apps.size()));
            if (apps != null) {
                appStats = this.getAppList(lCtx, modPropSet, retUser, apps);
                modPropSet = (ModPropertySet)appStats.get(0);
            }
            if (shouldCreateBaseUser) {
                User baseUser = this.createBaseUser(lCtx, dn, modPropSet);
                try {
                    retUser = new JndiUser(OIDContext.getInstance(lCtx), baseUser);
                    retUser.setProvisioningConfiguration(provConf);
                }
                catch (Exception e) {
                    CreateUserHandler.debug("Error while creating JNDI User...");
                    CreateUserHandler.debug(e);
                }
            } else {
                CreateUserHandler.debug("Updating the Base User application status attributes");
                CreateUserHandler.debug(modPropSet);
                LDIFRecord lRec = modPropSet.getModProperty();
                int sz = apps.size();
                ModPropertySet mpSet = new ModPropertySet();
                for (int i = 0; i < sz; ++i) {
                    String val;
                    Application app = null;
                    String appStatAttr = null;
                    String appStatDescAttr = null;
                    LDIFAttribute lattr = null;
                    app = (Application)apps.elementAt(i);
                    appStatAttr = ProvUtil.getProvStatusAttrName(app);
                    appStatDescAttr = ProvUtil.getProvStatusDescAttrName(app);
                    lattr = lRec.getAttribute(appStatAttr);
                    if (lattr != null && !(val = lattr.getValue()).equalsIgnoreCase("PROVISIONING_REQUIRED")) {
                        mpSet.addProperty(7, lattr);
                    }
                    if ((lattr = lRec.getAttribute(appStatDescAttr)) == null) continue;
                    mpSet.addProperty(7, lattr);
                }
                CreateUserHandler.debug("status to be applied");
                CreateUserHandler.debug(mpSet);
                if (mpSet.size() > 1) {
                    try {
                        Util.ldapModify(lCtx, retUser.getDN(), mpSet);
                    }
                    catch (UtilException ue) {
                        NamingException ne;
                        if (!ue.isNamingException() || !((ne = ue.returnNamingException()) instanceof SchemaViolationException)) break block18;
                        mpSet.addProperty("objectClass", "orclUserProvStatus");
                        Util.ldapModify(lCtx, retUser.getDN(), mpSet);
                    }
                }
            }
        }
        this.processAppStats(retUser, modPropSet, appStats);
        noOfMilSec = System.currentTimeMillis() - startTime;
        CreateUserHandler.debug("QUANTIFY TIME - create() - " + noOfMilSec);
        return retUser;
    }

    protected User createBaseUser(LdapContext lCtx, String dn, ModPropertySet pSet) throws UtilException {
        long startTime = System.currentTimeMillis();
        long noOfMilSec = 0L;
        pSet.addProperty(5, "orclUserProvMode", this.m_dateFormat.format(new Date()) + 'z');
        CreateUserHandler.debug("Creating BASE user : ");
        CreateUserHandler.debug(pSet);
        User baseUser = null;
        boolean dnCheck = true;
        this.addProvStatusOC(pSet);
        baseUser = dn != null ? this.m_subscriber.createUser(lCtx, dn, pSet, this.m_uctl.isDASMandatoryAttrChkEnabled(), dnCheck) : this.m_subscriber.createUser(lCtx, this.m_userCreateBase, pSet, this.m_uctl.isDASMandatoryAttrChkEnabled());
        baseUser.resolve(lCtx);
        CreateUserHandler.debug("Successfully Created BASE user");
        noOfMilSec = System.currentTimeMillis() - startTime;
        CreateUserHandler.debug("QUANTIFY TIME - createBaseUser() - " + noOfMilSec);
        return baseUser;
    }

    private void addProvStatusOC(ModPropertySet pSet) {
        String[] vals = pSet.getModPropertyValues("objectClass");
        boolean statusOCPresent = false;
        for (int i = 0; !statusOCPresent && vals != null && i < vals.length; ++i) {
            statusOCPresent = vals[i].equalsIgnoreCase("orclUserProvStatus");
        }
        if (!statusOCPresent) {
            pSet.addProperty("objectClass", "orclUserProvStatus");
        }
    }

    protected List getAppList(LdapContext lCtx, ModPropertySet modPropSet, IdmUser user, Vector apps) throws UtilException {
        String operation = null;
        ModPropertySet baseUserPropSet = null;
        ArrayList<Object> appStats = null;
        appStats = new ArrayList<Object>();
        baseUserPropSet = (ModPropertySet)modPropSet.clone();
        appStats.add(baseUserPropSet);
        operation = "CREATE";
        int sz = apps.size();
        for (int i = 0; i < sz; ++i) {
            PreDataEntryPluginAdapter prePlugin = null;
            ModPropertySet appUserPropSet = null;
            ApplicationContext appCtx = null;
            Application curApp = null;
            String provStatus = null;
            String provStatusMsg = null;
            String provAttrName = null;
            String descAttrName = null;
            curApp = (Application)apps.elementAt(i);
            if (!this.m_uctl.isAppAllowed(curApp)) {
                CreateUserHandler.debug("Ignoring Not Requested Application : " + curApp.getName());
                continue;
            }
            CreateUserHandler.debug("===== Processing CREATE Provisioning Request For Application: " + curApp.getName() + " ======");
            appCtx = new ApplicationContext(lCtx, curApp);
            appCtx.setCallOp(operation);
            appCtx.setCallMode("AUTOMATIC_MODE");
            appCtx.setClientLocale(Locale.getDefault());
            if (UtilDebug.getDebugMode() > 0) {
                appCtx.setDebugEnabled(true);
            }
            provStatus = curApp.getPolicy();
            provStatusMsg = "Used application default provisioning policy";
            CreateUserHandler.debug("Default application provisioning policy : " + provStatus);
            try {
                CreateUserHandler.debug("Getting application specific attributes that are configured...");
                appUserPropSet = curApp.getAttributes(lCtx);
            }
            catch (Exception e) {
                CreateUserHandler.debug("Error while retrieving application specific attributes");
                CreateUserHandler.debug(e);
            }
            CreateUserHandler.debug("Initial Application spcecific attributes:");
            CreateUserHandler.debug(appUserPropSet);
            try {
                prePlugin = new PreDataEntryPluginAdapter(lCtx, curApp, operation);
            }
            catch (NoSuchPluginException nspe) {
                CreateUserHandler.debug("No PRE data entry plugin configured for : CREATE : (" + curApp.getName() + "," + curApp.getType() + ")");
                prePlugin = null;
            }
            catch (PluginException pe) {
                prePlugin = null;
                CreateUserHandler.debug(new String[]{"ERROR on instantiating PRE data entry plugin : CREATE", pe.getMessage()});
            }
            if (prePlugin != null) {
                UserHandler.PluginResult pluginResult = this.executePrePlugin(prePlugin, appCtx, user, baseUserPropSet, appUserPropSet);
                baseUserPropSet = pluginResult.m_baseUserMod;
                appUserPropSet = pluginResult.m_appUserMod;
                provStatus = pluginResult.m_plgStat;
                provStatusMsg = pluginResult.m_plgStatMsg;
                appStats.set(0, baseUserPropSet);
            }
            provAttrName = ProvUtil.getProvStatusAttrName(curApp);
            descAttrName = ProvUtil.getProvStatusDescAttrName(curApp);
            LDIFRecord lRec = baseUserPropSet.getModProperty();
            boolean statAttrAlreadyExists = lRec.contains(provAttrName);
            if (statAttrAlreadyExists) {
                if (prePlugin != null) {
                    lRec.removeAttribute(provAttrName);
                    lRec.removeAttribute(descAttrName);
                    baseUserPropSet.addProperty(5, provAttrName, provStatus);
                    if (provStatusMsg != null) {
                        baseUserPropSet.addProperty(5, descAttrName, provStatusMsg);
                    }
                } else {
                    LDIFAttribute lattr = lRec.getAttribute(provAttrName);
                    provStatus = lattr.getValue();
                }
            } else {
                baseUserPropSet.addProperty(5, provAttrName, provStatus);
                if (provStatusMsg != null) {
                    baseUserPropSet.addProperty(5, descAttrName, provStatusMsg);
                }
            }
            if (!provStatus.equalsIgnoreCase("PROVISIONING_REQUIRED")) continue;
            appStats.add(appCtx);
            appStats.add(provStatus);
            appStats.add(provStatusMsg);
            appStats.add(appUserPropSet);
        }
        sz = appStats.size();
        int nApps = (sz - 1) / 4;
        CreateUserHandler.debug("No - " + sz);
        CreateUserHandler.debug("No. Of Applications before POST plugin : " + nApps);
        baseUserPropSet = (ModPropertySet)appStats.get(0);
        for (int i = 0; i < nApps; ++i) {
            PostDataEntryPluginAdapter postPlugin = null;
            ModPropertySet appUserPropSet = null;
            ApplicationContext appCtx = null;
            Application curApp = null;
            String provStatus = null;
            String provStatusMsg = null;
            String provAttrName = null;
            String descAttrName = null;
            appCtx = (ApplicationContext)appStats.remove(1);
            provStatus = (String)appStats.remove(1);
            provStatusMsg = (String)appStats.remove(1);
            appUserPropSet = (ModPropertySet)appStats.remove(1);
            curApp = appCtx.getApplication();
            try {
                postPlugin = new PostDataEntryPluginAdapter(lCtx, curApp, operation);
            }
            catch (NoSuchPluginException nspe) {
                postPlugin = null;
                CreateUserHandler.debug("No POST Data entry plugin configured : CREATE : (" + curApp.getName() + "," + curApp.getType() + ")");
            }
            catch (PluginException nspe) {
                postPlugin = null;
                CreateUserHandler.debug("ERROR on instantiating Post Data entry plugin : CREATE");
            }
            if (postPlugin != null) {
                UserHandler.PluginResult pluginResult = this.executePostPlugin(postPlugin, appCtx, user, baseUserPropSet, appUserPropSet, provStatus);
                baseUserPropSet = pluginResult.m_baseUserMod;
                appUserPropSet = pluginResult.m_appUserMod;
                provStatus = pluginResult.m_plgStat;
                provStatusMsg = pluginResult.m_plgStatMsg;
                appStats.set(0, baseUserPropSet);
            }
            if (provStatus.equalsIgnoreCase("PROVISIONING_REQUIRED")) {
                appStats.add(appCtx);
                appStats.add(provStatus);
                appStats.add(provStatusMsg);
                appStats.add(appUserPropSet);
            }
            LDIFRecord lRec = baseUserPropSet.getModProperty();
            provAttrName = ProvUtil.getProvStatusAttrName(curApp);
            descAttrName = ProvUtil.getProvStatusDescAttrName(curApp);
            lRec.removeAttribute(provAttrName);
            baseUserPropSet.addProperty(5, provAttrName, provStatus);
            if (provStatusMsg == null) continue;
            lRec.removeAttribute(descAttrName);
            baseUserPropSet.addProperty(5, descAttrName, provStatusMsg);
        }
        if (nApps > 0) {
            this.addProvStatusOC(baseUserPropSet);
        }
        return appStats;
    }

    private UserHandler.PluginResult executePrePlugin(PreDataEntryPluginAdapter prePlugin, ApplicationContext appCtx, IdmUser user, ModPropertySet baseAttrs, ModPropertySet appAttrs) {
        String provStatus = null;
        String pluginStatus = null;
        String pluginDescMsg = null;
        PluginStatus pluginStatusObj = null;
        ModPropertySet pluginBaseAttrs = null;
        ModPropertySet pluginAppAttrs = null;
        ModPropertySet retBaseAttrs = null;
        ModPropertySet retAppAttrs = null;
        PluginStatus defFailSafePluginObj = null;
        defFailSafePluginObj = new PluginStatus("FAILURE", "PRE Plugin did not return a status object", null);
        retBaseAttrs = baseAttrs;
        try {
            pluginStatusObj = prePlugin.process(appCtx, user, baseAttrs, appAttrs);
            if (pluginStatusObj == null) {
                pluginStatusObj = defFailSafePluginObj;
                CreateUserHandler.debug("NULL PluginStatus Object Returned From PreDataEntry..");
            }
            pluginStatus = pluginStatusObj.getExecStatus();
            CreateUserHandler.debug("PluginStatus :" + pluginStatus);
            pluginDescMsg = pluginStatusObj.getDesc();
        }
        catch (PluginException pe) {
            pluginStatus = "FAILURE";
            pluginDescMsg = pe.getMessage();
            CreateUserHandler.debug(new String[]{"PRE data entry plugin execution failure : CREATE", pluginDescMsg});
        }
        if (pluginStatus.equalsIgnoreCase("SUCCESS")) {
            pluginBaseAttrs = prePlugin.getBaseAttrMods();
            CreateUserHandler.debug("Delta Base ModAttrSet :");
            CreateUserHandler.debug(pluginBaseAttrs);
            retBaseAttrs = this.mergePropertySet(baseAttrs, pluginBaseAttrs);
            CreateUserHandler.debug("Merged Base ModAttrSet :");
            CreateUserHandler.debug(retBaseAttrs);
            provStatus = pluginStatusObj.getProvStatus();
            CreateUserHandler.debug("Provisioning status from plugin : " + provStatus);
            if (provStatus == null) {
                pluginDescMsg = "PRE Plugin did not return a provisioning status. Hence using the application default.";
                provStatus = appCtx.getApplication().getPolicy();
            }
            if (provStatus.equalsIgnoreCase("PROVISIONING_REQUIRED")) {
                pluginAppAttrs = prePlugin.getAppAttrMods();
                CreateUserHandler.debug("Delta App ModAttrSet :");
                CreateUserHandler.debug(pluginAppAttrs);
                retAppAttrs = this.mergePropertySet(appAttrs, pluginAppAttrs);
                CreateUserHandler.debug("Merged App ModAttrSet :");
                CreateUserHandler.debug(retAppAttrs);
            }
        } else {
            CreateUserHandler.debug("Plug in status NOT SUCCESS..");
            provStatus = "PROVISIONING_FAILURE";
        }
        CreateUserHandler.debug("PRE Data Entry Plugin completed. Status : " + pluginStatus);
        CreateUserHandler.debug("User Provisioning Status : " + provStatus);
        return new UserHandler.PluginResult(this, retBaseAttrs, retAppAttrs, provStatus, pluginDescMsg);
    }

    protected UserHandler.PluginResult executePostPlugin(PostDataEntryPluginAdapter postPlugin, ApplicationContext appCtx, IdmUser user, ModPropertySet baseAttrs, ModPropertySet appAttrs, String prePluginStatus) {
        String provStatus = null;
        String pluginStatus = null;
        String pluginDescMsg = null;
        PluginStatus pluginStatusObj = null;
        ModPropertySet pluginBaseAttrs = null;
        ModPropertySet pluginAppAttrs = null;
        ModPropertySet retBaseAttrs = null;
        ModPropertySet retAppAttrs = null;
        PluginStatus defFailSafePluginObj = null;
        defFailSafePluginObj = new PluginStatus("FAILURE", "POST Plugin did not return a status object", null);
        CreateUserHandler.debug("Processing Post Plug in ...");
        retBaseAttrs = baseAttrs;
        CreateUserHandler.debug("Current Base ModPropSet : ");
        CreateUserHandler.debug(baseAttrs);
        try {
            pluginStatusObj = postPlugin.process(appCtx, user, baseAttrs, appAttrs);
            if (pluginStatusObj == null) {
                pluginStatusObj = defFailSafePluginObj;
                CreateUserHandler.debug("Plugin status Object NULL..");
            }
            pluginStatus = pluginStatusObj.getExecStatus();
            CreateUserHandler.debug("Plugin Exec status : " + pluginStatus);
            pluginDescMsg = pluginStatusObj.getDesc();
        }
        catch (PluginException pe) {
            pluginStatus = "FAILURE";
            pluginDescMsg = pe.getMessage();
            CreateUserHandler.debug(new String[]{"POST data entry plugin execution failure : CREATE", pluginDescMsg});
        }
        if (pluginStatus.equalsIgnoreCase("SUCCESS")) {
            pluginBaseAttrs = postPlugin.getBaseAttrMods();
            CreateUserHandler.debug("Delta Base ModPropSet :");
            CreateUserHandler.debug(pluginBaseAttrs);
            retBaseAttrs = this.mergePropertySet(baseAttrs, pluginBaseAttrs);
            CreateUserHandler.debug("Merged Base ModPropSet :");
            CreateUserHandler.debug(retBaseAttrs);
            provStatus = pluginStatusObj.getProvStatus();
            CreateUserHandler.debug("Provisioning Status from Plugin :" + provStatus);
            if (provStatus == null) {
                pluginDescMsg = "POST Plugin did not return a provisioning status. Hence using the PRE Plugin status or the application default.";
                String string = provStatus = prePluginStatus == null ? prePluginStatus : appCtx.getApplication().getPolicy();
            }
            if (provStatus.equalsIgnoreCase("PROVISIONING_REQUIRED")) {
                pluginAppAttrs = postPlugin.getAppAttrMods();
                CreateUserHandler.debug("Delta App ModPropSet :");
                CreateUserHandler.debug(pluginAppAttrs);
                retAppAttrs = this.mergePropertySet(appAttrs, pluginAppAttrs);
                CreateUserHandler.debug("Merged App ModPropSet :");
                CreateUserHandler.debug(retAppAttrs);
            }
        } else {
            provStatus = "PROVISIONING_FAILURE";
        }
        CreateUserHandler.debug("Post Data Entry Plugin completed. Status : " + pluginStatus);
        CreateUserHandler.debug("App Prov Status : " + provStatus);
        return new UserHandler.PluginResult(this, retBaseAttrs, retAppAttrs, provStatus, pluginDescMsg);
    }

    public static void createAppUserWithPlugin(DataAccessPluginAdapter dataAccessPlugin, ApplicationContext appCtx, IdmUser idmUser, ModPropertySet baseUserPropSet, ModPropertySet appUserPropSet) throws UtilException {
        PluginStatus plgStat = null;
        PluginStatus defPlgStat = null;
        String stat = null;
        String provStat = null;
        String provStatMsg = null;
        IdmException uex = null;
        Application app = appCtx.getApplication();
        String appType = app.getType();
        String appName = app.getName();
        LdapContext dirCtx = (LdapContext)appCtx.getDirCtx();
        if (!appCtx.getCallOp().equalsIgnoreCase("CREATE")) {
            throw new IdmException("Call op CREATE expected");
        }
        defPlgStat = new PluginStatus("FAILURE", "Data Access Plugin did not return a status object", null);
        appCtx.setCallWhen("DATA_ACCESS");
        try {
            plgStat = dataAccessPlugin.process(appCtx, idmUser, baseUserPropSet, appUserPropSet);
            if (plgStat == null) {
                plgStat = defPlgStat;
            }
        }
        catch (PluginException pe) {
            plgStat = defPlgStat;
            plgStat.setDesc(pe.getMessage());
            CreateUserHandler.debug("Data access plugin execution failure");
            CreateUserHandler.debug(pe);
            uex = new IdmException(pe);
        }
        stat = plgStat.getExecStatus();
        provStat = plgStat.getProvStatus();
        provStatMsg = plgStat.getDesc();
        if (stat.equalsIgnoreCase("SUCCESS")) {
            if (provStat == null) {
                provStat = "PROVISIONING_SUCCESSFUL";
            }
        } else {
            if (provStat == null) {
                provStat = "PROVISIONING_FAILURE";
            }
            if (uex == null) {
                uex = new IdmException(provStatMsg);
            }
        }
        ProvUtil.setUserProvisioningStatus(dirCtx, Util.IDTYPE_GUID, idmUser.getGUID(), appType, appName, provStat, provStatMsg);
        if (uex != null) {
            throw uex;
        }
    }

    static void createAppUserInDefAppContainer(String userGuid, ApplicationContext appCtx, ModPropertySet appUserPropSet) throws UtilException {
        Application app = appCtx.getApplication();
        LdapContext dirCtx = (LdapContext)appCtx.getDirCtx();
        String appType = app.getType();
        String appName = app.getName();
        String container = app.getUserDataLocation();
        String provStat = "PROVISIONING_REQUIRED";
        String provStatMsg = "";
        UtilException uex = null;
        if (appUserPropSet == null) {
            CreateUserHandler.debug("Application footprint is NULL");
            ProvUtil.setUserProvisioningStatus(dirCtx, Util.IDTYPE_GUID, userGuid, appType, appName, provStat, provStatMsg);
            return;
        }
        if (container == null || container.trim().equals("") || container.trim().equalsIgnoreCase("DEFAULT")) {
            CreateUserHandler.debug("Application does not have user data container (DEFAULT)..");
            ProvUtil.setUserProvisioningStatus(dirCtx, Util.IDTYPE_GUID, userGuid, appType, appName, provStat, provStatMsg);
            return;
        }
        String dn = "orclownerguid=" + userGuid + "," + container;
        CreateUserHandler.debug("Creating the app user info - " + dn);
        appUserPropSet.addProperty(5, "orclownerguid", userGuid);
        appUserPropSet.addProperty(5, "objectclass", "orclAppSpecificUserInfo");
        String[] objectclasses = app.getObjectClasses();
        if (objectclasses != null) {
            appUserPropSet.addProperty(5, "objectclass", objectclasses);
        } else {
            CreateUserHandler.debug("No Application user Object Class...!!!");
        }
        try {
            CreateUserHandler.debug("App user footprint - ");
            CreateUserHandler.debug(appUserPropSet);
            Util.ldapAdd(dirCtx, dn, appUserPropSet);
            CreateUserHandler.debug("App user footprint created successfully..");
        }
        catch (UtilException ue) {
            CreateUserHandler.debug("Creating app user footprint failed.");
            provStat = "PROVISIONING_FAILURE";
            provStatMsg = ue.getMessage();
            uex = ue;
            if (ue.isNamingException()) {
                NamingException ne = ue.returnNamingException();
                if (ne instanceof NameAlreadyBoundException) {
                    CreateUserHandler.debug("App user footprint already exists ..");
                    try {
                        CreateUserHandler.debug("Deleting App user footprint ..");
                        Util.ldapDelete(dirCtx, dn);
                        CreateUserHandler.debug("Re-Creating App user footprint ..");
                        Util.ldapAdd(dirCtx, dn, appUserPropSet);
                        provStat = "PROVISIONING_REQUIRED";
                        provStatMsg = "";
                        uex = null;
                    }
                    catch (UtilException uee) {
                        CreateUserHandler.debug("Error while re-creating App user footprint ..");
                        provStatMsg = uee.getMessage();
                        uex = uee;
                        CreateUserHandler.debug(uex);
                    }
                } else {
                    CreateUserHandler.debug(ne);
                }
            }
            CreateUserHandler.debug(uex);
        }
        ProvUtil.setUserProvisioningStatus(dirCtx, Util.IDTYPE_GUID, userGuid, appType, appName, provStat, provStatMsg);
        if (uex != null) {
            throw uex;
        }
    }

    static void debug(Object o) {
        UtilDebug.log(32, "CreateUserHandler : ", o);
    }
}

