/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.util;

import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.plugin.ApplicationContext;
import oracle.idm.provisioning.plugin.IDataEntryPlugin;
import oracle.idm.provisioning.plugin.NoSuchPluginException;
import oracle.idm.provisioning.plugin.PluginException;
import oracle.idm.provisioning.plugin.PluginStatus;
import oracle.idm.provisioning.util.DataEntryPluginAdapter;
import oracle.idm.provisioning.util.PreDataEntryPluginAdapter;
import oracle.idm.user.IdmUser;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.UtilDebug;

public class PostDataEntryPluginAdapter
extends DataEntryPluginAdapter {
    private static int sInstanceCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PostDataEntryPluginAdapter(LdapContext lCtx, Application app, String operation) throws NoSuchPluginException, PluginException {
        String pluginName = "POST_DATA_ENTRY_" + operation.toUpperCase();
        try {
            long startTime = System.currentTimeMillis();
            long noOfMilSec = 0L;
            this.m_dataEntryPlugin = (IDataEntryPlugin)app.getPluginInstance(lCtx, pluginName);
            noOfMilSec = System.currentTimeMillis() - startTime;
            PostDataEntryPluginAdapter.debug("QUANTIFY TIME - " + app.getType() + "." + app.getName() + ".getPluginInstance() - " + noOfMilSec);
        }
        catch (Exception e) {
            throw new PluginException(e.getMessage());
        }
        if (null == this.m_dataEntryPlugin) {
            throw new NoSuchPluginException(pluginName + " not configured for (" + app.getType() + ", " + app.getName() + ")");
        }
        UtilDebug.log(32, "PostDataEntryPluginAdapter : Instantiated plugin : ", pluginName);
        this.m_oper = operation;
        Class clazz = PreDataEntryPluginAdapter.class;
        synchronized (clazz) {
        }
        UtilDebug.log(32, "INSTANCE COUNT - " + app.getType() + "." + app.getName() + "#Plugin POST DATA ENTRY " + this.m_oper, ++sInstanceCount + "");
    }

    public PluginStatus process(ApplicationContext appCtx, IdmUser idmUser, ModPropertySet baseUserAttr, ModPropertySet appUserAttr) throws PluginException {
        UtilDebug.log(32, "PostDataEntryPluginAdapter", "*********************************************************************");
        appCtx.setCallWhen("POST_DATA_ENTRY");
        Application app = appCtx.getApplication();
        UtilDebug.log(32, "PostDataEntryPluginAdapter.process", "AppCtx :" + appCtx);
        UtilDebug.log(32, "PostDataEntryPluginAdapter.process", "ImdUser :" + idmUser);
        UtilDebug.log(32, "PostDataEntryPluginAdapter", "*****Control Passing over to the POST DATA ENTRY Plug in ******");
        long startTime = System.currentTimeMillis();
        long noOfMilSec = 0L;
        PluginStatus status = this.m_dataEntryPlugin.process(appCtx, idmUser, baseUserAttr, appUserAttr);
        noOfMilSec = System.currentTimeMillis() - startTime;
        PostDataEntryPluginAdapter.debug("QUANTIFY TIME - " + app.getType() + "." + app.getName() + ".process() - " + noOfMilSec);
        UtilDebug.log(32, "PostDataEntryPluginAdapter", "*****Control Back from the POST DATA ENTRY Plug in ******");
        return status;
    }
}

