/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.util;

import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.plugin.ApplicationContext;
import oracle.idm.provisioning.plugin.IApplnAdminPlugin;
import oracle.idm.provisioning.plugin.NoSuchPluginException;
import oracle.idm.provisioning.plugin.PluginException;
import oracle.idm.provisioning.plugin.PluginStatus;
import oracle.idm.user.IdmUser;
import oracle.ldap.util.UtilDebug;

public class ApplnAdminPluginAdapter {
    protected IApplnAdminPlugin m_applnAdminPlugin = null;
    public final String ADMIN_PLUGIN_NAME = "APPLN_ADMIN_PLUGIN";

    public ApplnAdminPluginAdapter(LdapContext lCtx, Application app) throws NoSuchPluginException, PluginException {
        try {
            UtilDebug.log(32, "Instantiating Application Admin Management Plugin Adapter", "APPLN_ADMIN_PLUGIN plugin");
            this.m_applnAdminPlugin = (IApplnAdminPlugin)app.getPluginInstance(lCtx, "APPLN_ADMIN_PLUGIN");
            UtilDebug.log(32, "Application Admin Management Plugin Adapter", "Instantiated APPLN_ADMIN_PLUGIN plugin");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new PluginException(ex.getMessage());
        }
        if (null == this.m_applnAdminPlugin) {
            throw new NoSuchPluginException("APPLN_ADMIN_PLUGIN not configured for ( " + app.getType() + ", " + app.getName() + ")");
        }
    }

    public boolean isUserApplicationAdmin(ApplicationContext appCtx, IdmUser idmUser) throws PluginException {
        boolean flag = false;
        UtilDebug.log(32, "ApplnAdminPluginAdapter", "************************************************************************************");
        UtilDebug.log(32, "ApplnAdminPluginAdapter.isUserApplicationAdmin", "AppCtx" + appCtx);
        UtilDebug.log(32, "ApplnAdminPluginAdapter.isUserApplicationAdmin", "IdmUser to Verify" + idmUser);
        UtilDebug.log(32, "ApplnAdminPluginAdapter.isUserApplicationAdmin", "*****Control Passing over to the Plugin");
        PluginStatus status = this.m_applnAdminPlugin.isUserApplicationAdmin(appCtx, idmUser);
        Boolean retval = (Boolean)status.getPluginReturnObject();
        flag = retval;
        UtilDebug.log(32, "ApplnAdminPluginAdapter.isUserApplicationAdmin", "Passing control over to the Plugin");
        return flag;
    }
}

