/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.event;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.idm.provisioning.event.PlsqlAttrVal;
import oracle.ldap.util.LDIFAttribute;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class PlsqlAttr
implements ORAData,
ORADataFactory {
    static final PlsqlAttr _PlsqlAttrFactory = new PlsqlAttr();
    private String m_attrName = null;
    private int m_attrType;
    private int m_attrModOp;
    private ARRAY m_attrVals = null;
    private String m_schemaName = "";

    public static ORADataFactory getFactory() {
        return _PlsqlAttrFactory;
    }

    public PlsqlAttr() {
    }

    public PlsqlAttr(String attrName, int attrType, int attrChgType) {
        this.m_attrName = attrName;
        this.m_attrType = attrType;
        this.m_attrModOp = attrChgType;
    }

    public PlsqlAttr(Connection conn, LDIFAttribute attr, String schemaName) throws SQLException {
        boolean binary = attr.isBinary();
        int sz = attr.size();
        this.m_attrName = attr.getName();
        this.m_attrType = binary ? 1 : 0;
        this.m_attrModOp = this.alterChangeType(attr.getChangeType());
        this.m_schemaName = schemaName;
        if (sz > 0) {
            PlsqlAttrVal[] attrVals = new PlsqlAttrVal[sz];
            if (binary) {
                byte[][] bvals = attr.getByteValueArray();
                for (int i = 0; i < sz; ++i) {
                    attrVals[i] = new PlsqlAttrVal(bvals[i], this.m_schemaName);
                }
            } else {
                String[] vals = attr.getStringValueArray();
                for (int i = 0; i < sz; ++i) {
                    attrVals[i] = new PlsqlAttrVal(vals[i], this.m_schemaName);
                }
            }
            this.addValues(conn, attrVals);
        }
    }

    public void addValues(Connection conn, PlsqlAttrVal[] attrVals) throws SQLException {
        ArrayDescriptor vals = ArrayDescriptor.createDescriptor((String)(this.m_schemaName + "LDAP_ATTR_VALUE_LIST_V3"), (Connection)conn);
        this.m_attrVals = new ARRAY(vals, conn, (Object)attrVals);
    }

    public void addValues(ARRAY attrs) {
        this.m_attrVals = attrs;
    }

    public Datum toDatum(Connection c) throws SQLException {
        StructDescriptor sd = StructDescriptor.createDescriptor((String)(this.m_schemaName + "LDAP_ATTR_V3"), (Connection)c);
        Object[] attributes = new Object[]{this.m_attrName, new NUMBER(this.m_attrType), new NUMBER(this.m_attrModOp), this.m_attrVals};
        return new STRUCT(sd, c, attributes);
    }

    public ORAData create(Datum d, int sqlType) throws SQLException {
        if (d == null) {
            return null;
        }
        Datum[] attributes = ((STRUCT)d).getOracleAttributes();
        PlsqlAttr newObj = new PlsqlAttr(attributes[0] != null ? attributes[0].stringValue() : null, attributes[1] != null ? attributes[1].intValue() : 0, attributes[2] != null ? attributes[2].intValue() : 0);
        newObj.addValues((ARRAY)attributes[3]);
        return newObj;
    }

    public ARRAY getValues() {
        return this.m_attrVals;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer sbuf = new StringBuffer(nl);
        Object[] attrVals = null;
        sbuf.append(" Attr Name    : ").append(this.m_attrName).append(nl).append(" Attr Type    : ").append(this.m_attrType).append(nl).append(" Attr ChgType : ").append(this.m_attrModOp).append(nl);
        if (null != this.m_attrVals) {
            try {
                attrVals = (Object[])this.m_attrVals.getArray();
                for (int i = 0; i < attrVals.length; ++i) {
                    PlsqlAttrVal attrVal = (PlsqlAttrVal)attrVals[i];
                    sbuf.append(attrVal);
                }
            }
            catch (SQLException sqe) {
                sbuf.append(sqe.getMessage());
            }
        } else {
            sbuf.append(" Attr Values  :  None").append(nl);
        }
        sbuf.append(nl);
        return sbuf.toString();
    }

    public String getAttrName() {
        return this.m_attrName;
    }

    public int getAttrType() {
        return this.m_attrType;
    }

    public int getChgType() {
        return this.m_attrModOp;
    }

    private int alterChangeType(int chgType) {
        chgType = chgType >= 5 ? (chgType -= 5) : (chgType += 5);
        return chgType;
    }
}

