/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.event;

import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.ModPropertySet;

public class Event {
    public static final int ATTR_TYPE_STRING = 0;
    public static final int ATTR_TYPE_BINARY = 1;
    public static final int ATTR_TYPE_ENCRYPTED_STRING = 2;
    public static final int ATTR_TYPE_DATE_STRING = 3;
    public static final int ATTR_TYPE_DECRYPTED_STRING = 99;
    protected String m_eventType = null;
    protected String m_eventID = null;
    protected String m_eventSrc = null;
    protected String m_eventTime = null;
    protected String m_objectName = null;
    protected String m_objectGuid = null;
    protected String m_objectDN = null;
    protected String m_profileID = null;
    protected ModPropertySet m_changes = null;
    private String m_status;

    public Event() {
    }

    public Event(String type, String ID, String src, String time, String objName, String objGuid, String objDN, String profID) {
        this.setType(type);
        this.setID(ID);
        this.setSource(src);
        this.setTime(time);
        this.setObjName(objName);
        this.setObjGuid(objGuid);
        this.setObjDN(objDN);
        this.setProfileID(profID);
    }

    public String getType() {
        return this.m_eventType;
    }

    public void setType(String evtType) {
        this.m_eventType = evtType;
    }

    public String getID() {
        return this.m_eventID;
    }

    public void setID(String evtID) {
        this.m_eventID = evtID;
    }

    public String getSource() {
        return this.m_eventSrc;
    }

    public void setSource(String evtSrc) {
        this.m_eventSrc = evtSrc;
    }

    public String getTime() {
        return this.m_eventTime;
    }

    public void setTime(String evtTime) {
        this.m_eventTime = evtTime;
    }

    public String getObjName() {
        return this.m_objectName;
    }

    public void setObjName(String objName) {
        this.m_objectName = objName;
    }

    public String getObjGuid() {
        return this.m_objectGuid;
    }

    public void setObjGuid(String objGuid) {
        this.m_objectGuid = objGuid;
    }

    public String getObjDN() {
        return this.m_objectDN;
    }

    public void setObjDN(String objDN) {
        this.m_objectDN = objDN;
    }

    public String getProfileID() {
        return this.m_profileID;
    }

    public void setProfileID(String profID) {
        this.m_profileID = profID;
    }

    public ModPropertySet getChanges() {
        return this.m_changes;
    }

    public void setChanges(ModPropertySet chgs) {
        this.m_changes = chgs;
    }

    public void addChanges(Attributes attrs) {
        if (attrs != null) {
            NamingEnumeration<? extends Attribute> vals = attrs.getAll();
            while (vals.hasMoreElements()) {
                Attribute attr = (Attribute)vals.nextElement();
                String val = attr.getID();
                String mpval = this.m_changes.getModPropertyValue(val);
                if (mpval != null) continue;
                this.m_changes.addProperty(5, attr);
            }
        }
    }

    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    public int size() {
        if (this.m_changes != null) {
            return this.m_changes.size();
        }
        return 0;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(nl).append("--------------- Event start ---------------").append(nl).append("Event Type : ").append(this.m_eventType).append(nl).append("Event ID   : ").append(this.m_eventID).append(nl).append("Event Src  : ").append(this.m_eventSrc).append(nl).append("Event Time : ").append(this.m_eventTime).append(nl).append("Obj Name   : ").append(this.m_objectName).append(nl).append("Obj GUID   : ").append(this.m_objectGuid).append(nl).append("Obj DN     : ").append(this.m_objectDN).append(nl).append("Profile ID : ").append(this.m_profileID).append(nl);
        if (this.m_changes != null) {
            sbuf.append("--------# Attributes :" + this.m_changes.size() + "---------");
            sbuf.append(nl);
            LDIFRecord lrec = this.m_changes.getModProperty();
            for (int i = 0; i < lrec.size(); ++i) {
                LDIFAttribute attrRec = lrec.getAttribute(i);
                String attrName = attrRec.getName();
                int changeType = this.alterChangeType(attrRec.getChangeType());
                String[] values = attrRec.getStringValueArray();
                if (values == null) continue;
                for (int j = 0; j < values.length; ++j) {
                    sbuf.append("AttrName : ").append(attrName).append(nl);
                    sbuf.append("ChangeType: ").append(changeType).append(nl);
                    sbuf.append("Value: ").append(values[j]).append(nl);
                    sbuf.append(nl);
                }
            }
        }
        sbuf.append("--------------- Event End  ----------------").append(nl);
        return sbuf.toString();
    }

    private int alterChangeType(int chgType) {
        chgType = chgType >= 5 ? (chgType -= 5) : (chgType += 5);
        return chgType;
    }

    public static void main(String[] s) {
        Event evt = new Event("<type>", "<id>", "<src>", "<time>", "<objname>", "<objguid>", "<objdn>", "<profdn>");
        ModPropertySet mod = new ModPropertySet();
        mod.addProperty(5, "dc", "com");
        mod.addProperty(5, "objectClass", new String[]{"top", "domain"});
        evt.setChanges(mod);
        System.out.println(evt);
    }
}

