/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.demo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.configuration.Configuration;
import oracle.idm.provisioning.plugin.ApplicationContext;
import oracle.idm.user.IdmUser;
import oracle.idm.user.UserFactory;
import oracle.idm.user.UserFactoryBuilder;
import oracle.idm.user.UserFactoryControl;
import oracle.ldap.util.LDIFReader;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.Property;
import oracle.ldap.util.PropertySet;
import oracle.ldap.util.PropertySetCollection;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.UtilException;
import oracle.ldap.util.jndi.ConnectionUtil;

public class JndiUserSample {
    public static void handleMailApp(ApplicationContext gmmailCtx, IdmUser user) throws UtilException {
        System.out.println(" ---------- EMAIL APP ----------------");
        if (gmmailCtx != null) {
            Application gmmail = gmmailCtx.getApplication();
            DirContext ctx = gmmailCtx.getDirCtx();
            String appType = gmmail.getType();
            String appName = gmmail.getName();
            ModPropertySet appPset = new ModPropertySet();
            appPset.addProperty(5, "orclmaildomain", "oracle.com");
            appPset.addProperty(5, "orclmailquota", "40 M");
            appPset.addProperty(5, "orclmailautoreplymode", "Off");
            user.setExtendedProperties(gmmailCtx, null, appPset);
            user.setProvisioningStatus(gmmailCtx, "PROVISION_SUCCESS", "");
            System.out.println("Current Status : " + user.getProvisioningStatus(gmmailCtx));
            JndiUserSample.display(user, gmmailCtx);
            ModPropertySet gmmailModPset = new ModPropertySet();
            gmmailModPset.addProperty(7, "orclmaildomain", "touchtelindia.net");
            user.setExtendedProperties(gmmailCtx, null, gmmailModPset);
            ModPropertySet basePset = new ModPropertySet();
            basePset.addProperty(5, "sn", "Herzeleid");
            basePset.addProperty(5, "sn", "Sehhnsucht");
            basePset.addProperty(5, "sn", "Mutter");
            user.modifyAttributes(basePset);
            System.out.println("\n\nAfter modification");
            JndiUserSample.display(user, gmmailCtx);
            System.out.println(" ---------- EMAIL APP ----------------");
        }
    }

    public static void handleFilesApp(ApplicationContext filesAppCtx, IdmUser user) throws UtilException {
        System.out.println(" ---------- FILES APP ----------------");
        if (filesAppCtx != null) {
            Application filesApp = filesAppCtx.getApplication();
            String appType = filesApp.getType();
            String appName = filesApp.getName();
            ModPropertySet appPset = new ModPropertySet();
            appPset.addProperty(5, "orcluserFilesDomain", "oracle.com");
            user.setExtendedProperties(filesAppCtx, null, appPset);
            user.setProvisioningStatus(filesAppCtx, "PROVISION_FAILURE", "");
            System.out.println("Current Status : " + user.getProvisioningStatus(filesAppCtx));
            JndiUserSample.display(user, filesAppCtx);
            ModPropertySet gmmailModPset = new ModPropertySet();
            gmmailModPset.addProperty(7, "orcluserFilesDomain", "us.oracle.com");
            user.setExtendedProperties(filesAppCtx, null, gmmailModPset);
            System.out.println("\n\nAfter modification");
            JndiUserSample.display(user, filesAppCtx);
        }
        System.out.println(" ---------- FILES APP ----------------");
    }

    static void createBaseUser(UserFactory userFactory, String file) throws Exception {
        LDIFReader lread = new LDIFReader(file);
        LDIFRecord lrec = null;
        while ((lrec = lread.nextRecord()) != null) {
            ModPropertySet mpSet = new ModPropertySet();
            int sz = lrec.size();
            for (int i = 0; i < sz; ++i) {
                mpSet.addProperty(5, lrec.getAttribute(i));
            }
            userFactory.createUser(lrec.getDN(), mpSet);
        }
        lread.close();
    }

    static void createNoBaseUser(UserFactory userFactory, String file) throws Exception {
        UserFactoryControl ufc = new UserFactoryControl();
        ufc.setCreateBaseUser(false);
        userFactory.setUserFactoryControl(ufc);
        JndiUserSample.createBaseUser(userFactory, file);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage :  java oracle.idm.provisioning.demo.JndiUserSample <hostName> <port> <binddn> <passwd> <realm>");
            return;
        }
        UtilDebug.setDebugMode(32);
        String hostName = args[0];
        String port = args[1];
        String bindDn = args[2];
        String passwd = args[3];
        String realm = args[4];
        String file = null;
        if (args.length > 5) {
            file = args[5];
        }
        Configuration cfg = new Configuration(realm);
        try {
            JndiUserSample.debug("Connecting...");
            InitialLdapContext ctx = ConnectionUtil.getDefaultDirCtx(hostName, port, bindDn, passwd);
            JndiUserSample.debug("Connected...");
            UserFactory factory = UserFactoryBuilder.createUserFactory((DirContext)ctx, cfg);
            JndiUserSample.createNoBaseUser(factory, file);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public static void display(List users) {
        try {
            Iterator itr = users.iterator();
            while (itr.hasNext()) {
                IdmUser usr = (IdmUser)itr.next();
                try {
                    PropertySetCollection psc = usr.getAllProperties();
                    PropertySet pset = psc.getPropertySet(0);
                    int size = pset.size();
                    for (int i = 0; i < size; ++i) {
                        Property prop = pset.getProperty(i);
                        if (prop == null) continue;
                        int num = prop.size();
                        for (int j = 0; j < num; ++j) {
                            System.out.println(prop.getName() + ": " + prop.getValue(j));
                        }
                    }
                    System.out.println();
                }
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public static void display(IdmUser user, ApplicationContext appCtx) {
        ArrayList<IdmUser> list = new ArrayList<IdmUser>();
        list.add(user);
        DirContext ctx = appCtx.getDirCtx();
        JndiUserSample.display(list, appCtx);
    }

    public static void display(List users, ApplicationContext appCtx) {
        System.out.println("user properties:");
        DirContext ctx = appCtx.getDirCtx();
        System.out.println("-------------------------------------------------");
        try {
            Iterator itr = users.iterator();
            while (itr.hasNext()) {
                IdmUser usr = (IdmUser)itr.next();
                try {
                    PropertySetCollection psc = usr.getAllProperties();
                    PropertySet pset = psc.getPropertySet(0);
                    int size = pset.size();
                    for (int i = 0; i < size; ++i) {
                        Property prop = pset.getProperty(i);
                        if (prop == null) continue;
                        int num = prop.size();
                        for (int j = 0; j < num; ++j) {
                            System.out.println(prop.getName() + ": " + prop.getValue(j));
                        }
                    }
                    System.out.println();
                    PropertySetCollection appPsc = usr.getExtendedProperties(appCtx);
                    pset = appPsc.getPropertySet(0);
                    size = pset.size();
                    for (int i = 0; i < size; ++i) {
                        Property prop = pset.getProperty(i);
                        if (prop == null) continue;
                        int num = prop.size();
                        for (int j = 0; j < num; ++j) {
                            System.out.println(prop.getName() + ": " + prop.getValue(j));
                        }
                    }
                    System.out.println();
                }
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    private static void debug(Object obj) {
        System.out.println(obj);
    }
}

