/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.demo;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.naming.ldap.InitialLdapContext;
import oracle.idm.provisioning.approval.ApprovalPolicy;
import oracle.idm.provisioning.approval.Approvers;
import oracle.idm.provisioning.provpolicy.PolicyManager;
import oracle.idm.provisioning.provpolicy.PolicyManagerFactory;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.jndi.ConnectionUtil;

public class ApprovalPolicyAPI {
    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("Usage :  java oracle.idm.provisioning.demo.ApprovalPolicyAPI <hostName> <port> <binddn> <passwd> <app> <create/delete/both>");
            return;
        }
        UtilDebug.setDebugMode(32);
        String hostName = args[0];
        String port = args[1];
        String bindDn = args[2];
        String passwd = args[3];
        String app = args[4];
        String operation = null;
        if (args.length == 6) {
            operation = args[5];
        }
        boolean cp = true;
        boolean dp = true;
        if (operation != null) {
            if (operation.equalsIgnoreCase("create")) {
                dp = false;
            } else if (operation.equalsIgnoreCase("delete")) {
                cp = false;
            }
        }
        try {
            ApprovalPolicyAPI.debug("Connecting...");
            InitialLdapContext ctx = ConnectionUtil.getDefaultDirCtx(hostName, port, bindDn, passwd);
            ApprovalPolicyAPI.debug("Connected...");
            PolicyManager pm = PolicyManagerFactory.getPolicyManager(PolicyManager.APPROVAL_POLICY, ctx);
            System.out.println("Created policy manager");
            System.out.println("Calling getPolicyCollection....");
            List policies = pm.getPolicyCollection(app);
            System.out.println("Total policies for app " + app + " = " + policies.size());
            String polKey = ((ApprovalPolicy)policies.get(0)).getKey();
            System.out.println("Calling getTrusteeCollection....");
            List trustees = pm.getTrusteeCollection(polKey);
            ApprovalPolicyAPI.printTrustees(trustees);
            System.out.println("Calling getTrusteeCollectionByProperty....");
            List l2trustees = pm.getTrusteeCollectionByProperty(polKey, "approval_level", "2");
            ApprovalPolicyAPI.printTrustees(l2trustees);
            ApprovalPolicy ap = new ApprovalPolicy();
            ap.setName("Test1");
            ap.addOperation("CREATE_OPERATION");
            ap.setObjectFilter("(employeeType=contractors)");
            ap.setDescription("Test policy");
            ap.setApprovalLevels(2);
            System.out.println("Levels = " + ap.getApprovalLevels());
            ArrayList<Approvers> approvers = new ArrayList<Approvers>();
            Approvers a1 = new Approvers();
            a1.setDescription("Approver L1");
            a1.addUserTrustee("cn=rsteven,cn=users,dc=us,dc=oracle,dc=com");
            a1.addManagerTrustee(2);
            a1.setLevel(1);
            approvers.add(a1);
            Approvers a2 = new Approvers();
            a2.setDescription("Approver L2");
            a2.addManagerTrustee(1);
            a2.setLevel(2);
            approvers.add(a2);
            ap.setApprovers(approvers);
            pm.validatePolicy(ap);
            pm.validateTrusteeCollection(approvers);
            ApprovalPolicy newpol = null;
            if (cp) {
                System.out.println("Creating policy...");
                String newpolkey = pm.createPolicy(app, ap, approvers);
                System.out.println("Calling getPolicy....");
                newpol = (ApprovalPolicy)pm.getPolicy(newpolkey);
                ApprovalPolicyAPI.printPolicy(newpol);
                List pt = newpol.getAllTrustees();
                ApprovalPolicyAPI.printTrustees(pt);
                newpol.setApprovalLevels(3);
                System.out.println("Adding approver to policy...");
                ArrayList<Approvers> apr = new ArrayList<Approvers>();
                apr.addAll(pt);
                Approvers a3 = new Approvers();
                a3.addUserTrustee("cn=istone,cn=users,dc=us,dc=oracle,dc=com");
                a3.setLevel(3);
                apr.add(a3);
                newpol.setApprovers(apr);
                pm.modifyPolicy(newpol);
                System.out.println("Checking modified policy 1....");
                newpol = (ApprovalPolicy)pm.getPolicy(newpolkey);
                ApprovalPolicyAPI.printPolicy(newpol);
                ApprovalPolicyAPI.printTrustees(newpol.getAllTrustees());
                newpol.addOpAttr("email");
                pm.modifyPolicy(newpol);
                System.out.println("Checking modified policy 2....");
                newpol = (ApprovalPolicy)pm.getPolicy(newpolkey);
                ApprovalPolicyAPI.printPolicy(newpol);
                newpol.setObjectFilter(null);
                pm.modifyPolicy(newpol);
                System.out.println("Checking modified policy 3....");
                newpol = (ApprovalPolicy)pm.getPolicy(newpolkey);
                ApprovalPolicyAPI.printPolicy(newpol);
                newpol.setOperations(null);
                pm.modifyPolicy(newpol);
                System.out.println("Checking modified policy 4....");
                newpol = (ApprovalPolicy)pm.getPolicy(newpolkey);
                ApprovalPolicyAPI.printPolicy(newpol);
                a1 = (Approvers)apr.get(0);
                a1.addGroupTrustee("cn=LoanAgentGroup,cn=groups,dc=us,dc=oracle,dc=com");
                pm.modifyPolicy(newpol);
                System.out.println("Checking modified policy 5....");
                newpol = (ApprovalPolicy)pm.getPolicy(newpolkey);
                ApprovalPolicyAPI.printPolicy(newpol);
                ApprovalPolicyAPI.printTrustees(newpol.getAllTrustees());
                newpol.setApprovalLevels(1);
                apr.clear();
                apr.add(a1);
                newpol.setApprovers(apr);
                pm.modifyPolicy(newpol);
                System.out.println("Checking modified policy 6....");
                newpol = (ApprovalPolicy)pm.getPolicy(newpolkey);
                ApprovalPolicyAPI.printPolicy(newpol);
                ApprovalPolicyAPI.printTrustees(newpol.getAllTrustees());
            }
            if (dp) {
                if (newpol == null) {
                    System.out.println("Calling getPolicy before delete ....");
                    String uid = "orclApprovalPolicyName=Test1,cn=" + app + ",cn=applications, cn=provisioning,cn=directory integration platform,cn=products,cn=oraclecontext";
                    newpol = (ApprovalPolicy)pm.getPolicy(uid);
                    ApprovalPolicyAPI.printPolicy(newpol);
                    ApprovalPolicyAPI.printTrustees(newpol.getAllTrustees());
                }
                System.out.println("Calling deletePolicy....");
                pm.deletePolicy(newpol);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public static void printPolicy(ApprovalPolicy pol) {
        try {
            String nl = System.getProperty("line.separator");
            System.out.println("Printing policy...");
            StringBuffer buf = new StringBuffer();
            buf.append("Name = ").append(pol.getName()).append(nl);
            buf.append("Key = ").append(pol.getKey()).append(nl);
            buf.append("Descr = ").append(pol.getDescription()).append(nl);
            buf.append("Levels = ").append(pol.getApprovalLevels()).append(nl);
            buf.append("ApprovalProcess = ").append(pol.getApprovalProcess()).append(nl);
            buf.append("ObjectFilter = ").append(pol.getObjectFilter()).append(nl);
            buf.append("Operations : ").append(nl);
            List ops = pol.getOperations();
            if (ops != null) {
                ListIterator iter = ops.listIterator();
                while (iter.hasNext()) {
                    String str = (String)iter.next();
                    buf.append("    ").append(str);
                }
                buf.append(nl);
            }
            buf.append("Atrtributes : ").append(nl);
            List attrs = pol.getOpAttrs();
            if (attrs != null) {
                ListIterator iter = attrs.listIterator();
                while (iter.hasNext()) {
                    String str = (String)iter.next();
                    buf.append("    ").append(str);
                }
                buf.append(nl);
            }
            System.out.println(buf.toString());
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public static void printTrustees(List trustees) {
        System.out.println("Printing trustees...");
        if (trustees != null) {
            ListIterator iter = trustees.listIterator();
            while (iter.hasNext()) {
                Approvers ap = (Approvers)iter.next();
                ApprovalPolicyAPI.printTrustee(ap);
            }
        }
    }

    public static void printTrustee(Approvers trustee) {
        try {
            System.out.println("Printing trustee...");
            String nl = System.getProperty("line.separator");
            StringBuffer buf = new StringBuffer();
            buf.append("Name = ").append(trustee.getName()).append(nl);
            buf.append("Descr = ").append(trustee.getDescription()).append(nl);
            buf.append("Level = ").append(trustee.getLevel()).append(nl);
            buf.append("Users : ").append(nl);
            List users = trustee.getApproverUsers();
            if (users != null) {
                ListIterator iter = users.listIterator();
                while (iter.hasNext()) {
                    String str = (String)iter.next();
                    buf.append("    ").append(str);
                }
                buf.append(nl);
            }
            buf.append("Groups : ").append(nl);
            List grps = trustee.getApproverGroups();
            if (grps != null) {
                ListIterator iter = grps.listIterator();
                while (iter.hasNext()) {
                    String str = (String)iter.next();
                    buf.append("    ").append(str);
                }
                buf.append(nl);
            }
            buf.append("Managers : ").append(nl);
            List roles = trustee.getApproverRoleNames();
            if (roles != null) {
                ListIterator iter = roles.listIterator();
                while (iter.hasNext()) {
                    String str = (String)iter.next();
                    buf.append("    ").append(str);
                }
                buf.append(nl);
            }
            System.out.println(buf.toString());
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    private static void debug(Object obj) {
        System.out.println(obj);
    }
}

