/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.demo;

import java.util.Date;
import java.util.Vector;
import javax.naming.ldap.InitialLdapContext;
import oracle.idm.provisioning.configuration.Application;
import oracle.idm.provisioning.configuration.ConfigAttribute;
import oracle.idm.provisioning.configuration.Configuration;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.jndi.ConnectionUtil;

public class ApplicationSample {
    public static void main(String[] args) {
        if (args.length != 5) {
            System.out.println("Usage: java oracle.idm.provisioning.demo.ApplicationSample <realm> <host> <port> <bindDn> <passwd>");
            return;
        }
        Configuration cfg = new Configuration(args[0]);
        try {
            System.out.println("Connecting...");
            InitialLdapContext ctx = ConnectionUtil.getDefaultDirCtx(args[1], args[2], args[3], args[4]);
            System.out.println("Connected...");
            System.out.println(new Date(System.currentTimeMillis()));
            Vector apps = cfg.getAllApplications(ctx);
            System.out.println(new Date(System.currentTimeMillis()));
            Application app = cfg.getApplication(ctx, "OracleInternal", "OracleClub");
            ConfigAttribute[] attrlist = app.getAllAttributes(ctx);
            for (int i = 0; i < attrlist.length; ++i) {
                ConfigAttribute attr = attrlist[i];
                System.out.println(attr.getDefaultVal());
            }
            ModPropertySet appUserPropSet = new ModPropertySet();
            String val = "BaseBall";
            appUserPropSet.addProperty(7, "orclclubidnumber", "666");
            appUserPropSet.addProperty(7, "orclpreferredsport", val);
            appUserPropSet.addProperty(7, "orclfitnesslevel", "333");
            app.setDefaultAttrs(ctx, appUserPropSet);
            attrlist = app.getAllAttributes(ctx);
            for (int i = 0; i < attrlist.length; ++i) {
                ConfigAttribute attr = attrlist[i];
                System.out.println(attr.getDefaultVal());
            }
            if (apps == null) {
                System.out.println("No applications found ");
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }
}

