/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.configuration;

import java.io.Serializable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import oracle.idm.provisioning.configuration.ApplicationType;
import oracle.idm.provisioning.configuration.ConfigAttribute;
import oracle.idm.provisioning.configuration.ConfigCategory;
import oracle.idm.provisioning.plugin.ApplicationContext;
import oracle.idm.provisioning.plugin.NoSuchPluginException;
import oracle.idm.provisioning.util.ApplnAdminPluginAdapter;
import oracle.idm.provisioning.util.DefMgmtPluginAdapter;
import oracle.idm.user.IdmUser;
import oracle.ldap.util.ModPropertySet;
import oracle.ldap.util.UtilDebug;
import oracle.ldap.util.jndi.ConnectionUtil;

public class Application
implements Serializable {
    private String mName = null;
    private String mType = null;
    private String mAppUserDataLoc = null;
    private String mPolicy = null;
    private String mDisplayName = null;
    private ApplicationType mAppType = null;
    private boolean mManageDefaults = false;
    private boolean mManageMultiDefaults = false;
    private DefMgmtPluginAdapter mDefMgmtPlugin = null;
    private String mStatus = null;
    private long mSchedInterval;
    private String mAppProfDN = null;
    private String mDN = null;
    private String mGuid = null;

    private Application() {
    }

    public Application(LdapContext lCtx, ApplicationType appType, Attributes attrs) throws Exception {
        Attribute attr = null;
        this.mAppType = appType;
        this.mType = this.mAppType.getType();
        attr = attrs.get("orclODIPProvisioningAppName");
        this.mName = attr != null ? (String)attr.get(0) : this.mType;
        attr = attrs.get("orclApplicationUserDataLoc");
        this.mAppUserDataLoc = attr != null ? (String)attr.get(0) : "";
        attr = attrs.get("orclApplicationDefaultPolicy");
        this.mPolicy = attr != null ? (String)attr.get(0) : "";
        attr = attrs.get("orclApplicationDisplayName");
        this.mDisplayName = attr != null ? (String)attr.get(0) : "";
        attr = attrs.get("orclStatus");
        this.mStatus = attr != null ? (String)attr.get(0) : "DISABLED";
        attr = attrs.get("orclODIPProfileSchedule");
        if (attr != null) {
            try {
                this.mSchedInterval = Integer.parseInt((String)attr.get(0));
            }
            catch (NumberFormatException nfe) {
                this.mSchedInterval = -1L;
            }
        }
        if ((attr = attrs.get("orclODIPProvisioningAppGUID")) != null) {
            this.mGuid = (String)attr.get(0);
        }
        if ((attr = attrs.get("orclODIPProvisioningAppDN")) != null) {
            this.mDN = (String)attr.get(0);
        }
        String value = (attr = attrs.get("orclManageApplicationDefaults")) != null ? (String)attr.get(0) : "";
        this.mManageDefaults = value.trim().equalsIgnoreCase("true");
        try {
            this.mDefMgmtPlugin = new DefMgmtPluginAdapter(lCtx, this);
        }
        catch (NoSuchPluginException nspe) {
            Application.debug("Defaults Management Plugin NOT present");
        }
    }

    public boolean getIsManageDefaults() {
        return this.mManageDefaults;
    }

    public Application(String appName, String appType) {
        this.mName = appName.toLowerCase();
        this.mType = appType.toLowerCase();
    }

    public String getName() {
        return this.mName;
    }

    public String getType() {
        return this.mType;
    }

    public String getDN() {
        return this.mDN;
    }

    public String getGUID() {
        return this.mGuid;
    }

    public String getUserDataLocation() {
        return this.mAppUserDataLoc;
    }

    public String getPolicy() {
        return this.mPolicy;
    }

    void setAppProfileDN(String appProfDN) {
        this.mAppProfDN = appProfDN;
    }

    public void setPolicy(LdapContext lCtx, String defPolicy) throws Exception {
        if (defPolicy != null && defPolicy.equalsIgnoreCase("PROVISIONING_REQUIRED") || defPolicy.equalsIgnoreCase("PROVISIONING_NOT_REQUIRED")) {
            BasicAttributes attrs = new BasicAttributes("orclApplicationDefaultPolicy", defPolicy);
            lCtx.modifyAttributes(this.mAppProfDN, 2, (Attributes)attrs);
            this.mPolicy = defPolicy;
        }
    }

    public boolean isEnabled() {
        return this.mStatus != null && this.mStatus.equalsIgnoreCase("ENABLED");
    }

    public void disable(LdapContext lCtx) throws Exception {
        String attrVal = "DISABLED";
        BasicAttributes attrs = new BasicAttributes("orclStatus", attrVal);
        lCtx.modifyAttributes(this.mAppProfDN, 2, (Attributes)attrs);
        this.mStatus = attrVal;
    }

    public void enable(LdapContext lCtx) throws Exception {
        String attrVal = "ENABLED";
        BasicAttributes attrs = new BasicAttributes("orclStatus", attrVal);
        lCtx.modifyAttributes(this.mAppProfDN, 2, (Attributes)attrs);
        this.mStatus = attrVal;
    }

    public long getScheduleInterval() {
        return this.mSchedInterval;
    }

    public void setScheduleInterval(LdapContext lCtx, long interval) throws Exception {
        BasicAttributes attrs = new BasicAttributes("orclODIPProfileSchedule", interval + "");
        lCtx.modifyAttributes(this.mAppProfDN, 2, (Attributes)attrs);
        this.mSchedInterval = interval;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public boolean isMultipleDefaultSetsSupported(LdapContext lCtx) throws Exception {
        boolean retVal = false;
        if (this.mDefMgmtPlugin != null) {
            ApplicationContext appCtx = new ApplicationContext(lCtx, this);
            retVal = this.mDefMgmtPlugin.isMultipleDefaultSetsSupported(appCtx);
        } else {
            retVal = this.mManageMultiDefaults;
        }
        return retVal;
    }

    public String[] getDefaultSetNames(LdapContext lCtx) throws Exception {
        String[] setNames = null;
        if (this.mDefMgmtPlugin != null) {
            ApplicationContext appCtx = new ApplicationContext(lCtx, this);
            setNames = this.mDefMgmtPlugin.getDefaultSetNames(appCtx);
        } else {
            setNames = null;
        }
        return setNames;
    }

    public ModPropertySet getDefaultSet(LdapContext lCtx, String name) throws Exception {
        ModPropertySet mpSet = null;
        if (this.mDefMgmtPlugin != null) {
            ApplicationContext appCtx = new ApplicationContext(lCtx, this);
            mpSet = this.mDefMgmtPlugin.getDefaultSet(appCtx, name);
        } else {
            ConfigAttribute[] retAttrs = this.mAppType.getAllAttributes(lCtx);
            if (retAttrs != null && retAttrs.length > 0) {
                mpSet = new ModPropertySet();
                for (int i = 0; i < retAttrs.length; ++i) {
                    String val = retAttrs[i].getDefaultVal();
                    if (val == null) continue;
                    mpSet.addProperty(retAttrs[i].getName(), val);
                }
            }
        }
        return mpSet;
    }

    public String getCurrentDefaultSetName(LdapContext lCtx) throws Exception {
        String setName = null;
        if (this.mDefMgmtPlugin != null) {
            ApplicationContext appCtx = new ApplicationContext(lCtx, this);
            setName = this.mDefMgmtPlugin.getCurrentDefaultSetName(appCtx);
        } else {
            setName = null;
        }
        return setName;
    }

    public void setCurrentDefaultSetName(LdapContext lCtx, String defSetName) throws Exception {
        if (this.mDefMgmtPlugin != null) {
            ApplicationContext appCtx = new ApplicationContext(lCtx, this);
            this.mDefMgmtPlugin.setCurrentDefaultSet(appCtx, defSetName);
        }
    }

    public ModPropertySet getCurrentDefaultSet(LdapContext lCtx) throws Exception {
        ModPropertySet mpSet = null;
        String setName = null;
        setName = this.getCurrentDefaultSetName(lCtx);
        mpSet = this.getDefaultSet(lCtx, setName);
        return mpSet;
    }

    public void createDefaultSet(LdapContext lCtx, String name, ModPropertySet mpSet) throws Exception {
        if (!this.isMultipleDefaultSetsSupported(lCtx)) {
            Application.debug("Create - Multiple Default set NOT supported");
            return;
        }
        if (this.mDefMgmtPlugin != null) {
            ApplicationContext appCtx = new ApplicationContext(lCtx, this);
            appCtx.setCallOp("CREATE");
            this.mDefMgmtPlugin.setDefaultSet(appCtx, name, mpSet);
        }
    }

    public void modifyDefaultSet(LdapContext lCtx, String name, ModPropertySet mpSet) throws Exception {
        if (this.mDefMgmtPlugin != null) {
            ApplicationContext appCtx = new ApplicationContext(lCtx, this);
            appCtx.setCallOp("MODIFY");
            this.mDefMgmtPlugin.setDefaultSet(appCtx, name, mpSet);
        } else {
            this.mAppType.setDefaultAttrs(lCtx, mpSet);
        }
    }

    public void deleteDefaultSet(LdapContext lCtx, String name) throws Exception {
        if (!this.isMultipleDefaultSetsSupported(lCtx)) {
            Application.debug("Delete - Multiple Default set NOT supported");
            return;
        }
        if (this.mDefMgmtPlugin != null) {
            ApplicationContext appCtx = new ApplicationContext(lCtx, this);
            appCtx.setCallOp("DELETE");
            this.mDefMgmtPlugin.setDefaultSet(appCtx, name, null);
        }
    }

    public ConfigAttribute[] getAllAttributes() throws Exception {
        return this.getAllAttributes(null);
    }

    public ConfigAttribute[] getAllAttributes(LdapContext lCtx) throws Exception {
        ModPropertySet mpSet;
        ConfigAttribute[] retAttrs = this.mAppType.getAllAttributes(lCtx);
        if (this.mDefMgmtPlugin != null && (mpSet = this.getCurrentDefaultSet(lCtx)) != null && retAttrs != null) {
            for (int i = 0; i < retAttrs.length; ++i) {
                String val = mpSet.getModPropertyValue(retAttrs[i].getName());
                if (val == null) continue;
                retAttrs[i].setDefaultVal(val);
            }
        }
        return retAttrs;
    }

    private ConfigCategory[] getAllCategories(LdapContext lCtx) throws Exception {
        return null;
    }

    public ConfigAttribute[] getMandatoryAttributes(LdapContext lCtx) throws Exception {
        return this.mAppType.getMandatoryAttributes(lCtx);
    }

    public ConfigAttribute[] getOptionalAttributes(LdapContext lCtx) throws Exception {
        return this.mAppType.getOptionalAttributes(lCtx);
    }

    public String[] getObjectClasses() {
        return this.mAppType.getObjectClasses();
    }

    public Object getPluginInstance(LdapContext lCtx, String pName) throws Exception {
        return this.mAppType.getPluginInstance(lCtx, this.mName, pName);
    }

    public ModPropertySet getAttributes(LdapContext lCtx) throws Exception {
        return this.mAppType.getAttributes(lCtx);
    }

    public String[] getAllAttributeNames(LdapContext lCtx) throws Exception {
        return this.mAppType.getAllAttributeNames(lCtx);
    }

    public String getAppID() {
        return this.mName + '_' + this.mType;
    }

    public String getProvStatusAttrName(boolean nameAndType) {
        String attrName = "orclUserApplnProvStatus";
        attrName = nameAndType ? attrName + ";" + this.getAppID() : attrName + ";" + this.getName();
        return attrName.toLowerCase();
    }

    public void setDefaultAttrs(LdapContext lCtx, ModPropertySet pmods) throws Exception {
    }

    public void refreshAttrDefValCache(LdapContext lCtx) throws Exception {
        if (this.mDefMgmtPlugin == null) {
            this.mAppType.refreshAttrDefValCache(lCtx);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage :  java oracle.idm.provisioning.configuration.Application<hostName> <port> <binddn> <passwd> <realm>");
            return;
        }
        UtilDebug.setDebugMode(32);
        String hostName = args[0];
        String port = args[1];
        String bindDn = args[2];
        String passwd = args[3];
        String realm = args[4];
        Application.debug("Connecting...");
        InitialLdapContext ctx = ConnectionUtil.getDefaultDirCtx(hostName, port, bindDn, passwd);
        Application.debug("Connected...");
        Application.debug("-------------------------------------");
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer sbuf = new StringBuffer(nl);
        sbuf.append("Application Instance Name : " + this.getName()).append(nl).append("Application Type          : " + this.getType()).append(nl).append("Default Prov Policy       : " + this.getPolicy()).append(nl).append("User Data Location        : " + this.getUserDataLocation()).append(nl).append("Display Name              : " + this.getDisplayName()).append(nl).append("ObjectClasses             : ");
        if (this.mAppType == null) {
            return sbuf.toString();
        }
        String[] vals = this.getObjectClasses();
        for (int i = 0; vals != null && i < vals.length; ++i) {
            sbuf.append(vals[i] + " ");
        }
        sbuf.append(nl);
        return sbuf.toString();
    }

    public String getProvStatusAttr() {
        return "orclUserApplnProvStatus;" + this.getName();
    }

    public boolean equals(Object obj) {
        boolean retBool = false;
        if (obj instanceof Application) {
            Application ap = (Application)obj;
            retBool = this.mType.equalsIgnoreCase(ap.mType) && this.mName.equalsIgnoreCase(ap.mName);
        } else if (obj instanceof String) {
            String app = (String)obj;
            String curAppStr = this.mName + '_' + this.mType;
            retBool = app.equalsIgnoreCase(curAppStr.trim());
        }
        return retBool;
    }

    public boolean isUserApplicationAdmin(LdapContext ctx, IdmUser user) {
        boolean retval = false;
        try {
            String val;
            ApplnAdminPluginAdapter apAdapter = new ApplnAdminPluginAdapter(ctx, this);
            Attribute attr = user.getAttribute("orclUserApplnProvStatus;" + this.getAppID());
            if (null != attr && (val = (String)attr.get()).equalsIgnoreCase("PROVISIONING_SUCCESSFUL")) {
                retval = apAdapter.isUserApplicationAdmin(new ApplicationContext(ctx, this), user);
            }
        }
        catch (Exception ex) {
            Application.debug("Error determining Application Admin:" + ex.getMessage() + " Returning false");
            retval = false;
        }
        return retval;
    }

    static void debug(Object o) {
        UtilDebug.log(32, "Application: ", o);
    }
}

