/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.util.Hashtable;

public class RequestSearchCriteria {
    public static String CRITERIA_MATCH_ALL = "all";
    public static String CRITERIA_MATCH_ANY = "any";
    public static String CRITERIA_AND = "AND";
    public static String CRITERIA_OR = "OR";
    public static String CRITERIA_EQUAL_TO = "=";
    public static String CRITERIA_NOT_EQUAL_TO = "!";
    public static String CRITERIA_LESS_THAN = "<";
    public static String CRITERIA_GREATER_THAN = ">";
    public static String CRITERIA_NOT_GREATER_THAN = ">";
    public static String CRITERIA_NOT_LESS_THAN = ">";
    private String m_match = CRITERIA_MATCH_ANY;
    private Hashtable m_statuses = null;
    private Hashtable m_creator = null;
    private Hashtable m_apps = null;
    private Hashtable m_provOps = null;
    private Hashtable m_requestIDs = null;
    private Hashtable m_procStatuses = null;
    private Hashtable m_creationDate = null;
    private Hashtable m_lastModDate = null;

    public String getMatch() {
        return this.m_match;
    }

    public boolean isEmpty() {
        boolean rtval = false;
        if (this.m_statuses == null && this.m_apps == null && this.m_creator == null && this.m_provOps == null && this.m_procStatuses == null && this.m_creationDate == null && this.m_lastModDate == null && this.m_requestIDs == null) {
            rtval = true;
        }
        return rtval;
    }

    public Hashtable getCreatorsMap() {
        return this.m_creator;
    }

    public Hashtable getAppsMap() {
        return this.m_apps;
    }

    public Hashtable getProvOpsMap() {
        return this.m_provOps;
    }

    public Hashtable getIDsMap() {
        return this.m_requestIDs;
    }

    public Hashtable getProcStatusMap() {
        return this.m_procStatuses;
    }

    public Hashtable getCreationDateMap() {
        return this.m_creationDate;
    }

    public Hashtable getLastModDateMap() {
        return this.m_lastModDate;
    }

    public Hashtable getStatusesMap() {
        return this.m_statuses;
    }

    public void setMatchAll() {
        this.m_match = CRITERIA_MATCH_ALL;
    }

    public void setMatchAny() {
        this.m_match = CRITERIA_MATCH_ANY;
    }

    public void addStatus(String status, String match) throws IllegalArgumentException {
        if (status == null) {
            throw new IllegalArgumentException("Null status passed.");
        }
        if (!CRITERIA_EQUAL_TO.equalsIgnoreCase(match) && !CRITERIA_NOT_EQUAL_TO.equalsIgnoreCase(match)) {
            throw new IllegalArgumentException("Invalid match: " + match);
        }
        if (this.m_statuses == null) {
            this.m_statuses = new Hashtable();
        }
        this.m_statuses.put(status, match);
    }

    public void addCreator(String creator, String match) throws IllegalArgumentException {
        if (creator == null) {
            throw new IllegalArgumentException("Null creator passed.");
        }
        if (!CRITERIA_EQUAL_TO.equalsIgnoreCase(match) && !CRITERIA_NOT_EQUAL_TO.equalsIgnoreCase(match)) {
            throw new IllegalArgumentException("Invalid match: " + match);
        }
        if (this.m_creator == null) {
            this.m_creator = new Hashtable();
        }
        this.m_creator.put(creator, match);
    }

    public void addApp(String app, String match) throws IllegalArgumentException {
        if (app == null) {
            throw new IllegalArgumentException("Null app passed.");
        }
        if (!CRITERIA_EQUAL_TO.equalsIgnoreCase(match) && !CRITERIA_NOT_EQUAL_TO.equalsIgnoreCase(match)) {
            throw new IllegalArgumentException("Invalid match: " + match);
        }
        if (this.m_apps == null) {
            this.m_apps = new Hashtable();
        }
        this.m_apps.put(app, match);
    }

    public void addProvOp(String provop, String match) throws IllegalArgumentException {
        if (provop == null) {
            throw new IllegalArgumentException("Null provop passed.");
        }
        if (!CRITERIA_EQUAL_TO.equalsIgnoreCase(match) && !CRITERIA_NOT_EQUAL_TO.equalsIgnoreCase(match)) {
            throw new IllegalArgumentException("Invalid match: " + match);
        }
        if (this.m_provOps == null) {
            this.m_provOps = new Hashtable();
        }
        this.m_provOps.put(provop, match);
    }

    public void addRequestID(String id, String match) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("Null id passed.");
        }
        if (!CRITERIA_EQUAL_TO.equalsIgnoreCase(match) && !CRITERIA_NOT_EQUAL_TO.equalsIgnoreCase(match)) {
            throw new IllegalArgumentException("Invalid match: " + match);
        }
        if (this.m_requestIDs == null) {
            this.m_requestIDs = new Hashtable();
        }
        this.m_requestIDs.put(id, match);
    }

    public void addProcStatus(String procstatus, String match) throws IllegalArgumentException {
        if (procstatus == null) {
            throw new IllegalArgumentException("Null procstatus passed.");
        }
        if (!CRITERIA_EQUAL_TO.equalsIgnoreCase(match) && !CRITERIA_NOT_EQUAL_TO.equalsIgnoreCase(match)) {
            throw new IllegalArgumentException("Invalid match: " + match);
        }
        if (this.m_procStatuses == null) {
            this.m_procStatuses = new Hashtable();
        }
        this.m_procStatuses.put(procstatus, match);
    }

    public void addCreationDate(String date, String match) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("Null date passed.");
        }
        if (!CRITERIA_LESS_THAN.equalsIgnoreCase(match) && !CRITERIA_GREATER_THAN.equalsIgnoreCase(match)) {
            throw new IllegalArgumentException("Invalid match: " + match);
        }
        if (this.m_creationDate == null) {
            this.m_creationDate = new Hashtable();
        }
        this.m_creationDate.put(date, match);
    }

    public void addLastModDate(String date, String match) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("Null date passed.");
        }
        if (!CRITERIA_LESS_THAN.equalsIgnoreCase(match) && !CRITERIA_GREATER_THAN.equalsIgnoreCase(match)) {
            throw new IllegalArgumentException("Invalid match: " + match);
        }
        if (this.m_lastModDate == null) {
            this.m_lastModDate = new Hashtable();
        }
        this.m_lastModDate.put(date, match);
    }
}

