/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import oracle.idm.provisioning.approval.RequestPayload;

public class RequestOperationData {
    public static String FIELD_SEPARATOR = ":";
    public static String OBJECT_GUID = "GUID";
    public static String OBJECT_NAME = "NICKNAME";
    private String m_targetApp;
    private String m_sourceApp;
    private String m_operation;
    private String m_object;
    private ArrayList m_requestCharValues;
    private ArrayList m_operationInfo;
    private ArrayList m_objectInfo;
    private String m_creator;

    public RequestOperationData() {
        this.m_targetApp = null;
        this.m_sourceApp = null;
        this.m_operation = null;
        this.m_object = null;
        this.m_creator = null;
        this.m_requestCharValues = null;
        this.m_operationInfo = null;
        this.m_objectInfo = null;
    }

    public RequestOperationData(RequestOperationData rdata) {
        if (rdata != null) {
            ListIterator itr;
            this.m_targetApp = rdata.m_targetApp;
            this.m_sourceApp = rdata.m_sourceApp;
            this.m_operation = rdata.m_operation;
            this.m_object = rdata.m_object;
            this.m_creator = rdata.m_creator;
            if (rdata.m_requestCharValues != null) {
                this.m_requestCharValues = new ArrayList();
                itr = rdata.m_requestCharValues.listIterator();
                while (itr.hasNext()) {
                    RequestPayload val = (RequestPayload)itr.next();
                    this.m_requestCharValues.add(val);
                }
            }
            if (rdata.m_operationInfo != null) {
                this.m_operationInfo = new ArrayList();
                itr = rdata.m_operationInfo.listIterator();
                while (itr.hasNext()) {
                    this.m_operationInfo.add((String)itr.next());
                }
            }
            if (rdata.m_objectInfo != null) {
                this.m_objectInfo = new ArrayList();
                itr = rdata.m_objectInfo.listIterator();
                while (itr.hasNext()) {
                    this.m_objectInfo.add((String)itr.next());
                }
            }
        }
    }

    public String getTargetApp() {
        return this.m_targetApp;
    }

    public String getSourceApp() {
        return this.m_sourceApp;
    }

    public String getOperation() {
        return this.m_operation;
    }

    public String getObjectKey() {
        return this.m_object;
    }

    public String getOriginator() {
        return this.m_creator;
    }

    public List getRequestPayload() {
        List rtval = null;
        if (this.m_requestCharValues != null) {
            rtval = Collections.unmodifiableList(this.m_requestCharValues);
        }
        return rtval;
    }

    public List getOperationInfo() {
        List rtval = null;
        if (this.m_operationInfo != null) {
            rtval = Collections.unmodifiableList(this.m_operationInfo);
        }
        return rtval;
    }

    public List getObjectInfo() {
        List rtval = null;
        if (this.m_objectInfo != null) {
            rtval = Collections.unmodifiableList(this.m_objectInfo);
        }
        return rtval;
    }

    public String getObjectInfoVal(String key) {
        String ret = null;
        if (this.m_objectInfo != null) {
            ListIterator itr = this.m_objectInfo.listIterator();
            while (itr.hasNext()) {
                String pair = (String)itr.next();
                if (!pair.startsWith(key)) continue;
                ret = pair.substring(key.length() + 1, pair.length());
                break;
            }
        }
        return ret;
    }

    public List getUniqueRequestAttrs() {
        ArrayList<String> list = null;
        if (this.m_requestCharValues != null) {
            list = new ArrayList<String>();
            ListIterator itr = this.m_requestCharValues.listIterator();
            while (itr.hasNext()) {
                RequestPayload val = (RequestPayload)itr.next();
                String attr = val.getAttrName();
                if (list.indexOf(attr) != -1) continue;
                list.add(val.getAttrName());
            }
        }
        return list;
    }

    public List getRequestPayload(String name) {
        ArrayList<RequestPayload> list = null;
        if (this.m_requestCharValues != null && name != null) {
            list = new ArrayList<RequestPayload>();
            ListIterator itr = this.m_requestCharValues.listIterator();
            while (itr.hasNext()) {
                RequestPayload val = (RequestPayload)itr.next();
                if (!name.equalsIgnoreCase(val.getAttrName())) continue;
                list.add(new RequestPayload(val));
            }
        }
        return list;
    }

    public void setTargetApp(String app) {
        this.m_targetApp = app;
    }

    public void setSourceApp(String app) {
        this.m_sourceApp = app;
    }

    public void setOperation(String operation) {
        this.m_operation = operation;
    }

    public void setObjectKey(String object) {
        this.m_object = object;
    }

    public void setCreator(String god) {
        this.m_creator = god;
    }

    public void addOperationInfo(String info) {
        if (info != null) {
            if (this.m_operationInfo == null) {
                this.m_operationInfo = new ArrayList();
            }
            this.m_operationInfo.add(info);
        }
    }

    public void addObjectInfo(String key, String val) {
        if (key != null) {
            if (this.m_objectInfo == null) {
                this.m_objectInfo = new ArrayList();
            }
            String info = key + FIELD_SEPARATOR + val;
            this.m_objectInfo.add(info);
        }
    }

    public void addObjectInfo(String info) {
        if (info != null) {
            if (this.m_objectInfo == null) {
                this.m_objectInfo = new ArrayList();
            }
            this.m_objectInfo.add(info);
        }
    }

    public void addRequestPayload(RequestPayload req) {
        if (req != null) {
            if (this.m_requestCharValues == null) {
                this.m_requestCharValues = new ArrayList();
            }
            this.m_requestCharValues.add(req);
        }
    }

    public String toString() {
        int i;
        StringBuffer strbuf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        strbuf.append(nl).append("------ Request Operation Data ------").append(nl).append("Target App : ").append(this.m_targetApp).append(nl).append("Source App : ").append(this.m_sourceApp).append(nl).append("Operation  : ").append(this.m_operation).append(nl).append("Obj DN     : ").append(this.m_object).append(nl).append("Creator : ").append(this.m_creator).append(nl);
        strbuf.append("Op Info    : ").append(nl);
        if (this.m_operationInfo != null) {
            for (i = 0; i < this.m_operationInfo.size(); ++i) {
                strbuf.append("             ");
                strbuf.append(this.m_operationInfo.get(i)).append(nl);
            }
        }
        strbuf.append("Object Info: ").append(nl);
        if (this.m_objectInfo != null) {
            for (i = 0; i < this.m_objectInfo.size(); ++i) {
                strbuf.append("             ");
                strbuf.append(this.m_objectInfo.get(i)).append(nl);
            }
        }
        if (this.m_requestCharValues != null) {
            for (i = 0; i < this.m_requestCharValues.size(); ++i) {
                strbuf.append("             ");
                strbuf.append(this.m_requestCharValues.get(i).toString()).append(nl);
            }
        }
        return strbuf.toString();
    }
}

