/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.TimeZone;
import oracle.idm.provisioning.approval.RequestOperationData;
import oracle.idm.provisioning.approval.RequestPayload;
import oracle.idm.provisioning.approval.RequestProcessingHistory;
import oracle.ldap.util.UtilDebug;

public class Request {
    public static String REQUEST_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static String REQUEST_DATE_TIMEZONE = "UTC";
    public static String SRCH_REQUEST_STATUS = "requestStatus";
    public static String SRCH_REQUEST_PROC_STATUS = "requestProcStatus";
    public static String SRCH_REQUEST_CREATE_DATE = "requestCreateDate";
    public static String SRCH_REQUEST_OPERATION = "requestOperation";
    public static String SRCH_REQUEST_TARGET_APP = "requestTargetApp";
    public static String SRCH_REQUEST_APPROVER = "requestApprover";
    public static String SRCH_REQUEST_CREATOR = "requestCreator";
    public static String SRCH_REQUEST_USER_ROLE = "requetUserRole";
    public static int REQUEST_OPERATION_DATA = 1;
    public static int REQUEST_APPROVAL_DATA = 2;
    public static int REQUEST_POLICY_DATA = 4;
    public static int REQUEST_ALL_DATA = 7;
    public static String REQUEST_PENDING_APPROVAL = "PENDING_APPROVAL";
    public static String REQUEST_APPROVED = "APPROVED";
    public static String REQUEST_REJECTED = "REJECTED";
    public static String REQUEST_CANCELLED = "CANCELLED";
    public static String PROCESSING_ERROR = "PROCESSING_ERROR";
    public static String CREATION_NOTIFICATION_PENDING = "CREATION_NOTIFICATION_PENDING";
    public static String COMPLETION_NOTIFICATION_PENDING = "COMPLETION_NOTIFICATION_PENDING";
    public static String APPLICATION_NOTIFICATION_PENDING = "APPLICATION_NOTIFICATION_PENDING";
    public static String APPROVAL_NOTIFICATION_PENDING = "APPROVAL_NOTIFICATION_PENDING";
    public static String REJECTION_NOTIFICATION_PENDING = "REJECTION_NOTIFICATION_PENDING";
    private String m_id = null;
    private String m_status = null;
    private String m_processingStatus = null;
    private ArrayList m_processors = new ArrayList();
    private RequestOperationData m_reqData = null;
    private int m_currApprLevel = 0;
    private int m_totalApprLevels = 1;
    private String m_approvalPolicy = null;
    private ArrayList m_approverUids = null;
    private ArrayList m_approverGroups = null;
    private Date m_creationDate = null;
    private Date m_lastModDate = null;

    public String getID() {
        return this.m_id;
    }

    public String getStatus() {
        return this.m_status;
    }

    public String getProcessingStatus() {
        return this.m_processingStatus;
    }

    public String getOriginator() {
        return this.m_reqData.getOriginator();
    }

    public List getProcessors() {
        List rtval = null;
        if (this.m_processors != null) {
            rtval = Collections.unmodifiableList(this.m_processors);
        }
        return rtval;
    }

    public RequestOperationData getRequestOpData() {
        return this.m_reqData;
    }

    public int getCurrentApprovalLevel() {
        return this.m_currApprLevel;
    }

    public int getTotalApprovalLevels() {
        return this.m_totalApprLevels;
    }

    public String getApprovalPolicyKey() {
        return this.m_approvalPolicy;
    }

    public List getApproverUids() {
        List rtval = null;
        if (this.m_approverUids != null) {
            rtval = Collections.unmodifiableList(this.m_approverUids);
        }
        return rtval;
    }

    public List getApproverGroups() {
        List rtval = null;
        if (this.m_approverGroups != null) {
            rtval = Collections.unmodifiableList(this.m_approverGroups);
        }
        return rtval;
    }

    public Date getRequestCreationDate() {
        return this.m_creationDate;
    }

    public Date getRequestLastModDate() {
        return this.m_lastModDate;
    }

    public void setID(String id) {
        this.m_id = id;
    }

    public void setStatus(String status) throws IllegalArgumentException {
        if (!Request.isStatusValid(status)) {
            throw new IllegalArgumentException("Invalid status");
        }
        this.m_status = status;
    }

    public void clearProcessingStatus() {
        this.m_processingStatus = null;
    }

    public void setProcessingStatus(String status) throws IllegalArgumentException {
        if (!Request.isProcessingStatusValid(status)) {
            throw new IllegalArgumentException("Invalid processing status");
        }
        this.m_processingStatus = status;
    }

    public void setCreationDate(String date) {
        if (date != null && date.length() > 0) {
            SimpleDateFormat format = new SimpleDateFormat(REQUEST_DATE_FORMAT);
            TimeZone tz = TimeZone.getTimeZone(REQUEST_DATE_TIMEZONE);
            format.setTimeZone(tz);
            try {
                this.m_creationDate = format.parse(date);
            }
            catch (ParseException ex) {
                String msg = "Parse exception while parsing date: " + date + ", exception: " + ex.getMessage();
                UtilDebug.log(127, "Request.setCreationDate:", msg);
            }
        }
    }

    public void setLastModDate(String date) {
        if (date != null && date.length() > 0) {
            SimpleDateFormat format = new SimpleDateFormat(REQUEST_DATE_FORMAT);
            TimeZone tz = TimeZone.getTimeZone(REQUEST_DATE_TIMEZONE);
            format.setTimeZone(tz);
            try {
                this.m_lastModDate = format.parse(date);
            }
            catch (ParseException ex) {
                String msg = "Parse exception while parsing date: " + date + ", exception: " + ex.getMessage();
                UtilDebug.log(127, "Request.setLastModDate:", msg);
            }
        }
    }

    public void setRequestOpData(RequestOperationData rdata) {
        this.m_reqData = new RequestOperationData(rdata);
    }

    public void setCurrentApprovalLevel(int level) {
        this.m_currApprLevel = level;
    }

    public void setTotalApprovalLevels(int levels) {
        this.m_totalApprLevels = levels;
    }

    public void setApprovalPolicyKey(String pol) {
        this.m_approvalPolicy = pol;
    }

    public void addApproverUid(String dn) {
        if (this.m_approverUids == null) {
            this.m_approverUids = new ArrayList();
        }
        this.m_approverUids.add(dn);
    }

    public void addApproverGroup(String dn) {
        if (this.m_approverGroups == null) {
            this.m_approverGroups = new ArrayList();
        }
        this.m_approverGroups.add(dn);
    }

    public void setApproverUids(List users) {
        this.m_approverUids = users == null ? null : new ArrayList(users);
    }

    public void setApproverGroups(List groups) {
        this.m_approverGroups = groups == null ? null : new ArrayList(groups);
    }

    public void setRequestCreationDate(Date date) {
        this.m_creationDate = date;
    }

    public void setLastModDate(Date date) {
        this.m_lastModDate = date;
    }

    public void setTargetApp(String app) {
        if (this.m_reqData == null) {
            this.m_reqData = new RequestOperationData();
        }
        this.m_reqData.setTargetApp(app);
    }

    public void setSourceApp(String app) {
        if (this.m_reqData == null) {
            this.m_reqData = new RequestOperationData();
        }
        this.m_reqData.setSourceApp(app);
    }

    public void setOperation(String operation) {
        if (this.m_reqData == null) {
            this.m_reqData = new RequestOperationData();
        }
        this.m_reqData.setOperation(operation);
    }

    public void setObjectKey(String object) {
        if (this.m_reqData == null) {
            this.m_reqData = new RequestOperationData();
        }
        this.m_reqData.setObjectKey(object);
    }

    public void setCreator(String god) {
        this.m_reqData.setCreator(god);
    }

    public void addProcessor(RequestProcessingHistory processor) {
        if (processor != null) {
            this.m_processors.add(processor);
        }
    }

    public void addProcessor(String processor) {
        if (processor != null) {
            this.m_processors.add(new RequestProcessingHistory(processor));
        }
    }

    public void addOperationInfo(String info) {
        if (this.m_reqData == null) {
            this.m_reqData = new RequestOperationData();
        }
        this.m_reqData.addOperationInfo(info);
    }

    public void addObjectInfo(String key, String val) {
        if (this.m_reqData == null) {
            this.m_reqData = new RequestOperationData();
        }
        this.m_reqData.addObjectInfo(key, val);
    }

    public void addObjectInfo(String info) {
        if (this.m_reqData == null) {
            this.m_reqData = new RequestOperationData();
        }
        this.m_reqData.addObjectInfo(info);
    }

    public void addRequestPayload(RequestPayload req) {
        if (this.m_reqData == null) {
            this.m_reqData = new RequestOperationData();
        }
        this.m_reqData.addRequestPayload(req);
    }

    public static boolean isStatusValid(String status) {
        boolean ret = false;
        if (status != null && (status.equalsIgnoreCase(REQUEST_PENDING_APPROVAL) || status.equalsIgnoreCase(REQUEST_APPROVED) || status.equalsIgnoreCase(REQUEST_REJECTED) || status.equalsIgnoreCase(REQUEST_CANCELLED) || status.equalsIgnoreCase(PROCESSING_ERROR))) {
            ret = true;
        }
        return ret;
    }

    public static boolean isProcessingStatusValid(String status) {
        boolean ret = false;
        if (status != null) {
            if (status.equalsIgnoreCase(CREATION_NOTIFICATION_PENDING) || status.equalsIgnoreCase(COMPLETION_NOTIFICATION_PENDING) || status.equalsIgnoreCase(APPROVAL_NOTIFICATION_PENDING) || status.equalsIgnoreCase(REJECTION_NOTIFICATION_PENDING)) {
                ret = true;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public String toString() {
        String str;
        ListIterator iter;
        StringBuffer strbuf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        strbuf.append(nl).append("-------------- Request --------------").append(nl).append("Id         : ").append(this.m_id).append(nl).append("Status     : ").append(this.m_status).append(nl).append("ProcStatus : ").append(this.m_processingStatus).append(nl).append("Curr Level : ").append(this.m_currApprLevel).append(nl).append("Total Levels : ").append(this.m_totalApprLevels).append(nl).append("Policy : ").append(this.m_approvalPolicy).append(nl);
        strbuf.append("Approver Uids : ").append(nl);
        if (this.m_approverUids != null) {
            iter = this.m_approverUids.listIterator();
            while (iter.hasNext()) {
                str = (String)iter.next();
                strbuf.append("    ").append(str);
            }
            strbuf.append(nl);
        }
        strbuf.append("Approver Groups : ").append(nl);
        if (this.m_approverGroups != null) {
            iter = this.m_approverUids.listIterator();
            while (iter.hasNext()) {
                str = (String)iter.next();
                strbuf.append("    ").append(str);
            }
            strbuf.append(nl);
        }
        strbuf.append(this.m_reqData.toString()).append(nl);
        return strbuf.toString();
    }
}

