/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.util.List;
import java.util.ListIterator;
import oracle.idm.provisioning.approval.IOperationInfo;

public class ProvOperationInfo
implements IOperationInfo {
    public static String CHANGE_TYPE = "CHANGE_TYPE:";
    public static String EVENT_ID = "EVENT_ID:";
    public static String EVENT_CREATION_TIME = "EVENT_CREATION_TIME:";
    public static String PROFILE_NAME = "PROFILE_NAME:";
    public static String UPDATE_USER_PROFILE = "UPDATE_USER_PROFILE:";
    public static String PROVOP_VAL_TRUE = "true";

    public String formatOperationInfo(String key, Object info) throws IllegalArgumentException {
        if (key == null || info == null) {
            return null;
        }
        String ret = null;
        ret = key.equalsIgnoreCase(CHANGE_TYPE) ? this.formatChangeType((String)info) : this.formatStringKey(key, (String)info);
        return ret;
    }

    public Object extractOperationInfo(List input, String name) {
        String ret = null;
        if (input != null && name != null) {
            ListIterator itr = input.listIterator();
            while (itr.hasNext()) {
                String str = (String)itr.next();
                if (!str.startsWith(name)) continue;
                ret = str.substring(name.length(), str.length());
                break;
            }
        }
        return ret;
    }

    private String formatChangeType(String input) {
        int chgType = 3;
        try {
            Integer chgitgr = new Integer(input.trim());
            chgType = chgitgr;
        }
        catch (NumberFormatException ex) {
            String msg = "Illegal input to formatOperationInfo: " + ex.getMessage();
            throw new IllegalArgumentException(msg);
        }
        if (chgType != 1 && chgType != 2 && chgType != 3 && chgType != 4 && chgType != 5) {
            String msg = "Invalid changetype in record: " + chgType;
            throw new IllegalArgumentException(msg);
        }
        String str = CHANGE_TYPE + chgType;
        return str;
    }

    private String formatStringKey(String key, String input) {
        return key + input;
    }
}

