/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.util.Enumeration;
import oracle.idm.provisioning.approval.RequestOperationData;
import oracle.idm.provisioning.approval.RequestPayload;
import oracle.ldap.util.LDIFAttribute;
import oracle.ldap.util.LDIFRecord;
import oracle.ldap.util.ModPropertySet;

public class JndiApprovalUtils {
    public static void addRequestPayload(RequestOperationData req, ModPropertySet modset) {
        if (modset == null || req == null) {
            return;
        }
        LDIFRecord rec = modset.getModProperty();
        Enumeration attrs = null;
        if (rec != null) {
            attrs = rec.getAll();
        }
        if (attrs != null) {
            while (attrs.hasMoreElements()) {
                String[] attrvals;
                LDIFAttribute attr = (LDIFAttribute)attrs.nextElement();
                String name = attr.getName();
                int chgtype = attr.getChangeType();
                if (attr.isBinary() || (attrvals = attr.getStringValueArray()) == null) continue;
                for (int i = 0; i < attrvals.length; ++i) {
                    RequestPayload charval = new RequestPayload(i, name, String.valueOf(chgtype), attrvals[i]);
                    req.addRequestPayload(charval);
                }
            }
        }
    }
}

