/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import oracle.idm.policy.IPolicyTrusteeCollection;
import oracle.idm.provisioning.approval.ApproverTrustee;
import oracle.ldap.util.UtilDebug;

public class Approvers
implements Comparable,
IPolicyTrusteeCollection {
    public static String MGR_ROLE_NAME = "manager";
    private String m_name = null;
    private ArrayList m_users = new ArrayList();
    private ArrayList m_grps = new ArrayList();
    private ArrayList m_roleNames = new ArrayList();
    private int m_level = 0;
    private String m_description = null;

    public void copyTrusteeCollection(IPolicyTrusteeCollection tc) throws IllegalArgumentException {
        List roles;
        List grps;
        if (tc == null) {
            String msg = "Null trustee collection.";
            UtilDebug.log(127, "Approvers:copyTrusteeCollection:", msg);
            throw new IllegalArgumentException(msg);
        }
        this.m_name = tc.getName();
        String al = tc.getProperty("approval_level");
        int level = 0;
        try {
            level = Integer.parseInt(al);
        }
        catch (NumberFormatException ex) {
            String msg = "Invalid value for TRUSTEE_COLLECTION_PROPERTY_APPROVAL_LEVEL" + al + ", can not proceed further. Exception: " + ex.getMessage();
            UtilDebug.log(127, "Approvers:copyTrusteeCollection:", msg);
            throw new IllegalArgumentException(msg);
        }
        this.setLevel(level);
        List users = tc.getTrusteesByType("user");
        if (users != null) {
            ListIterator iter = users.listIterator();
            while (iter.hasNext()) {
                ApproverTrustee user = (ApproverTrustee)iter.next();
                this.addUserTrustee(user.getID());
            }
        }
        if ((grps = tc.getTrusteesByType("group")) != null) {
            ListIterator iter = grps.listIterator();
            while (iter.hasNext()) {
                ApproverTrustee grp = (ApproverTrustee)iter.next();
                this.addGroupTrustee(grp.getID());
            }
        }
        if ((roles = tc.getTrusteesByType("manager")) != null) {
            ListIterator iter = roles.listIterator();
            while (iter.hasNext()) {
                ApproverTrustee role = (ApproverTrustee)iter.next();
                this.addManagerTrustee(role.getManagerLevel());
            }
        }
    }

    public String getName() {
        return this.m_name;
    }

    public List getApproverUsers() {
        List rtval = null;
        if (this.m_users != null) {
            rtval = Collections.unmodifiableList(this.m_users);
        }
        return rtval;
    }

    public List getApproverGroups() {
        List rtval = null;
        if (this.m_grps != null) {
            rtval = Collections.unmodifiableList(this.m_grps);
        }
        return rtval;
    }

    public List getApproverRoleNames() {
        List rtval = null;
        if (this.m_roleNames != null) {
            rtval = Collections.unmodifiableList(this.m_roleNames);
        }
        return rtval;
    }

    public String getDescription() {
        return this.m_description;
    }

    public List getTrusteesByType(String type) {
        ArrayList<ApproverTrustee> ret;
        block6: {
            List lst;
            block8: {
                block7: {
                    ret = null;
                    if (type == null) break block6;
                    if (!type.equalsIgnoreCase("user")) break block7;
                    List lst2 = this.getApproverUsers();
                    if (lst2 == null) break block6;
                    ret = new ArrayList<ApproverTrustee>();
                    ListIterator iter = lst2.listIterator();
                    while (iter.hasNext()) {
                        String val = (String)iter.next();
                        ApproverTrustee trustee = new ApproverTrustee("user", val, 0);
                        ret.add(trustee);
                    }
                    break block6;
                }
                if (!type.equalsIgnoreCase("group")) break block8;
                List lst3 = this.getApproverGroups();
                if (lst3 == null) break block6;
                ret = new ArrayList();
                ListIterator iter = lst3.listIterator();
                while (iter.hasNext()) {
                    String val = (String)iter.next();
                    ApproverTrustee trustee = new ApproverTrustee("group", val, 0);
                    ret.add(trustee);
                }
                break block6;
            }
            if (type.equalsIgnoreCase("manager") && (lst = this.getApproverRoleNames()) != null) {
                ret = new ArrayList();
                ListIterator iter = lst.listIterator();
                while (iter.hasNext()) {
                    String val = (String)iter.next();
                    int level = 0;
                    try {
                        level = Approvers.getRoleLevel(val);
                    }
                    catch (NumberFormatException ex) {
                        String msg = "Invalid manager level: " + val + " ,ignoring trustee.";
                        UtilDebug.log(127, "Approvers:getTrusteesByProperty:", msg);
                    }
                    ApproverTrustee trustee = new ApproverTrustee("manager", MGR_ROLE_NAME, level);
                    ret.add(trustee);
                }
            }
        }
        return ret;
    }

    public int getLevel() {
        return this.m_level;
    }

    public String getProperty(String prop) {
        String ret = null;
        if (prop != null && prop.equalsIgnoreCase("approval_level")) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.m_level);
            ret = buf.toString();
        }
        return ret;
    }

    public List getPropertyNames() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("approval_level");
        return ret;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setDescription(String descr) {
        this.m_description = descr;
    }

    public void addUserTrustee(String user) {
        if (user != null) {
            this.m_users.add(user);
        }
    }

    public void addGroupTrustee(String grp) {
        if (grp != null) {
            this.m_grps.add(grp);
        }
    }

    public void addManagerTrustee(int level) throws IllegalArgumentException {
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid manager level: " + level);
        }
        this.m_roleNames.add(MGR_ROLE_NAME + "(" + level + ")");
    }

    public void setLevel(int level) {
        this.m_level = level;
    }

    public static int getRoleLevel(String name) throws NumberFormatException, IllegalArgumentException {
        if (!name.startsWith(MGR_ROLE_NAME)) {
            throw new IllegalArgumentException("Don't know how to resolve role " + name);
        }
        int index = name.indexOf(41, MGR_ROLE_NAME.length() + 1);
        String str = name.substring(MGR_ROLE_NAME.length() + 1, index);
        int rtval = Integer.parseInt(str.trim());
        return rtval;
    }

    public void deleteUserTrustee(String id) {
        if (id != null && this.m_users != null) {
            ListIterator iter = this.m_users.listIterator();
            int index = 0;
            while (iter.hasNext()) {
                String val = (String)iter.next();
                if (id.equalsIgnoreCase(val)) {
                    this.m_users.remove(index);
                    break;
                }
                ++index;
            }
        }
    }

    public void deleteGroupTrustee(String id) {
        if (id != null && this.m_grps != null) {
            ListIterator iter = this.m_grps.listIterator();
            int index = 0;
            while (iter.hasNext()) {
                String val = (String)iter.next();
                if (id.equalsIgnoreCase(val)) {
                    this.m_grps.remove(index);
                    break;
                }
                ++index;
            }
        }
    }

    public void deleteManagerTrustee(int level) {
        if (this.m_roleNames != null) {
            String deleteThis = MGR_ROLE_NAME + "(" + level + ")";
            ListIterator iter = this.m_roleNames.listIterator();
            int index = 0;
            while (iter.hasNext()) {
                String mgr = (String)iter.next();
                if (deleteThis.equalsIgnoreCase(mgr)) {
                    this.m_roleNames.remove(index);
                    break;
                }
                ++index;
            }
        }
    }

    public void setProperty(String name, String value) throws IllegalArgumentException {
        if (name != null && name.equalsIgnoreCase("approval_level") && value != null) {
            try {
                int level = Integer.parseInt(value);
                this.setLevel(level);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
    }

    public int compareTo(Object obj) {
        Approvers other = (Approvers)obj;
        int rtval = this.m_level < other.m_level ? -1 : (this.m_level == other.m_level ? 0 : 1);
        return rtval;
    }

    public void addApproverRoleByName(String role) {
        if (role != null) {
            this.m_roleNames.add(role);
        }
    }
}

