/*
 * Decompiled with CFR 0.152.
 */
package oracle.idm.provisioning.approval;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.idm.provisioning.approval.ApprovalPolicy;
import oracle.idm.provisioning.approval.ApprovalPolicyDAO;
import oracle.ldap.util.UtilDebug;

public class ApprovalPolicyLDAPDAO
extends ApprovalPolicyDAO {
    private static String objClassAttr = "objectclass";
    private static String approvalPolicyClass = "orclapprovalpolicy";
    private static String topClass = "top";
    private static String apName = "orclApprovalPolicyName";
    private static String apProvOperation = "orclprovoperation";
    private static String apApprovalLevels = "orclapprovallevels";
    private static String apProvOperationAttrs = "orclprovoperationattrs";
    private static String apProvObjectFilter = "orclprovobjectfilter";
    private static String apApprovalProcess = "orclapprovalprocess";
    private static String apDescription = "orclapprovaldescription";
    private static String basicApprovalPolicyFilter = "(objectclass=orclapprovalpolicy)";
    private static String profileName = "cn";
    private DirContext m_dirCtx;
    private String m_policyBase;

    public ApprovalPolicyLDAPDAO(DirContext ctx, String policyBase) {
        this.m_dirCtx = ctx;
        this.m_policyBase = policyBase;
    }

    public List getApprovalPolicies(String appName, String operation) throws NamingException, IllegalArgumentException {
        ArrayList<ApprovalPolicy> list = null;
        if (this.m_dirCtx == null) {
            NamingException nex = new NamingException("Invalid directory context.");
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.getApprovalPolicies:", nex);
            throw nex;
        }
        if (appName != null) {
            String base = profileName + "=" + appName + "," + this.m_policyBase;
            String filter = null;
            filter = operation != null ? "(&(" + objClassAttr + "=" + approvalPolicyClass + ")(|(" + apProvOperation + "=" + operation + ")(" + apProvOperation + "=" + "all" + ")))" : "(" + objClassAttr + "=" + approvalPolicyClass + ")";
            SearchControls ctl = new SearchControls();
            ctl.setSearchScope(1);
            NamingEnumeration<SearchResult> results = null;
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.getApprovalPolicies:", "Searching with base: " + base + ", filter: " + filter);
            results = this.m_dirCtx.search(base, filter, ctl);
            if (results != null) {
                list = new ArrayList<ApprovalPolicy>();
                while (results.hasMore()) {
                    SearchResult res = (SearchResult)results.nextElement();
                    ApprovalPolicy pol = this.createApprovalPolicy(res, base);
                    list.add(pol);
                }
                UtilDebug.log(127, "ApprovalPolicyLDAPDAO.getApprovalPolicies:", "Number of results fetched: " + list.size());
            }
        } else {
            IllegalArgumentException ex = new IllegalArgumentException("Null application name");
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.getApprovalPolicies:", ex);
            throw ex;
        }
        return list;
    }

    public ApprovalPolicy getApprovalPolicy(String id) throws NamingException, IllegalArgumentException {
        ApprovalPolicy rtval = null;
        if (this.m_dirCtx == null) {
            NamingException nex = new NamingException("Invalid directory context.");
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.getApprovalPolicy:", nex);
            throw nex;
        }
        if (id == null) {
            IllegalArgumentException iex = new IllegalArgumentException("Null id.");
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.getApprovalPolicy:", iex);
            throw iex;
        }
        SearchControls ctl = new SearchControls();
        ctl.setSearchScope(0);
        NamingEnumeration<SearchResult> results = null;
        UtilDebug.log(127, "ApprovalPolicyLDAPDAO.getApprovalPolicy:", "Reading with base: " + id);
        results = this.m_dirCtx.search(id, basicApprovalPolicyFilter, ctl);
        if (results != null) {
            while (results.hasMore()) {
                SearchResult res = (SearchResult)results.nextElement();
                rtval = this.createApprovalPolicy(res, null);
                rtval.setKey(id);
            }
        }
        return rtval;
    }

    public void deletePolicy(String uid) throws NamingException {
        if (this.m_dirCtx == null) {
            NamingException nex = new NamingException("Invalid directory context.");
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.deletePolicy:", nex);
            throw nex;
        }
        if (uid != null) {
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.deletePolicy:", "Deleting approval policy: " + uid);
            this.m_dirCtx.destroySubcontext(uid);
        }
    }

    public String createPolicy(String app, ApprovalPolicy pol) throws NamingException, IllegalArgumentException {
        String descr;
        String filter;
        List opattrs;
        if (this.m_dirCtx == null) {
            NamingException nex = new NamingException("Invalid directory context.");
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.createPolicy:", nex);
            throw nex;
        }
        if (pol == null || app == null) {
            String msg = "Null policy or app name for application: " + app;
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.createPolicy:", ex);
            throw ex;
        }
        String name = pol.getName();
        if (name == null) {
            IllegalArgumentException ex = new IllegalArgumentException("Null policy name");
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.createPolicy:", ex);
            throw ex;
        }
        int level = pol.getApprovalLevels();
        if (level <= 0) {
            String msg = "Invalid number of approval levels " + level;
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.createPolicy:", ex);
            throw ex;
        }
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute lattr = new BasicAttribute(apApprovalLevels);
        StringBuffer buf = new StringBuffer();
        buf.append(level);
        lattr.add(buf.toString());
        attrs.put(lattr);
        BasicAttribute nattr = new BasicAttribute(apName);
        nattr.add(name);
        attrs.put(nattr);
        List ops = pol.getOperations();
        if (ops != null && ops.size() > 0) {
            BasicAttribute attr = new BasicAttribute(apProvOperation);
            ListIterator iter = ops.listIterator();
            while (iter.hasNext()) {
                String op = (String)iter.next();
                attr.add(op);
            }
            attrs.put(attr);
        }
        if ((opattrs = pol.getOpAttrs()) != null && opattrs.size() > 0) {
            BasicAttribute attr = new BasicAttribute(apProvOperationAttrs);
            ListIterator iter = opattrs.listIterator();
            while (iter.hasNext()) {
                String opattr = (String)iter.next();
                attr.add(opattr);
            }
            attrs.put(attr);
        }
        if ((filter = pol.getObjectFilter()) != null) {
            BasicAttribute fattr = new BasicAttribute(apProvObjectFilter);
            fattr.add(filter);
            attrs.put(fattr);
        }
        if ((descr = pol.getDescription()) != null) {
            BasicAttribute dattr = new BasicAttribute(apDescription);
            dattr.add(descr);
            attrs.put(dattr);
        }
        String proc = pol.getApprovalProcess();
        BasicAttribute pattr = new BasicAttribute(apApprovalProcess);
        if (proc != null) {
            pattr.add(proc);
        } else {
            pattr.add("OIMApprovalProcess");
        }
        attrs.put(pattr);
        BasicAttribute oattr = new BasicAttribute(objClassAttr);
        oattr.add(approvalPolicyClass);
        oattr.add(topClass);
        attrs.put(oattr);
        String dn = apName + "=" + name + ", " + profileName + "=" + app + "," + this.m_policyBase;
        UtilDebug.log(127, "ApprovalPolicyLDAPDAO.createPolicy:", "Adding approvers: " + dn);
        DirContext result = this.m_dirCtx.createSubcontext(dn, (Attributes)attrs);
        return dn;
    }

    public ApprovalPolicy modifyPolicy(ApprovalPolicy pol) throws NamingException, IllegalArgumentException {
        int oldsize;
        BasicAttribute attr;
        BasicAttribute attr2;
        BasicAttribute attr3;
        int newlevel;
        ApprovalPolicy rtval = null;
        if (this.m_dirCtx == null) {
            NamingException nex = new NamingException("Invalid directory context.");
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.modifyPolicy:", nex);
            throw nex;
        }
        if (pol == null || pol.getKey() == null) {
            String msg = "Null policy or policy key";
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.modifyPolicy:", ex);
            throw ex;
        }
        String key = pol.getKey();
        int level = pol.getApprovalLevels();
        if (level <= 0) {
            String msg = "Invalid number of approval levels " + level;
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.modifyPolicy:", ex);
            throw ex;
        }
        ApprovalPolicy oldpol = this.getApprovalPolicy(key);
        if (oldpol == null) {
            String msg = "Policy to modify: " + key + " does not exist.";
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.modifyPolicy:", ex);
            throw ex;
        }
        String oldname = oldpol.getName();
        String newname = pol.getName();
        if (newname != null && !oldname.equalsIgnoreCase(newname)) {
            String msg = "Policy name change not supported.";
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.modifyPolicy:", ex);
            throw ex;
        }
        ArrayList<ModificationItem> attrArray = new ArrayList<ModificationItem>();
        int oldlevel = oldpol.getApprovalLevels();
        if (oldlevel != (newlevel = pol.getApprovalLevels())) {
            StringBuffer buf = new StringBuffer();
            buf.append(newlevel);
            BasicAttribute attr4 = new BasicAttribute(apApprovalLevels, buf.toString());
            attrArray.add(new ModificationItem(2, attr4));
        }
        String oldfilter = oldpol.getObjectFilter();
        String newfilter = pol.getObjectFilter();
        if (newfilter != null) {
            if (!newfilter.equalsIgnoreCase(oldfilter)) {
                attr3 = new BasicAttribute(apProvObjectFilter, newfilter);
                attrArray.add(new ModificationItem(2, attr3));
            }
        } else if (oldfilter != null) {
            attr3 = new BasicAttribute(apProvObjectFilter);
            attrArray.add(new ModificationItem(3, attr3));
        }
        String olddescr = oldpol.getDescription();
        String newdescr = pol.getDescription();
        if (newdescr != null) {
            if (!newdescr.equalsIgnoreCase(olddescr)) {
                attr2 = new BasicAttribute(apDescription, newdescr);
                attrArray.add(new ModificationItem(2, attr2));
            }
        } else if (olddescr != null) {
            attr2 = new BasicAttribute(apDescription);
            attrArray.add(new ModificationItem(3, attr2));
        }
        String oldproc = oldpol.getApprovalProcess();
        String newproc = pol.getApprovalProcess();
        if (newproc != null) {
            if (!newproc.equalsIgnoreCase(oldproc)) {
                attr = new BasicAttribute(apApprovalProcess, newproc);
                attrArray.add(new ModificationItem(2, attr));
            }
        } else if (oldproc != null) {
            attr = new BasicAttribute(apApprovalProcess);
            attrArray.add(new ModificationItem(3, attr));
        }
        boolean chgattr = false;
        List newattrs = pol.getOpAttrs();
        List oldattrs = oldpol.getOpAttrs();
        int newsize = newattrs != null ? newattrs.size() : 0;
        int n = oldsize = oldattrs != null ? oldattrs.size() : 0;
        if (newsize != oldsize) {
            chgattr = true;
        } else {
            boolean match = false;
            try {
                match = newattrs.containsAll(oldattrs);
            }
            catch (Exception ex) {
                // empty catch block
            }
            boolean bl = chgattr = !match;
        }
        if (chgattr) {
            BasicAttribute attr5 = new BasicAttribute(apProvOperationAttrs);
            if (newsize == 0) {
                attrArray.add(new ModificationItem(3, attr5));
            } else {
                ListIterator iter = newattrs.listIterator();
                while (iter.hasNext()) {
                    String attrname = (String)iter.next();
                    attr5.add(attrname);
                }
                attrArray.add(new ModificationItem(2, attr5));
            }
        }
        boolean chgevt = false;
        List newevts = pol.getOperations();
        List oldevts = oldpol.getOperations();
        newsize = newevts != null ? newevts.size() : 0;
        int n2 = oldsize = oldevts != null ? oldevts.size() : 0;
        if (newsize != oldsize) {
            chgevt = true;
        } else {
            boolean match = false;
            try {
                match = newevts.containsAll(oldevts);
            }
            catch (Exception ex) {
                // empty catch block
            }
            boolean bl = chgevt = !match;
        }
        if (chgevt) {
            BasicAttribute attr6 = new BasicAttribute(apProvOperationAttrs);
            if (newsize == 0) {
                attrArray.add(new ModificationItem(3, attr6));
            } else {
                ListIterator iter = newevts.listIterator();
                while (iter.hasNext()) {
                    String evt = (String)iter.next();
                    attr6.add(evt);
                }
                attrArray.add(new ModificationItem(2, attr6));
            }
        }
        if (attrArray.size() > 0) {
            ModificationItem[] mods = attrArray.toArray(new ModificationItem[0]);
            String uid = oldpol.getKey();
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.modifyPolicy:", "Modifying policy: " + uid);
            this.m_dirCtx.modifyAttributes(uid, mods);
            rtval = oldpol;
        } else {
            UtilDebug.log(127, "ApprovalPolicyLDAPDAO.modifyPolicy:", "Modifying policy: no information changed.");
        }
        return rtval;
    }

    private ApprovalPolicy createApprovalPolicy(SearchResult res, String base) throws NamingException {
        ApprovalPolicy rtval = null;
        if (res != null) {
            rtval = new ApprovalPolicy();
            Attributes attrs = null;
            Attribute attr = null;
            String attrName = null;
            if (base != null) {
                rtval.setKey(res.getName() + "," + base);
            } else {
                rtval.setKey(res.getName());
            }
            attrs = res.getAttributes();
            NamingEnumeration<? extends Attribute> namingEnumeration = attrs.getAll();
            while (namingEnumeration.hasMore()) {
                attr = namingEnumeration.next();
                attrName = attr.getID();
                if (attrName.equalsIgnoreCase(apName)) {
                    rtval.setName((String)attr.get(0));
                    continue;
                }
                if (attrName.equalsIgnoreCase(apProvOperation)) {
                    for (int i = 0; i < attr.size(); ++i) {
                        rtval.addOperation((String)attr.get(i));
                    }
                    continue;
                }
                if (attrName.equalsIgnoreCase(apProvOperationAttrs)) {
                    for (int i = 0; i < attr.size(); ++i) {
                        rtval.addOpAttr((String)attr.get(i));
                    }
                    continue;
                }
                if (attrName.equalsIgnoreCase(apApprovalLevels)) {
                    try {
                        rtval.setApprovalLevels(Integer.parseInt((String)attr.get(0)));
                    }
                    catch (NumberFormatException e) {
                        rtval.setApprovalLevels(1);
                    }
                    continue;
                }
                if (attrName.equalsIgnoreCase(apProvObjectFilter)) {
                    rtval.setObjectFilter((String)attr.get(0));
                    continue;
                }
                if (attrName.equalsIgnoreCase(apDescription)) {
                    rtval.setDescription((String)attr.get(0));
                    continue;
                }
                if (!attrName.equalsIgnoreCase(apApprovalProcess)) continue;
                rtval.setApprovalProcess((String)attr.get(0));
            }
        }
        return rtval;
    }
}

