/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.log;

import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.EventObject;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogOwner;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.log.TabbedPage;

public class LogWindowImpl
extends LogWindow {
    private static final String CLOSED_BY_USER = "ClosedByUser";
    private LogPage _page;
    private boolean _closed;

    protected LogWindowImpl(LogPage page) {
        super(page.getLogPageView().getId());
        this._page = page;
        page.setOwner((LogOwner)this);
        this.setType(32);
    }

    public void activate() {
        super.activate();
        LogPage lpage = this.getPage();
        if (lpage != null) {
            boolean alreadyHasFocus = false;
            Component lpageComp = lpage.getLogPageView().getGUI();
            alreadyHasFocus = GraphicsUtils.isAncestorOfFocusedComponent((Component)lpageComp);
            if (alreadyHasFocus) {
                return;
            }
            if (lpage instanceof AbstractLogPage) {
                AbstractLogPage abstractPage = (AbstractLogPage)lpage;
                Component tcomp = abstractPage.getTopComponent();
                alreadyHasFocus = GraphicsUtils.isAncestorOfFocusedComponent((Component)tcomp);
                if (alreadyHasFocus) {
                    return;
                }
                Component bcomp = abstractPage.getBottomComponent();
                alreadyHasFocus = GraphicsUtils.isAncestorOfFocusedComponent((Component)bcomp);
                if (alreadyHasFocus) {
                    return;
                }
                GraphicsUtils.focusComponentOrChild((Component)lpageComp, (boolean)true);
            }
        }
    }

    public ContextMenu getContextMenu() {
        ContextMenu cm = LogManager.getLogManager().getContextMenu();
        return cm;
    }

    public void clearAll() {
        this._page.clearAll();
    }

    public String getTabName() {
        return this._page.getTabName();
    }

    public Icon getTabIcon() {
        return IdeArb.getIcon((int)174);
    }

    public String getMenuTitle() {
        return IdeArb.getString((int)172);
    }

    public String getToolTip() {
        return this._page.getToolTip();
    }

    public void log(Object msg) {
        this._page.log(msg);
    }

    public String getTitleName() {
        return this._page.getTitleName() + " - " + LogArb.getString((int)0);
    }

    public void setOwner(LogOwner owner) {
    }

    public void addMouseListener(MouseListener listener) {
    }

    public void removeMouseListener(MouseListener listener) {
    }

    public View getLogPageView() {
        return this;
    }

    public LogPage getPage() {
        if (this._page != null && this._page instanceof TabbedPage) {
            return ((TabbedPage)this._page).getSelectedPage();
        }
        return this._page;
    }

    public Component getGUI() {
        return this._page.getLogPageView().getGUI();
    }

    public Context getContext(EventObject event) {
        return this._page.getLogPageView().getContext(event);
    }

    public Controller getController() {
        return LogManager.getLogManager();
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        View logPageView;
        super.updateVisibleActions(updateMessage);
        LogPage logPage = this.getPage();
        if (logPage != null && (logPageView = logPage.getLogPageView()) != null) {
            logPageView.updateVisibleActions(updateMessage);
        }
    }

    public void stateChange(int newState) {
        super.stateChange(newState);
        switch (newState) {
            case 1: {
                this._closed = false;
                break;
            }
            case 3: {
                this._closed = true;
            }
        }
    }

    public void updateTabTitle(LogPage logPage, String title) {
        if (this._page != null && this._page instanceof TabbedPage) {
            ((TabbedPage)this._page).updateTabTitle(logPage, title);
        }
    }

    public void saveLayout(PropertyAccess p) {
        Boolean value = this._closed;
        p.setProperty(CLOSED_BY_USER, value.toString());
    }

    public void loadLayout(PropertyAccess p) {
        String value = p.getProperty(CLOSED_BY_USER, "false");
        this._closed = Boolean.valueOf(value);
    }

    public void selectPage(LogPage page) {
        page.getLogPageView().show();
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void highlightPage(LogPage page) {
        LogOwner lowner = (LogOwner)page.getLogPageView().owner();
        lowner.highlightPage(page);
    }

    public View getLogOwnerView() {
        return this;
    }
}

