/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.xquery.editor.language;

import oracle.bali.xml.editor.renderer.XMLStyles;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.jdevimpl.xml.xquery.XQueryNode;
import oracle.jdevimpl.xml.xquery.editor.language.XQueryBlockRenderer;
import oracle.jdevimpl.xml.xquery.editor.language.XQueryLanguageSupport;
import oracle.jdevimpl.xml.xquery.editor.language.XQueryStyles;
import oracle.jdevimpl.xml.xquery.resource.XQueryArb;

public class XQueryLanguageModule
extends LanguageModule {
    public LanguageSupport createLanguageSupport() {
        return new XQueryLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new XQueryBlockRenderer(buffer);
    }

    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(: List all titles containing chapters or sections on XML :)\n");
        buffer.append("<results>\n");
        buffer.append("  {\n");
        buffer.append("    for $t in doc(\"books.xml\")//(chapter | section)/title\n");
        buffer.append("    where contains($t/text(), \"XML\")\n");
        buffer.append("    return $t\n");
        buffer.append("  }\n");
        buffer.append("</results>\n");
        return buffer.toString();
    }

    public String getPresentationName() {
        return XQueryArb.getString(1);
    }

    public String[] getStyleNames() {
        return XQueryStyles.STYLE_NAMES;
    }

    public String[] getSupportedFileTypes() {
        return XQueryNode.EXTENSIONS;
    }

    public void registerStyles(StyleRegistry registry) {
        new XMLStyles(registry);
        new XQueryStyles(registry);
    }
}

