/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;

class ThreadLocalPool {
    private final WeakHashMap<Thread, HashMap<ThreadLocal, Object>> m_ThreadToLocalsMap = new WeakHashMap();

    ThreadLocalPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Thread> getThreads() {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        WeakHashMap<Thread, HashMap<ThreadLocal, Object>> weakHashMap = this.m_ThreadToLocalsMap;
        synchronized (weakHashMap) {
            this.clearDeadThreads();
            threads.addAll(this.m_ThreadToLocalsMap.keySet());
        }
        return threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        WeakHashMap<Thread, HashMap<ThreadLocal, Object>> weakHashMap = this.m_ThreadToLocalsMap;
        synchronized (weakHashMap) {
            this.m_ThreadToLocalsMap.clear();
        }
    }

    private void clearDeadThreads() {
        Iterator<Thread> iterator = this.m_ThreadToLocalsMap.keySet().iterator();
        while (iterator.hasNext()) {
            Thread thread = iterator.next();
            if (thread.getState() != Thread.State.TERMINATED) continue;
            iterator.remove();
        }
    }

    public class ThreadLocal<T> {
        protected T initialValue() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final T get() {
            Object value;
            HashMap<ThreadLocal, Object> localsMap;
            HashMap<ThreadLocal, Object> hashMap = localsMap = this.getLocalsMapCreatingIfNecessary();
            synchronized (hashMap) {
                value = localsMap.get(this);
                if (value == null) {
                    value = this.initialValue();
                    localsMap.put(this, value);
                }
            }
            return (T)value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final T get(Thread thread) {
            Object value;
            HashMap<ThreadLocal, Object> localsMap = this.getLocalsMap(thread);
            if (localsMap == null) {
                return null;
            }
            HashMap<ThreadLocal, Object> hashMap = localsMap;
            synchronized (hashMap) {
                value = localsMap.get(this);
            }
            return (T)value;
        }

        public final void set(T value) {
            this.set(Thread.currentThread(), value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void set(Thread thread, T value) throws IllegalArgumentException {
            HashMap<ThreadLocal, Object> localsMap;
            HashMap<ThreadLocal, Object> hashMap = localsMap = this.getLocalsMapCreatingIfNecessary(thread);
            synchronized (hashMap) {
                localsMap.put(this, value);
            }
        }

        private HashMap<ThreadLocal, Object> getLocalsMapCreatingIfNecessary() {
            return this.getLocalsMapCreatingIfNecessary(Thread.currentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HashMap<ThreadLocal, Object> getLocalsMapCreatingIfNecessary(Thread thread) {
            HashMap<ThreadLocal, Object> localsMap;
            WeakHashMap weakHashMap = ThreadLocalPool.this.m_ThreadToLocalsMap;
            synchronized (weakHashMap) {
                ThreadLocalPool.this.clearDeadThreads();
                localsMap = (HashMap<ThreadLocal, Object>)ThreadLocalPool.this.m_ThreadToLocalsMap.get(thread);
                if (localsMap == null) {
                    localsMap = new HashMap<ThreadLocal, Object>();
                    ThreadLocalPool.this.m_ThreadToLocalsMap.put(thread, localsMap);
                }
            }
            return localsMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HashMap<ThreadLocal, Object> getLocalsMap(Thread thread) {
            HashMap localsMap;
            WeakHashMap weakHashMap = ThreadLocalPool.this.m_ThreadToLocalsMap;
            synchronized (weakHashMap) {
                ThreadLocalPool.this.clearDeadThreads();
                localsMap = (HashMap)ThreadLocalPool.this.m_ThreadToLocalsMap.get(thread);
            }
            return localsMap;
        }
    }
}

